<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        // Drop all existing website tables completely
        Schema::dropIfExists('website_visits');
        Schema::dropIfExists('website_visit_tasks');

        // Create website_visit_tasks table WITHOUT foreign keys first
        Schema::create('website_visit_tasks', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->text('description');
            $table->string('website_url');
            $table->enum('visit_method', ['direct', 'google_search'])->default('direct');
            $table->string('search_keywords')->nullable();
            $table->integer('required_time')->default(30);
            $table->decimal('reward_amount', 8, 2);
            $table->integer('max_completions')->default(100);
            $table->integer('user_daily_limit')->default(1);
            $table->integer('user_total_limit')->default(1);
            $table->unsignedInteger('target_country_id')->nullable(); // Changed to unsignedInteger
            $table->unsignedInteger('target_city_id')->nullable();    // Changed to unsignedInteger
            $table->tinyInteger('target_gender')->default(0);
            $table->tinyInteger('status')->default(1);
            $table->unsignedBigInteger('created_by');
            $table->timestamp('expires_at')->nullable();
            $table->timestamps();

            // Only add user foreign key (this should work)
            $table->foreign('created_by')->references('id')->on('users')->onDelete('cascade');
            
            // Add indexes without foreign keys
            $table->index(['status', 'expires_at']);
            $table->index(['target_country_id', 'target_city_id']);
        });

        // Create website_visits table
        Schema::create('website_visits', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('task_id');
            $table->unsignedBigInteger('user_id');
            $table->string('session_id');
            $table->timestamp('start_time')->nullable();
            $table->timestamp('end_time')->nullable();
            $table->integer('duration')->default(0);
            $table->string('ip_address');
            $table->text('user_agent');
            $table->string('referrer')->nullable();
            $table->enum('status', ['started', 'in_progress', 'completed', 'failed'])->default('started');
            $table->boolean('reward_given')->default(false);
            $table->string('verification_token')->unique();
            $table->timestamps();

            // Add foreign keys
            $table->foreign('task_id')->references('id')->on('website_visit_tasks')->onDelete('cascade');
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            
            // Add indexes
            $table->index(['user_id', 'task_id']);
            $table->index(['status', 'created_at']);
            $table->index('verification_token');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('website_visits');
        Schema::dropIfExists('website_visit_tasks');
    }
};