<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddMissingFieldsToBalanceLogTable extends Migration
{
    /**
     * Run the migrations.
     *
     * Adds columns required by BalanceLog::create calls.
     */
    public function up()
    {
        Schema::table('balanceLog', function (Blueprint $table) {
            // Add snake_case user_id alongside existing userId
            $table->unsignedBigInteger('user_id')->nullable()->after('userId');

            // Record the actual transaction amount
            $table->decimal('amount', 10, 2)->default(0)->after('user_id');

            // Log the type of operation (debit/credit)
            $table->string('operation_type', 50)->nullable()->after('amount');

            // Reference entity type (e.g., 'withdrawal')
            $table->string('reference_type', 50)->nullable()->after('operation_type');

            // Reference entity ID (e.g., withdrawal request ID)
            $table->unsignedBigInteger('reference_id')->nullable()->after('reference_type');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down()
    {
        Schema::table('balanceLog', function (Blueprint $table) {
            $table->dropColumn([
                'user_id',
                'amount',
                'operation_type',
                'reference_type',
                'reference_id',
            ]);
        });
    }
}
