<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('languages', function (Blueprint $table) {
            $table->id();
            $table->string('code', 10)->unique(); // tr, en, ar, ru
            $table->string('name', 100); // Türkçe, English, العربية, Русский
            $table->string('native_name', 100); // Native language name
            $table->string('flag', 10)->nullable(); // Flag emoji or code
            $table->boolean('is_active')->default(true);
            $table->boolean('is_default')->default(false);
            $table->boolean('is_rtl')->default(false); // Right to left languages
            $table->integer('sort_order')->default(0);
            $table->timestamps();
        });

        Schema::create('language_keys', function (Blueprint $table) {
            $table->id();
            $table->string('key', 500); // Translation key
            $table->text('description')->nullable(); // Key description for translators
            $table->string('group', 100)->default('general'); // Group for organization
            $table->timestamps();
            
            $table->index(['key', 'group']);
        });

        Schema::create('language_translations', function (Blueprint $table) {
            $table->id();
            $table->foreignId('language_id')->constrained()->onDelete('cascade');
            $table->foreignId('language_key_id')->constrained()->onDelete('cascade');
            $table->text('value');
            $table->boolean('is_approved')->default(false);
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->timestamps();
            
            $table->unique(['language_id', 'language_key_id']);
            $table->index(['language_id', 'is_approved']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('language_translations');
        Schema::dropIfExists('language_keys');
        Schema::dropIfExists('languages');
    }
};