<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // ENUM değerlerini güncelle
        DB::statement("ALTER TABLE notifications MODIFY COLUMN type ENUM(
            'announcement',
            'new_content',
            'task_created',
            'task_approved',
            'task_rejected',
            'ticket_created',
            'ticket_replied',
            'withdrawal_request',
            'withdrawal_approved',
            'withdrawal_rejected',
            'balance_request',
            'balance_approved',
            'balance_rejected',
            'task_proof_approved',
            'task_proof_rejected'
        ) NOT NULL");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Eski ENUM değerlerine geri dön
        DB::statement("ALTER TABLE notifications MODIFY COLUMN type ENUM('announcement','new_content') NOT NULL");
    }
};