<!-- Mobile Cards Layout -->
<div class="d-block d-lg-none">
    @forelse($requests as $request)
        <div class="mobile-request-card request-item" data-id="{{ $request->id }}">
            <div class="d-flex justify-content-between align-items-start mb-3">
                <div class="d-flex align-items-center">
                    <div class="stat-icon primary me-3" style="width: 45px; height: 45px; font-size: 1.2rem;">
                        <i class="bx bx-user"></i>
                    </div>
                    <div>
                        <h6 class="mb-0 fw-bold">{{ $request->user->username ?? 'N/A' }}</h6>
                        <small class="text-muted">{{ $request->user->email ?? 'N/A' }}</small>
                    </div>
                </div>
                <div class="text-end">
                    @if($request->status == 'pending')
                        <span class="status-badge bg-warning text-dark">{{ __('Pending') }}</span>
                    @elseif($request->status == 'completed')
                        <span class="status-badge bg-success text-white">{{ __('Approved') }}</span>
                    @elseif($request->status == 'rejected')
                        <span class="status-badge bg-danger text-white">{{ __('Rejected') }}</span>
                    @endif
                </div>
            </div>
            
            <div class="row g-3 mb-3">
                <div class="col-6">
                    <div class="d-flex align-items-center">
                        <i class="bx bx-money text-success me-2"></i>
                        <div>
                            <small class="text-muted d-block">{{ __('Amount') }}</small>
                            <span class="fw-bold text-success">{{ number_format($request->amount, 2) }} ₺</span>
                        </div>
                    </div>
                </div>
                <div class="col-6">
                    <div class="d-flex align-items-center">
                        <i class="bx bx-calendar text-primary me-2"></i>
                        <div>
                            <small class="text-muted d-block">{{ __('Date') }}</small>
                            <span class="fw-medium">{{ $request->created_at->format('d.m.Y H:i') }}</span>
                        </div>
                    </div>
                </div>
            </div>

            @if($request->receipt_path)
                <div class="mb-3">
                    <a href="{{ route('admin.balance-requests.download-receipt', ['id' => $request->id]) }}" 
                       class="btn btn-sm btn-outline-primary btn-modern">
                        <i class="bx bx-download me-1"></i> {{ __('Download Receipt') }}
                    </a>
                </div>
            @endif

            <div class="d-flex gap-2 flex-wrap">
                <button class="btn btn-sm btn-outline-info btn-modern" onclick="viewRequest({{ $request->id }})">
                    <i class="bx bx-show me-1"></i> {{ __('View') }}
                </button>
                @if($request->status == 'pending')
                    <button class="btn btn-sm btn-success btn-modern" onclick="approveRequest({{ $request->id }})">
                        <i class="bx bx-check me-1"></i> {{ __('Approve') }}
                    </button>
                    <button class="btn btn-sm btn-danger btn-modern" onclick="rejectRequest({{ $request->id }})">
                        <i class="bx bx-x me-1"></i> {{ __('Reject') }}
                    </button>
                @endif
            </div>
        </div>
    @empty
        <div class="text-center py-5">
            <div class="stat-icon info d-inline-flex mb-3" style="width: 80px; height: 80px; font-size: 2rem;">
                <i class="bx bx-inbox"></i>
            </div>
            <h5 class="text-muted mb-2">{{ __('No balance requests found') }}</h5>
            <p class="text-muted">{{ __('There are no balance requests to display at the moment.') }}</p>
        </div>
    @endforelse
</div>

<!-- Desktop Table Layout -->
<div class="d-none d-lg-block">
    <div class="table-responsive">
        <table class="table table-hover align-middle">
            <thead>
                <tr style="background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);">
                    <th class="border-0 fw-bold text-dark">ID</th>
                    <th class="border-0 fw-bold text-dark">{{ __('User') }}</th>
                    <th class="border-0 fw-bold text-dark">{{ __('Amount') }}</th>
                    <th class="border-0 fw-bold text-dark">{{ __('Date') }}</th>
                    <th class="border-0 fw-bold text-dark">{{ __('Status') }}</th>
                    <th class="border-0 fw-bold text-dark">{{ __('Receipt') }}</th>
                    <th class="border-0 text-center fw-bold text-dark">{{ __('Actions') }}</th>
                </tr>
            </thead>
            <tbody>
                @forelse($requests as $request)
                    <tr class="request-item" data-id="{{ $request->id }}" style="border-bottom: 1px solid #f1f3f4;">
                        <td class="py-3">
                            <span class="badge" style="background: linear-gradient(135deg, #6f42c1 0%, #007bff 100%); color: white; padding: 6px 10px; border-radius: 12px;">#{{ $request->id }}</span>
                        </td>
                        <td class="py-3">
                            <div class="d-flex align-items-center">
                                <div class="stat-icon primary me-3" style="width: 40px; height: 40px; font-size: 1rem;">
                                    <i class="bx bx-user"></i>
                                </div>
                                <div>
                                    <div class="fw-bold text-dark">{{ $request->user->username ?? 'N/A' }}</div>
                                    <small class="text-muted">{{ $request->user->email ?? 'N/A' }}</small>
                                </div>
                            </div>
                        </td>
                        <td class="py-3">
                            <div class="d-flex align-items-center">
                                <i class="bx bx-money text-success me-2 fs-5"></i>
                                <span class="fw-bold text-success fs-5">{{ number_format($request->amount, 2) }} ₺</span>
                            </div>
                        </td>
                        <td class="py-3">
                            <div class="d-flex align-items-center">
                                <i class="bx bx-calendar text-primary me-2"></i>
                                <div>
                                    <div class="fw-medium">{{ $request->created_at->format('d.m.Y') }}</div>
                                    <small class="text-muted">{{ $request->created_at->format('H:i') }}</small>
                                </div>
                            </div>
                        </td>
                        <td class="py-3">
                            @if($request->status == 'pending')
                                <span class="status-badge bg-warning text-dark">{{ __('Pending') }}</span>
                            @elseif($request->status == 'completed')
                                <span class="status-badge bg-success text-white">{{ __('Approved') }}</span>
                            @elseif($request->status == 'rejected')
                                <span class="status-badge bg-danger text-white">{{ __('Rejected') }}</span>
                            @endif
                        </td>
                        <td class="py-3">
                            @if($request->receipt_path)
                                <a href="{{ route('admin.balance-requests.download-receipt', ['id' => $request->id]) }}" 
                                   class="btn btn-sm btn-outline-primary btn-modern">
                                    <i class="bx bx-download me-1"></i>
                                    <span class="d-none d-xl-inline">{{ __('Download') }}</span>
                                </a>
                            @else
                                <span class="text-muted fst-italic">{{ __('No receipt') }}</span>
                            @endif
                        </td>
                        <td class="text-center py-3">
                            <div class="btn-group" role="group">
                                <button class="btn btn-sm btn-outline-info btn-modern" onclick="viewRequest({{ $request->id }})" title="{{ __('View Details') }}">
                                    <i class="bx bx-show"></i>
                                </button>
                                @if($request->status == 'pending')
                                    <button class="btn btn-sm btn-outline-success btn-modern" onclick="approveRequest({{ $request->id }})" title="{{ __('Approve') }}">
                                        <i class="bx bx-check"></i>
                                    </button>
                                    <button class="btn btn-sm btn-outline-danger btn-modern" onclick="rejectRequest({{ $request->id }})" title="{{ __('Reject') }}">
                                        <i class="bx bx-x"></i>
                                    </button>
                                @endif
                            </div>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="7" class="text-center py-5">
                            <div class="stat-icon info d-inline-flex mb-3" style="width: 80px; height: 80px; font-size: 2rem;">
                                <i class="bx bx-inbox"></i>
                            </div>
                            <h5 class="text-muted mb-2">{{ __('No balance requests found') }}</h5>
                            <p class="text-muted">{{ __('There are no balance requests to display at the moment.') }}</p>
                        </td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>
</div>

<!-- Pagination -->
@if($requests->hasPages())
    <div class="d-flex justify-content-center mt-4 px-3">
        {{ $requests->links() }}
    </div>
@endif