<!-- Mobile-First Card Layout -->
<div class="d-block d-lg-none">
    @forelse($requests as $request)
        <div class="border-bottom p-3 request-item" data-id="{{ $request->id }}">
            <div class="d-flex justify-content-between align-items-start mb-2">
                <div class="d-flex align-items-center">
                    <div class="bg-primary bg-opacity-10 rounded-circle p-2 me-3">
                        <i class="bx bx-user fs-5 text-primary"></i>
                    </div>
                    <div>
                        <h6 class="mb-0 fw-bold">{{ $request->user->username ?? 'N/A' }}</h6>
                        <small class="text-muted">{{ $request->user->email ?? 'N/A' }}</small>
                    </div>
                </div>
                <div class="text-end">
                    @if($request->status == 'pending')
                        <span class="badge bg-warning">{{ __('Pending') }}</span>
                    @elseif($request->status == 'completed')
                        <span class="badge bg-success">{{ __('Approved') }}</span>
                    @elseif($request->status == 'rejected')
                        <span class="badge bg-danger">{{ __('Rejected') }}</span>
                    @endif
                </div>
            </div>
            
            <div class="row g-2 mb-3">
                <div class="col-6">
                    <small class="text-muted d-block">{{ __('Amount') }}</small>
                    <span class="fw-bold text-success">{{ number_format($request->amount, 2) }} ₺</span>
                </div>
                <div class="col-6">
                    <small class="text-muted d-block">{{ __('Date') }}</small>
                    <span>{{ $request->created_at->format('d.m.Y H:i') }}</span>
                </div>
            </div>

            @if($request->receipt_path)
                <div class="mb-3">
                    <a href="{{ route('admin.balance-requests.download-receipt', ['id' => $request->id]) }}" 
                       class="btn btn-sm btn-outline-primary">
                        <i class="bx bx-download"></i> {{ __('Download Receipt') }}
                    </a>
                </div>
            @endif

            <div class="d-flex gap-2 flex-wrap">
                <button class="btn btn-sm btn-outline-info" onclick="viewRequest({{ $request->id }})">
                    <i class="bx bx-show"></i> {{ __('View') }}
                </button>
                @if($request->status == 'pending')
                    <button class="btn btn-sm btn-success" onclick="approveRequest({{ $request->id }})">
                        <i class="bx bx-check"></i> {{ __('Approve') }}
                    </button>
                    <button class="btn btn-sm btn-danger" onclick="rejectRequest({{ $request->id }})">
                        <i class="bx bx-x"></i> {{ __('Reject') }}
                    </button>
                @endif
            </div>
        </div>
    @empty
        <div class="text-center py-5">
            <div class="bg-light rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 80px; height: 80px;">
                <i class="bx bx-inbox fs-1 text-muted"></i>
            </div>
            <h5 class="text-muted">{{ __('No balance requests found') }}</h5>
            <p class="text-muted">{{ __('There are no balance requests to display at the moment.') }}</p>
        </div>
    @endforelse
</div>

<!-- Desktop Table Layout -->
<div class="d-none d-lg-block">
    <div class="table-responsive">
        <table class="table table-hover align-middle">
            <thead class="table-light">
                <tr>
                    <th class="border-0">ID</th>
                    <th class="border-0">{{ __('User') }}</th>
                    <th class="border-0">{{ __('Amount') }}</th>
                    <th class="border-0">{{ __('Date') }}</th>
                    <th class="border-0">{{ __('Status') }}</th>
                    <th class="border-0">{{ __('Receipt') }}</th>
                    <th class="border-0 text-center">{{ __('Actions') }}</th>
                </tr>
            </thead>
            <tbody>
                @forelse($requests as $request)
                    <tr class="request-item" data-id="{{ $request->id }}">
                        <td>
                            <span class="badge bg-light text-dark">#{{ $request->id }}</span>
                        </td>
                        <td>
                            <div class="d-flex align-items-center">
                                <div class="bg-primary bg-opacity-10 rounded-circle p-2 me-3">
                                    <i class="bx bx-user text-primary"></i>
                                </div>
                                <div>
                                    <div class="fw-bold">{{ $request->user->username ?? 'N/A' }}</div>
                                    <small class="text-muted">{{ $request->user->email ?? 'N/A' }}</small>
                                </div>
                            </div>
                        </td>
                        <td>
                            <span class="fw-bold text-success fs-6">{{ number_format($request->amount, 2) }} ₺</span>
                        </td>
                        <td>
                            <div>
                                <div>{{ $request->created_at->format('d.m.Y') }}</div>
                                <small class="text-muted">{{ $request->created_at->format('H:i') }}</small>
                            </div>
                        </td>
                        <td>
                            @if($request->status == 'pending')
                                <span class="badge bg-warning">{{ __('Pending') }}</span>
                            @elseif($request->status == 'completed')
                                <span class="badge bg-success">{{ __('Approved') }}</span>
                            @elseif($request->status == 'rejected')
                                <span class="badge bg-danger">{{ __('Rejected') }}</span>
                            @endif
                        </td>
                        <td>
                            @if($request->receipt_path)
                                <a href="{{ route('admin.balance-requests.download-receipt', ['id' => $request->id]) }}" 
                                   class="btn btn-sm btn-outline-primary">
                                    <i class="bx bx-download"></i>
                                    <span class="d-none d-xl-inline ms-1">{{ __('Download') }}</span>
                                </a>
                            @else
                                <span class="text-muted">{{ __('None') }}</span>
                            @endif
                        </td>
                        <td class="text-center">
                            <div class="btn-group" role="group">
                                <button class="btn btn-sm btn-outline-info" onclick="viewRequest({{ $request->id }})" title="{{ __('View Details') }}">
                                    <i class="bx bx-show"></i>
                                </button>
                                @if($request->status == 'pending')
                                    <button class="btn btn-sm btn-outline-success" onclick="approveRequest({{ $request->id }})" title="{{ __('Approve') }}">
                                        <i class="bx bx-check"></i>
                                    </button>
                                    <button class="btn btn-sm btn-outline-danger" onclick="rejectRequest({{ $request->id }})" title="{{ __('Reject') }}">
                                        <i class="bx bx-x"></i>
                                    </button>
                                @endif
                            </div>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="7" class="text-center py-5">
                            <div class="bg-light rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 80px; height: 80px;">
                                <i class="bx bx-inbox fs-1 text-muted"></i>
                            </div>
                            <h5 class="text-muted">{{ __('No balance requests found') }}</h5>
                            <p class="text-muted">{{ __('There are no balance requests to display at the moment.') }}</p>
                        </td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>
</div>

<!-- Pagination -->
@if($requests->hasPages())
    <div class="d-flex justify-content-center mt-4 px-3">
        {{ $requests->links() }}
    </div>
@endif