@if(isset($request))
<div class="row g-3">
    <!-- User Information -->
    <div class="col-12">
        <div class="card border-0 bg-light">
            <div class="card-body">
                <h6 class="card-title mb-3">
                    <i class="bx bx-user me-2 text-primary"></i>{{ __('User Information') }}
                </h6>
                <div class="row">
                    <div class="col-md-6">
                        <small class="text-muted">{{ __('Username') }}</small>
                        <div class="fw-bold">{{ $request->user->username ?? 'N/A' }}</div>
                    </div>
                    <div class="col-md-6">
                        <small class="text-muted">{{ __('Email') }}</small>
                        <div class="fw-bold">{{ $request->user->email ?? 'N/A' }}</div>
                    </div>
                </div>
                @if($request->user->phone ?? false)
                <div class="row mt-2">
                    <div class="col-md-6">
                        <small class="text-muted">{{ __('Phone') }}</small>
                        <div class="fw-bold">{{ $request->user->phone }}</div>
                    </div>
                    <div class="col-md-6">
                        <small class="text-muted">{{ __('Current Balance') }}</small>
                        <div class="fw-bold text-success">{{ number_format($request->user->balance ?? 0, 2) }} ₺</div>
                    </div>
                </div>
                @endif
            </div>
        </div>
    </div>

    <!-- Request Details -->
    <div class="col-12">
        <div class="card border-0">
            <div class="card-body">
                <h6 class="card-title mb-3">
                    <i class="bx bx-wallet me-2 text-info"></i>{{ __('Request Details') }}
                </h6>
                <div class="row g-3">
                    <div class="col-md-4">
                        <small class="text-muted">{{ __('Request ID') }}</small>
                        <div class="fw-bold">#{{ $request->id }}</div>
                    </div>
                    <div class="col-md-4">
                        <small class="text-muted">{{ __('Amount') }}</small>
                        <div class="fw-bold text-success fs-5">{{ number_format($request->amount, 2) }} ₺</div>
                    </div>
                    <div class="col-md-4">
                        <small class="text-muted">{{ __('Status') }}</small>
                        <div>
                            @if($request->status == 'pending')
                                <span class="badge bg-warning fs-6">{{ __('Pending') }}</span>
                            @elseif($request->status == 'completed')
                                <span class="badge bg-success fs-6">{{ __('Approved') }}</span>
                            @elseif($request->status == 'rejected')
                                <span class="badge bg-danger fs-6">{{ __('Rejected') }}</span>
                            @endif
                        </div>
                    </div>
                    <div class="col-md-6">
                        <small class="text-muted">{{ __('Request Date') }}</small>
                        <div class="fw-bold">{{ $request->created_at->format('d.m.Y H:i:s') }}</div>
                    </div>
                    @if($request->updated_at != $request->created_at)
                    <div class="col-md-6">
                        <small class="text-muted">{{ __('Last Updated') }}</small>
                        <div class="fw-bold">{{ $request->updated_at->format('d.m.Y H:i:s') }}</div>
                    </div>
                    @endif
                </div>

                @if($request->description)
                <div class="mt-3">
                    <small class="text-muted">{{ __('Description') }}</small>
                    <div class="mt-1 p-2 bg-light rounded">{{ $request->description }}</div>
                </div>
                @endif

                @if($request->rejection_reason)
                <div class="mt-3">
                    <small class="text-muted text-danger">{{ __('Rejection Reason') }}</small>
                    <div class="mt-1 p-2 bg-danger bg-opacity-10 text-white border border-danger rounded">
                        <i class="bx bx-info-circle me-1"></i>{{ $request->rejection_reason }}
                    </div>
                </div>
                @endif
            </div>
        </div>
    </div>

    <!-- Receipt Information -->
    @if($request->receipt_path)
    <div class="col-12">
        <div class="card border-0">
            <div class="card-body">
                <h6 class="card-title mb-3">
                    <i class="bx bx-file me-2 text-success"></i>{{ __('Receipt') }}
                </h6>
                <div class="d-flex align-items-center justify-content-between">
                    <div>
                        <div class="fw-bold">{{ __('Receipt Available') }}</div>
                        <small class="text-muted">{{ __('Click to download the receipt file') }}</small>
                    </div>
                    <a href="{{ route('admin.balance-requests.download-receipt', ['id' => $request->id]) }}" 
                       class="btn btn-success" target="_blank">
                        <i class="bx bx-download me-2"></i>{{ __('Download Receipt') }}
                    </a>
                </div>
            </div>
        </div>
    </div>
    @else
    <div class="col-12">
        <div class="alert alert-info">
            <i class="bx bx-info-circle me-2"></i>{{ __('No receipt file uploaded for this request') }}
        </div>
    </div>
    @endif

    <!-- Bank Information (if available) -->
    @if($request->user->bank_name || $request->user->iban)
    <div class="col-12">
        <div class="card border-0">
            <div class="card-body">
                <h6 class="card-title mb-3">
                    <i class="bx bx-credit-card me-2 text-warning"></i>{{ __('Bank Information') }}
                </h6>
                <div class="row">
                    @if($request->user->bank_name)
                    <div class="col-md-6">
                        <small class="text-muted">{{ __('Bank Name') }}</small>
                        <div class="fw-bold">{{ $request->user->bank_name }}</div>
                    </div>
                    @endif
                    @if($request->user->iban)
                    <div class="col-md-6">
                        <small class="text-muted">{{ __('IBAN') }}</small>
                        <div class="fw-bold font-monospace">{{ $request->user->iban }}</div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
    @endif

    <!-- Action Buttons -->
    @if($request->status == 'pending')
    <div class="col-12">
        <div class="card border-0 bg-light">
            <div class="card-body">
                <h6 class="card-title mb-3">
                    <i class="bx bx-cog me-2 text-secondary"></i>{{ __('Actions') }}
                </h6>
                <div class="d-flex gap-2 flex-wrap">
                    <button class="btn btn-success" onclick="approveRequest({{ $request->id }})">
                        <i class="bx bx-check me-2"></i>{{ __('Approve Request') }}
                    </button>
                    <button class="btn btn-danger" onclick="rejectRequest({{ $request->id }})">
                        <i class="bx bx-x me-2"></i>{{ __('Reject Request') }}
                    </button>
                </div>
            </div>
        </div>
    </div>
    @endif
</div>
@else
<div class="alert alert-danger">
    <i class="bx bx-error-circle me-2"></i>{{ __('Request not found or access denied') }}
</div>
@endif