<!-- Add/Edit Language Modal -->
<div class="modal fade" id="addEditModal" tabindex="-1">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content border-0 shadow">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title">
                    <i class="bx bx-world me-2"></i>
                    <span id="modalTitle">{{ __('Add Language') }}</span>
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <form id="languageForm">
                <div class="modal-body">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label class="form-label fw-bold">{{ __('Language Code') }} <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="code" name="code" placeholder="tr, en, ar, ru" maxlength="10" required>
                            <div class="invalid-feedback"></div>
                            <small class="text-muted">{{ __('ISO 639-1 language code (2-3 characters)') }}</small>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label fw-bold">{{ __('Language Name') }} <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="name" name="name" placeholder="English, Türkçe" required>
                            <div class="invalid-feedback"></div>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label fw-bold">{{ __('Native Name') }} <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="native_name" name="native_name" placeholder="English, Türkçe, العربية" required>
                            <div class="invalid-feedback"></div>
                            <small class="text-muted">{{ __('Language name in its native script') }}</small>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label fw-bold">{{ __('Flag Emoji') }}</label>
                            <input type="text" class="form-control" id="flag" name="flag" placeholder="🇺🇸, 🇹🇷, 🇸🇦" maxlength="10">
                            <div class="invalid-feedback"></div>
                            <small class="text-muted">{{ __('Flag emoji or icon code') }}</small>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label fw-bold">{{ __('Sort Order') }}</label>
                            <input type="number" class="form-control" id="sort_order" name="sort_order" value="0" min="0">
                            <div class="invalid-feedback"></div>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label fw-bold">{{ __('Options') }}</label>
                            <div class="d-flex flex-column gap-2">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="is_active" name="is_active" checked>
                                    <label class="form-check-label" for="is_active">
                                        {{ __('Active') }}
                                    </label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="is_default" name="is_default">
                                    <label class="form-check-label" for="is_default">
                                        {{ __('Default Language') }}
                                    </label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="is_rtl" name="is_rtl">
                                    <label class="form-check-label" for="is_rtl">
                                        {{ __('Right to Left (RTL)') }}
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer border-0">
                    <button type="button" class="btn btn-light" data-bs-dismiss="modal">{{ __('Cancel') }}</button>
                    <button type="submit" class="btn btn-primary" id="submitBtn">
                        <i class="bx bx-save me-2"></i>{{ __('Save Language') }}
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>