@extends("layouts.app")

@section('title', __('System Settings') . ' - ' . ($settings['site_name'] ?? 'Site'))

@section("style")
    <link href="{{asset('assets/plugins/notifications/css/lobibox.min.css')}}" rel="stylesheet"/>
@endsection

@section("wrapper")
<div class="page-wrapper">
    <div class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">{{ __('Settings') }}</div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{ __('System Settings') }}</li>
                    </ol>
                </nav>
            </div>
        </div>
        <!--end breadcrumb-->

        <div class="row">
            <div class="col-xl-12 mx-auto">
                <div class="card">
                    <div class="card-header">
                        <h4 class="mb-0"><i class="lni lni-cog me-2"></i>{{ __('System Settings') }}</h4>
                    </div>
                    <div class="card-body">
                                            
                        <form id="settingsForm" enctype="multipart/form-data">
                            @csrf
                            
                            <!-- Site Bilgileri -->
                            <div class="row mb-4">
                                <div class="col-12">
                                    <h5 class="border-bottom pb-2 mb-3"><i class="bx bx-globe me-2"></i>{{ __('Site Information') }}</h5>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="site_name" class="form-label">{{ __('Site Name') }} <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="site_name" name="site_name" value="{{ $settingsModel->site_name ?? '' }}" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="slogan" class="form-label">{{ __('Slogan') }}</label>
                                    <input type="text" class="form-control" id="slogan" name="slogan" value="{{ $settingsModel->slogan ?? '' }}">
                                </div>
                                <div class="col-12 mb-3">
                                    <label for="description" class="form-label">{{ __('Description') }}</label>
                                    <textarea class="form-control" id="description" name="description" rows="3">{{ $settingsModel->description ?? '' }}</textarea>
                                </div>
                                <div class="col-12 mb-3">
                                    <label for="keywords" class="form-label">{{ __('Keywords') }}</label>
                                    <input type="text" class="form-control" id="keywords" name="keywords" value="{{ $settingsModel->keywords ?? '' }}" placeholder="keyword1, keyword2, keyword3">
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="logo" class="form-label">{{ __('Site Logo') }}</label>
                                    <input type="file" class="form-control" id="logo" name="logo" accept="image/*">
                                    @if($settingsModel->logo)
                                        <div class="mt-2">
                                            <img src="{{ asset('assets/images/' . $settingsModel->logo) }}" alt="Current Logo" style="max-height: 50px;">
                                            <small class="text-muted d-block">{{ __('Current Logo') }}: {{ $settingsModel->logo }}</small>
                                        </div>
                                    @endif
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="favicon" class="form-label">{{ __('Site Favicon') }}</label>
                                    <input type="file" class="form-control" id="favicon" name="favicon" accept="image/*">
                                    @if($settingsModel->favicon)
                                        <div class="mt-2">
                                            <img src="{{ asset('assets/images/' . $settingsModel->favicon) }}" alt="Current Favicon" style="max-height: 32px;">
                                            <small class="text-muted d-block">{{ __('Current Favicon') }}: {{ $settingsModel->favicon }}</small>
                                        </div>
                                    @endif
                                </div>
                            </div>

                            <!-- Sistem Ayarları -->
                            <div class="row mb-4">
                                <div class="col-12">
                                    <h5 class="border-bottom pb-2 mb-3"><i class="bx bx-cog me-2"></i>{{ __('System Configuration') }}</h5>
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label for="komisyon" class="form-label">{{ __('Commission Rate') }} (%)</label>
                                    <input type="number" class="form-control" id="komisyon" name="komisyon" value="{{ $settingsModel->komisyon ?? 0 }}" min="0" max="100" step="0.01">
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label for="gunluk_bonus" class="form-label">{{ __('Daily Bonus') }}</label>
                                    <input type="number" class="form-control" id="gunluk_bonus" name="gunluk_bonus" value="{{ $settingsModel->gunluk_bonus ?? 0 }}" min="0" step="0.01">
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label for="min_bakiyecekim" class="form-label">{{ __('Minimum Withdrawal Amount') }}</label>
                                    <input type="number" class="form-control" id="min_bakiyecekim" name="min_bakiyecekim" value="{{ $settingsModel->min_bakiyecekim ?? 0 }}" min="0" step="0.01">
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label for="ref" class="form-label">{{ __('Referral Bonus') }}</label>
                                    <input type="number" class="form-control" id="ref" name="ref" value="{{ $settingsModel->ref ?? 0 }}" min="0" step="0.01">
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label for="pbirim" class="form-label">{{ __('Currency Unit') }}</label>
                                    <input type="text" class="form-control" id="pbirim" name="pbirim" value="{{ $settingsModel->pbirim ?? $settingsModel->currency ?? 'TL' }}" maxlength="10">
                                </div>
                            </div>

                            <!-- Üyelik Seviyeleri -->
                            <div class="row mb-4">
                                <div class="col-12">
                                    <h5 class="border-bottom pb-2 mb-3"><i class="bx bx-medal me-2"></i>{{ __('Membership Levels') }}</h5>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="silver" class="form-label">{{ __('Silver Level Requirement') }}</label>
                                    <input type="number" class="form-control" id="silver" name="silver" value="{{ $settingsModel->silver ?? 0 }}" min="0" step="0.01">
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="silver_bonus" class="form-label">{{ __('Silver Level Bonus') }} (%)</label>
                                    <input type="number" class="form-control" id="silver_bonus" name="silver_bonus" value="{{ $settingsModel->silver_bonus ?? 0 }}" min="0" step="0.01">
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="gold" class="form-label">{{ __('Gold Level Requirement') }}</label>
                                    <input type="number" class="form-control" id="gold" name="gold" value="{{ $settingsModel->gold ?? 0 }}" min="0" step="0.01">
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="gold_bonus" class="form-label">{{ __('Gold Level Bonus') }} (%)</label>
                                    <input type="number" class="form-control" id="gold_bonus" name="gold_bonus" value="{{ $settingsModel->gold_bonus ?? 0 }}" min="0" step="0.01">
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="platin" class="form-label">{{ __('Platinum Level Requirement') }}</label>
                                    <input type="number" class="form-control" id="platin" name="platin" value="{{ $settingsModel->platin ?? 0 }}" min="0" step="0.01">
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="platin_bonus" class="form-label">{{ __('Platinum Level Bonus') }} (%)</label>
                                    <input type="number" class="form-control" id="platin_bonus" name="platin_bonus" value="{{ $settingsModel->platin_bonus ?? 0 }}" min="0" step="0.01">
                                </div>
                            </div>

                            <!-- Doğrulama Ayarları -->
                            <div class="row mb-4">
                                <div class="col-12">
                                    <h5 class="border-bottom pb-2 mb-3"><i class="bx bx-shield-check me-2"></i>{{ __('Verification Settings') }}</h5>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox" id="sms_dogrulama" name="sms_dogrulama" value="1" {{ ($settingsModel->sms_dogrulama ?? 0) ? 'checked' : '' }}>
                                        <label class="form-check-label" for="sms_dogrulama">{{ __('SMS Verification Required') }}</label>
                                    </div>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox" id="mail_dogrulama" name="mail_dogrulama" value="1" {{ ($settingsModel->mail_dogrulama ?? 0) ? 'checked' : '' }}>
                                        <label class="form-check-label" for="mail_dogrulama">{{ __('Email Verification Required') }}</label>
                                    </div>
                                </div>
                            </div>

                            <!-- reCAPTCHA Ayarları -->
                            <div class="row mb-4">
                                <div class="col-12">
                                    <h5 class="border-bottom pb-2 mb-3"><i class="bx bx-shield me-2"></i>{{ __('reCAPTCHA Settings') }}</h5>
                                </div>
                                <div class="col-12 mb-3">
                                    <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox" id="recaptcha_enabled" name="recaptcha_enabled" value="1" {{ ($settingsModel->recaptcha_enabled ?? 0) ? 'checked' : '' }}>
                                        <label class="form-check-label" for="recaptcha_enabled">{{ __('Enable reCAPTCHA') }}</label>
                                        <small class="text-muted d-block">{{ __('Protects against bot registrations and logins') }}</small>
                                    </div>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="recaptcha_site_key" class="form-label">{{ __('reCAPTCHA Site Key') }}</label>
                                    <input type="text" class="form-control" id="recaptcha_site_key" name="recaptcha_site_key" value="{{ $settingsModel->recaptcha_site_key ?? '' }}" placeholder="6Lc...">
                                    <small class="text-muted">{{ __('Get from Google reCAPTCHA Console') }}</small>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="recaptcha_secret_key" class="form-label">{{ __('reCAPTCHA Secret Key') }}</label>
                                    <input type="password" class="form-control" id="recaptcha_secret_key" name="recaptcha_secret_key" value="{{ $settingsModel->recaptcha_secret_key ?? '' }}" placeholder="6Lc...">
                                    <small class="text-muted">{{ __('Keep this secret and secure') }}</small>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-12">
                                    <button type="submit" class="btn btn-primary px-5">
                                        <i class="bx bx-save me-2"></i>{{ __('Save Settings') }}
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section("script")
<script src="{{asset('assets/plugins/notifications/js/lobibox.min.js')}}"></script>
<script>
$(document).ready(function() {
    $('#settingsForm').on('submit', function(e) {
        e.preventDefault();
        
        let formData = new FormData(this);
        
        // Checkbox değerlerini kontrol et
        formData.set('sms_dogrulama', $('#sms_dogrulama').is(':checked') ? '1' : '0');
        formData.set('mail_dogrulama', $('#mail_dogrulama').is(':checked') ? '1' : '0');
        
        // Boş string alanları kontrol et
        const textFields = ['keywords', 'description', 'slogan', 'pbirim'];
        textFields.forEach(field => {
            if (!formData.get(field)) {
                formData.set(field, '');
            }
        });
        
        // Numeric alanları kontrol et
        const numericFields = ['komisyon', 'gunluk_bonus', 'min_bakiyecekim', 'ref', 'gold', 'platin', 'silver', 'gold_bonus', 'silver_bonus', 'platin_bonus'];
        numericFields.forEach(field => {
            if (!formData.get(field)) {
                formData.set(field, '0');
            }
        });
        
        $.ajax({
            url: '{{ route("settings.update") }}',
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            beforeSend: function() {
                $('button[type="submit"]').prop('disabled', true).html('<i class="bx bx-loader-alt bx-spin me-2"></i>{{ __("Saving...") }}');
            },
            success: function(response) {
                if (response.success) {
                    Lobibox.notify('success', {
                        pauseDelayOnHover: true,
                        continueDelayOnInactiveTab: false,
                        position: 'top right',
                        icon: 'bx bx-check-circle',
                        msg: response.message
                    });
                } else {
                    Lobibox.notify('error', {
                        pauseDelayOnHover: true,
                        continueDelayOnInactiveTab: false,
                        position: 'top right',
                        icon: 'bx bx-x-circle',
                        msg: response.message
                    });
                }
            },
            error: function(xhr) {
                let message = '{{ __("An error occurred") }}';
                if (xhr.responseJSON && xhr.responseJSON.message) {
                    message = xhr.responseJSON.message;
                }
                
                Lobibox.notify('error', {
                    pauseDelayOnHover: true,
                    continueDelayOnInactiveTab: false,
                    position: 'top right',
                    icon: 'bx bx-x-circle',
                    msg: message
                });
            },
            complete: function() {
                $('button[type="submit"]').prop('disabled', false).html('<i class="bx bx-save me-2"></i>{{ __("Save Settings") }}');
            }
        });
    });
});
</script>
@endsection