@extends('layouts.app')

@section('title', __('Admin - Website Visit Tasks'))

@section('style')
    <link href="{{ asset('assets/plugins/notifications/css/lobibox.min.css') }}" rel="stylesheet">
    <link href="{{ asset('assets/plugins/datatable/css/dataTables.bootstrap5.min.css') }}" rel="stylesheet">
    <style>
        .task-card {
            border: 1px solid #e9ecef;
            border-radius: 16px;
            transition: all 0.3s ease;
            background: white;
            box-shadow: 0 2px 8px rgba(0,0,0,0.08);
            margin-bottom: 20px;
            overflow: hidden;
        }
        .task-card:hover {
            box-shadow: 0 8px 30px rgba(0,0,0,0.15);
            transform: translateY(-3px);
        }
        .task-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 20px;
            position: relative;
        }
        .task-header::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: linear-gradient(90deg, #28a745, #20c997, #17a2b8);
        }
        .creator-avatar {
            width: 45px;
            height: 45px;
            border-radius: 50%;
            background: rgba(255,255,255,0.2);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: bold;
            font-size: 1.1rem;
            border: 2px solid rgba(255,255,255,0.3);
        }
        .reward-badge {
            background: linear-gradient(45deg, #28a745, #20c997);
            color: white;
            padding: 10px 20px;
            border-radius: 25px;
            font-weight: 700;
            font-size: 1.1rem;
            box-shadow: 0 4px 15px rgba(40, 167, 69, 0.3);
        }
        .progress-custom {
            height: 8px;
            border-radius: 10px;
            background: #f8f9fa;
            overflow: hidden;
        }
        .progress-custom .progress-bar {
            border-radius: 10px;
            background: linear-gradient(90deg, #28a745, #20c997);
        }
        .stats-item {
            text-align: center;
            padding: 15px;
            border-radius: 12px;
            background: #f8f9fa;
            margin: 5px;
        }
        .stats-number {
            font-size: 1.5rem;
            font-weight: 700;
            color: #495057;
        }
        .stats-label {
            font-size: 0.85rem;
            color: #6c757d;
            margin-top: 5px;
        }
        .action-buttons {
            display: flex;
            gap: 8px;
            flex-wrap: wrap;
        }
        .action-buttons .btn {
            border-radius: 10px;
            padding: 8px 16px;
            font-weight: 600;
            transition: all 0.3s ease;
        }
        .website-link {
            display: inline-flex;
            align-items: center;
            padding: 8px 15px;
            background: #e3f2fd;
            border-radius: 20px;
            text-decoration: none;
            color: #1976d2;
            font-weight: 500;
            transition: all 0.3s ease;
        }
        .website-link:hover {
            background: #bbdefb;
            color: #0d47a1;
            transform: translateY(-1px);
        }
        .method-badge {
            padding: 6px 12px;
            border-radius: 15px;
            font-size: 0.8rem;
            font-weight: 600;
        }
        .status-badge {
            padding: 8px 16px;
            border-radius: 20px;
            font-weight: 600;
            font-size: 0.85rem;
        }
        .search-container {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 16px;
            padding: 25px;
            margin-bottom: 25px;
            color: white;
        }
        .search-container .form-control {
            border: none;
            border-radius: 12px;
            padding: 12px 16px;
            background: rgba(255,255,255,0.9);
            backdrop-filter: blur(10px);
        }
        .search-container .btn {
            border-radius: 12px;
            padding: 12px 24px;
            font-weight: 600;
            border: 2px solid rgba(255,255,255,0.3);
            background: rgba(255,255,255,0.1);
            color: white;
            backdrop-filter: blur(10px);
        }
        .search-container .btn:hover {
            background: rgba(255,255,255,0.2);
            border-color: rgba(255,255,255,0.5);
            transform: translateY(-2px);
        }
        
        /* Mobile Responsive */
        @media (max-width: 768px) {
            .task-card {
                margin-bottom: 15px;
            }
            .task-header {
                padding: 15px;
            }
            .creator-avatar {
                width: 35px;
                height: 35px;
                font-size: 0.9rem;
            }
            .reward-badge {
                font-size: 0.9rem;
                padding: 8px 16px;
            }
            .stats-item {
                padding: 10px;
                margin: 3px;
            }
            .stats-number {
                font-size: 1.2rem;
            }
            .action-buttons {
                justify-content: center;
            }
            .search-container {
                padding: 20px 15px;
            }
        }
        
        @media (max-width: 576px) {
            .task-header .row {
                text-align: center;
            }
            .creator-avatar {
                margin: 0 auto 10px;
            }
            .reward-badge {
                display: block;
                text-align: center;
                margin-top: 10px;
            }
            .stats-item {
                margin: 2px;
                padding: 8px;
            }
            .action-buttons .btn {
                flex: 1;
                min-width: 0;
            }
        }
        
    </style>
@endsection

@section('wrapper')
<div class="page-wrapper">
    <div class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">{{ __('Admin - Website Visit Tasks') }}</div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item"><a href="{{ route('website-visits.index') }}">{{ __('Website Visits') }}</a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{ __('Admin Panel') }}</li>
                    </ol>
                </nav>
            </div>
            <div class="ms-auto">
                <a href="{{ route('admin.website-visits.proofs.index') }}" class="btn btn-warning me-2">
                    <i class='bx bx-camera me-1'></i>{{ __('Review Proofs') }}
                </a>
                <a href="{{ route('website-visits.index') }}" class="btn btn-secondary">
                    <i class='bx bx-arrow-back me-1'></i>{{ __('Back to Tasks') }}
                </a>
            </div>
        </div>
        <!--end breadcrumb-->

        <!-- Search and Filter Section -->
        <div class="search-container">
            <div class="row align-items-end">
                <div class="col-md-4 mb-3">
                    <label class="form-label text-white">{{ __('Search Tasks') }}</label>
                    <input type="text" class="form-control" id="searchInput" placeholder="{{ __('Search by title, creator, or website...') }}">
                </div>
                <div class="col-md-3 mb-3">
                    <label class="form-label text-white">{{ __('Status Filter') }}</label>
                    <select class="form-select" id="statusFilter">
                        <option value="">{{ __('All Status') }}</option>
                        <option value="active">{{ __('Active') }}</option>
                        <option value="inactive">{{ __('Inactive') }}</option>
                        <option value="expired">{{ __('Expired') }}</option>
                    </select>
                </div>
                <div class="col-md-3 mb-3">
                    <button type="button" class="btn w-100" onclick="filterTasks()">
                        <i class="bx bx-search me-2"></i>{{ __('Filter') }}
                    </button>
                </div>
            </div>
        </div>

        @if($tasks->count() > 0)
            <!-- Card View -->
            <div id="cardViewContainer">
                <div class="row" id="tasksContainer">
                    @foreach($tasks as $task)
                        <div class="col-xl-6 col-lg-12 task-item" 
                             data-title="{{ strtolower($task->title) }}" 
                             data-creator="{{ strtolower($task->creator->name ?? '') }}"
                             data-website="{{ strtolower(parse_url($task->website_url, PHP_URL_HOST) ?? '') }}"
                             data-status="{{ $task->status == 1 ? ($task->expires_at && $task->expires_at->isPast() ? 'expired' : 'active') : 'inactive' }}">
                            <div class="task-card">
                                <!-- Task Header -->
                                <div class="task-header">
                                    <div class="row align-items-center">
                                        <div class="col-md-8">
                                            <div class="d-flex align-items-center">
                                                <div class="creator-avatar me-3">
                                                    {{ substr($task->creator->name ?? 'U', 0, 1) }}
                                                </div>
                                                <div>
                                                    <h5 class="mb-1 text-white">{{ $task->title }}</h5>
                                                    <p class="mb-0 opacity-75">{{ __('by') }} {{ $task->creator->name ?? __('Unknown') }}</p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4 text-md-end">
                                            <div class="reward-badge">
                                                {{ number_format($task->reward_amount, 2, ',', '.') }}{{ $settings['currency'] ?? 'TL' }}
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Task Body -->
                                <div class="card-body">
                                    <div class="row mb-3">
                                        <div class="col-12">
                                            <p class="text-muted mb-2" style="padding-left: 10px;">{{ Str::limit($task->description, 120) }}</p>
                                            <div class="d-flex align-items-center flex-wrap gap-2">
                                                <a href="{{ $task->website_url }}" target="_blank" class="website-link">
                                                    <i class="bx bx-globe me-2"></i>
                                                    {{ parse_url($task->website_url, PHP_URL_HOST) }}
                                                    <i class="bx bx-link-external ms-2"></i>
                                                </a>
                                                @if($task->visit_method === 'direct')
                                                    <span class="method-badge bg-primary text-white">{{ __('Direct Visit') }}</span>
                                                @else
                                                    <span class="method-badge bg-info text-white">{{ __('Google Search') }}</span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Progress Bar -->
                                    <div class="mb-3" style="margin-right: 10px;">
                                        <div class="d-flex justify-content-between align-items-center mb-2">
                                            <span class="text-muted" style="margin-left: 10px;">{{ __('Progress') }}</span>
                                            <span class="fw-bold">{{ $task->completed_visits_count }}/{{ $task->max_completions }}</span>
                                        </div>
                                        <div class="progress-custom">
                                            <div class="progress-bar" style="width: {{ $task->getCompletionPercentage() }}%"></div>
                                        </div>
                                    </div>

                                    <!-- Statistics -->
                                    <div class="row mb-3">
                                        <div class="col-4">
                                            <div class="stats-item">
                                                <div class="stats-number text-success">{{ $task->completed_visits_count }}</div>
                                                <div class="stats-label">{{ __('Completed') }}</div>
                                            </div>
                                        </div>
                                        <div class="col-4">
                                            <div class="stats-item">
                                                <div class="stats-number text-primary">{{ $task->visits_count }}</div>
                                                <div class="stats-label">{{ __('Total Visits') }}</div>
                                            </div>
                                        </div>
                                        <div class="col-4">
                                            <div class="stats-item">
                                                <div class="stats-number text-info">{{ $task->required_time }}s</div>
                                                <div class="stats-label">{{ __('Required Time') }}</div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Status and Actions -->
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div>
                                            @if($task->status == 1)
                                                @if($task->expires_at && $task->expires_at->isPast())
                                                    <span class="status-badge bg-warning text-dark">{{ __('Expired') }}</span>
                                                @else
                                                    <span class="status-badge bg-success text-white">{{ __('Active') }}</span>
                                                @endif
                                            @else
                                                <span class="status-badge bg-secondary text-white">{{ __('Inactive') }}</span>
                                            @endif
                                            <small class="text-muted ms-2">{{ $task->created_at->format('d/m/Y') }}</small>
                                        </div>
                                        <div class="action-buttons" style="margin-right: 10px;">
                                            <a href="{{ route('admin.website-visits.show', $task) }}" 
                                               class="btn btn-outline-primary btn-sm" title="{{ __('View Details') }}">
                                                <i class="bx bx-show me-1"></i>{{ __('Details') }}
                                            </a>
                                            <button class="btn btn-outline-danger btn-sm" 
                                                    onclick="deleteTask({{ $task->id }})" title="{{ __('Delete') }}">
                                                <i class="bx bx-trash me-1"></i>{{ __('Delete') }}
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>

            <!-- Pagination -->
            <div class="d-flex justify-content-center mt-4">
                {{ $tasks->links() }}
            </div>
        @else
            <div class="card">
                <div class="card-body">
                    <div class="text-center py-5">
                        <i class='bx bx-globe display-1 text-muted'></i>
                        <h4 class="mt-3">{{ __('No Website Visit Tasks') }}</h4>
                        <p class="text-muted">{{ __('No website visit tasks have been created yet.') }}</p>
                        <a href="{{ route('website-visits.create') }}" class="btn btn-primary mt-3">
                            <i class="bx bx-plus me-2"></i>{{ __('Create First Task') }}
                        </a>
                    </div>
                </div>
            </div>
        @endif
    </div>
</div>
@endsection

@section('script')
    <script src="{{ asset('assets/plugins/notifications/js/lobibox.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/notifications/js/notifications.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatable/js/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatable/js/dataTables.bootstrap5.min.js') }}"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script>
        $(document).ready(function() {
            // Initialize DataTable
            $('#tasksTable').DataTable({
                order: [[7, 'desc']], // Sort by created date
                pageLength: 25,
                responsive: true,
                language: {
                    search: "{{ __('Search') }}:",
                    lengthMenu: "{{ __('Show') }} _MENU_ {{ __('entries') }}",
                    info: "{{ __('Showing') }} _START_ {{ __('to') }} _END_ {{ __('of') }} _TOTAL_ {{ __('entries') }}",
                    paginate: {
                        first: "{{ __('First') }}",
                        last: "{{ __('Last') }}",
                        next: "{{ __('Next') }}",
                        previous: "{{ __('Previous') }}"
                    }
                }
            });


            // Search functionality
            $('#searchInput').on('keyup', function() {
                filterTasks();
            });

            $('#statusFilter').on('change', function() {
                filterTasks();
            });
        });

        // Filter tasks function
        function filterTasks() {
            const searchTerm = $('#searchInput').val().toLowerCase();
            const statusFilter = $('#statusFilter').val();

            $('.task-item').each(function() {
                const $item = $(this);
                const title = $item.data('title') || '';
                const creator = $item.data('creator') || '';
                const website = $item.data('website') || '';
                const status = $item.data('status') || '';

                const matchesSearch = title.includes(searchTerm) || 
                                    creator.includes(searchTerm) || 
                                    website.includes(searchTerm);
                
                const matchesStatus = !statusFilter || status === statusFilter;

                if (matchesSearch && matchesStatus) {
                    $item.show();
                } else {
                    $item.hide();
                }
            });

            // Update visible count
            const visibleCount = $('.task-item:visible').length;
            const totalCount = $('.task-item').length;
            
            if (visibleCount === 0) {
                if (!$('#noResultsMessage').length) {
                    $('#tasksContainer').append(`
                        <div class="col-12" id="noResultsMessage">
                            <div class="text-center py-5">
                                <i class="bx bx-search-alt-2 display-1 text-muted"></i>
                                <h4 class="mt-3">{{ __('No tasks found') }}</h4>
                                <p class="text-muted">{{ __('Try adjusting your search criteria') }}</p>
                            </div>
                        </div>
                    `);
                }
            } else {
                $('#noResultsMessage').remove();
            }
        }

        // Delete task function
        function deleteTask(taskId) {
            Swal.fire({
                title: '{{ __("Are you sure?") }}',
                text: '{{ __("This action cannot be undone!") }}',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: '{{ __("Yes, delete it!") }}',
                cancelButtonText: '{{ __("Cancel") }}'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: `{{ url('/admin/website-visits') }}/${taskId}/delete`,
                        type: 'POST',
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
                            'X-Requested-With': 'XMLHttpRequest'
                        },
                        success: function(response) {
                            showNotification('success', '{{ __("Success") }}', '{{ __("Task deleted successfully.") }}');
                            setTimeout(() => {
                                location.reload();
                            }, 1500);
                        },
                        error: function(xhr) {
                            const message = xhr.responseJSON?.message || '{{ __("An error occurred") }}';
                            showNotification('error', '{{ __("Error") }}', message);
                        }
                    });
                }
            });
        }

        // Notification function
        function showNotification(type, title, message) {
            Lobibox.notify(type, {
                pauseDelayOnHover: true,
                continueDelayOnInactiveTab: false,
                position: 'top right',
                icon: type === 'success' ? 'bx bx-check-circle' : 'bx bx-x-circle',
                title: title,
                msg: message,
                delay: 4000
            });
        }


        // Auto-refresh every 30 seconds for real-time updates
        setInterval(function() {
            // Only refresh if user is not actively interacting
            if (document.hidden === false && $('#searchInput').val() === '' && $('#statusFilter').val() === '') {
                location.reload();
            }
        }, 300000);
    </script>
@endsection