@extends('layouts.app')

@section('title', __('Website Visit Task Details') . ' - ' . ($settings['site_name'] ?? 'Site'))

@section('style')
    <link href="{{ asset('assets/plugins/datatable/css/dataTables.bootstrap5.min.css') }}" rel="stylesheet" />
    <link href="{{ asset('assets/plugins/notifications/css/lobibox.min.css') }}" rel="stylesheet"/>
@endsection

@section('wrapper')
<div class="page-wrapper">
    <div class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">{{ __('Website Visit Task Details') }}</div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="{{ url('/home') }}"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.website-visits.index') }}">{{ __('Admin Panel') }}</a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{ __('Task Details') }}</li>
                    </ol>
                </nav>
            </div>
            <div class="ms-auto">
                <a href="{{ route('admin.website-visits.index') }}" class="btn btn-secondary">
                    <i class='bx bx-arrow-back'></i> {{ __('Back to List') }}
                </a>
            </div>
        </div>
        <!--end breadcrumb-->

        <!-- Task Information Card -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0">{{ __('Task Information') }}</h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <table class="table table-borderless">
                                    <tr>
                                        <td><strong>{{ __('Task Title') }}:</strong></td>
                                        <td>{{ $task->title }}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>{{ __('Website URL') }}:</strong></td>
                                        <td><a href="{{ $task->website_url }}" target="_blank">{{ $task->website_url }}</a></td>
                                    </tr>
                                    <tr>
                                        <td><strong>{{ __('Reward Amount') }}:</strong></td>
                                        <td>{{ number_format($task->reward_amount, 2, ',', '.') }}{{ $settings['currency'] ?? 'TL' }}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>{{ __('Visit Duration') }}:</strong></td>
                                        <td>{{ $task->visit_duration }} {{ __('seconds') }}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>{{ __('Daily Limit') }}:</strong></td>
                                        <td>{{ $task->user_daily_limit ?? __('Unlimited') }}</td>
                                    </tr>
                                </table>
                            </div>
                            <div class="col-md-6">
                                <table class="table table-borderless">
                                    <tr>
                                        <td><strong>{{ __('Status') }}:</strong></td>
                                        <td>
                                            @if($task->status == 1 || $task->status == 'active')
                                                <span class="badge bg-success">{{ __('Active') }}</span>
                                            @elseif($task->status == 0 || $task->status == 'inactive')
                                                <span class="badge bg-warning">{{ __('Inactive') }}</span>
                                            @elseif($task->status == 2 || $task->status == 'pending')
                                                <span class="badge bg-info">{{ __('Pending Approval') }}</span>
                                            @else
                                                <span class="badge bg-danger">{{ __('Deleted') }}</span>
                                            @endif
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><strong>{{ __('Country') }}:</strong></td>
                                        <td>{{ $task->country->name ?? __('All Countries') }}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>{{ __('City') }}:</strong></td>
                                        <td>{{ $task->city->name ?? __('All Cities') }}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>{{ __('Created By') }}:</strong></td>
                                        <td>
                                            @if($task->creator)
                                                <a href="{{ route('user.profile') }}?user={{ $task->creator->id }}" class="text-decoration-none">
                                                    <div class="d-flex align-items-center">
                                                        <img src="{{ asset('assets/images/avatars/' . ($task->creator->avatar ?? 'avatar-1.png')) }}" 
                                                             alt="{{ $task->creator->account_holder ?? $task->creator->name }}" 
                                                             class="rounded-circle me-2" width="24" height="24">
                                                        <span class="text-primary">{{ $task->creator->account_holder ?? $task->creator->name }}</span>
                                                    </div>
                                                </a>
                                            @else
                                                <span class="text-muted">{{ __('Unknown User') }}</span>
                                            @endif
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><strong>{{ __('Created At') }}:</strong></td>
                                        <td>{{ $task->created_at->format('d.m.Y H:i') }}</td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                        @if($task->description)
                        <div class="row mt-3">
                            <div class="col-12">
                                <strong>{{ __('Description') }}:</strong>
                                <p class="mt-2">{{ $task->description }}</p>
                            </div>
                        </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>

        <!-- Statistics Cards -->
        <div class="row">
            <div class="col-xl-3 col-md-6">
                <div class="card radius-10 border-start border-0 border-4 border-info">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">{{ __('Total Visits') }}</p>
                                <h4 class="my-1 text-info">{{ $stats['total_visits'] }}</h4>
                            </div>
                            <div class="widgets-icons-2 rounded-circle bg-gradient-blues text-white ms-auto">
                                <i class='bx bx-mouse'></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-3 col-md-6">
                <div class="card radius-10 border-start border-0 border-4 border-success">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">{{ __('Completed Visits') }}</p>
                                <h4 class="my-1 text-success">{{ $stats['completed_visits'] }}</h4>
                            </div>
                            <div class="widgets-icons-2 rounded-circle bg-gradient-ohhappiness text-white ms-auto">
                                <i class='bx bx-check-circle'></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-3 col-md-6">
                <div class="card radius-10 border-start border-0 border-4 border-danger">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">{{ __('Failed Visits') }}</p>
                                <h4 class="my-1 text-danger">{{ $stats['failed_visits'] }}</h4>
                            </div>
                            <div class="widgets-icons-2 rounded-circle bg-gradient-burning text-white ms-auto">
                                <i class='bx bx-x-circle'></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-3 col-md-6">
                <div class="card radius-10 border-start border-0 border-4 border-warning">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">{{ __('Unique Users') }}</p>
                                <h4 class="my-1 text-warning">{{ $stats['unique_users'] }}</h4>
                            </div>
                            <div class="widgets-icons-2 rounded-circle bg-gradient-orange text-white ms-auto">
                                <i class='bx bx-user'></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Additional Statistics -->
        <div class="row">
            <div class="col-xl-3 col-md-6">
                <div class="card radius-10 border-start border-0 border-4 border-primary">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">{{ __('Total Rewards Given') }}</p>
                                <h4 class="my-1 text-primary">{{ number_format($stats['total_rewards_given'], 2, ',', '.') }}{{ $settings['currency'] ?? 'TL' }}</h4>
                            </div>
                            <div class="widgets-icons-2 rounded-circle bg-gradient-blues text-white ms-auto">
                                <i class='bx bx-money'></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-3 col-md-6">
                <div class="card radius-10 border-start border-0 border-4 border-secondary">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">{{ __('Average Duration') }}</p>
                                <h4 class="my-1 text-secondary">{{ number_format($stats['avg_duration'] ?? 0, 1) }}s</h4>
                            </div>
                            <div class="widgets-icons-2 rounded-circle bg-gradient-moonlit text-white ms-auto">
                                <i class='bx bx-time'></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-3 col-md-6">
                <div class="card radius-10 border-start border-0 border-4 border-info">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">{{ __('Today Visits') }}</p>
                                <h4 class="my-1 text-info">{{ $stats['today_visits'] }}</h4>
                            </div>
                            <div class="widgets-icons-2 rounded-circle bg-gradient-blues text-white ms-auto">
                                <i class='bx bx-calendar'></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-3 col-md-6">
                <div class="card radius-10 border-start border-0 border-4 border-warning">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">{{ __('Pending Proofs') }}</p>
                                <h4 class="my-1 text-warning">{{ $stats['pending_proofs'] }}</h4>
                            </div>
                            <div class="widgets-icons-2 rounded-circle bg-gradient-orange text-white ms-auto">
                                <i class='bx bx-hourglass'></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Recent Visits Table -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="card-title mb-0">{{ __('Recent Visits') }}</h5>
                        <div class="d-flex gap-2">
                            <select id="statusFilter" class="form-select form-select-sm" style="width: auto;">
                                <option value="">{{ __('All Status') }}</option>
                                <option value="completed">{{ __('Completed') }}</option>
                                <option value="in_progress">{{ __('In Progress') }}</option>
                                <option value="failed">{{ __('Failed') }}</option>
                                <option value="started">{{ __('Started') }}</option>
                            </select>
                            <button type="button" class="btn btn-sm btn-primary" onclick="refreshVisits()">
                                <i class='bx bx-refresh'></i> {{ __('Refresh') }}
                            </button>
                            <button type="button" class="btn btn-sm btn-success" onclick="exportVisits()">
                                <i class='bx bx-download'></i> {{ __('Export') }}
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="recentVisitsTable" class="table table-striped table-bordered">
                                <thead>
                                    <tr>
                                        <th>{{ __('User') }}</th>
                                        <th>{{ __('Status') }}</th>
                                        <th>{{ __('Duration') }}</th>
                                        <th>{{ __('Reward Given') }}</th>
                                        <th>{{ __('Started At') }}</th>
                                        <th>{{ __('Completed At') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($recentVisits as $visit)
                                    <tr>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <img src="{{ asset('assets/images/avatars/' . ($visit->user->avatar ?? 'avatar-1.png')) }}" 
                                                     alt="{{ $visit->user->account_holder ?? $visit->user->name }}" class="rounded-circle" width="32" height="32">
                                                <div class="ms-2">
                                                    <a href="{{ route('user.profile') }}?user={{ $visit->user->id }}" class="text-decoration-none">
                                                        <h6 class="mb-0 text-primary">{{ $visit->user->account_holder ?? $visit->user->name }}</h6>
                                                    </a>
                                                    <p class="text-muted mb-0 small">{{ $visit->user->email }}</p>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            @php
                                                // Kanıt varsa ve onaylanmışsa completed olarak göster
                                                $hasApprovedProof = $visit->proofs()->where('status', 1)->exists();
                                                $displayStatus = $hasApprovedProof ? 'completed' : $visit->status;
                                            @endphp
                                            @if($displayStatus == 'completed')
                                                <span class="badge bg-success">{{ __('Completed') }}</span>
                                                @if($hasApprovedProof && $visit->status != 'completed')
                                                    <small class="text-muted d-block">{{ __('Proof Approved') }}</small>
                                                @endif
                                            @elseif($displayStatus == 'failed')
                                                <span class="badge bg-danger">{{ __('Failed') }}</span>
                                            @elseif($displayStatus == 'in_progress')
                                                <span class="badge bg-warning">{{ __('In Progress') }}</span>
                                                @if($visit->proofs()->where('status', 0)->exists())
                                                    <small class="text-info d-block">{{ __('Proof Pending') }}</small>
                                                @endif
                                            @else
                                                <span class="badge bg-secondary">{{ __('Started') }}</span>
                                            @endif
                                        </td>
                                        <td>
                                            @if($visit->duration)
                                                {{ $visit->duration }}s
                                            @else
                                                <span class="text-muted">-</span>
                                            @endif
                                        </td>
                                        <td>
                                            @if($visit->reward_given)
                                                <span class="badge bg-success">{{ __('Yes') }}</span>
                                            @else
                                                <span class="badge bg-secondary">{{ __('No') }}</span>
                                            @endif
                                        </td>
                                        <td>{{ $visit->created_at->format('d.m.Y H:i') }}</td>
                                        <td>
                                            @php
                                                // Kanıt onaylanmışsa onay tarihini, yoksa completed_at'i göster
                                                $approvedProof = $visit->proofs()->where('status', 1)->first();
                                                $completedDate = null;
                                                
                                                if ($approvedProof && $approvedProof->reviewed_at) {
                                                    $completedDate = $approvedProof->reviewed_at;
                                                } elseif ($visit->completed_at) {
                                                    $completedDate = $visit->completed_at;
                                                } elseif ($visit->end_time && $visit->status == 'completed') {
                                                    $completedDate = $visit->end_time;
                                                }
                                            @endphp
                                            @if($completedDate)
                                                {{ $completedDate->format('d.m.Y H:i') }}
                                                @if($approvedProof && $approvedProof->reviewed_at)
                                                    <small class="text-success d-block">{{ __('Proof Approved') }}</small>
                                                @endif
                                            @else
                                                <span class="text-muted">-</span>
                                            @endif
                                        </td>
                                    </tr>
                                    @empty
                                    <tr>
                                        <td colspan="6" class="text-center">{{ __('No visits found') }}</td>
                                    </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                        
                        <!-- Pagination for more visits -->
                        <div class="d-flex justify-content-between align-items-center mt-3">
                            <div>
                                <small class="text-muted">{{ __('Showing last 5 visits') }}</small>
                            </div>
                            <div>
                                <button type="button" class="btn btn-outline-primary btn-sm" onclick="showAllVisits()">
                                    <i class='bx bx-list-ul'></i> {{ __('View All Visits') }}
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Action Buttons -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex gap-2">
                            @if($task->status == 'active')
                                <button type="button" class="btn btn-warning" onclick="toggleTaskStatus('inactive')">
                                    <i class='bx bx-pause'></i> {{ __('Deactivate Task') }}
                                </button>
                            @elseif($task->status == 'inactive')
                                <button type="button" class="btn btn-success" onclick="toggleTaskStatus('active')">
                                    <i class='bx bx-play'></i> {{ __('Activate Task') }}
                                </button>
                            @endif
                            
                            <button type="button" class="btn btn-danger" onclick="deleteTask()">
                                <i class='bx bx-trash'></i> {{ __('Delete Task') }}
                            </button>
                            
                            <a href="{{ route('admin.website-visits.proofs.index') }}" class="btn btn-info">
                                <i class='bx bx-check-square'></i> {{ __('Review Proofs') }}
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('script')
<script src="{{ asset('assets/plugins/notifications/js/lobibox.min.js') }}"></script>

<script>
function toggleTaskStatus(newStatus) {
    Swal.fire({
        title: '{{ __("Are you sure?") }}',
        text: newStatus === 'active' ? '{{ __("This will activate the task") }}' : '{{ __("This will deactivate the task") }}',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: '{{ __("Yes, continue!") }}',
        cancelButtonText: '{{ __("Cancel") }}'
    }).then((result) => {
        if (result.isConfirmed) {
            // Here you would implement the AJAX call to update task status
            // For now, just show a success message
            Lobibox.notify('success', {
                pauseDelayOnHover: true,
                continueDelayOnInactiveTab: false,
                position: 'top right',
                icon: 'bx bx-check',
                title: '{{ __("Success") }}',
                msg: '{{ __("Task status updated successfully!") }}',
                delay: 3000
            });
        }
    });
}

function deleteTask() {
    Swal.fire({
        title: '{{ __("Are you sure?") }}',
        text: '{{ __("This action cannot be undone!") }}',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#3085d6',
        confirmButtonText: '{{ __("Yes, delete it!") }}',
        cancelButtonText: '{{ __("Cancel") }}'
    }).then((result) => {
        if (result.isConfirmed) {
            // Create a form and submit it for deletion
            const form = document.createElement('form');
            form.method = 'POST';
            form.action = '{{ route("admin.website-visits.destroy", $task) }}';
            
            const methodInput = document.createElement('input');
            methodInput.type = 'hidden';
            methodInput.name = '_method';
            methodInput.value = 'DELETE';
            
            const tokenInput = document.createElement('input');
            tokenInput.type = 'hidden';
            tokenInput.name = '_token';
            tokenInput.value = '{{ csrf_token() }}';
            
            form.appendChild(methodInput);
            form.appendChild(tokenInput);
            document.body.appendChild(form);
            form.submit();
        }
    });
}

// Refresh visits function
function refreshVisits() {
    const taskId = {{ $task->id }};
    const status = document.getElementById('statusFilter').value;
    
    // Show loading state
    const tableBody = document.querySelector('#recentVisitsTable tbody');
    const refreshBtn = document.querySelector('button[onclick="refreshVisits()"]');
    const originalBtnText = refreshBtn.innerHTML;
    
    // Update button to show loading
    refreshBtn.innerHTML = '<i class="bx bx-loader-alt bx-spin"></i> {{ __("Refreshing...") }}';
    refreshBtn.disabled = true;
    
    // Add loading row
    tableBody.innerHTML = '<tr><td colspan="6" class="text-center"><i class="bx bx-loader-alt bx-spin me-2"></i>{{ __("Loading...") }}</td></tr>';
    
    // Make AJAX request
    let url = `{{ url('/admin/website-visits/' . $task->id . '/recent-visits') }}`;
    if (status) {
        url += `?status=${status}`;
    }
    
    fetch(url, {
        method: 'GET',
        headers: {
            'X-Requested-With': 'XMLHttpRequest',
            'Accept': 'application/json'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            // Update table content
            tableBody.innerHTML = data.html;
            
            // Update statistics if provided
            if (data.stats) {
                updateStatistics(data.stats);
            }
            
            // Show success notification
            Lobibox.notify('success', {
                pauseDelayOnHover: true,
                continueDelayOnInactiveTab: false,
                position: 'top right',
                icon: 'bx bx-check',
                title: '{{ __("Success") }}',
                msg: '{{ __("Recent visits refreshed successfully!") }}',
                delay: 3000
            });
        } else {
            throw new Error(data.message || 'Unknown error');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        
        // Show error notification
        Lobibox.notify('error', {
            pauseDelayOnHover: true,
            continueDelayOnInactiveTab: false,
            position: 'top right',
            icon: 'bx bx-x',
            title: '{{ __("Error") }}',
            msg: '{{ __("Failed to refresh recent visits!") }}',
            delay: 5000
        });
        
        // Restore original content on error
        location.reload();
    })
    .finally(() => {
        // Restore button state
        refreshBtn.innerHTML = originalBtnText;
        refreshBtn.disabled = false;
    });
}

// Update statistics cards
function updateStatistics(stats) {
    // Update total visits
    const totalVisitsElement = document.querySelector('.card:has(.bx-mouse) h4');
    if (totalVisitsElement) {
        totalVisitsElement.textContent = stats.total_visits;
    }
    
    // Update completed visits
    const completedVisitsElement = document.querySelector('.card:has(.bx-check-circle) h4');
    if (completedVisitsElement) {
        completedVisitsElement.textContent = stats.completed_visits;
    }
    
    // Update failed visits
    const failedVisitsElement = document.querySelector('.card:has(.bx-x-circle) h4');
    if (failedVisitsElement) {
        failedVisitsElement.textContent = stats.failed_visits;
    }
    
    // Update unique users
    const uniqueUsersElement = document.querySelector('.card:has(.bx-user) h4');
    if (uniqueUsersElement) {
        uniqueUsersElement.textContent = stats.unique_users;
    }
    
    // Update today visits
    const todayVisitsElement = document.querySelector('.card:has(.bx-calendar-today) h4');
    if (todayVisitsElement) {
        todayVisitsElement.textContent = stats.today_visits;
    }
    
    // Update pending proofs
    const pendingProofsElement = document.querySelector('.card:has(.bx-hourglass) h4');
    if (pendingProofsElement) {
        pendingProofsElement.textContent = stats.pending_proofs;
    }
}

// Export visits function
function exportVisits() {
    const taskId = {{ $task->id }};
    const status = document.getElementById('statusFilter').value;
    let url = `/admin/website-visits/${taskId}/export`;
    if (status) {
        url += `?status=${status}`;
    }
    
    // Show loading notification
    Lobibox.notify('info', {
        pauseDelayOnHover: true,
        continueDelayOnInactiveTab: false,
        position: 'top right',
        icon: 'bx bx-download',
        title: '{{ __("Exporting") }}',
        msg: '{{ __("Generating professional PDF report...") }}',
        delay: 3000
    });
    
    // Open download link
    window.open(url, '_blank');
}

// Show all visits in modal
function showAllVisits() {
    // Bu fonksiyon için ayrı bir modal ve AJAX endpoint gerekir
    Swal.fire({
        title: '{{ __("All Visits") }}',
        text: '{{ __("This feature will show all visits in a paginated modal") }}',
        icon: 'info',
        confirmButtonText: '{{ __("OK") }}'
    });
}

// Status filter change handler - now triggers AJAX refresh
document.getElementById('statusFilter').addEventListener('change', function() {
    // Automatically refresh with new filter
    refreshVisits();
});

// Include SweetAlert2 if not already included
if (typeof Swal === 'undefined') {
    const script = document.createElement('script');
    script.src = 'https://cdn.jsdelivr.net/npm/sweetalert2@11';
    document.head.appendChild(script);
}
</script>
@endsection