@extends('layouts.app')

@section('style')
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" rel="stylesheet">
@endsection

@section('wrapper')
<div class="page-wrapper">
    <div class="page-content">
        <!-- Header -->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">{{__('Announcements')}}</div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="{{ url('/home') }}"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item"><a href="{{ route('announcements.index') }}">{{__('Announcements')}}</a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{__('Create Announcement')}}</li>
                    </ol>
                </nav>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">{{__('Create New Announcement')}}</h5>
                    </div>
                    <div class="card-body">
                        <form id="createAnnouncementForm">
                            @csrf
                            
                            <!-- Title -->
                            <div class="mb-3">
                                <label for="title" class="form-label">{{__('Title')}} <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="title" name="title" required maxlength="255">
                            </div>

                            <!-- Content -->
                            <div class="mb-3">
                                <label for="content" class="form-label">{{__('Content')}} <span class="text-danger">*</span></label>
                                <textarea class="form-control" id="content" name="content" rows="6" required maxlength="5000" placeholder="{{__('Enter announcement content...')}}"></textarea>
                                <div class="form-text">{{__('Remaining characters')}}: <span id="contentCharCount">5000</span></div>
                            </div>

                            <!-- Type -->
                            <div class="mb-3">
                                <label for="type" class="form-label">{{__('Type')}} <span class="text-danger">*</span></label>
                                <select class="form-select" id="type" name="type" required>
                                    <option value="">{{__('Select Type')}}</option>
                                    <option value="general">{{__('General')}} - {{__('All users can see')}}</option>
                                    <option value="user_specific">{{__('User Specific')}} - {{__('Only selected users can see')}}</option>
                                </select>
                            </div>

                            <!-- Target Users (for user_specific type) -->
                            <div class="mb-3" id="targetUsersDiv" style="display: none;">
                                <label for="targetUsers" class="form-label">{{__('Target Users')}} <span class="text-danger">*</span></label>
                                <select class="form-select" id="targetUsers" name="target_users[]" multiple>
                                </select>
                                <div class="form-text">{{__('Search and select users who can see this announcement')}}</div>
                            </div>

                            <!-- Priority -->
                            <div class="mb-3">
                                <label for="priority" class="form-label">{{__('Priority')}} <span class="text-danger">*</span></label>
                                <select class="form-select" id="priority" name="priority" required>
                                    <option value="">{{__('Select Priority')}}</option>
                                    <option value="low">{{__('Low')}}</option>
                                    <option value="medium" selected>{{__('Medium')}}</option>
                                    <option value="high">{{__('High')}}</option>
                                    <option value="urgent">{{__('Urgent')}}</option>
                                </select>
                            </div>

                            <!-- Options -->
                            <div class="mb-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="showAsPopup" name="show_as_popup" value="1" checked>
                                    <label class="form-check-label" for="showAsPopup">
                                        {{__('Show as popup to users')}}
                                    </label>
                                </div>
                            </div>

                            <!-- Expires At -->
                            <div class="mb-3">
                                <label for="expiresAt" class="form-label">{{__('Expires At')}} <span class="text-muted">({{__('Optional')}})</span></label>
                                <input type="datetime-local" class="form-control" id="expiresAt" name="expires_at">
                                <div class="form-text">{{__('Leave empty for no expiration')}}</div>
                            </div>

                            <!-- Submit Button -->
                            <div class="d-grid">
                                <button type="submit" class="btn btn-primary" id="createBtn">
                                    <i class="bx bx-plus me-2"></i>{{__('Create Announcement')}}
                                    <span class="spinner-border spinner-border-sm ms-2 d-none" id="createSpinner"></span>
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-4">
                <div class="card">
                    <div class="card-header">
                        <h6 class="mb-0">{{__('Help & Tips')}}</h6>
                    </div>
                    <div class="card-body">
                        <div class="alert alert-info">
                            <h6>{{__('Announcement Types')}}</h6>
                            <ul class="mb-0">
                                <li><strong>{{__('General')}}:</strong> {{__('Visible to all users')}}</li>
                                <li><strong>{{__('User Specific')}}:</strong> {{__('Visible only to selected users')}}</li>
                            </ul>
                        </div>
                        
                        <div class="alert alert-warning">
                            <h6>{{__('Priority Levels')}}</h6>
                            <ul class="mb-0">
                                <li><span class="badge bg-success">{{__('Low')}}</span> - {{__('Regular information')}}</li>
                                <li><span class="badge bg-info">{{__('Medium')}}</span> - {{__('Important updates')}}</li>
                                <li><span class="badge bg-warning">{{__('High')}}</span> - {{__('Critical information')}}</li>
                                <li><span class="badge bg-danger">{{__('Urgent')}}</span> - {{__('Immediate attention required')}}</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('script')
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script>
$(document).ready(function() {
    // Character counter
    $('#content').on('input', function() {
        const remaining = 5000 - $(this).val().length;
        $('#contentCharCount').text(remaining);
        
        if (remaining < 100) {
            $('#contentCharCount').addClass('text-danger');
        } else {
            $('#contentCharCount').removeClass('text-danger');
        }
    });

    // Type change handler
    $('#type').on('change', function() {
        if ($(this).val() === 'user_specific') {
            $('#targetUsersDiv').show();
            $('#targetUsers').prop('required', true);
            initializeUserSelect();
        } else {
            $('#targetUsersDiv').hide();
            $('#targetUsers').prop('required', false);
        }
    });

    // Form submission
    $('#createAnnouncementForm').on('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        
        $('#createBtn').prop('disabled', true);
        $('#createSpinner').removeClass('d-none');
        
        $.ajax({
            url: '{{ route('admin.announcements.store') }}',
            method: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                if (response.success) {
                    Lobibox.notify('success', {
                        title: '{{__('Success')}}',
                        msg: response.message,
                        sound: false
                    });
                    
                    setTimeout(() => {
                        window.location.href = '{{ route('announcements.index') }}';
                    }, 1000);
                } else {
                    Lobibox.notify('error', {
                        title: '{{__('Error')}}',
                        msg: response.message,
                        sound: false
                    });
                }
            },
            error: function(xhr) {
                if (xhr.status === 422) {
                    const errors = xhr.responseJSON?.errors;
                    let errorMsg = '{{__('Please check your input and try again.')}}';
                    if (errors) {
                        const firstError = Object.values(errors)[0];
                        if (firstError && firstError[0]) {
                            errorMsg = firstError[0];
                        }
                    }
                    Lobibox.notify('error', {
                        title: '{{__('Validation Error')}}',
                        msg: errorMsg,
                        sound: false
                    });
                } else {
                    Lobibox.notify('error', {
                        title: '{{__('Error')}}',
                        msg: '{{__('Error creating announcement')}}',
                        sound: false
                    });
                }
            },
            complete: function() {
                $('#createBtn').prop('disabled', false);
                $('#createSpinner').addClass('d-none');
            }
        });
    });
});

function initializeUserSelect() {
    if (!$('#targetUsers').hasClass('select2-hidden-accessible')) {
        $('#targetUsers').select2({
            theme: 'bootstrap-5',
            ajax: {
                url: '/api/users/search',
                dataType: 'json',
                delay: 250,
                data: function (params) {
                    return {
                        q: params.term,
                        page: params.page
                    };
                },
                processResults: function (data, params) {
                    params.page = params.page || 1;
                    return {
                        results: data.data.map(function(user) {
                            return {
                                id: user.id,
                                text: user.account_holder + ' (' + user.email + ')'
                            };
                        }),
                        pagination: {
                            more: data.has_more
                        }
                    };
                },
                cache: true
            },
            placeholder: '{{__('Search users...')}}',
            minimumInputLength: 2
        });
    }
}
</script>
@endsection