@extends('layouts.app')

@section('wrapper')
<div class="page-wrapper">
    <div class="page-content">
        <!-- Header -->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">{{__('Announcements')}}</div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="{{ url('/home') }}"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{__('Announcements')}}</li>
                    </ol>
                </nav>
            </div>
        </div>

        @if(auth()->user()->user_type == 1)
        <!-- Admin View -->
        <div class="card">
            <div class="card-header">
                <div class="d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">{{__('Announcements Management')}}</h5>
                    <a href="{{ route('admin.announcements.create') }}" class="btn btn-primary">
                        <i class="bx bx-plus me-2"></i>{{__('Create Announcement')}}
                    </a>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>{{__('Title')}}</th>
                                <th>{{__('Type')}}</th>
                                <th>{{__('Priority')}}</th>
                                <th>{{__('Status')}}</th>
                                <th>{{__('Created')}}</th>
                                <th>{{__('Actions')}}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($announcements as $announcement)
                            <tr>
                                <td>
                                    <div>
                                        <strong>{{ $announcement->title }}</strong>
                                        @if($announcement->show_as_popup)
                                        <span class="badge bg-info ms-2">{{__('Popup')}}</span>
                                        @endif
                                    </div>
                                </td>
                                <td>
                                    <span class="badge bg-secondary">{{ $announcement->type_text }}</span>
                                </td>
                                <td>
                                    <span class="badge bg-{{ $announcement->priority_badge }}">{{ $announcement->priority_text }}</span>
                                </td>
                                <td>
                                    @if($announcement->is_active && !$announcement->isExpired())
                                    <span class="badge bg-success">{{__('Active')}}</span>
                                    @elseif($announcement->isExpired())
                                    <span class="badge bg-warning">{{__('Expired')}}</span>
                                    @else
                                    <span class="badge bg-secondary">{{__('Inactive')}}</span>
                                    @endif
                                </td>
                                <td>{{ $announcement->created_at->format('d.m.Y H:i') }}</td>
                                <td>
                                    <div class="d-flex gap-1">
                                        <a href="{{ route('announcements.show', $announcement->id) }}" class="btn btn-sm btn-outline-primary">
                                            <i class="bx bx-show"></i>
                                        </a>
                                        <a href="{{ route('admin.announcements.edit', $announcement->id) }}" class="btn btn-sm btn-outline-warning">
                                            <i class="bx bx-edit"></i>
                                        </a>
                                        <button class="btn btn-sm btn-outline-danger" onclick="deleteAnnouncement({{ $announcement->id }})">
                                            <i class="bx bx-trash"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                
                {{ $announcements->links() }}
            </div>
        </div>
        @else
        <!-- User View -->
        <div class="row">
            @forelse($announcements as $announcement)
            <div class="col-lg-6 col-xl-4">
                <div class="card announcement-card h-100">
                    <div class="card-header">
                        <div class="d-flex justify-content-between align-items-start">
                            <h6 class="mb-0">{{ $announcement->title }}</h6>
                            <span class="badge bg-{{ $announcement->priority_badge }}">{{ $announcement->priority_text }}</span>
                        </div>
                    </div>
                    <div class="card-body">
                        <p class="card-text">{{ Str::limit(strip_tags($announcement->content), 150) }}</p>
                        <div class="d-flex justify-content-between align-items-center">
                            <small class="text-muted">
                                <i class="bx bx-time me-1"></i>{{ $announcement->created_at->diffForHumans() }}
                            </small>
                            <a href="{{ route('announcements.show', $announcement->id) }}" class="btn btn-sm btn-primary">
                                {{__('Read More')}}
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            @empty
            <div class="col-12">
                <div class="text-center py-5">
                    <i class="bx bx-bullhorn display-1 text-muted"></i>
                    <h5 class="mt-3">{{__('No announcements found')}}</h5>
                    <p class="text-muted">{{__('There are no announcements available at the moment.')}}</p>
                </div>
            </div>
            @endforelse
        </div>
        
        @if($announcements->hasPages())
        <div class="d-flex justify-content-center mt-4">
            {{ $announcements->links() }}
        </div>
        @endif
        @endif
    </div>
</div>
@endsection

@section('script')
<script>
function deleteAnnouncement(id) {
    Swal.fire({
        title: '{{__('Are you sure?')}}',
        text: '{{__('This announcement will be deleted permanently!')}}',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: '{{__('Yes, delete it!')}}',
        cancelButtonText: '{{__('Cancel')}}',
        confirmButtonColor: '#dc3545'
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: `/admin/announcements/${id}`,
                method: 'DELETE',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                success: function(response) {
                    if (response.success) {
                        Lobibox.notify('success', {
                            title: '{{__('Success')}}',
                            msg: response.message,
                            sound: false
                        });
                        setTimeout(() => location.reload(), 1000);
                    }
                },
                error: function() {
                    Lobibox.notify('error', {
                        title: '{{__('Error')}}',
                        msg: '{{__('Error deleting announcement')}}',
                        sound: false
                    });
                }
            });
        }
    });
}
</script>
@endsection

<style>
.announcement-card {
    transition: transform 0.2s ease;
}

.announcement-card:hover {
    transform: translateY(-2px);
}
</style>