<!DOCTYPE html>
<html lang="tr">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <!-- start linking  -->
  <link href="https://fonts.googleapis.com/css?family=Nunito:300,400,600,700,800,900" rel="stylesheet">
  <link href="https://use.fontawesome.com/releases/v5.0.4/css/all.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
  <link rel="stylesheet" href="{{ asset('assets/css/app.css') }}">
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap5.min.css">

  <meta name="csrf-token" content="{{ csrf_token() }}">
  <!-- icon -->
  <link rel="icon" href="{{ asset('assets/img/log.png') }}">
  <style>
.text-truncate {
    overflow: hidden;
    text-overflow: ellipsis;
    white-space: nowrap;
}

.half-width-offcanvas {
    width: 70% !important;
}

@media (max-width: 768px) {
    .half-width-offcanvas {
        width: 100% !important;
    }
}

.half-width-offcanva {
    width: 50% !important;
}

@media (max-width: 768px) {
    .half-width-offcanva {
        width: 100% !important;
    }
}

/* Updated pagination styling */
.pagination .page-link .fa {
    font-size: 16px; /* Adjust size as needed */
    vertical-align: middle; /* Aligns icon nicely with the text if necessary */
}

.item {
    display: flex;
    flex-wrap: wrap;
    margin-bottom: 1rem;
}
.item .col-md-2, .item .col-md-1 {
    padding-right: 0.5rem;
    padding-left: 0.5rem;
}
.item input, .item select {
    width: 100%;
}

.offcanvas {
    z-index: 1060;
}

.dataTables_wrapper {
    z-index: 1050;
}

.modal-dialog-right {
        position: fixed;
        margin: auto;
        width: 100%;
        height: 100%;
        right: 0;
        top: 0;
        bottom: 0;
    }
    .modal-dialog-scrollable .modal-content {
        height: 100%;
        overflow-y: auto;
    }
    .modal-dialog-right .modal-content {
        height: 100%;
        overflow-y: auto;
        border: 0;
        border-radius: 0;
    }
</style>
  <!-- end linking -->
  <title>Receipt</title>
</head>
<body>
<!-- start admin -->
<section id="admin">
  <!-- start sidebar -->
  <div class="sidebar">
    <!-- start with head -->
    <div class="head">
        @if(Auth::check())
        <p class="badge badge-primary">Hoş geldiniz, {{ Auth::user()->name }}!</p>
       
    @endif
      <a href="{{ route('bulk-receipt') }}" class="btn btn-danger">YENİ TOPLU FİŞ KES</a>
    </div>
    <!-- end with head -->
    <!-- start the list -->
    @include('partials.sidebar')
    <!-- end the list -->
  </div>
  <!-- end sidebar -->
  <!-- start content -->
  <div class="content">
    <!-- start content head -->
    <div class="head">
      <!-- head top -->
      <div class="top">
        <div class="left">
          <button id="on" class="btn btn-info"><i class="fa fa-bars"></i></button>
          <button id="off" class="btn btn-info hide"><i class="fa fa-align-left"></i></button>
         
        </div>
     
      </div>
      <!-- end head top -->
      <!-- start head bottom -->
      @yield('content')
    
  <!-- end content -->
</section>
<!-- end admin -->
<!-- start screpting -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="{{ asset('assets/js/tether.min.js') }}"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.8/dist/umd/popper.min.js" integrity="sha384-I7E8VVD/ismYTF4hNIPjVp/Zjvgyol6VFvRkX/vR+Vc4jQkC+hVqc2pM8ODewa9r" crossorigin="anonymous"></script>
<link rel="stylesheet" href="{{ asset('assets/css/bootstrap.min.css') }}">
<!-- DataTables JS -->
<script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap4.min.js"></script>
<script src="{{ asset('assets/js/app.js') }}"></script>

<script>
$(document).ready(function() {
    // Business DataTable
    $('#businessTable').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: '{{ route('api.businesses') }}',
            type: 'GET'
        },
        pageLength: 10,
        columns: [
            { data: 'id', name: 'id' },
            { data: 'name', name: 'name' },
            { data: 'address', name: 'address' },
            { data: 'tax_number', name: 'tax_number' },
            { data: 'tax_office', name: 'tax_office' },
            { data: 'id', name: 'id', orderable: false, searchable: false, render: function(data, type, row) {
                return `<a href="/business/${data}/edit" class="btn btn-outline btn-primary btn-edit"><i class="fa fa-edit"></i></a>`;
            }}
        ]
    });

    // Receipt DataTable


});

$(document).ready(function() {
        $('#products-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
            url: '{{ route('products.api') }}',
            type: 'GET'
        },
        pageLength: 10,
            columns: [
                {data: 'id', name: 'id'},
                {data: 'name', name: 'name'},
                {data: 'unit_price', name: 'unit_price'},
                {data: 'vat_rate', name: 'vat_rate'},
                {data: 'unit_type', name: 'unit_type'},
                {data: 'serial', name: 'serial'},
                {data: 'action', name: 'action', orderable: false, searchable: false}
            ]
        });
    });



                </script>
<!-- end screpting -->
<script>
$(document).ready(function() {
    var table = $('#receiptTable').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: '{{ route('api.receipts') }}',
            type: 'GET'
        },
        pageLength: 10,
        columns: [
            { data: 'id', name: 'id', orderable: true, searchable: true },
            { data: 'business_name', name: 'business_name', orderable: true, searchable: true },
            { data: 'total_amount', name: 'total_amount', orderable: true, searchable: true },
            { data: 'date', name: 'date', orderable: true, searchable: true },
            { data: 'printed', name: 'printed', orderable: true, searchable: true, render: function(data, type, row) {
                return data ? '<span class="badge text-bg-primary">Yazdırıldı</span>' : '<span class="badge text-bg-danger">Yazdırılmadı</span>';
            }},
            { data: 'id', name: 'id', orderable: false, searchable: false, render: function(data, type, row) {
                return `
                    <button type="button" class="btn btn-info" onclick="viewReceipt(${data})"><i class="fa fa-print"></i></button>
                    <a href="/receipts/${data}/edit" class="btn btn-outline btn-primary btn-edit"><i class="fa fa-edit"></i></a>
                    <button type="button" class="btn btn-outline btn-danger deleteButton" data-id="${data}"><i class="fa fa-trash"></i></button>`;
            }}
        ],
        order: [[3, 'desc']] // Varsayılan olarak tarih sütununa göre azalan sıralama
    });






    // Dinamik olarak eklenen deleteButton butonlarına olay dinleyicisi ekle
    $('#receiptTable').on('click', '.deleteButton', function(event) {
        var recordId = $(this).data('id');
        console.log('Record ID:', recordId);

        // Kullanıcıdan onay al
        Swal.fire({
            title: 'Emin misiniz?',
            text: "Bu kaydı silmek istediğinizden emin misiniz?",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Evet, sil!',
            cancelButtonText: 'İptal'
        }).then((result) => {
            if (result.isConfirmed) {
                // DELETE isteğini gönder
                fetch('/receipts/' + recordId, {
                    method: 'DELETE',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                    }
                })
                .then(response => {
                    return response.json().then(data => {
                        if (!response.ok) {
                            throw new Error(data.message || 'Kayıt silinirken bir hata oluştu.');
                        }
                        return data;
                    });
                })
                .then(data => {
                    Swal.fire({
                        title: 'Silindi!',
                        text: 'Kayıt başarıyla silindi.',
                        icon: 'success',
                        confirmButtonText: 'Tamam'
                    }).then(() => {
                        // DataTable'ı yeniden yükle
                        table.ajax.reload(null, false);
                    });
                })
                .catch(error => {
                    console.error('Hata:', error);
                    Swal.fire(
                        'Hata!',
                        error.message,
                        'error'
                    );
                });
            }
        });
    });
});
$(document).ready(function() {
    $('.nav-link.dropdown-toggle').on('click', function(e) {
        var $el = $(this);
        var $parent = $el.parent('.nav-item.dropdown');
        var $dropdownMenu = $parent.find('.dropdown-menu');

        if ($dropdownMenu.is(':visible')) {
            $dropdownMenu.removeClass('show');
        } else {
            $('.dropdown-menu').removeClass('show'); // Diğer açık olan menüleri kapat
            $dropdownMenu.addClass('show');
        }
    });

    // Sayfanın herhangi bir yerine tıklanınca dropdown menüyü kapat
    $(document).on('click', function(e) {
        if (!$(e.target).closest('.nav-item.dropdown').length) {
            $('.dropdown-menu').removeClass('show');
        }
    });
});
$(document).ready(function() {
    // Rastgele seri numarası oluşturma fonksiyonu
    function generateRandomSerial(length) {
        var result = '';
        var characters = '0123456789';
        var charactersLength = characters.length;
        for (var i = 0; i < length; i++) {
            result += characters.charAt(Math.floor(Math.random() * charactersLength));
        }
        return result;
    }

    // Rastgele butonuna tıklama olayı
    $('#generate-serial').on('click', function() {
        var randomSerial = generateRandomSerial(12);
        $('#serial').val(randomSerial);
    });

    $('#product-form').on('submit', function(e) {
    e.preventDefault();
    
    var form = $(this);
    var url = form.attr('action');
    var submitButton = $('#submit-button');
    
    submitButton.prop('disabled', true).text('Ürün Güncelleniyor...');
    
    $.ajax({
        type: "POST",
        url: url,
        data: form.serialize(),
        success: function(response) {
            if(response.success) {
                Swal.fire({
                    title: 'Başarılı!',
                    text: 'Ürün başarıyla güncellendi.',
                    icon: 'success',
                    confirmButtonText: 'Tamam'
                }).then((result) => {
                    if (result.isConfirmed) {
                        window.location.href = '{{ route('products.index') }}';
                    }
                });
            } else {
                Swal.fire(
                    'Hata!',
                    'Ürün güncellenirken bir hata oluştu.',
                    'error'
                );
                submitButton.prop('disabled', false).text('Ürün Güncelle');
            }
        },
        error: function(xhr, status, error) {
            var errorMessage = xhr.status + ': ' + xhr.statusText;
            Swal.fire(
                'Hata!',
                'Ürün güncellenirken bir hata oluştu: ' + errorMessage,
                'error'
            );
            submitButton.prop('disabled', false).text('Ürün Güncelle');
        }
    });
});

});
</script>
</body>
</html>
