<!doctype html>
<html lang="{{ app()->getLocale() }}" dir="{{ app()->getLocale() == 'ar' ? 'rtl' : 'ltr' }}">

<head>
	<!-- Required meta tags -->
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<!--favicon-->
	<link rel="icon" href="{{asset('assets/images/' . ($settings['favicon'] ?? 'favicon-32x32.png'))}}" type="image/png" />
	<!--plugins-->
	<link href="{{asset('assets/plugins/simplebar/css/simplebar.css')}}" rel="stylesheet" />
	<link href="{{asset('assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css')}}" rel="stylesheet" />
	<link href="{{asset('assets/plugins/metismenu/css/metisMenu.min.css')}}" rel="stylesheet" />
	<!-- loader-->
	<link href="{{asset('assets/css/pace.min.css')}}" rel="stylesheet" />
	<script src="{{asset('assets/js/pace.min.js')}}"></script>
	<!-- Bootstrap CSS -->
	<link href="{{asset('assets/css/bootstrap.min.css')}}" rel="stylesheet">
	<link href="{{asset('assets/css/bootstrap-extended.css')}}" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">
	<link href="{{asset('assets/css/app.css')}}" rel="stylesheet">
	<link href="{{asset('assets/css/icons.css')}}" rel="stylesheet">
	<meta name="csrf-token" content="{{ csrf_token() }}">
	<meta name="description" content="{{ $settings['description'] ?? '' }}">
	<meta name="keywords" content="{{ $settings['keywords'] ?? '' }}">
	<meta name="author" content="{{ $settings['site_name'] ?? 'Site' }}">
	<title>{{ $settings['site_name'] ?? 'Site' }} - {{__("Login")}}</title>
	<script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
	@if($settings['recaptcha_enabled'] ?? false)
	<script src="https://www.google.com/recaptcha/api.js" async defer></script>
	@endif
</head>

<body class="">
	<!--wrapper-->
	<div class="wrapper">
		<div class="section-authentication-cover">
			<div class="">
				<div class="row g-0">

					<div class="col-12 col-xl-7 col-xxl-8 auth-cover-left align-items-center justify-content-center d-none d-xl-flex">

                        <div class="card shadow-none bg-transparent shadow-none rounded-0 mb-0">
							<div class="card-body">
                                 <img src="{{asset('assets/images/login-images/login-cover.svg')}}" class="img-fluid auth-img-cover-login" width="650" alt=""/>
							</div>
						</div>
						
					</div>

					<div class="col-12 col-xl-5 col-xxl-4 auth-cover-right align-items-center justify-content-center">
						<div class="card rounded-0 m-3 shadow-none bg-transparent mb-0">
							<div class="card-body p-sm-5">
								<div class="">
									<div class="mb-3 text-center">
										<img src="assets/images/{{ $settings['logo'] }}" width="150" alt="{{ $settings['title'] }}">
									</div>
									<div class="text-center mb-4">
										<h5 class="">{{ $settings['site_name'] }}</h5>
										<p class="mb-0">{{ __('Please log in to your account')}}</p>
									</div>
									<div class="form-body">
									@if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif
@if(session('success'))
    <div class="alert alert-success">
        {{ session('success') }}
    </div>
@endif
									<form method="POST" id="LoginForm" action="{{ route('login') }}" class="row g-3">
        @csrf
										
											<div class="col-12">
												<label for="inputEmailAddress" class="form-label">{{ __("Email")}}</label>
												<input type="email" name="email" class="form-control" id="inputEmailAddress" placeholder="{{ __("jhon@example.com")}}">
											</div>
											<div class="col-12">
												<label for="inputChoosePassword" class="form-label">{{ __("Password")}}</label>
												<div class="input-group" id="show_hide_password">
													<input type="password" name="password" class="form-control border-end-0" id="inputChoosePassword" value="" placeholder="{{ __("Enter Password")}}"> <a href="javascript:;" class="input-group-text bg-transparent"><i class="bx bx-hide"></i></a>
												</div>
											</div>
											<div class="col-md-6">
												<div class="form-check form-switch">
													<input class="form-check-input" type="checkbox" name="remember" id="flexSwitchCheckChecked">
													<label class="form-check-label" for="flexSwitchCheckChecked">{{ __("Remember Me")}}</label>
												</div>
											</div>
											<div class="col-md-6 text-end">	<a href="authentication-forgot-password.html">{{ __("Forgot Password ?")}}</a>
											</div>
											@if($settings['recaptcha_enabled'] ?? false)
											<div class="col-12 mb-3">
												<div class="g-recaptcha" data-sitekey="{{ $settings['recaptcha_site_key'] }}"></div>
											</div>
											@endif
											<div class="col-12">
												<div class="d-grid">
													<button type="submit" id="loginBtn" class="btn btn-primary">
														<span id="loginBtnText">{{ __("Sign in")}}</span>
														<span id="loginBtnLoader" class="d-none">
															<span class="spinner-border spinner-border-sm me-2" role="status" aria-hidden="true"></span>
															{{__('Logging in...')}}
														</span>
													</button>
												</div>
											</div>
										
										

											</div>
											<div class="col-12">
												<div class="text-center ">
													<p class="mb-0">{{ __("Don't have an account yet?")}} <a href="{{ route('register') }}">{{ __("Sign up here")}}</a>
													</p>
												</div>
											</div>
										</form>
									</div>
									
<hr>
<div class="text-right">
                  
				   <div class="top-menu ms-auto">
											<ul class="navbar-nav align-items-center gap-1">
                         
						 <li class="nav-item dropdown dropdown-laungauge d-sm-flex">
							 <a class="nav-link dropdown-toggle dropdown-toggle-nocaret" href="avascript:;" data-bs-toggle="dropdown">
							 @php
 $locale = session('locale', 'tr'); 
@endphp

<img src="assets/images/country/{{ in_array($locale, ['en', 'tr', 'ar','ru']) ? $locale : 'tr' }}.png" width="22" alt="">

							 </a>
							 <ul class="dropdown-menu dropdown-menu-end">
<li><a class="dropdown-item d-flex align-items-center py-2" href="{{ route('lang.switch', 'tr') }}"><img src="assets/images/country/tr.png" width="20" alt=""><span class="ms-2">Türkçe</span></a></li>
<li><a class="dropdown-item d-flex align-items-center py-2" href="{{ route('lang.switch', 'en') }}"><img src="assets/images/country/en.png" width="20" alt=""><span class="ms-2">English</span></a></li>
<li><a class="dropdown-item d-flex align-items-center py-2" href="{{ route('lang.switch', 'ru') }}"><img src="assets/images/country/ru.png" width="20" alt=""><span class="ms-2">Русский</span></a></li>
<li><a class="dropdown-item d-flex align-items-center py-2" href="{{ route('lang.switch', 'ar') }}"><img src="assets/images/country/ar.png" width="20" alt=""><span class="ms-2">العربية</span></a></li>

							 </ul>
						 </li>
</ul>
</div></div>



								</div>
							</div>
						</div>
					</div>

				</div>
				<!--end row-->
			</div>
		</div>
	</div>
	<!--end wrapper-->
	<!-- Bootstrap JS -->
	<script src="{{asset('assets/js/bootstrap.bundle.min.js')}}"></script>
	<!--plugins-->
	<script src="{{asset('assets/js/jquery.min.js')}}"></script>
	<script src="{{asset('assets/plugins/simplebar/js/simplebar.min.js')}}"></script>
	<script src="{{asset('assets/plugins/metismenu/js/metisMenu.min.js')}}"></script>
	<script src="{{asset('assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js')}}"></script>
	<!--Password show & hide js -->
<script>
document.addEventListener('DOMContentLoaded', function () {
    const loginForm = document.getElementById('LoginForm');
    const loginBtn = document.getElementById('loginBtn');
    const loginBtnText = document.getElementById('loginBtnText');
    const loginBtnLoader = document.getElementById('loginBtnLoader');

    function resetLoginButton(text = "{{ __('Sign in') }}", delay = 0) {
        setTimeout(() => {
            loginBtn.disabled = false;
            loginBtn.classList.remove('btn-success');
            loginBtn.classList.add('btn-primary');
            loginBtnText.classList.remove('d-none');
            loginBtnText.textContent = text;
            loginBtnLoader.classList.add('d-none');
        }, delay);
    }

    function resetRecaptcha() {
        @if($settings['recaptcha_enabled'] ?? false)
        if (typeof grecaptcha !== "undefined") {
            grecaptcha.reset();
        }
        @endif
    }

    if (loginForm) {
        loginForm.addEventListener('submit', function (event) {
            event.preventDefault();

            loginBtn.disabled = true;
            loginBtnText.classList.add('d-none');
            loginBtnLoader.classList.remove('d-none');

            @if($settings['recaptcha_enabled'] ?? false)
            const recaptchaResponse = grecaptcha.getResponse();
            if (!recaptchaResponse) {
                resetLoginButton();
                resetRecaptcha();
                alert("{{ __('Please complete the reCAPTCHA verification.') }}");
                return;
            }
            @endif

            const formData = new FormData(this);
            fetch("{{ route('login') }}", {
                method: 'POST',
                body: formData,
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                }
            })
                .then(response => {
                    if (!response.ok) {
                        throw new Error('Network response was not ok: ' + response.statusText);
                    }
                    return response.json();
                })
                .then(data => {
                    if (data.success) {
                        loginBtnLoader.classList.add('d-none');
                        loginBtnText.classList.remove('d-none');
                        loginBtnText.textContent = "{{ __('Login Successful!') }}";
                        loginBtn.classList.remove('btn-primary');
                        loginBtn.classList.add('btn-success');

                        // 3 saniyelik gecikme ile yönlendir
                        setTimeout(() => {
                            window.location.href = data.redirect;
                        }, 3000);
                    } else {
                        resetRecaptcha();
                        loginBtnLoader.classList.add('d-none');
                        loginBtnText.classList.remove('d-none');
                        loginBtnText.textContent = "{{ __('Girilen bilgiler kayıtlarımızla eşleşmiyor.') }}";
                        resetLoginButton("{{ __('Sign in') }}", 2000);
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    resetRecaptcha();
                    loginBtnLoader.classList.add('d-none');
                    loginBtnText.classList.remove('d-none');
                    loginBtnText.textContent = "{{ __('Bir hata oluştu, lütfen tekrar deneyin.') }}";
                    resetLoginButton("{{ __('Sign in') }}", 2000);
                });
        });
    }

    // Şifre göster/gizle
    const togglePasswordIcon = document.querySelector('#show_hide_password i');
    const passwordInput = document.querySelector('#show_hide_password input');
    if (togglePasswordIcon && passwordInput) {
        togglePasswordIcon.addEventListener('click', function () {
            if (passwordInput.type === 'password') {
                passwordInput.type = 'text';
                this.classList.remove('bx-hide');
                this.classList.add('bx-show');
            } else {
                passwordInput.type = 'password';
                this.classList.remove('bx-show');
                this.classList.add('bx-hide');
            }
        });
    }

    // Başarı bildirimi otomatik kaybolsun
    setTimeout(function () {
        const successAlert = document.querySelector('.alert-success');
        if (successAlert) {
            successAlert.style.transition = "opacity 1s ease-out";
            successAlert.style.opacity = 0;
            setTimeout(() => successAlert.remove(), 1000);
        }
    }, 5000);
});
</script>


	<!--app JS-->
	<script src="assets/js/app.js"></script>
</body>

</html>