<!doctype html>
<html lang="{{ app()->getLocale() }}" dir="{{ app()->getLocale() == 'ar' ? 'rtl' : 'ltr' }}">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!--favicon-->
    <link rel="icon" href="{{asset('assets/images/' . ($settings['favicon'] ?? 'favicon-32x32.png'))}}" type="image/png" />
    <!--plugins-->
    <link href="{{asset('assets/plugins/simplebar/css/simplebar.css')}}" rel="stylesheet" />
    <link href="{{asset('assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css')}}" rel="stylesheet" />
    <link href="{{asset('assets/plugins/metismenu/css/metisMenu.min.css')}}" rel="stylesheet" />
    <!-- loader-->
    <link href="{{asset('assets/css/pace.min.css')}}" rel="stylesheet" />
    <script src="{{asset('assets/js/pace.min.js')}}"></script>
    <!-- Bootstrap CSS -->
    <link href="{{asset('assets/css/bootstrap.min.css')}}" rel="stylesheet">
    <link href="{{asset('assets/css/bootstrap-extended.css')}}" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">
    <link href="{{asset('assets/css/app.css')}}" rel="stylesheet">
    <link href="{{asset('assets/css/icons.css')}}" rel="stylesheet">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="description" content="{{ $settings['description'] ?? '' }}">
    <meta name="keywords" content="{{ $settings['keywords'] ?? '' }}">
    <meta name="author" content="{{ $settings['site_name'] ?? 'Site' }}">
    <title>{{ $settings['site_name'] ?? 'Site' }} - {{__("Register")}}</title>
    <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    @if($settings['recaptcha_enabled'] ?? false)
    <script src="https://www.google.com/recaptcha/api.js" async defer></script>
    @endif

</head>

<body class="">
    <!--wrapper-->
    <div class="wrapper">
        <div class="section-authentication-cover">
            <div class="">
                <div class="row g-0">

                    <div class="col-12 col-xl-7 col-xxl-8 auth-cover-left align-items-center justify-content-center d-none d-xl-flex">

                        <div class="card shadow-none bg-transparent shadow-none rounded-0 mb-0">
                            <div class="card-body">
                                 <img src="assets/images/login-images/register-cover.svg" class="img-fluid auth-img-cover-login" width="550" alt="{{__("Register Screen")}}"/>
                            </div>
                        </div>
                        
                    </div>

                    <div class="col-12 col-xl-5 col-xxl-4 auth-cover-right align-items-center justify-content-center">
                        <div class="card rounded-0 m-3 shadow-none bg-transparent mb-0">
                            <div class="card-body p-sm-5">
                                <div class="">
                                    <div class="mb-3 text-center">
                                        <img src="assets/images/{{ $settings['logo'] }}" width="150" alt="{{ $settings['site_name'] }}" />
                                    </div>
                                    <div class="text-center mb-4">
                                        <h5 class="">{{ $settings['site_name'] }}</h5>
                                        <p class="mb-0"> {{__("Please fill the below details to create your account")}}</p>
                                    </div>
                                    <div class="form-body">
                                   
    <div>
        <ul>
        @if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif
                                    <form method="POST" class="row g-3" id="signupForm" action="{{ route('register') }}">
        @csrf
        <div class="col-6">
                                                <label for="inputaccount_holder" class="form-label">{{__("Name Surname")}}</label>
                                                <input type="text" class="form-control" name="account_holder" value="{{ old('account_holder') }}" id="inputaccount_holder" placeholder="{{__("Plase Enter Name Surname")}}">
                                            </div>
                                            <div class="col-6">
                                                <label for="inputUsername" class="form-label">{{__("Username")}}</label>
                                                <input type="text" class="form-control" name="username" value="{{ old('username') }}" id="inputUsername" placeholder="{{__("Plase Enter Username")}}">
                                            </div>
                                            <div class="col-6">
                                                <label for="inputEmailAddress" class="form-label">{{__("Email Address")}}</label>
                                                <input type="email" class="form-control" name="email" value="{{ old('email') }}" id="inputEmailAddress" placeholder="{{__("jhon@example.com")}}">
                                            </div>
                                            <div class="col-6">
                                                <label for="inputPhoneNumber" class="form-label">{{__("Phone Number")}}</label>
                                                <input type="phone" class="form-control" name="phone"  value="{{ old('phone') }}" id="inputPhoneNumber" placeholder="{{__("5320000000")}}">
                                            </div>

                                            <div class="col-12">
                                                <label for="inputSelectCountry" class="form-label">{{__("Sex")}}</label>
                                                <select class="form-select" name="gender" id="inputSelectSex" aria-label="Select Sex" required>
    <option value="" {{ old('gender') === '' ? 'selected' : '' }}>{{ __('Please Select') }}</option>
    <option value="male" {{ old('gender') === 'male' ? 'selected' : '' }}>{{ __('Male') }}</option>
    <option value="female" {{ old('gender') === 'female' ? 'selected' : '' }}>{{ __('Female') }}</option>
    <option value="other" {{ old('gender') === 'other' ? 'selected' : '' }}>{{ __('Other') }}</option>
</select>
                                            </div>

                                            <div class="col-12">
                                                <label for="inputChoosePassword" class="form-label">{{__("Password")}}</label>
                                                <div class="input-group" id="show_hide_password">
                                                <input type="password" name="password"  class="form-control border-end-0" id="inputChoosePassword" placeholder="{{__("Enter Password")}}" required> <a href="javascript:;" class="input-group-text bg-transparent"><i class='bx bx-hide'></i></a></div>
                                            </div>

                                            <div class="col-12">
            <label for="password_confirmation">{{__("Confirm Password:")}}</label>
            <div class="input-group" id="show_hide_password">
            <input type="password" name="password_confirmation" class="form-control border-end-0" id="password_confirmation" placeholder="{{__("Please Confirm Password")}}" required> <a href="javascript:;" class="input-group-text bg-transparent"><i class='bx bx-hide'></i></a>
</div>
        </div>

                                            <div class="col-6">
                                                <label for="inputSelectCountry" class="form-label">{{__("Country")}}</label>
                                                <select class="form-select" name="country_id" id="inputSelectCountry" aria-label="Default select Country" onchange="updateCitiesBasedOnCountry()">
     @foreach($countries as $country)
        <option value="{{ $country->code }}" data-countryCode="{{ $country->code }}" {{ old('country_id') == $country->code ? 'selected' : '' }}>{{ $country->name }}</option>
    @endforeach 
                                                <option value="9999" {{ old('country_id') == "9999" ? 'selected' : '' }}>{{__("Other")}}</option>
                                                </select>
                                            </div>

                                            <div class="col-6">
                                                <label for="inputSelectCountry" class="form-label">{{__("City")}}</label>
                                                <select class="form-select" name="city_id" id="inputSelectCity" aria-label="Default select City">
                                                @foreach($cities as $city)
        <option value="{{ $city->id }}" data-country-code="{{ $city->country_id }}" {{ old('city_id') == $city->id ? 'selected' : '' }}>{{ $city->name }}</option>
    @endforeach 
                                    <option value="9999"  {{ old('city_id') == "9999" ? 'selected' : '' }}>{{__("Other")}}</option>
                                                </select>
                                            </div>

                                            <div class="col-12">
                                                <div class="form-check form-switch">
                                                    <input class="form-check-input" type="checkbox" name="terms" id="flexSwitchCheckChecked">
                                                    <label class="form-check-label" for="flexSwitchCheckChecked">{{__("I read and agree to Terms & Conditions")}}</label>
                                                </div>
                                            </div>
                                            @if($settings['recaptcha_enabled'] ?? false)
                                            <div class="col-12 mb-3">
                                                <div class="g-recaptcha" data-sitekey="{{ $settings['recaptcha_site_key'] }}"></div>
                                            </div>
                                            @endif
                                            <div class="col-12">
                                                <div class="d-grid">
                                                    <button type="submit" class="btn btn-primary">{{__("Sign up")}}</button>
                                                </div>
                                            </div>
                                            <div class="col-12">
                                                <div class="text-center ">
                                                    <p class="mb-0">{{__("Already have an account?")}} <a href="{{ route('login') }}">{{__("Sign in here")}}</a></p>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                    
                                    <hr>
<div class="text-right">
                  
				   <div class="top-menu ms-auto">
											<ul class="navbar-nav align-items-center gap-1">
                         
						 <li class="nav-item dropdown dropdown-laungauge d-sm-flex">
							 <a class="nav-link dropdown-toggle dropdown-toggle-nocaret" href="avascript:;" data-bs-toggle="dropdown">
							 @php
 $locale = session('locale', 'tr'); 
@endphp

<img src="assets/images/country/{{ in_array($locale, ['en', 'tr', 'ar','ru']) ? $locale : 'tr' }}.png" width="22" alt="">

							 </a>
							 <ul class="dropdown-menu dropdown-menu-end">
<li><a class="dropdown-item d-flex align-items-center py-2" href="{{ route('lang.switch', 'tr') }}"><img src="assets/images/country/tr.png" width="20" alt=""><span class="ms-2">Türkçe</span></a></li>
<li><a class="dropdown-item d-flex align-items-center py-2" href="{{ route('lang.switch', 'en') }}"><img src="assets/images/country/en.png" width="20" alt=""><span class="ms-2">English</span></a></li>
<li><a class="dropdown-item d-flex align-items-center py-2" href="{{ route('lang.switch', 'ru') }}"><img src="assets/images/country/ru.png" width="20" alt=""><span class="ms-2">Русский</span></a></li>
<li><a class="dropdown-item d-flex align-items-center py-2" href="{{ route('lang.switch', 'ar') }}"><img src="assets/images/country/ar.png" width="20" alt=""><span class="ms-2">العربية</span></a></li>

							 </ul>
						 </li>
</ul>
</div></div>

                                </div>
                            </div>
                        </div>
                    </div>

                </div>
                <!--end row-->
            </div>
        </div>
    </div>
    <!--end wrapper-->
    <!-- Bootstrap JS -->
    <script src="assets/js/bootstrap.bundle.min.js"></script>
    <!--plugins-->
    <script src="assets/js/jquery.min.js"></script>
    <script src="assets/plugins/simplebar/js/simplebar.min.js"></script>
    <script src="assets/plugins/metismenu/js/metisMenu.min.js"></script>
    <script src="assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
    <!--Password show & hide js -->
    <script>
        $(document).ready(function () {
            $("#show_hide_password a").on('click', function (event) {
                event.preventDefault();
                if ($('#show_hide_password input').attr("type") == "text") {
                    $('#show_hide_password input').attr('type', 'password');
                    $('#show_hide_password i').addClass("bx-hide");
                    $('#show_hide_password i').removeClass("bx-show");
                } else if ($('#show_hide_password input').attr("type") == "password") {
                    $('#show_hide_password input').attr('type', 'text');
                    $('#show_hide_password i').removeClass("bx-hide");
                    $('#show_hide_password i').addClass("bx-show");
                }
            });
        });
    </script>
    
    <script>
function updateCitiesBasedOnCountry() {
    var countrySelect = document.getElementById('inputSelectCountry');
    var citySelect = document.getElementById('inputSelectCity');
    
    if (!countrySelect || !citySelect) {
        console.error('One or more dropdowns are not found.');
        return; 
    }
    
    var selectedCountry = countrySelect.value;

   
    if (selectedCountry != '90') {
      
        Array.from(citySelect.options).forEach(function(option) {
            option.disabled = true;
        });
      
        citySelect.querySelector('option[value="82"]').disabled = false;
        citySelect.value = '82';  
    } else {
        
        Array.from(citySelect.options).forEach(function(option) {
            option.disabled = false;
        });
    }
}

document.getElementById('signupForm').addEventListener('submit', function(event) {
    var termsCheckbox = document.getElementById('flexSwitchCheckChecked');
    if (!termsCheckbox.checked) {
        event.preventDefault(); 
        Swal.fire({
            icon: 'error',
            title: "{{ __('Warning') }}",
            text: "{{ __('You did not accept the terms and conditions.') }}",
            timer: 3000, 
            timerProgressBar: true,
            willClose: () => {
               
            }
        });
    }
});

// Duplicate function removed - using the first definition above

    </script>
    <!--app JS-->
    <script src="{{asset('assets/js/app.js')}}"></script>
</body>

</html>