@extends("layouts.app")

@section('title', __('Dashboard') . ' - ' . ($settings['site_name'] ?? 'Site'))
@section("style")
    <link href="assets/plugins/vectormap/jquery-jvectormap-2.0.2.css" rel="stylesheet"/>
    <link href="{{asset('assets/plugins/datatable/css/dataTables.bootstrap5.min.css')}}" rel="stylesheet" />
    <link href="{{asset('assets/plugins/notifications/css/lobibox.min.css')}}" rel="stylesheet"/>
    <style>
        /* Dashboard specific DataTables fix */
        #dashboardUsersTable_wrapper .dataTables_info:nth-of-type(n+2) {
            display: none !important;
        }
        #dashboardUsersTable_wrapper .dataTables_paginate:nth-of-type(n+2) {
            display: none !important;
        }
        /* Genel duplicate fix */
        .dataTables_wrapper .dataTables_info + .dataTables_info {
            display: none !important;
        }
    </style>
@endsection

@section("wrapper")
    <div class="page-wrapper">
            <div class="page-content">
                <div class="row row-cols-1 row-cols-md-2 row-cols-xl-4">
              
                <div class="col">
                    <div class="card radius-10 border-start border-0 border-4 border-warning">
                       <div class="card-body">
                           <div class="d-flex align-items-center">
                               <div>
                                   <p class="mb-0 text-secondary">{{ __('Active Members')}} </p>
                                   <h4 class="my-1 text-warning">  {{ $onlineUsersCount }}  </h4>
                                   
                               </div>
                               <div class="widgets-icons-2 rounded-circle bg-gradient-orange text-white ms-auto"><i class='bx bxs-group'></i>
                               </div>
                           </div>
                       </div>
                    </div>
                  </div> 

                  <div class="col">
						<div class="card radius-10 border-start border-0 border-4 border-warning">
							<div class="card-body">
								<div class="d-flex align-items-center">
									<div>
										<p class="mb-0 text-dark">{{ __('Mobile Approved Member')}} </p>
										<h4 class="my-1 text-dark">{{ $mobileverifed }}</h4>
                                        <p class="mb-0 font-13 text-dark"><i class="bx bx-mail-send align-middle"></i>{{ __('Email approved members')}} {{ $emailverifed }}</p>
									</div>
									<div class="widgets-icons bg-white text-dark ms-auto"><i class="bx bx-user-check"></i>
									</div>
								</div>
							</div>
						</div>
					</div>

                <div class="col">
                     <div class="card radius-10 border-start border-0 border-4 border-info">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div>
                                    <p class="mb-0 text-secondary">{{ __('Total Members')}}</p>
                                    <h4 class="my-1 text-info">{{$totaluser}}</h4>
                                    <p class="mb-0 font-13">{{ __('Members joining us today')}} {{$todayRegistrations}}</p>
                                </div>
                                <div class="widgets-icons-2 rounded-circle bg-gradient-blues text-white ms-auto"><i class='bx bxs-group'></i>
                                </div>
                            </div>
                        </div>
                     </div>
                   </div>
                   <div class="col">
                    <div class="card radius-10 border-start border-0 border-4 border-danger">
                       <div class="card-body">
                           <div class="d-flex align-items-center">
                               <div>
                                   <p class="mb-0 text-secondary">{{ __('Total Earnings')}}</p>
                                   <h4 class="my-1 text-danger">{{number_format($currentUser->balance,2) }}₺</h4>
                                   <p class="mb-0 font-13">{{ __('Total Earnings of Members:')}} {{ number_format($totalBalance, 2) }}₺</p>
                               </div>
                               <div class="widgets-icons-2 rounded-circle bg-gradient-burning text-white ms-auto"><i class='bx bxs-wallet'></i>
                               </div>
                           </div>
                       </div>
                    </div>
                  </div>

                  <div class="col">
                    <div class="card radius-10 border-start border-0 border-4 border-danger">
                       <div class="card-body">
                           <div class="d-flex align-items-center">
                               <div>
                                   <p class="mb-0 text-secondary">{{ __('Your Pending Payment')}}</p>
                                   <h4 class="my-1 text-danger">{{number_format($currentUser->balance,2) }}₺</h4>
                                   <p class="mb-0 font-13">{{ __('Total Pending Payments of Members:')}} {{ number_format($totalBalance, 2) }}₺</p>
                               </div>
                               <div class="widgets-icons-2 rounded-circle bg-gradient-burning text-white ms-auto"><i class='bx bxs-wallet'></i>
                               </div>
                           </div>
                       </div>
                    </div>
                  </div>

                  <div class="col">
                <div class="card radius-10 border-start border-0 border-4 border-success">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">{{ __('Active Tasks')}}</p>
                                <h4 class="my-1 text-success">{{$activeTasks}}</h4>
                                <p class="mb-0 font-13"></p>
                            </div>
                            <div class="widgets-icons-2 rounded-circle bg-gradient-ohhappiness text-white ms-auto"><i
                                    class='bx bxs-bar-chart-alt-2'></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col">
                <div class="card radius-10 border-start border-0 border-4 border-warning">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">{{ __('Weekly Tasks')}}</p>
                                <h4 class="my-1 text-warning">{{$weeklyTask}}</h4>
                                <p class="mb-0 font-13">{{__('New Tasks Added This Week')}}</p>
                            </div>
                            <div class="widgets-icons-2 rounded-circle bg-gradient-orange text-white ms-auto"><i
                                    class='bx bxs-add-to-queue'></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


            <div class="col">
                <div class="card radius-10 border-start border-0 border-4 border-dark">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">{{__('Number of Tasks Performed')}}</p>
                                <h4 class="my-1 text-dark">{{ $completedTasks }}</h4>
                                <p class="mb-0 font-13"></p>
                            </div>
                            <div class="widgets-icons-2 rounded-circle bg-gradient-orange text-white ms-auto"><i
                                    class='bx bxs-check'></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


            <div class="col">
                <div class="card radius-10 border-start border-0 border-4 border-secondary">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">{{__('Tasks Pending Approval')}}</p>
                                <h4 class="my-1 text-secondary">{{ $tasksAwaitingApproval }}</h4>
                                <p class="mb-0 font-13"></p>
                            </div>
                            <div class="widgets-icons-2 rounded-circle bg-gradient-orange text-white ms-auto"><i
                                    class='bx bxs-group'></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col">
                <div class="card radius-10 border-start border-0 border-4 border-primary">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">{{__('Evidence Pending Approval')}}</p>
                                <h4 class="my-1 text-primary">{{ $evidencesAwaitingApproval }}</h4>
                                <p class="mb-0 font-13"></p>
                            </div>
                            <div class="widgets-icons-2 rounded-circle bg-gradient-orange text-white ms-auto"><i
                                    class='bx bxs-group'></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
                </div><!--end row-->

     
                @if(auth()->user()->user_type == 1)
                <div class="card radius-10">
					<div class="card-header bg-transparent">
						<div class="d-flex align-items-center">
							<div>
								<h6 class="mb-0">{{__('Last Members')}}</h6>
							</div>
							<div class="dropdown ms-auto">
								<button class="btn btn-sm btn-outline-primary" onclick="refreshMembers()">
									<i class="bx bx-refresh"></i> {{__('Refresh')}}
								</button>
							</div>
						</div>
					</div>
					<div class="card-body p-0">
						<!-- Loading State -->
						<div id="members-loading" class="text-center p-4">
							<div class="spinner-border text-primary" role="status">
								<span class="visually-hidden">{{__('Loading...')}}</span>
							</div>
						</div>
						
						<!-- Mobile-Friendly Member Cards -->
						<div id="members-container" class="d-none">
							<!-- Members will be loaded here via AJAX -->
						</div>
						
						<!-- Empty State -->
						<div id="members-empty" class="text-center p-4 d-none">
							<i class="bx bx-user text-muted" style="font-size: 3rem;"></i>
							<p class="text-muted mt-2">{{__('No recent members found')}}</p>
						</div>
					</div>
			   </div>
			   @endif


                <div class="card radius-10">
					<div class="card-header bg-transparent">
						<div class="d-flex align-items-center">
							<div>
								<h6 class="mb-0">{{__('Recently Added Tasks')}}</h6>
							</div>
							<div class="dropdown ms-auto">
								<button class="btn btn-sm btn-outline-primary" onclick="refreshTasks()">
									<i class="bx bx-refresh"></i> {{__('Refresh')}}
								</button>
							</div>
						</div>
					</div>
					<div class="card-body p-0">
						<!-- Loading State -->
						<div id="tasks-loading" class="text-center p-4">
							<div class="spinner-border text-primary" role="status">
								<span class="visually-hidden">{{__('Loading...')}}</span>
							</div>
						</div>
						
						<!-- Mobile-Friendly Task Cards -->
						<div id="tasks-container" class="d-none">
							<!-- Tasks will be loaded here via AJAX -->
						</div>
						
						<!-- Empty State -->
						<div id="tasks-empty" class="text-center p-4 d-none">
							<i class="bx bx-task text-muted" style="font-size: 3rem;"></i>
							<p class="text-muted mt-2">{{__('No recent tasks found')}}</p>
						</div>
					</div>
			   </div>
               
          
               <!--end row-->

                   <!--end row-->

            </div>
        </div>
@endsection

@section("script")
    <script src="assets/plugins/vectormap/jquery-jvectormap-2.0.2.min.js"></script>
    <script src="assets/plugins/vectormap/jquery-jvectormap-world-mill-en.js"></script>
    <script src="assets/plugins/chartjs/js/chart.js"></script>
    <script src="assets/js/index.js"></script>
    
    <!--DataTables-->
    <script src="{{asset('assets/plugins/datatable/js/jquery.dataTables.min.js')}}"></script>
    <script src="{{asset('assets/plugins/datatable/js/dataTables.bootstrap5.min.js')}}"></script>
    <!--Notifications-->
    <script src="{{asset('assets/plugins/notifications/js/lobibox.min.js')}}"></script>
    
    <script>
    $(document).ready(function() {
        // Günlük bonus bildirimi kontrolü
        @if(session('daily_bonus'))
            Lobibox.notify('success', {
                pauseDelayOnHover: true,
                continueDelayOnInactiveTab: false,
                position: 'top right',
                icon: 'bx bx-gift',
                title: '{{ __("Daily Bonus") }}',
                msg: '{{ __("Your daily bonus has been added to your account!") }} (+{{ session("daily_bonus.amount") }} {{ session("daily_bonus.currency") }})',
                delay: 5000
            });
        @endif
        
        // Mevcut DataTable'ı tamamen temizle
        if ($.fn.DataTable.isDataTable('#dashboardUsersTable')) {
            $('#dashboardUsersTable').DataTable().clear().destroy();
            $('#dashboardUsersTable').empty();
        }
        
        // Sadece duplicate elementleri temizle (ilkini koru)
        if ($('.dataTables_info').length > 1) {
            $('.dataTables_info:gt(0)').remove();
        }
        if ($('.dataTables_paginate').length > 1) {
            $('.dataTables_paginate:gt(0)').remove();
        }
        
        $('#dashboardUsersTable').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '{{ route("api.users.datatable") }}',
                type: 'GET'
            },
            columns: [
                { data: 'account_holder', name: 'account_holder' },
                { data: 'username', name: 'username' },
                { data: 'email', name: 'email' },
                { data: 'location', name: 'location', orderable: false },
                { data: 'phone', name: 'phone', orderable: false },
                { data: 'phone_verified', name: 'phone_verified', orderable: false },
                { data: 'gender', name: 'gender', orderable: false },
                { data: 'balance', name: 'balance' },
                { data: 'created_at', name: 'created_at' }
            ],
            order: [[8, 'desc']], // Son kayıt tarihi sıralama
            pageLength: 10,
            lengthMenu: [[10, 25, 50, 100], [10, 25, 50, 100]],
            dom: 'lfrtip', // Basit DOM yapısı
            language: {
                @if(app()->getLocale() == 'tr')
                url: '//cdn.datatables.net/plug-ins/1.13.7/i18n/tr.json'
                @endif
            },
            responsive: true,
            info: true,
            paging: true,
            searching: true,
            destroy: true,
            drawCallback: function(settings) {
                // Dashboard tablosu için özel duplicate temizleme
                setTimeout(function() {
                    var wrapper = $('#dashboardUsersTable_wrapper');
                    var infoElements = wrapper.find('.dataTables_info');
                    var paginateElements = wrapper.find('.dataTables_paginate');
                    
                    if (infoElements.length > 1) {
                        infoElements.slice(1).remove();
                    }
                    if (paginateElements.length > 1) {
                        paginateElements.slice(1).remove();
                    }
                }, 100);
            }
        });
        
        // Üye listesi yenile butonu
        $('#refreshMembersBtn').on('click', function(e) {
            e.preventDefault();
            
            // Loading göster
            Lobibox.notify('info', {
                pauseDelayOnHover: true,
                continueDelayOnInactiveTab: false,
                position: 'top right',
                icon: 'bx bx-refresh',
                title: '{{ __("Refreshing") }}',
                msg: '{{ __("Refreshing member list...") }}',
                delay: 2000
            });
            
            // DataTable'ı yenile
            $('#dashboardUsersTable').DataTable().ajax.reload(function() {
                Lobibox.notify('success', {
                    pauseDelayOnHover: true,
                    continueDelayOnInactiveTab: false,
                    position: 'top right',
                    icon: 'bx bx-check',
                    title: '{{ __("Success") }}',
                    msg: '{{ __("Member list refreshed successfully!") }}',
                    delay: 3000
                });
            });
        });
        
        // Son eklenen görevler yenile butonu
        $('#refreshTasksBtn').on('click', function(e) {
            e.preventDefault();
            
            // Loading göster
            Lobibox.notify('info', {
                pauseDelayOnHover: true,
                continueDelayOnInactiveTab: false,
                position: 'top right',
                icon: 'bx bx-refresh',
                title: '{{ __("Refreshing") }}',
                msg: '{{ __("Refreshing recent tasks...") }}',
                delay: 2000
            });
            
            // AJAX ile son görevleri yenile
            $.ajax({
                url: '{{ route("api.recent.tasks") }}',
                type: 'GET',
                success: function(response) {
                    if (response.success) {
                        $('#recentTasksTableBody').html(response.html);
                        
                        Lobibox.notify('success', {
                            pauseDelayOnHover: true,
                            continueDelayOnInactiveTab: false,
                            position: 'top right',
                            icon: 'bx bx-check',
                            title: '{{ __("Success") }}',
                            msg: '{{ __("Recent tasks refreshed successfully!") }}',
                            delay: 3000
                        });
                    }
                },
                error: function() {
                    Lobibox.notify('error', {
                        pauseDelayOnHover: true,
                        continueDelayOnInactiveTab: false,
                        position: 'top right',
                        icon: 'bx bx-x',
                        title: '{{ __("Error") }}',
                        msg: '{{ __("Failed to refresh recent tasks!") }}',
                        delay: 3000
                    });
                }
            });
        });
        
        // Mobile-friendly AJAX functions - Chart.js çakışmasını önlemek için timeout
        setTimeout(function() {
            loadRecentTasks();
            @if(auth()->user()->user_type == 1)
            loadRecentMembers();
            @endif
        }, 2000);
    });
    
    // Load recent tasks via AJAX
    function loadRecentTasks() {
        $('#tasks-loading').removeClass('d-none');
        $('#tasks-container').addClass('d-none');
        $('#tasks-empty').addClass('d-none');
        
        $.ajax({
            url: '{{ route("ajax.recent-tasks") }}',
            method: 'GET',
            headers: {
                'X-Requested-With': 'XMLHttpRequest',
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            success: function(tasks) {
              
                $('#tasks-loading').addClass('d-none');
                
                if (tasks.length > 0) {
                    let html = '';
                    tasks.forEach(function(task) {
                        html += `
                            <div class="mobile-task-card">
                                <div class="task-header">
                                    <div class="flex-grow-1">
                                        <div class="task-title">${task.title}</div>
                                        <div class="task-description">${task.description}</div>
                                    </div>
                                    <span class="badge ${task.type_badge} type-badge ms-2">${task.type_text}</span>
                                </div>
                                <div class="task-meta">
                                    <div class="d-flex align-items-center">
                                        <span class="task-reward">${task.reward} ${task.currency}</span>
                                        <small class="text-muted ms-2">${task.task_id}</small>
                                    </div>
                                    <div class="d-flex align-items-center gap-2">
                                        <span class="task-date">${task.date_human}</span>
                                        <a href="${task.view_url}" class="btn btn-sm btn-outline-primary">
                                            <i class="bx bx-show"></i> {{__('View')}}
                                        </a>
                                    </div>
                                </div>
                            </div>
                        `;
                    });
                    $('#tasks-container').html(html).removeClass('d-none');
                } else {
                    $('#tasks-empty').removeClass('d-none');
                }
            },
            error: function(xhr, status, error) {
                console.error('Tasks loading error:', error);
                $('#tasks-loading').addClass('d-none');
                $('#tasks-empty').removeClass('d-none');
            }
        });
    }

    @if(auth()->user()->user_type == 1)
    // Load recent members via AJAX (Admin only)
    function loadRecentMembers() {
      
        $('#members-loading').removeClass('d-none');
        $('#members-container').addClass('d-none');
        $('#members-empty').addClass('d-none');
        
        $.ajax({
            url: '{{ route("ajax.recent-members") }}',
            method: 'GET',
            headers: {
                'X-Requested-With': 'XMLHttpRequest',
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            success: function(members) {
             
                $('#members-loading').addClass('d-none');
                
                if (members.length > 0) {
                    let html = '';
                    members.forEach(function(member) {
                        html += `
                            <div class="mobile-member-card">
                                <div class="d-flex">
                                    <img src="${member.avatar}" alt="${member.name}" class="member-avatar">
                                    <div class="member-info">
                                        <div class="member-name">${member.name}</div>
                                        <div class="member-username">@${member.username}</div>
                                        <div class="text-muted small">
                                            <i class="bx bx-envelope"></i> ${member.email}
                                        </div>
                                        <div class="text-muted small">
                                            <i class="bx bx-phone"></i> ${member.phone}
                                            ${member.phone_verified ? '<i class="bx bx-check-circle phone-verified"></i>' : ''}
                                        </div>
                                        ${member.location ? `<div class="text-muted small"><i class="bx bx-map"></i> ${member.location}</div>` : ''}
                                    </div>
                                </div>
                                <div class="member-details">
                                    <span class="member-balance">${member.balance} {{app('settings')['pbirim'] ?? 'TL'}}</span>
                                    <span class="member-date">${member.join_date_human}</span>
                                </div>
                            </div>
                        `;
                    });
                    $('#members-container').html(html).removeClass('d-none');
                } else {
                    $('#members-empty').removeClass('d-none');
                }
            },
            error: function(xhr, status, error) {
                console.error('Members loading error:', error, xhr.responseText);
                $('#members-loading').addClass('d-none');
                $('#members-empty').removeClass('d-none');
                
                // Debug için response'u göster
                if (xhr.responseJSON && xhr.responseJSON.error) {
                    console.error('Server error:', xhr.responseJSON.error);
                }
            }
        });
    }

    // Refresh members
    function refreshMembers() {
        loadRecentMembers();
    }
    @endif

    // Refresh tasks
    function refreshTasks() {
        loadRecentTasks();
    }
    </script>

    <style>
    .mobile-task-card, .mobile-member-card {
        border: 1px solid #e9ecef;
        border-radius: 12px;
        margin-bottom: 12px;
        padding: 16px;
        background: white;
        transition: all 0.3s ease;
        box-shadow: 0 2px 8px rgba(0,0,0,0.05);
    }

    .mobile-task-card:hover, .mobile-member-card:hover {
        box-shadow: 0 4px 20px rgba(0,0,0,0.1);
        transform: translateY(-2px);
    }

    .task-header {
        display: flex;
        justify-content: space-between;
        align-items: flex-start;
        margin-bottom: 12px;
    }

    .task-title {
        font-weight: 600;
        color: #2c3e50;
        margin-bottom: 4px;
        font-size: 1rem;
    }

    .task-description {
        color: #6c757d;
        font-size: 0.875rem;
        margin-bottom: 8px;
    }

    .task-meta {
        display: flex;
        justify-content: space-between;
        align-items: center;
        flex-wrap: wrap;
        gap: 8px;
    }

    .task-reward {
        font-weight: 700;
        color: #28a745;
        font-size: 1.1rem;
    }

    .task-date {
        color: #6c757d;
        font-size: 0.8rem;
    }

    .member-avatar {
        width: 50px;
        height: 50px;
        border-radius: 50%;
        margin-right: 12px;
    }

    .member-info {
        flex: 1;
    }

    .member-name {
        font-weight: 600;
        color: #2c3e50;
        margin-bottom: 2px;
    }

    .member-username {
        color: #6c757d;
        font-size: 0.875rem;
        margin-bottom: 4px;
    }

    .member-details {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-top: 8px;
        flex-wrap: wrap;
        gap: 8px;
    }

    .member-balance {
        font-weight: 700;
        color: #007bff;
    }

    .member-date {
        color: #6c757d;
        font-size: 0.8rem;
    }

    .type-badge {
        font-size: 0.75rem;
        padding: 4px 8px;
        border-radius: 12px;
        font-weight: 600;
    }

    .phone-verified {
        color: #28a745;
        margin-left: 4px;
    }

    @media (max-width: 768px) {
        .task-meta {
            flex-direction: column;
            align-items: flex-start;
        }
        
        .member-details {
            flex-direction: column;
            align-items: flex-start;
        }
        
        .mobile-task-card, .mobile-member-card {
            padding: 12px;
        }
    }
    </style>
@endsection
