@extends('gorevsitesi.layouts.app')

@section('title', __('Order Details'))

@section('content')
<div class="row">
    <div class="col-12">
        <h1>@lang('Order Details') #{{ $order->order_number }}</h1>
        <hr>
    </div>
</div>
<div class="row">
    <div class="col-md-6">
        <div class="card mb-3">
            <div class="card-header">@lang('Product Information')</div>
            <div class="card-body">
                <h5 class="card-title">{{ $order->product_name }}</h5>
                <p class="card-text">@lang('Unit Price'): {{ $order->product_price }} ₺</p>
                <p class="card-text">@lang('Quantity'): {{ $order->quantity }}</p>
                <p class="card-text">@lang('Total Amount'): {{ $order->formatted_total }}</p>
                @if($order->product_id && $order->product)
                    <a href="{{ route('site2.products.show', $order->product_id) }}" class="btn btn-sm btn-info">@lang('View Product')</a>
                @else
                    <span class="text-muted">@lang('Product no longer available')</span>
                @endif
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card mb-3">
            <div class="card-header">@lang('Order Information')</div>
            <div class="card-body">
                <p class="card-text">@lang('Order Number'): {{ $order->order_number }}</p>
                <p class="card-text">@lang('Order Date'): {{ $order->created_at }}</p>
                <p class="card-text">@lang('Status'): <span class="badge {{ $order->status_badge }}">{{ $order->status_text }}</span></p>
                <p class="card-text">@lang('Payment Status'): <span class="badge {{ $order->payment_status_badge }}">{{ $order->payment_status_text }}</span></p>
                @if($order->delivered_at)
                    <p class="card-text">@lang('Delivered on'): {{ $order->delivered_at }}</p>
                @endif
                @if($order->notes)
                    <p class="card-text">@lang('Notes'): {{ $order->notes }}</p>
                @endif
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-12">
        <div class="card mb-3">
            <div class="card-header">@lang('Delivery Information')</div>
            <div class="card-body">
                @if($order->product_data && $order->product_data['digital_content'])
                    <p>@lang('Digital Content'):</p>
                    <pre>{{ $order->product_data['digital_content'] }}</pre>
                    @if($order->product_data['instructions'])
                        <p>@lang('Instructions'):</p>
                        <pre>{{ $order->product_data['instructions'] }}</pre>
                    @endif
                @else
                    <p>@lang('No delivery information available yet.')</p>
                @endif
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-12 text-center">
        @if($order->can_be_cancelled)
            <button type="button" class="btn btn-danger cancel-order-btn" data-order-id="{{ $order->id }}">@lang('Cancel Order')</button>
        @endif
        <a href="{{ route('site2.account.orders') }}" class="btn btn-secondary">@lang('Back to My Orders')</a>
    </div>
</div>

@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function () {
        document.querySelectorAll('.cancel-order-btn').forEach(button => {
            button.addEventListener('click', function () {
                const orderId = this.dataset.orderId;
                if (confirm('@lang('Are you sure you want to cancel this order?')')) {
                    fetch(`{{ url('hesabim/siparislerim') }}/${orderId}/cancel`, {
                        method: 'POST',
                        headers: {
                            'X-CSRF-TOKEN': '{{ csrf_token() }}',
                            'Content-Type': 'application/json',
                            'Accept': 'application/json'
                        }
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            alert(data.message);
                            window.location.href = '{{ route('site2.account.orders') }}';
                        } else {
                            alert(data.message);
                        }
                    })
                    .catch(error => {
                        console.error('Error:', error);
                        alert('@lang('An error occurred')');
                    });
                }
            });
        });
    });
</script>
@endpush
@endsection
