@extends('gorevsitesi.layouts.app')

@section('title', __('My Orders'))

@section('content')
<div class="row">
    <div class="col-12">
        <h1>@lang('My Orders')</h1>
        <hr>
    </div>
</div>
<div class="row">
    <div class="col-12">
        @if($orders->isEmpty())
            <div class="alert alert-info" role="alert">
                @lang('No orders found') @lang('You haven\'t placed any orders yet.') <a href="{{ route('site2.products.index') }}">@lang('Browse Products')</a>
            </div>
        @else
            <div class="table-responsive">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>@lang('Order Number')</th>
                            <th>@lang('Product')</th>
                            <th>@lang('Quantity')</th>
                            <th>@lang('Total Amount')</th>
                            <th>@lang('Status')</th>
                            <th>@lang('Order Date')</th>
                            <th>@lang('Actions')</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($orders as $order)
                            <tr>
                                <td>{{ $order->order_number }}</td>
                                <td>{{ $order->product_name }}</td>
                                <td>{{ $order->quantity }}</td>
                                <td>{{ $order->formatted_total }}</td>
                                <td><span class="btn btn-info badge {{ $order->status_badge }}">{{ $order->status_text }}</span></td>
                                <td>{{ $order->created_at }}</td>
                                <td>
                                    <a href="{{ route('site2.account.orders.show', $order->id) }}" class="btn btn-sm btn-info">@lang('View')</a>
                                    @if($order->can_be_cancelled)
                                        <button type="button" class="btn btn-sm btn-danger cancel-order-btn" data-order-id="{{ $order->id }}">@lang('Cancel Order')</button>
                                    @endif
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            
            <!-- Pagination -->
            <div class="d-flex justify-content-center mt-4">
                {{ $orders->links() }}
            </div>
        @endif
    </div>
</div>

@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function () {
        document.querySelectorAll('.cancel-order-btn').forEach(button => {
            button.addEventListener('click', function () {
                const orderId = this.dataset.orderId;
                if (confirm('@lang('Are you sure you want to cancel this order?')')) {
                    fetch(`{{ url('hesabim/siparislerim') }}/${orderId}/cancel`, {
                        method: 'POST',
                        headers: {
                            'X-CSRF-TOKEN': '{{ csrf_token() }}',
                            'Content-Type': 'application/json',
                            'Accept': 'application/json'
                        }
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            alert(data.message);
                            window.location.reload();
                        } else {
                            alert(data.message);
                        }
                    })
                    .catch(error => {
                        console.error('Error:', error);
                        alert('@lang('An error occurred')');
                    });
                }
            });
        });
    });
</script>
@endpush
@endsection