@extends('gorevsitesi.layouts.app')

@section('title', s__('Profile Settings') . ' - GorevSitesi')
@section('description', s__('Update your profile information'))

@section('content')
<!-- Page Header -->
<div class="row mb-4">
    <div class="col-12">
        <div class="d-flex align-items-center">
            <a href="{{ route('site2.account.dashboard') }}" class="btn btn-outline-secondary me-3">
                <i class="bi bi-arrow-left"></i> {{ s__('Back') }}
            </a>
            <div>
                <h1 class="fw-bold mb-1">{{ s__('Profile Settings') }}</h1>
                <p class="text-muted mb-0">{{ s__('Account Information') }}</p>
            </div>
        </div>
    </div>
</div>

<!-- Alert Messages -->
<div id="alert-container"></div>

<!-- Profile Settings Tabs -->
<div class="row">
    <div class="col-12">
        <div class="card border-0 shadow-sm">
            <div class="card-header bg-white border-0">
                <ul class="nav nav-tabs card-header-tabs" id="profileTabs" role="tablist">
                    <li class="nav-item" role="presentation">
                        <button class="nav-link active" id="profile-tab" data-bs-toggle="tab" data-bs-target="#profile" type="button" role="tab">
                            <i class="bi bi-person me-2"></i>{{ s__('Profile Information') }}
                        </button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="password-tab" data-bs-toggle="tab" data-bs-target="#password" type="button" role="tab">
                            <i class="bi bi-shield-lock me-2"></i>{{ s__('Change Password') }}
                        </button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="payment-tab" data-bs-toggle="tab" data-bs-target="#payment" type="button" role="tab">
                            <i class="bi bi-credit-card me-2"></i>{{ s__('Payment Information') }}
                        </button>
                    </li>
                </ul>
            </div>
            <div class="card-body">
                <div class="tab-content" id="profileTabsContent">
                    <!-- Profile Information Tab -->
                    <div class="tab-pane fade show active" id="profile" role="tabpanel">
                        <form id="profileForm">
                            @csrf
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="account_holder" class="form-label">{{ s__('Full Name') }}</label>
                                    <input type="text" class="form-control" id="account_holder" name="account_holder" 
                                           value="{{ Auth::user()->account_holder }}" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="username" class="form-label">{{ s__('Username') }}</label>
                                    <input type="text" class="form-control" value="{{ Auth::user()->username }}" disabled>
                                    <div class="form-text">{{ s__('Username cannot be changed') }}</div>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="email" class="form-label">{{ s__('Email') }}</label>
                                    <input type="email" class="form-control" id="email" name="email" 
                                           value="{{ Auth::user()->email }}" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="phone" class="form-label">Telefon</label>
                                    <input type="text" class="form-control" id="phone" name="phone" 
                                           value="{{ Auth::user()->phone }}" required>
                                </div>
                            </div>
                            <div class="text-end">
                                <button type="submit" class="btn btn-primary">
                                    <i class="bi bi-check-circle me-2"></i>Profil Bilgilerini Güncelle
                                </button>
                            </div>
                        </form>
                    </div>

                    <!-- Password Change Tab -->
                    <div class="tab-pane fade" id="password" role="tabpanel">
                        <form id="passwordForm">
                            @csrf
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="current_password" class="form-label">Mevcut Şifre</label>
                                    <input type="password" class="form-control" id="current_password" name="current_password" required>
                                </div>
                                <div class="col-md-6"></div>
                                <div class="col-md-6 mb-3">
                                    <label for="new_password" class="form-label">Yeni Şifre</label>
                                    <input type="password" class="form-control" id="new_password" name="new_password" 
                                           minlength="8" required>
                                    <div class="form-text">En az 8 karakter olmalıdır.</div>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="new_password_confirmation" class="form-label">Yeni Şifre Tekrar</label>
                                    <input type="password" class="form-control" id="new_password_confirmation" 
                                           name="new_password_confirmation" required>
                                </div>
                            </div>
                            <div class="text-end">
                                <button type="submit" class="btn btn-warning">
                                    <i class="bi bi-shield-check me-2"></i>Şifreyi Güncelle
                                </button>
                            </div>
                        </form>
                    </div>

                    <!-- Payment Information Tab -->
                    <div class="tab-pane fade" id="payment" role="tabpanel">
                        <form id="paymentForm">
                            @csrf
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="iban" class="form-label">IBAN</label>
                                    <input type="text" class="form-control" id="iban" name="iban" 
                                           value="{{ Auth::user()->iban }}" placeholder="TR00 0000 0000 0000 0000 0000 00">
                                    <div class="form-text">Para çekme işlemleri için gereklidir.</div>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="bank_name" class="form-label">Banka Adı</label>
                                    <input type="text" class="form-control" id="bank_name" name="bank_name" 
                                           value="{{ Auth::user()->bank_name }}" placeholder="Örn: Ziraat Bankası">
                                </div>
                            </div>
                            <div class="alert alert-info">
                                <i class="bi bi-info-circle me-2"></i>
                                <strong>Bilgi:</strong> IBAN bilgileriniz sadece para çekme işlemlerinde kullanılır ve güvenli şekilde saklanır.
                            </div>
                            <div class="text-end">
                                <button type="submit" class="btn btn-success">
                                    <i class="bi bi-credit-card me-2"></i>Ödeme Bilgilerini Güncelle
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
    .nav-tabs .nav-link {
        border: none;
        color: #6c757d;
        font-weight: 500;
    }
    
    .nav-tabs .nav-link.active {
        background-color: transparent;
        border-bottom: 2px solid var(--bs-primary);
        color: var(--bs-primary);
    }
    
    .form-control:focus {
        border-color: var(--bs-primary);
        box-shadow: 0 0 0 0.2rem rgba(var(--bs-primary-rgb), 0.25);
    }
    
    .btn {
        border-radius: 8px;
        font-weight: 500;
    }
    
    .alert {
        border-radius: 8px;
        border: none;
    }
</style>
@endpush

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Profile Form Handler
    document.getElementById('profileForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        // Show loading state
        submitBtn.innerHTML = '<i class="bi bi-hourglass-split me-2"></i>Güncelleniyor...';
        submitBtn.disabled = true;
        
        fetch('{{ route("site2.account.profile.update") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                'Accept': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                showAlert('success', data.message);
            } else {
                showAlert('danger', data.message || 'Bir hata oluştu.');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            showAlert('danger', 'Bir hata oluştu. Lütfen tekrar deneyin.');
        })
        .finally(() => {
            // Reset button state
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });
    
    // Password Form Handler
    document.getElementById('passwordForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        // Check if passwords match
        const newPassword = document.getElementById('new_password').value;
        const confirmPassword = document.getElementById('new_password_confirmation').value;
        
        if (newPassword !== confirmPassword) {
            showAlert('danger', 'Yeni şifreler eşleşmiyor.');
            return;
        }
        
        // Show loading state
        submitBtn.innerHTML = '<i class="bi bi-hourglass-split me-2"></i>Güncelleniyor...';
        submitBtn.disabled = true;
        
        fetch('{{ route("site2.account.password.update") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                'Accept': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                showAlert('success', data.message);
                this.reset(); // Clear form
            } else {
                showAlert('danger', data.message || 'Bir hata oluştu.');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            showAlert('danger', 'Bir hata oluştu. Lütfen tekrar deneyin.');
        })
        .finally(() => {
            // Reset button state
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });
    
    // Payment Form Handler (same as profile form)
    document.getElementById('paymentForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        // Show loading state
        submitBtn.innerHTML = '<i class="bi bi-hourglass-split me-2"></i>Güncelleniyor...';
        submitBtn.disabled = true;
        
        fetch('{{ route("site2.account.profile.update") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                'Accept': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                showAlert('success', data.message);
            } else {
                showAlert('danger', data.message || 'Bir hata oluştu.');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            showAlert('danger', 'Bir hata oluştu. Lütfen tekrar deneyin.');
        })
        .finally(() => {
            // Reset button state
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });
    
    // Alert function
    function showAlert(type, message) {
        const alertContainer = document.getElementById('alert-container');
        const alertHtml = `
            <div class="alert alert-${type} alert-dismissible fade show" role="alert">
                <i class="bi bi-${type === 'success' ? 'check-circle' : 'exclamation-triangle'} me-2"></i>
                ${message}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        `;
        alertContainer.innerHTML = alertHtml;
        
        // Auto dismiss after 5 seconds
        setTimeout(() => {
            const alert = alertContainer.querySelector('.alert');
            if (alert) {
                alert.remove();
            }
        }, 5000);
    }
});
</script>
@endpush