@extends('gorevsitesi.layouts.app')

@section('title', s__('Login') . ' - GorevSitesi')
@section('description', s__('Login to your account and continue shopping'))

@section('content')
<div class="row justify-content-center">
    <div class="col-md-6 col-lg-5">
        <div class="card border-0 shadow-lg">
            <div class="card-body p-5">
                <!-- Header -->
                <div class="text-center mb-4">
                    <div class="bg-primary bg-opacity-10 rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 80px; height: 80px;">
                        <i class="bi bi-box-arrow-in-right text-primary fs-1"></i>
                    </div>
                    <h2 class="fw-bold mb-2">{{ s__('Welcome!') }}</h2>
                    <p class="text-muted">{{ s__('Login to your account and continue shopping') }}</p>
                </div>

                <!-- Login Form -->
                <form method="POST" action="{{ route('site2.login.submit') }}" id="loginForm">
                    @csrf

                    <!-- Email -->
                    <div class="mb-3">
                        <label for="username" class="form-label fw-medium">
                            <i class="bi bi-envelope me-2"></i>{{ s__('Email Address') }}
                        </label>
                       <input id="username"
       type="text"
       class="form-control form-control-lg @error('username') is-invalid @enderror"
       name="username"
       value="{{ old('username') }}"
       required
       autocomplete="username"
       autofocus
       placeholder="{{ s__('Email or Username') }}">
@error('username')
  <div class="invalid-feedback">
     <i class="bi bi-exclamation-circle me-1"></i>{{ $message }}
  </div>
@enderror
                    </div>

                    <!-- Password -->
                    <div class="mb-3">
                        <label for="password" class="form-label fw-medium">
                            <i class="bi bi-lock me-2"></i>{{ s__('Password') }}
                        </label>
                        <div class="position-relative">
                            <input id="password" 
                                   type="password" 
                                   class="form-control form-control-lg @error('password') is-invalid @enderror" 
                                   name="password" 
                                   required 
                                   autocomplete="current-password"
                                   placeholder="{{ s__('Enter Password') }}">
                            <button type="button" 
                                    class="btn btn-link position-absolute end-0 top-50 translate-middle-y text-muted"
                                    onclick="togglePassword('password')"
                                    style="border: none; background: none; z-index: 10;">
                                <i class="bi bi-eye" id="password-eye"></i>
                            </button>
                        </div>
                        @error('password')
                            <div class="invalid-feedback">
                                <i class="bi bi-exclamation-circle me-1"></i>{{ $message }}
                            </div>
                        @enderror
                    </div>

                    <!-- Remember Me -->
                    <div class="mb-4">
                        <div class="form-check">
                            <input class="form-check-input" 
                                   type="checkbox" 
                                   name="remember" 
                                   id="remember" 
                                   {{ old('remember') ? 'checked' : '' }}>
                            <label class="form-check-label" for="remember">
                                {{ s__('Remember Me') }}
                            </label>
                        </div>
                    </div>

                    <!-- Submit Button -->
                    <div class="d-grid mb-3">
                        <button type="submit" class="btn btn-primary btn-lg" id="loginBtn">
                            <i class="bi bi-box-arrow-in-right me-2"></i>{{ s__('Login') }}
                        </button>
                    </div>

                    <!-- Forgot Password -->
                    <div class="text-center mb-3">
                        <a href="#" class="text-decoration-none">
                            <i class="bi bi-question-circle me-1"></i>{{ s__('Forgot Password') }}
                        </a>
                    </div>
                </form>

                <!-- Divider -->
                <div class="text-center my-4">
                    <hr class="my-3">
                    <span class="bg-white px-3 text-muted">{{ s__('or') }}</span>
                </div>

                <!-- Register Link -->
                <div class="text-center">
                    <p class="mb-2">{{ s__("Don't have an account yet?") }}</p>
                    <a href="{{ route('site2.register') }}" class="btn btn-outline-primary">
                        <i class="bi bi-person-plus me-2"></i>{{ s__('Create Free Account') }}
                    </a>
                </div>
            </div>
        </div>

        <!-- Additional Info -->
        <div class="text-center mt-4">
            <div class="row g-3">
                <div class="col-4">
                    <div class="text-center">
                        <i class="bi bi-shield-check text-success fs-4"></i>
                        <p class="small text-muted mb-0">{{ s__('Secure') }}</p>
                    </div>
                </div>
                <div class="col-4">
                    <div class="text-center">
                        <i class="bi bi-lightning-charge text-warning fs-4"></i>
                        <p class="small text-muted mb-0">{{ s__('Fast') }}</p>
                    </div>
                </div>
                <div class="col-4">
                    <div class="text-center">
                        <i class="bi bi-headset text-info fs-4"></i>
                        <p class="small text-muted mb-0">{{ s__('24/7 Support') }}</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    // Password toggle functionality
    function togglePassword(inputId) {
        const input = document.getElementById(inputId);
        const eye = document.getElementById(inputId + '-eye');
        
        if (input.type === 'password') {
            input.type = 'text';
            eye.classList.remove('bi-eye');
            eye.classList.add('bi-eye-slash');
        } else {
            input.type = 'password';
            eye.classList.remove('bi-eye-slash');
            eye.classList.add('bi-eye');
        }
    }

    // Form submission with loading state
    document.getElementById('loginForm').addEventListener('submit', function(e) {
        const btn = document.getElementById('loginBtn');
        const originalText = btn.innerHTML;
        
        btn.innerHTML = '<span class="loading"></span> ' + '{{ s__("Logging in...") }}';
        btn.disabled = true;
        
        // Re-enable button after 5 seconds in case of slow response
        setTimeout(function() {
            btn.innerHTML = originalText;
            btn.disabled = false;
        }, 5000);
    });

    // Auto-focus on email field
    document.addEventListener('DOMContentLoaded', function() {
        document.getElementById('username').focus();
    });
</script>
@endpush
