@extends('gorevsitesi.layouts.app')

@section('title', __('Register') . ' - GorevSitesi')
@section('description', __('Join GorevSitesi for free and enjoy shopping.'))

@section('content')
<div class="row justify-content-center">
  <div class="col-lg-10">
    <div class="card border-0 shadow-lg">
      <div class="card-body p-5">
        <div class="text-center mb-4">
          <div class="bg-success bg-opacity-10 rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width:80px;height:80px;">
            <i class="bi bi-person-plus text-success fs-1"></i>
          </div>
          <h2 class="fw-bold mb-2">{{ __('Create Account') }}</h2>
          <p class="text-muted">{{ __('Create a free account and start shopping') }}</p>
        </div>

        <form method="POST" action="{{ route('site2.register.submit') }}" id="registerForm">
          @csrf

          <div class="row g-3">
            <!-- Name / Username -->
            <div class="col-md-6">
              <label for="account_holder" class="form-label fw-medium">
                <i class="bi bi-person me-2"></i>{{ __('Name Surname') }}</label>
              <input id="account_holder" type="text"
                     class="form-control form-control-lg @error('account_holder') is-invalid @enderror"
                     name="account_holder" value="{{ old('account_holder') }}" required
                     autocomplete="name" autofocus
                     placeholder="{{ __('Please Enter Name Surname') }}">
              @error('account_holder')<div class="invalid-feedback"><i class="bi bi-exclamation-circle me-1"></i>{{ $message }}</div>@enderror
            </div>

            <div class="col-md-6">
              <label for="username" class="form-label fw-medium">
                <i class="bi bi-at me-2"></i>{{ __('Username') }}</label>
              <input id="username" type="text"
                     class="form-control form-control-lg @error('username') is-invalid @enderror"
                     name="username" value="{{ old('username') }}" required autocomplete="username"
                     placeholder="{{ __('Please Enter Username') }}">
              @error('username')<div class="invalid-feedback"><i class="bi bi-exclamation-circle me-1"></i>{{ $message }}</div>@enderror
            </div>

            <!-- Email / Phone -->
            <div class="col-md-6">
              <label for="email" class="form-label fw-medium">
                <i class="bi bi-envelope me-2"></i>{{ __('Email Address') }}</label>
              <input id="email" type="email"
                     class="form-control form-control-lg @error('email') is-invalid @enderror"
                     name="email" value="{{ old('email') }}" required autocomplete="email"
                     placeholder="{{ __('jhon@example.com') }}">
              @error('email')<div class="invalid-feedback"><i class="bi bi-exclamation-circle me-1"></i>{{ $message }}</div>@enderror
            </div>

            <div class="col-md-6">
              <label for="phone" class="form-label fw-medium">
                <i class="bi bi-telephone me-2"></i>{{ __('Phone Number') }}</label>
              <input id="phone" type="tel"
                     class="form-control form-control-lg @error('phone') is-invalid @enderror"
                     name="phone" value="{{ old('phone') }}" required autocomplete="tel"
                     placeholder="{{ __('5320000000') }}">
              @error('phone')<div class="invalid-feedback"><i class="bi bi-exclamation-circle me-1"></i>{{ $message }}</div>@enderror
            </div>

            <!-- Country / City -->
            <div class="col-md-6">
              <label for="country_code" class="form-label fw-medium">
                <i class="bi bi-globe me-2"></i>{{ __('Country') }}</label>
              <select class="form-select form-select-lg @error('country_code') is-invalid @enderror"
                      name="country_code" id="country_code"
                      data-cities-url-template="{{ url('/api/cities/XX') }}" required>
                <option value="">{{ __('Please Select') }}</option>
                @foreach(($countries ?? []) as $country)
                  <option value="{{ $country->code }}" {{ old('country_code') === $country->code ? 'selected' : '' }}>
                    {{ $country->name }}
                  </option>
                @endforeach
                <option value="9999" {{ old('country_code') == "9999" ? 'selected' : '' }}>{{ __('Other') }}</option>
              </select>
              @error('country_code')<div class="invalid-feedback"><i class="bi bi-exclamation-circle me-1"></i>{{ $message }}</div>@enderror
            </div>

            <div class="col-md-6">
              <label for="city_id" class="form-label fw-medium">
                <i class="bi bi-building me-2"></i>{{ __('City') }}</label>
              <select class="form-select form-select-lg @error('city_id') is-invalid @enderror"
                      name="city_id" id="city_id" {{ old('country_code') ? '' : 'disabled' }}>
                <option value="">{{ __('Please Select') }}</option>
                <option value="9999" {{ old('city_id') == "9999" ? 'selected' : '' }}>{{ __('Other') }}</option>
              </select>
              @error('city_id')<div class="invalid-feedback"><i class="bi bi-exclamation-circle me-1"></i>{{ $message }}</div>@enderror
            </div>

            <!-- Gender / Password -->
            <div class="col-md-6">
              <label for="gender" class="form-label fw-medium">
                <i class="bi bi-person-badge me-2"></i>{{ __('Sex') }}</label>
              <select class="form-select form-select-lg @error('gender') is-invalid @enderror"
                      name="gender" id="gender" required>
                <option value="">{{ __('Please Select') }}</option>
                <option value="male"   {{ old('gender') === 'male'   ? 'selected' : '' }}>{{ __('Male') }}</option>
                <option value="female" {{ old('gender') === 'female' ? 'selected' : '' }}>{{ __('Female') }}</option>
                <option value="other"  {{ old('gender') === 'other'  ? 'selected' : '' }}>{{ __('Other') }}</option>
              </select>
              @error('gender')<div class="invalid-feedback"><i class="bi bi-exclamation-circle me-1"></i>{{ $message }}</div>@enderror
            </div>

            <div class="col-md-6">
              <label for="password" class="form-label fw-medium"><i class="bi bi-lock me-2"></i>{{ __('Password') }}</label>
              <div class="position-relative">
                <input id="password" type="password"
                       class="form-control form-control-lg @error('password') is-invalid @enderror"
                       name="password" required autocomplete="new-password" placeholder="********" minlength="8">
                <button type="button" class="btn btn-link position-absolute end-0 top-50 translate-middle-y text-muted"
                        onclick="togglePassword('password')" style="border:none;background:none;z-index:10;">
                  <i class="bi bi-eye" id="password-eye"></i>
                </button>
              </div>
              @error('password')<div class="invalid-feedback"><i class="bi bi-exclamation-circle me-1"></i>{{ $message }}</div>@enderror
              <div class="form-text"><small class="text-muted"><i class="bi bi-info-circle me-1"></i>{{ __('Password must be at least 8 characters long') }}</small></div>
            </div>

            <!-- Password confirm / Terms -->
            <div class="col-md-6">
              <label for="password_confirmation" class="form-label fw-medium"><i class="bi bi-lock-fill me-2"></i>{{ __('Password Confirmation') }}</label>
              <div class="position-relative">
                <input id="password_confirmation" type="password" class="form-control form-control-lg"
                       name="password_confirmation" required autocomplete="new-password" placeholder="********" minlength="8">
                <button type="button" class="btn btn-link position-absolute end-0 top-50 translate-middle-y text-muted"
                        onclick="togglePassword('password_confirmation')" style="border:none;background:none;z-index:10;">
                  <i class="bi bi-eye" id="password_confirmation-eye"></i>
                </button>
              </div>
              <div id="password-match-message" class="form-text"></div>
            </div>

            <div class="col-md-6 d-flex align-items-end">
              <div class="form-check">
                <input class="form-check-input" type="checkbox" id="terms" name="terms" required>
                <label class="form-check-label" for="terms">{{ __('I read and agree to Terms & Conditions') }}</label>
              </div>
            </div>

            <!-- Submit full width -->
            <div class="col-12">
              <div class="d-grid">
                <button type="submit" class="btn btn-success btn-lg" id="registerBtn">
                  <i class="bi bi-person-plus me-2"></i>{{ __('Create Account') }}
                </button>
              </div>
            </div>
          </div>
        </form>

        <div class="text-center my-4">
          <hr class="my-3"><span class="bg-white px-3 text-muted">{{ __('or') }}</span>
        </div>

        <div class="text-center">
          <p class="mb-2">{{ __('Already have an account?') }}</p>
          <a href="{{ route('site2.login') }}" class="btn btn-outline-primary">
            <i class="bi bi-box-arrow-in-right me-2"></i>{{ __('Login') }}
          </a>
        </div>
      </div>
    </div>

    <div class="text-center mt-4">
      <h6 class="fw-bold mb-3">{{ __('Benefits') }}</h6>
      <div class="row g-3">
        <div class="col-4"><div class="text-center"><i class="bi bi-gift fs-4"></i><p class="small text-muted mb-0">{{ __('Special Discounts') }}</p></div></div>
        <div class="col-4"><div class="text-center"><i class="bi bi-truck fs-4"></i><p class="small text-muted mb-0">{{ __('Free Shipping') }}</p></div></div>
        <div class="col-4"><div class="text-center"><i class="bi bi-star fs-4"></i><p class="small text-muted mb-0">{{ __('Quality Products') }}</p></div></div>
      </div>
    </div>
  </div>
</div>
@endsection

@push('scripts')
<script>
function togglePassword(id){
  const i=document.getElementById(id), e=document.getElementById(id+'-eye');
  if(i.type==='password'){ i.type='text'; e.classList.replace('bi-eye','bi-eye-slash'); }
  else{ i.type='password'; e.classList.replace('bi-eye-slash','bi-eye'); }
}

function checkPasswordMatch(){
  const p1=document.getElementById('password').value;
  const p2=document.getElementById('password_confirmation').value;
  const el=document.getElementById('password-match-message');
  if(p2.length>0){
    if(p1===p2){ el.innerHTML='<small class="text-success"><i class="bi bi-check-circle me-1"></i>{{ __("Passwords match") }}</small>'; return true; }
    el.innerHTML='<small class="text-danger"><i class="bi bi-x-circle me-1"></i>{{ __("Passwords do not match") }}</small>'; return false;
  }
  el.innerHTML=''; return false;
}

(function(){
  const countrySel=document.getElementById('country_code');
  const citySel=document.getElementById('city_id');
  const urlTpl=countrySel?.getAttribute('data-cities-url-template')||'';
  const OLD={country:@json(old('country_code')), city:@json(old('city_id'))};
  const cache={};

  function url(code){ return urlTpl.replace('XX', encodeURIComponent(code)); }

  function resetCities(){
    citySel.innerHTML='';
    const def=document.createElement('option'); def.value=''; def.textContent='{{ __("Please Select") }}'; citySel.appendChild(def);
    const other=document.createElement('option'); other.value='9999'; other.textContent='{{ __("Other") }}'; citySel.appendChild(other);
  }

  function fill(cities, selected){
    resetCities();
    (cities||[]).forEach(c=>{
      const o=document.createElement('option'); o.value=c.id; o.textContent=c.name;
      if(String(selected||'')===String(c.id)) o.selected=true;
      citySel.insertBefore(o, citySel.querySelector('option[value="9999"]'));
    });
    citySel.disabled=false;
  }

  async function loadCities(code, selected){
    if(!code || code==='9999'){ resetCities(); citySel.disabled=(code!=='9999'); return; }
    if(cache[code]){ fill(cache[code], selected); return; }
    citySel.disabled=true; citySel.innerHTML='<option value="">{{ __("Loading...") }}</option>';
    try{
      const res=await fetch(url(code), {headers:{'Accept':'application/json'}});
      if(!res.ok) throw new Error('HTTP '+res.status);
      const data=await res.json();
      cache[code]=data.cities||[];
      fill(cache[code], selected);
    }catch(err){
      console.error(err); resetCities(); citySel.disabled=true;
    }
  }

  countrySel?.addEventListener('change', function(){ loadCities(this.value, null); });

  document.addEventListener('DOMContentLoaded', function(){
    document.getElementById('account_holder').focus();
    document.getElementById('password_confirmation').addEventListener('input', checkPasswordMatch);
    document.getElementById('password').addEventListener('input', function(){
      if(document.getElementById('password_confirmation').value.length>0) checkPasswordMatch();
    });
    if(OLD.country){ loadCities(OLD.country, OLD.city); }
  });
})();

document.getElementById('registerForm').addEventListener('submit', function(e){
  if(!checkPasswordMatch()){ e.preventDefault(); return; }
  const btn=document.getElementById('registerBtn'), t=btn.innerHTML;
  btn.innerHTML='<span class="spinner-border spinner-border-sm me-2"></span>{{ __("Creating account...") }}';
  btn.disabled=true; setTimeout(()=>{btn.innerHTML=t; btn.disabled=false;}, 5000);
});
</script>
@endpush
