@extends('gorevsitesi.layouts.app')

@section('title', s__('GorevSitesi - Quality Products, Fast Delivery'))
@section('description', s__('Access quality products with GorevSitesi. Fast delivery, secure payment and customer satisfaction guarantee.'))
@section('keywords', s__('e-commerce, online shopping, quality products, fast delivery'))

@section('content')
<!-- Hero Section -->
<section class="hero-section mb-5">
    <div class="row align-items-center min-vh-50">
        <div class="col-lg-6 mb-4 mb-lg-0">
            <h1 class="display-4 fw-bold text-primary mb-4">
                {{ s__('Quality Products') }},<br>
                <span class="text-dark">{{ s__('Fast Delivery') }}</span>
            </h1>
            <p class="lead text-muted mb-4">
                {{ s__('Access all the products you need easily with GorevSitesi. We are with you with secure payment, fast shipping and 24/7 customer support.') }}
            </p>
            <div class="d-flex flex-column flex-sm-row gap-3">
                <a href="{{ route('site2.products.index') }}" class="btn btn-primary btn-lg">
                    <i class="bi bi-grid"></i> {{ s__('Discover Products') }}
                </a>
                @guest
                    <a href="{{ route('site2.register') }}" class="btn btn-outline-primary btn-lg">
                        <i class="bi bi-person-plus"></i> {{ s__('Join Free') }}
                    </a>
                @endguest
            </div>
        </div>
        <div class="col-lg-6">
            <div class="hero-image text-center">
                <div class="bg-primary bg-opacity-10 rounded-circle d-inline-flex align-items-center justify-content-center" style="width: 300px; height: 300px;">
                    <i class="bi bi-shop text-primary" style="font-size: 8rem;"></i>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Features Section -->
<section class="features-section mb-5">
    <div class="row text-center mb-5">
        <div class="col-12">
            <h2 class="fw-bold mb-3">{{ s__('Why GorevSitesi') }}</h2>
            <p class="text-muted">{{ s__('We are here to provide you with the best shopping experience') }}</p>
        </div>
    </div>
    <div class="row g-4">
        <div class="col-md-4">
            <div class="card h-100 border-0 shadow-sm text-center">
                <div class="card-body p-4">
                    <div class="bg-success bg-opacity-10 rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 80px; height: 80px;">
                        <i class="bi bi-lightning-charge text-success fs-1"></i>
                    </div>
                    <h5 class="fw-bold mb-3">{{ s__('Fast Delivery') }}</h5>
                    <p class="text-muted">{{ s__('Your orders are at your door in the shortest time. Even faster with same day shipping option.') }}</p>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card h-100 border-0 shadow-sm text-center">
                <div class="card-body p-4">
                    <div class="bg-primary bg-opacity-10 rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 80px; height: 80px;">
                        <i class="bi bi-shield-check text-primary fs-1"></i>
                    </div>
                    <h5 class="fw-bold mb-3">{{ s__('Secure Payment') }}</h5>
                    <p class="text-muted">{{ s__('Payment system protected with SSL certificate. Pay securely with credit card and balance.') }}</p>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card h-100 border-0 shadow-sm text-center">
                <div class="card-body p-4">
                    <div class="bg-warning bg-opacity-10 rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 80px; height: 80px;">
                        <i class="bi bi-headset text-warning fs-1"></i>
                    </div>
                    <h5 class="fw-bold mb-3">{{ s__('24/7 Support') }}</h5>
                    <p class="text-muted">{{ s__('Our customer service is always with you. Contact us for your questions.') }}</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Stats Section -->
<section class="stats-section mb-5">
    <div class="bg-primary bg-opacity-5 rounded-3 p-5">
        <div class="row text-center g-4">
            <div class="col-6 col-md-3">
                <div class="stat-item">
                    <h3 class="fw-bold text-white mb-2">1000+</h3>
                    <p class="text-muted mb-0">{{ s__('Happy Customers') }}</p>
                </div>
            </div>
            <div class="col-6 col-md-3">
                <div class="stat-item">
                    <h3 class="fw-bold text-white mb-2">500+</h3>
                    <p class="text-muted mb-0">{{ s__('Product Varieties') }}</p>
                </div>
            </div>
            <div class="col-6 col-md-3">
                <div class="stat-item">
                    <h3 class="fw-bold text-white mb-2">24/7</h3>
                    <p class="text-muted mb-0">{{ s__('Customer Support') }}</p>
                </div>
            </div>
            <div class="col-6 col-md-3">
                <div class="stat-item">
                    <h3 class="fw-bold text-white mb-2">99%</h3>
                    <p class="text-muted mb-0">{{ s__('Satisfaction Rate') }}</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- CTA Section -->
<section class="cta-section">
    <div class="bg-primary rounded-3 p-5 text-center text-white">
        <h2 class="fw-bold mb-3">{{ s__('Start Shopping Now') }}</h2>
        <p class="lead mb-4 opacity-90">
            {{ s__('Choose the most suitable products for you among thousands of products and enjoy fast delivery.') }}
        </p>
        <div class="d-flex flex-column flex-sm-row gap-3 justify-content-center">
            <a href="{{ route('site2.products.index') }}" class="btn btn-light btn-lg">
                <i class="bi bi-grid text-primary"></i> {{ s__('Browse Products') }}
            </a>
            @guest
                <a href="{{ route('site2.register') }}" class="btn btn-outline-light btn-lg">
                    <i class="bi bi-person-plus"></i> {{ s__('Join Free') }}
                </a>
            @endguest
        </div>
    </div>
</section>
@endsection

@push('styles')
<style>
    .hero-section {
        padding: 2rem 0;
    }
    
    .min-vh-50 {
        min-height: 50vh;
    }
    
    .hero-image {
        animation: float 3s ease-in-out infinite;
    }
    
    @keyframes float {
        0%, 100% { transform: translateY(0px); }
        50% { transform: translateY(-10px); }
    }
    
    .features-section .card {
        transition: all 0.3s ease;
    }
    
    .features-section .card:hover {
        transform: translateY(-5px);
    }
    
    .stat-item h3 {
        font-size: 2.5rem;
    }
    
    @media (max-width: 768px) {
        .hero-section {
            padding: 1rem 0;
        }
        
        .display-4 {
            font-size: 2.5rem;
        }
        
        .stat-item h3 {
            font-size: 2rem;
        }
    }
</style>
@endpush
