<!doctype html>
<html lang="{{ app()->getLocale() }}" dir="{{ app()->getLocale() == 'ar' ? 'rtl' : 'ltr' }}">
<head>
	 <base href="{{ url('/') }}/">
	<!-- Required meta tags -->
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<!--favicon-->
	<link rel="icon" href="{{asset('assets/images/' . ($settings['favicon'] ?? 'favicon-32x32.png'))}}" type="image/png">
	<!--plugins-->
	@yield("style")
	<link href="{{asset('assets/plugins/simplebar/css/simplebar.css')}}" rel="stylesheet">
	<link href="{{asset('assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css')}}" rel="stylesheet">
	<link href="{{asset('assets/plugins/metismenu/css/metisMenu.min.css')}}" rel="stylesheet">
	<!-- loader-->
	<link href="{{asset('assets/css/pace.min.css')}}" rel="stylesheet">
	<script src="{{asset('assets/js/pace.min.js')}}"></script>
	<!-- Bootstrap CSS -->
	<link href="{{asset('assets/css/bootstrap.min.css')}}" rel="stylesheet">
    <link href="{{asset('assets/css/bootstrap-extended.css')}}" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">
	<link href="{{asset('assets/css/app.css')}}" rel="stylesheet">
	<link href="{{asset('assets/css/icons.css')}}" rel="stylesheet">

    <!-- Theme Style CSS -->
    <link rel="stylesheet" href="{{asset('assets/css/dark-theme.css')}}">
    <link rel="stylesheet" href="{{asset('assets/css/semi-dark.css')}}">
    <link rel="stylesheet" href="{{asset('assets/css/header-colors.css')}}">

    <meta name="description" content="{{ $settings['description'] ?? '' }}">
    <meta name="keywords" content="{{ $settings['keywords'] ?? '' }}">
    <meta name="author" content="{{ $settings['site_name'] ?? 'TaskHub' }}">
	<meta name="csrf-token" content="{{ csrf_token() }}">
	
    <title>@yield('title', $settings['site_name'] ?? 'Dashboard')</title>
	<!-- SweetAlert2 -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<link href="{{ asset('assets/plugins/notifications/css/lobibox.min.css') }}" rel="stylesheet">

<style>
	.announcement-popup-modal {
		max-width: 600px !important;
	}
	
	.announcement-popup-content {
		text-align: left !important;
	}
	
	.announcement-content {
		max-height: 300px;
		overflow-y: auto;
		line-height: 1.6;
	}
	</style>
</head>

<body>
	<!--wrapper-->
	<div class="wrapper">
		<!--start header -->
		@include("layouts.header")
		<!--end header -->
		<!--navigation-->
		@include("layouts.nav")
		<!--end navigation-->
		<!--start page wrapper -->
		@yield("wrapper")
		<!--end page wrapper -->
    
		<!--start overlay-->
		<div class="overlay toggle-icon"></div>
		<!--end overlay-->
		<!--Start Back To Top Button--> <a href="javaScript:;" class="back-to-top"><i class='bx bxs-up-arrow-alt'></i></a>
		<!--End Back To Top Button-->
		<footer class="page-footer">
			<p class="mb-0">{{ __('copyright', ['year' => date("Y")]) }}</p>
		</footer>
	</div>
	<!--end wrapper-->
 
	<!-- Bootstrap JS -->
	<script src="{{asset('assets/js/bootstrap.bundle.min.js')}}"></script>
	<!--plugins-->
	<script src="{{asset('assets/js/jquery.min.js')}}"></script>
	<script>
  $.ajaxSetup({
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
      'Accept':       'application/json',
      'X-Requested-With': 'XMLHttpRequest'
    }
  });
</script>
	<script src="{{ asset('assets/plugins/notifications/js/lobibox.min.js') }}"></script>
	<script>
  // Lobibox'un varsayılan soundPath'ini mutlak bir asset yoluyla değiştiriyoruz
  Lobibox.notify.DEFAULTS = $.extend(true, {}, Lobibox.notify.DEFAULTS, {
    soundPath: @json(asset('assets/plugins/notifications/sounds/')),
    soundExt: '.ogg'   // eğer .ogg dışında bir uzantı kullanıyorsan burayı da güncelle
  });
</script>
	<script src="{{ asset('assets/plugins/notifications/js/notifications.min.js') }}"></script>
	<script src="{{asset('assets/plugins/simplebar/js/simplebar.min.js')}}"></script>
	<script src="{{asset('assets/plugins/metismenu/js/metisMenu.min.js')}}"></script>
	<script src="{{asset('assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js')}}"></script>

	<!--app JS-->
	<script src="{{asset('assets/js/app.js')}}"></script>

	<!-- Announcement Popup System -->
	<script>
	$(document).ready(function() {
		// Check for popup announcements after page load
		setTimeout(function() {
			checkPopupAnnouncements();
		}, 2000);
	});

	function checkPopupAnnouncements() {
		$.ajax({
			url: '{{ route('api.announcements.popup') }}',
			method: 'GET',
			success: function(response) {
				if (response.success && response.announcements.length > 0) {
					showAnnouncementPopups(response.announcements);
				}
			},
			error: function() {
				console.log('Error loading popup announcements');
			}
		});
	}

	function showAnnouncementPopups(announcements) {
		let currentIndex = 0;
		
		function showNextAnnouncement() {
			if (currentIndex >= announcements.length) {
				return;
			}
			
			const announcement = announcements[currentIndex];
			const priorityIcon = getPriorityIcon(announcement.priority);
			
			Swal.fire({
				title: announcement.title,
				html: `
					<div class="announcement-popup">
						<div class="d-flex align-items-center mb-3">
							<span class="badge bg-${announcement.priority_badge} me-2">${announcement.priority.toUpperCase()}</span>
							<small class="text-muted">${announcement.created_at}</small>
						</div>
						<div class="announcement-content text-start">
							${announcement.content}
						</div>
					</div>
				`,
				icon: priorityIcon,
				showCancelButton: true,
				confirmButtonText: '{{ __('Mark as Read') }}',
				cancelButtonText: '{{ __('Close') }}',
				allowOutsideClick: false,
				customClass: {
					popup: 'announcement-popup-modal',
					content: 'announcement-popup-content'
				}
			}).then((result) => {
				if (result.isConfirmed) {
					markAnnouncementAsRead(announcement.id);
				}
				
				currentIndex++;
				if (currentIndex < announcements.length) {
					setTimeout(showNextAnnouncement, 500);
				}
			});
		}
		
		showNextAnnouncement();
	}

	function getPriorityIcon(priority) {
		switch(priority) {
			case 'urgent': return 'error';
			case 'high': return 'warning';
			case 'medium': return 'info';
			case 'low': return 'success';
			default: return 'info';
		}
	}

	function markAnnouncementAsRead(announcementId) {
		$.ajax({
			url: `/announcements/${announcementId}/read`,
			method: 'POST',
			headers: {
				'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
			},
			success: function(response) {
				if (response.success) {
					console.log('Announcement marked as read');
				}
			}
		});
	}
	</script>

	
		
	@yield("script")
</body>

</html>
