    <!--start header wrapper-->
    <div class="header-wrapper">
        <header>
            <div class="topbar d-flex align-items-center">
                <nav class="navbar navbar-expand gap-3">
                    <div class="topbar-logo-header d-none d-lg-flex">
                        <div class="">
                            <img src="{{ asset('assets/images/' . ($settings['logo'] ?? 'logo-icon.png')) }}" class="logo-icon" alt="{{ $settings['site_name'] ?? 'Site Logo' }}">
                        </div>
                        <div class="">
                            <h4 class="logo-text">{{ $settings['site_name'] ?? 'Site Name' }}</h4>
                        </div>
                    </div>
                    <div class="mobile-toggle-menu d-block d-lg-none" data-bs-toggle="offcanvas" data-bs-target="#offcanvasNavbar"><i class='bx bx-menu'></i></div>
                   
                      <div class="top-menu ms-auto">
                        <ul class="navbar-nav align-items-center gap-1">
                         
                        <li class="nav-item dropdown dropdown-laungauge d-sm-flex">
    <a class="nav-link dropdown-toggle dropdown-toggle-nocaret" href="javascript:;" data-bs-toggle="dropdown">
        @php
            $locale = session('locale', 'tr');
        @endphp
        <img src="/assets/images/country/{{ $locale }}.png" width="22" alt="">
    </a>
    <ul class="dropdown-menu dropdown-menu-end">
        @foreach ($languages as $lang)
            <li>
                <a class="dropdown-item d-flex align-items-center py-2" href="{{ route('lang.switch', $lang['code']) }}">
                    <img src="/assets/images/country/{{ $lang['icon'] }}.png" width="20" alt="">
                    <span class="ms-2">{{ $lang['name'] }}</span>
                </a>
            </li>
        @endforeach
    </ul>
</li>
                            <li class="nav-item dark-mode d-none d-sm-flex">
                                <a class="nav-link dark-mode-icon" href="javascript:;"><i class='bx bx-moon'></i>
                                </a>
                            </li>

                            <li class="nav-item dropdown dropdown-app">
                                <a class="nav-link dropdown-toggle dropdown-toggle-nocaret" data-bs-toggle="dropdown" href="javascript:;"><i class='bx bx-grid-alt'></i></a>
                                <div class="dropdown-menu dropdown-menu-end p-0">
                                    <div class="app-container p-2 my-2">
                                      <div class="row gx-0 gy-2 row-cols-3 justify-content-center p-2">
                                        
                                      
                                      @foreach ($platforms as $platform)
<div class="col">
    <a href="javascript:;">
        <div class="app-box text-center">
            <div class="app-icon">
                <img src="{{ asset('assets/images/app/' . $platform->icon) }}" width="30" alt="{{ $platform->description }}">
            </div>
            <div class="app-name">
                <p class="mb-0 mt-1">{{ $platform->platform }}</p>
            </div>
        </div>
    </a>
</div>
@endforeach  
                                    
                      
                              
                                      </div><!--end row-->
                
                                    </div>
                                </div>
                            </li>

                            <li class="nav-item dropdown dropdown-large">
    <a class="nav-link dropdown-toggle dropdown-toggle-nocaret position-relative" href="#" data-bs-toggle="dropdown">
        <span class="alert-count">{{ $unreadCount }}</span>
        <i class='bx bx-bell'></i>
    </a>
    <div class="dropdown-menu dropdown-menu-end" style="min-width: 350px; max-width: 400px;">
        <a href="javascript:;">
            <div class="msg-header">
                <p class="msg-header-title">{{ __('Notifications')}}</p>
                <p class="msg-header-badge">{{ $unreadCount }} {{ __('New')}}</p>
            </div>
        </a>
        <div class="header-notifications-list">
            @forelse ($notifications as $notification)
                @php
                    $iconClass = 'bx-bell';
                    $iconColor = 'text-primary';
                    
                    switch($notification->type) {
                        case 'task_created':
                        case 'task_approved':
                        case 'new_content':
                            $iconClass = 'bx-task';
                            $iconColor = 'text-success';
                            break;
                        case 'ticket_created':
                        case 'ticket_replied':
                            $iconClass = 'bx-support';
                            $iconColor = 'text-info';
                            break;
                        case 'withdrawal_request':
                        case 'withdrawal_approved':
                        case 'balance_approved':
                            $iconClass = 'bx-money';
                            $iconColor = 'text-warning';
                            break;
                        case 'announcement':
                            $iconClass = 'bx-megaphone';
                            $iconColor = 'text-danger';
                            break;
                        default:
                            $iconClass = 'bx-bell';
                            $iconColor = 'text-primary';
                    }
                @endphp
                
                <div class="dropdown-item notification-item" 
                     data-id="{{ $notification->id }}" 
                     data-link="{{ $notification->link ?? '#' }}"
                     style="cursor: pointer; border-left: 3px solid {{ $notification->status == 1 ? '#007bff' : 'transparent' }}; padding: 12px 16px; white-space: normal;">
                    <div class="d-flex align-items-start">
                        <div class="notification-icon me-3 flex-shrink-0">
                            <div class="rounded-circle d-flex align-items-center justify-content-center {{ $iconColor }}" 
                                 style="width: 40px; height: 40px; background: rgba(var(--bs-primary-rgb), 0.1);">
                                <i class="bx {{ $iconClass }} fs-5"></i>
                            </div>
                        </div>
                        <div class="flex-grow-1" style="min-width: 0;">
                            <div class="d-flex justify-content-between align-items-start mb-1">
                                <h6 class="notification-title mb-0 {{ $notification->status == 1 ? 'fw-bold' : '' }}" 
                                    style="font-size: 0.875rem; line-height: 1.3; word-wrap: break-word; overflow-wrap: break-word;">
                                    {{ $notification->title }}
                                </h6>
                                <span class="msg-time text-muted flex-shrink-0 ms-2" style="font-size: 0.75rem;">
                                    {{ $notification->created_at->diffForHumans() }}
                                </span>
                            </div>
                            <p class="notification-desc mb-1 text-muted" 
                               style="font-size: 0.8rem; line-height: 1.4; word-wrap: break-word; overflow-wrap: break-word; margin: 0;">
                                {{ $notification->description }}
                            </p>
                            @if($notification->status == 1)
                                <span class="badge bg-primary mt-1" style="font-size: 0.65rem;">{{ __('New') }}</span>
                            @endif
                        </div>
                    </div>
                </div>
            @empty
                <div class="dropdown-item text-center py-4">
                    <div class="text-muted">
                        <i class="bx bx-bell-off fs-1 mb-2"></i>
                        <p class="mb-0">{{ __('No notifications') }}</p>
                    </div>
                </div>
            @endforelse
        </div>
        <a href="{{ route('notifications.index') }}">
            <div class="text-center msg-footer">
                <button class="btn btn-primary w-100">{{ __('View All Notifications')}}</button>
            </div>
        </a>
    </div>
</li>
                            
                        </ul>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Notification item click handler
    document.querySelectorAll('.notification-item').forEach(function(item) {
        item.addEventListener('click', function(e) {
            e.preventDefault();
            
            const notificationId = this.dataset.id;
            const notificationLink = this.dataset.link;
            
            // Mark as read
            if (notificationId) {
                fetch(`/mark-notification-read/${notificationId}`, {
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                        'Content-Type': 'application/json',
                    }
                }).then(response => {
                    if (response.ok) {
                        // Update UI - remove "New" badge and bold text
                        this.querySelector('.badge')?.remove();
                        this.querySelector('.notification-title')?.classList.remove('fw-bold');
                        this.style.borderLeft = '3px solid transparent';
                        
                        // Update notification count
                        const countElement = document.querySelector('.alert-count');
                        if (countElement) {
                            let currentCount = parseInt(countElement.textContent) || 0;
                            if (currentCount > 0) {
                                countElement.textContent = currentCount - 1;
                                if (currentCount - 1 === 0) {
                                    countElement.style.display = 'none';
                                }
                            }
                        }
                    }
                }).catch(error => {
                    console.error('Error marking notification as read:', error);
                });
            }
            
            // Navigate to link if exists
            if (notificationLink && notificationLink !== '#') {
                // Close dropdown first
                const dropdown = bootstrap.Dropdown.getInstance(document.querySelector('[data-bs-toggle="dropdown"]'));
                if (dropdown) {
                    dropdown.hide();
                }
                
                // Navigate after a short delay
                setTimeout(() => {
                    window.location.href = notificationLink;
                }, 100);
            }
        });
    });
});
</script>
                                            

                   
                    </div>
                    <div class="user-box dropdown px-3">
                        <a class="d-flex align-items-center nav-link dropdown-toggle gap-3 dropdown-toggle-nocaret" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            <img src="/assets/images/avatars/{{ $user->user_avatar }}" class="user-img" alt="{{ $user->account_holder }}">
                            <div class="user-info">
                                <p class="user-name mb-0">{{ $user->account_holder }}</p>
                                <p class="designattion mb-0">   @if ($user->membership_type == 1)
        {{__('Admin')}}
    @elseif ($user->membership_type == 2)
    {{__('User')}}
    @elseif ($user->membership_type == 3)
    {{__('Advertiser')}}
    @else
    {{__('Undefined Role')}} 
    @endif</p>
                            </div>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end">
                        <li><a class="dropdown-item d-flex align-items-center" href="{{ route('task.index') }}"><i class="bx bx-home-circle fs-5"></i><span>{{__('Dashboard')}}</span></a>
                            </li>   
                        <li><a class="dropdown-item d-flex align-items-center" href="{{ route('user.profile') }}"><i class="bx bx-user fs-5"></i><span>{{__('Profile')}}</span></a>
                            </li>
                            @if ($user->membership_type == 1)
                            <li><a class="dropdown-item d-flex align-items-center" href="{{ route('settings.index') }}"><i class="bx bx-cog fs-5"></i><span>{{__('Settings')}}</span></a>
                            </li>
                            @endif
                            @if ($user->membership_type == 2)
                            <li><a class="dropdown-item d-flex align-items-center" href="{{ route('profit.user') }}"><i class="bx bx-trending-up fs-5"></i><span>{{__('My Earnings')}}</span></a>
                            </li>
                            @endif
                            @if ($user->membership_type == 1)
                            <li><a class="dropdown-item d-flex align-items-center" href="{{ route('profit.admin') }}"><i class="bx bx-bar-chart-alt-2 fs-5"></i><span>{{__('Earnings')}}</span></a>
                        </li>
                            @endif
                            <li>
                                <div class="dropdown-divider mb-0"></div>
                            </li>
                            <li>
                            <form action="{{ route('logout') }}" method="POST">
    @csrf
    <button type="submit" class="dropdown-item d-flex align-items-center"><i class="bx bx-log-out-circle"></i><span>{{ __("Logout")}}</span></button>
</form>    
                        
                            </li>
                        </ul>
                    </div>
                </nav>
            </div>
        </header>
    </div>
    <!-- Page wrapper end -->
