@extends('layouts.app')

@section('style')
    <link href="{{ asset('assets/plugins/notifications/css/lobibox.min.css') }}" rel="stylesheet" />
    <style>
        .member-card {
            transition: all 0.3s ease;
            border: none;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .member-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 20px rgba(0,0,0,0.15);
        }
        .member-avatar {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            object-fit: cover;
        }
        .status-badge {
            font-size: 0.75rem;
            padding: 0.25rem 0.5rem;
        }
        .action-btn {
            width: 35px;
            height: 35px;
            border-radius: 50%;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            margin: 0 2px;
            transition: all 0.3s ease;
            text-align: center;
        }
        .action-btn i {
            margin: 0 auto;
            display: block;
        }
        .action-btn:hover {
            transform: scale(1.1);
        }
        .search-container {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 15px;
            padding: 20px;
            margin-bottom: 20px;
        }
        .pagination-container {
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 10px;
            margin-top: 20px;
        }
        .loading-overlay {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(255,255,255,0.8);
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 1000;
        }
        .members-container {
            position: relative;
            min-height: 400px;
        }
        @media (max-width: 768px) {
            .member-card .row {
                text-align: center;
            }
            .action-buttons {
                justify-content: center;
                margin-top: 10px;
            }
        }
    </style>
@endsection

@section('wrapper')
<div class="page-wrapper">
    <div class="page-content">
        <!-- Breadcrumb -->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">{{ __('Members') }}</div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="{{ url('/home') }}"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{ __('All Members') }}</li>
                    </ol>
                </nav>
            </div>
        </div>

        <!-- Search Container -->
        <div class="search-container">
            <div class="row align-items-center">
                <div class="col-md-8">
                    <div class="input-group">
                        <span class="input-group-text bg-white border-0"><i class="bx bx-search text-primary"></i></span>
                        <input type="text" id="searchInput" class="form-control border-0" placeholder="{{ __('Search by name, username, email, phone...') }}" autocomplete="off">
                    </div>
                </div>
                <div class="col-md-4 text-end">
                    <div class="d-flex align-items-center justify-content-end gap-2">
                        <span class="text-white">{{ __('Total Members') }}: <strong id="totalMembers">0</strong></span>
                        <button class="btn btn-light btn-sm" onclick="refreshMembers()">
                            <i class="bx bx-refresh"></i>
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Members Container -->
        <div class="members-container">
            <div class="loading-overlay d-none" id="loadingOverlay">
                <div class="spinner-border text-primary" role="status">
                    <span class="visually-hidden">{{ __('Loading...') }}</span>
                </div>
            </div>
            
            <div id="membersContainer">
                <!-- Members will be loaded here via AJAX -->
            </div>

            <!-- Pagination -->
            <div class="pagination-container" id="paginationContainer">
                <!-- Pagination will be loaded here -->
            </div>
        </div>
    </div>
</div>

<!-- Member Details Offcanvas -->
<div class="offcanvas offcanvas-end" tabindex="-1" id="memberDetailsOffcanvas" aria-labelledby="memberDetailsOffcanvasLabel">
    <div class="offcanvas-header">
        <h5 class="offcanvas-title" id="memberDetailsOffcanvasLabel">{{ __('Member Details') }}</h5>
        <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body">
        <div id="memberDetailsContent">
            <!-- Member details will be loaded here -->
        </div>
    </div>
</div>

<!-- Ban Modal -->
<div class="modal fade" id="banModal" tabindex="-1" aria-labelledby="banModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-warning text-white">
                <h5 class="modal-title" id="banModalLabel">
                    <i class="bx bx-block me-2"></i>{{ __("Ban Account") }}
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="alert alert-warning">
                    <i class="bx bx-info-circle me-2"></i>
                    {{ __('This action will ban the user account. Please provide a reason.') }}
                </div>
                <form id="banForm">
                    <div class="mb-3">
                        <label for="banReason" class="form-label">{{ __("Reason for banning") }}</label>
                        <textarea class="form-control" id="banReason" rows="3" required placeholder="{{ __('Enter the reason for banning this account...') }}"></textarea>
                    </div>
                    <input type="hidden" id="banUserId">
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __("Cancel") }}</button>
                <button type="button" class="btn btn-warning" onclick="confirmBan()">
                    <i class="bx bx-block me-1"></i>{{ __("Ban Account") }}
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Delete Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-danger text-white">
                <h5 class="modal-title" id="deleteModalLabel">
                    <i class="bx bx-trash me-2"></i>{{ __("Delete Account") }}
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="alert alert-danger">
                    <i class="bx bx-error me-2"></i>
                    {{ __('This action cannot be undone. Please provide a reason for deletion.') }}
                </div>
                <form id="deleteForm">
                    <div class="mb-3">
                        <label for="deleteReason" class="form-label">{{ __("Reason for deletion") }}</label>
                        <textarea class="form-control" id="deleteReason" rows="3" required placeholder="{{ __('Enter the reason for deleting this account...') }}"></textarea>
                    </div>
                    <input type="hidden" id="deleteUserId">
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __("Cancel") }}</button>
                <button type="button" class="btn btn-danger" onclick="confirmDelete()">
                    <i class="bx bx-trash me-1"></i>{{ __("Delete Account") }}
                </button>
            </div>
        </div>
    </div>
</div>

@endsection

@section('script')
<script src="{{ asset('assets/plugins/notifications/js/lobibox.min.js') }}"></script>
<script>
let currentPage = 1;
let searchTimeout;
let isLoading = false;

$(document).ready(function() {
    loadMembers();
    
    // Search functionality with debounce
    $('#searchInput').on('input', function() {
        clearTimeout(searchTimeout);
        searchTimeout = setTimeout(function() {
            currentPage = 1;
            loadMembers();
        }, 500);
    });
    
    // Prevent pagination links from navigating
    $(document).on('click', '.pagination .page-link', function(e) {
        e.preventDefault();
        e.stopPropagation();
        return false;
    });
});

function loadMembers(page = 1) {
    if (isLoading) return;
    
    isLoading = true;
    showLoading(true);
    
    const search = $('#searchInput').val();
    
    $.ajax({
        url: '{{ route("members.ajax") }}',
        type: 'GET',
        data: {
            search: search,
            page: page,
            per_page: 12
        },
        success: function(response) {
            if (response.success) {
                renderMembers(response.data);
                renderPagination(response.pagination);
                $('#totalMembers').text(response.pagination.total);
                currentPage = page;
            } else {
                showError('{{ __("Failed to load members") }}');
            }
        },
        error: function() {
            showError('{{ __("An error occurred while loading members") }}');
        },
        complete: function() {
            isLoading = false;
            showLoading(false);
        }
    });
}

function renderMembers(members) {
    let html = '<div class="row">';
    
    if (members.length === 0) {
        html += '<div class="col-12 text-center py-5">';
        html += '<i class="bx bx-user-x display-1 text-muted"></i>';
        html += '<h4 class="text-muted mt-3">{{ __("No members found") }}</h4>';
        html += '</div>';
    } else {
        members.forEach(function(member) {
            html += renderMemberCard(member);
        });
    }
    
    html += '</div>';
    $('#membersContainer').html(html);
}

function renderMemberCard(member) {
    const statusClass = member.deleted ? 'bg-danger' : (member.banned ? 'bg-warning' : 'bg-success');
    const statusText = member.deleted ? '{{ __("Deleted") }}' : (member.banned ? '{{ __("Banned") }}' : '{{ __("Active") }}');
    const verifiedClass = member.phone_verified == 1 ? 'bg-success' : 'bg-danger';
    const verifiedText = member.phone_verified == 1 ? '{{ __("Verified") }}' : '{{ __("Not Verified") }}';
    const genderClass = member.gender === 'male' ? 'bg-primary' : 'bg-danger';
    const genderText = member.gender === 'male' ? '{{ __("Male") }}' : '{{ __("Female") }}';
    
    return `
        <div class="col-xl-4 col-lg-6 col-md-6 col-sm-12 mb-3">
            <div class="card member-card h-100">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col-auto">
                            <img src="{{ asset('assets/images/avatars/avatar-1.png') }}" alt="Avatar" class="member-avatar">
                        </div>
                        <div class="col">
                            <h6 class="mb-1 fw-bold">${member.account_holder || 'N/A'}</h6>
                            <p class="mb-0 text-muted small">#${member.username}</p>
                            <p class="mb-0 text-muted small">${member.email}</p>
                        </div>
                    </div>
                    
                    <hr class="my-3">
                    
                    <div class="row g-2 mb-3">
                        <div class="col-6">
                            <small class="text-muted">{{ __('Location') }}</small>
                            <p class="mb-0 small">${member.CountryName || 'N/A'}/${member.CityName || 'N/A'}</p>
                        </div>
                        <div class="col-6">
                            <small class="text-muted">{{ __('Phone') }}</small>
                            <p class="mb-0 small">
                                ${member.phone ? `<a href="https://wa.me/${member.phone}" target="_blank" class="text-success"><i class="bx bxl-whatsapp"></i> ${member.phone}</a>` : 'N/A'}
                            </p>
                        </div>
                    </div>
                    
                    <div class="row g-2 mb-3">
                        <div class="col-4">
                            <span class="badge ${statusClass} status-badge w-100" ${member.deleted || member.banned ? `onclick="showReason('${member.deletion_reason || member.ban_reason || ''}')"` : ''}>${statusText}</span>
                        </div>
                        <div class="col-4">
                            <span class="badge ${verifiedClass} status-badge w-100">${verifiedText}</span>
                        </div>
                        <div class="col-4">
                            <span class="badge ${genderClass} status-badge w-100">${genderText}</span>
                        </div>
                    </div>
                    
                    <div class="d-flex justify-content-center action-buttons">
                        <button class="btn btn-primary action-btn" onclick="showMemberDetails(${member.id})" title="{{ __('View Details') }}">
                            <i class="bx bx-show"></i>
                        </button>
                        ${!member.banned ? `
                        <button class="btn btn-warning action-btn" onclick="banMember(${member.id})" title="{{ __('Ban Member') }}">
                            <i class="bx bx-block"></i>
                        </button>
                        ` : `
                        <button class="btn btn-success action-btn" onclick="unbanMember(${member.id})" title="{{ __('Unban Member') }}">
                            <i class="bx bx-check"></i>
                        </button>
                        `}
                        ${!member.deleted ? `
                        <button class="btn btn-danger action-btn" onclick="deleteMember(${member.id})" title="{{ __('Delete Member') }}">
                            <i class="bx bx-trash"></i>
                        </button>
                        ` : ''}
                    </div>
                </div>
            </div>
        </div>
    `;
}

function renderPagination(pagination) {
    if (pagination.last_page <= 1) {
        $('#paginationContainer').html('');
        return;
    }
    
    let html = '<nav aria-label="Members pagination">';
    html += '<ul class="pagination pagination-sm justify-content-center">';
    
    // Previous button
    if (pagination.current_page > 1) {
        html += `<li class="page-item"><a class="page-link" href="javascript:void(0)" onclick="loadMembers(${pagination.current_page - 1}); return false;">{{ __('Previous') }}</a></li>`;
    }
    
    // Page numbers
    const startPage = Math.max(1, pagination.current_page - 2);
    const endPage = Math.min(pagination.last_page, pagination.current_page + 2);
    
    if (startPage > 1) {
        html += `<li class="page-item"><a class="page-link" href="javascript:void(0)" onclick="loadMembers(1); return false;">1</a></li>`;
        if (startPage > 2) {
            html += '<li class="page-item disabled"><span class="page-link">...</span></li>';
        }
    }
    
    for (let i = startPage; i <= endPage; i++) {
        const activeClass = i === pagination.current_page ? 'active' : '';
        html += `<li class="page-item ${activeClass}"><a class="page-link" href="javascript:void(0)" onclick="loadMembers(${i}); return false;">${i}</a></li>`;
    }
    
    if (endPage < pagination.last_page) {
        if (endPage < pagination.last_page - 1) {
            html += '<li class="page-item disabled"><span class="page-link">...</span></li>';
        }
        html += `<li class="page-item"><a class="page-link" href="javascript:void(0)" onclick="loadMembers(${pagination.last_page}); return false;">${pagination.last_page}</a></li>`;
    }
    
    // Next button
    if (pagination.current_page < pagination.last_page) {
        html += `<li class="page-item"><a class="page-link" href="javascript:void(0)" onclick="loadMembers(${pagination.current_page + 1}); return false;">{{ __('Next') }}</a></li>`;
    }
    
    html += '</ul></nav>';
    $('#paginationContainer').html(html);
}

function showMemberDetails(userId) {
    $.ajax({
        url: '{{ route("members.details", ":id") }}'.replace(':id', userId),
        type: 'GET',
        success: function(response) {
            if (response.success) {
                renderMemberDetails(response.user);
                new bootstrap.Offcanvas(document.getElementById('memberDetailsOffcanvas')).show();
            } else {
                showError('{{ __("Failed to load member details") }}');
            }
        },
        error: function() {
            showError('{{ __("An error occurred while loading member details") }}');
        }
    });
}

function renderMemberDetails(user) {
    const statusClass = user.deleted ? 'bg-danger' : (user.banned ? 'bg-warning' : 'bg-success');
    const statusText = user.deleted ? '{{ __("Deleted") }}' : (user.banned ? '{{ __("Banned") }}' : '{{ __("Active") }}');
    
    const html = `
        <div class="text-center mb-4">
            <img src="{{ asset('assets/images/avatars/avatar-1.png') }}" alt="Avatar" class="rounded-circle" style="width: 80px; height: 80px;">
            <h5 class="mt-2 mb-1">${user.account_holder || 'N/A'}</h5>
            <span class="badge ${statusClass}">${statusText}</span>
        </div>
        
        <div class="row g-3">
            <div class="col-12">
                <label class="form-label fw-bold">{{ __('Username') }}</label>
                <p class="form-control-plaintext">#${user.username}</p>
            </div>
            <div class="col-12">
                <label class="form-label fw-bold">{{ __('Email') }}</label>
                <p class="form-control-plaintext">${user.email}</p>
            </div>
            <div class="col-12">
                <label class="form-label fw-bold">{{ __('Phone') }}</label>
                <p class="form-control-plaintext">
                    ${user.phone ? `<a href="https://wa.me/${user.phone}" target="_blank" class="text-success"><i class="bx bxl-whatsapp"></i> ${user.phone}</a>` : 'N/A'}
                </p>
            </div>
            <div class="col-6">
                <label class="form-label fw-bold">{{ __('Country') }}</label>
                <p class="form-control-plaintext">${user.CountryName || 'N/A'}</p>
            </div>
            <div class="col-6">
                <label class="form-label fw-bold">{{ __('City') }}</label>
                <p class="form-control-plaintext">${user.CityName || 'N/A'}</p>
            </div>
            <div class="col-6">
                <label class="form-label fw-bold">{{ __('Gender') }}</label>
                <p class="form-control-plaintext">${user.gender === 'male' ? '{{ __("Male") }}' : '{{ __("Female") }}'}</p>
            </div>
            <div class="col-6">
                <label class="form-label fw-bold">{{ __('Phone Verified') }}</label>
                <p class="form-control-plaintext">
                    <span class="badge ${user.phone_verified == 1 ? 'bg-success' : 'bg-danger'}">
                        ${user.phone_verified == 1 ? '{{ __("Verified") }}' : '{{ __("Not Verified") }}'}
                    </span>
                </p>
            </div>
            <div class="col-12">
                <label class="form-label fw-bold">{{ __('Balance') }}</label>
                <p class="form-control-plaintext">${user.balance || '0'} TL</p>
            </div>
            ${user.ban_reason ? `
            <div class="col-12">
                <label class="form-label fw-bold text-warning">{{ __('Ban Reason') }}</label>
                <p class="form-control-plaintext text-warning">${user.ban_reason}</p>
            </div>
            ` : ''}
            ${user.deletion_reason ? `
            <div class="col-12">
                <label class="form-label fw-bold text-danger">{{ __('Deletion Reason') }}</label>
                <p class="form-control-plaintext text-danger">${user.deletion_reason}</p>
            </div>
            ` : ''}
        </div>
    `;
    
    $('#memberDetailsContent').html(html);
}

function banMember(userId) {
    $('#banUserId').val(userId);
    $('#banReason').val('');
    new bootstrap.Modal(document.getElementById('banModal')).show();
}

function confirmBan() {
    const userId = $('#banUserId').val();
    const reason = $('#banReason').val().trim();
    
    if (!reason) {
        showError('{{ __("Please provide a reason for banning") }}');
        return;
    }
    
    $.ajax({
        url: '{{ route("banned_member") }}',
        type: 'POST',
        data: {
            _token: '{{ csrf_token() }}',
            id: userId,
            reason: reason
        },
        success: function(response) {
            bootstrap.Modal.getInstance(document.getElementById('banModal')).hide();
            if (response.success) {
                showSuccess('{{ __("Member has been banned successfully") }}');
                loadMembers(currentPage);
            } else {
                showError('{{ __("Failed to ban member") }}');
            }
        },
        error: function() {
            bootstrap.Modal.getInstance(document.getElementById('banModal')).hide();
            showError('{{ __("An error occurred while banning member") }}');
        }
    });
}

function unbanMember(userId) {
    $.ajax({
        url: '{{ route("members.unban", ":id") }}'.replace(':id', userId),
        type: 'POST',
        data: {
            _token: '{{ csrf_token() }}'
        },
        success: function(response) {
            if (response.success) {
                showSuccess('{{ __("Member has been unbanned successfully") }}');
                loadMembers(currentPage);
            } else {
                showError('{{ __("Failed to unban member") }}');
            }
        },
        error: function() {
            showError('{{ __("An error occurred while unbanning member") }}');
        }
    });
}

function deleteMember(userId) {
    $('#deleteUserId').val(userId);
    $('#deleteReason').val('');
    new bootstrap.Modal(document.getElementById('deleteModal')).show();
}

function confirmDelete() {
    const userId = $('#deleteUserId').val();
    const reason = $('#deleteReason').val().trim();
    
    if (!reason) {
        showError('{{ __("Please provide a reason for deletion") }}');
        return;
    }
    
    $.ajax({
        url: '{{ route("delete_member") }}',
        type: 'POST',
        data: {
            _token: '{{ csrf_token() }}',
            id: userId,
            reason: reason
        },
        success: function(response) {
            bootstrap.Modal.getInstance(document.getElementById('deleteModal')).hide();
            if (response.success) {
                showSuccess('{{ __("Member has been deleted successfully") }}');
                loadMembers(currentPage);
            } else {
                showError('{{ __("Failed to delete member") }}');
            }
        },
        error: function() {
            bootstrap.Modal.getInstance(document.getElementById('deleteModal')).hide();
            showError('{{ __("An error occurred while deleting member") }}');
        }
    });
}

function showReason(reason) {
    if (reason) {
        Lobibox.alert('info', {
            msg: reason,
            title: '{{ __("Reason") }}'
        });
    }
}

function refreshMembers() {
    $('#searchInput').val('');
    currentPage = 1;
    loadMembers();
}

function showLoading(show) {
    if (show) {
        $('#loadingOverlay').removeClass('d-none');
    } else {
        $('#loadingOverlay').addClass('d-none');
    }
}

function showSuccess(message) {
    Lobibox.notify('success', {
        pauseDelayOnHover: true,
        size: 'mini',
        rounded: true,
        delayIndicator: false,
        continueDelayOnInactiveTab: false,
        position: 'top right',
        msg: message
    });
}

function showError(message) {
    Lobibox.notify('error', {
        pauseDelayOnHover: true,
        size: 'mini',
        rounded: true,
        delayIndicator: false,
        continueDelayOnInactiveTab: false,
        position: 'top right',
        msg: message
    });
}
</script>
@endsection