@push('styles')
<style>
.product-card {
    transition: transform 0.2s ease, box-shadow 0.2s ease;
    border: none;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.product-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 16px rgba(0,0,0,0.15);
}

.card-img-top {
    transition: transform 0.2s ease;
}

.product-card:hover .card-img-top {
    transform: scale(1.05);
}

.card-title {
    font-size: 1.1rem;
    font-weight: 600;
    color: #2c3e50;
}

.card-text {
    color: #6c757d;
    line-height: 1.5;
}

@media (max-width: 768px) {
    .col-lg-4.col-md-6 {
        margin-bottom: 1.5rem;
    }
}
</style>
    
@endpush
@extends('layouts.app')

@section('wrapper')
<div class="page-wrapper">
    <div class="page-content">
        <!-- Header -->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">{{__('Products')}}</div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="{{ url('/home') }}"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{__('Products')}}</li>
                    </ol>
                </nav>
            </div>
        </div>

        <!-- Search and Filters -->
        <div class="card mb-4">
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <form id="searchForm">
                            <div class="input-group">
                                <input type="text" class="form-control" id="searchInput" placeholder="{{__('Search products...')}}">
                                <button class="btn btn-primary" type="submit">
                                    <i class="bx bx-search"></i>
                                </button>
                            </div>
                        </form>
                    </div>
                    <div class="col-md-3">
                        <select class="form-select" id="categoryFilter">
                            <option value="">{{__('All Categories')}}</option>
                            @foreach($categories as $category)
                            <option value="{{ $category->id }}">{{ $category->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-3">
                        <select class="form-select" id="priceFilter">
                            <option value="">{{__('All Prices')}}</option>
                            <option value="low">{{__('Under 50₺')}}</option>
                            <option value="medium">{{__('50₺ - 200₺')}}</option>
                            <option value="high">{{__('Over 200₺')}}</option>
                        </select>
                    </div>
                </div>
            </div>
        </div>

        <!-- Products Grid -->
        <div class="card">
            <div class="card-body">
                <div id="productsContainer" class="row">
                    <!-- Products will be loaded here via Ajax -->
                </div>
                
                <!-- Load More Button -->
                <div class="text-center mt-4" id="loadMoreContainer" style="display: none;">
                    <button class="btn btn-outline-primary" id="loadMoreBtn" onclick="loadMoreProducts()">
                        <i class="bx bx-loader-alt bx-spin d-none" id="loadMoreSpinner"></i>
                        {{__('Load More Products')}}
                    </button>
                </div>
                
                <!-- Empty State -->
                <div id="emptyState" class="col-12 text-center py-5" style="display: none;">
                    <i class="bx bx-package display-1 text-muted"></i>
                    <h5 class="mt-3">{{__('No products found')}}</h5>
                    <p class="text-muted">{{__('Try adjusting your search or filter criteria.')}}</p>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('script')
<script>
    const productShowUrlTemplate = "{{ route('products.show.user', ['id' => '__ID__']) }}";
</script>
<script>
let currentPage = 1;
let hasMoreProducts = true;
let isLoading = false;

$(document).ready(function() {
    loadProducts();
    
    // Filter change handlers
    $('#categoryFilter, #priceFilter').on('change', function() {
        refreshProducts();
    });
    
    // Search form submission
    $('#searchForm').on('submit', function(e) {
        e.preventDefault();
        refreshProducts();
    });
});

function loadProducts(reset = false) {
    if (isLoading) return;
    
    if (reset) {
        currentPage = 1;
        hasMoreProducts = true;
        $('#productsContainer').empty();
    }
    
    isLoading = true;
    $('#loadMoreSpinner').removeClass('d-none');
    $('#loadMoreBtn').prop('disabled', true);
    
    const formData = {
        page: currentPage,
        category_id: $('#categoryFilter').val(),
        price_range: $('#priceFilter').val(),
        search: $('#searchInput').val()
    };
    
    $.ajax({
        url: '{{ route('api.products') }}',
        method: 'GET',
        data: formData,
        success: function(response) {
            if (response.success) {
                if (response.products.length > 0) {
                    response.products.forEach(function(product) {
                        const productCard = createProductCard(product);
                        $('#productsContainer').append(productCard);
                    });
                    
                    hasMoreProducts = response.has_more;
                    currentPage = response.current_page + 1;
                    
                    $('#loadMoreContainer').toggle(hasMoreProducts);
                    $('#emptyState').hide();
                } else if (currentPage === 1) {
                    $('#emptyState').show();
                    $('#loadMoreContainer').hide();
                }
            }
        },
        error: function() {
            Lobibox.notify('error', {
                title: '{{__('Error')}}',
                msg: '{{__('Error loading products')}}',
                sound: false
            });
        },
        complete: function() {
            isLoading = false;
            $('#loadMoreSpinner').addClass('d-none');
            $('#loadMoreBtn').prop('disabled', false);
        }
    });
}

function createProductCard(product) {
    const imageUrl      = product.image_url || '/assets/images/products/placeholder.png';
    const categoryName  = product.category ? product.category.name : "{{ __('No Category') }}";
    // placehold ’__ID__’ yerine gerçek ID’yi koyuyoruz
    const detailUrl     = productShowUrlTemplate.replace('__ID__', product.id);

    return `
        <div class="col-lg-4 col-md-6 mb-4">
            <div class="card product-card h-100">
                <img src="${imageUrl}" class="card-img-top"
                     alt="${product.product_name}"
                     style="height:200px; object-fit:cover;">
                <div class="card-body d-flex flex-column">
                    <h5 class="card-title">${product.product_name}</h5>
                    <p class="card-text">
                        ${product.description.substring(0,100)}${product.description.length>100?'…':''}
                    </p>
                    <div class="mt-auto">
                        <div class="d-flex justify-content-between align-items-center mb-2">
                            <span class="h5 text-primary mb-0">${product.formatted_price}</span>
                            <small class="text-muted">${categoryName}</small>
                        </div>
                        <div class="d-flex justify-content-between align-items-center mb-2">
                            <span class="badge bg-${product.stock_badge}">
                                ${product.stock_status}
                            </span>
                            ${product.is_digital?`<span class="badge bg-info">{{ __('Digital') }}</span>`:''}
                        </div>
                        <a href="${detailUrl}" class="btn btn-primary w-100">
                            <i class="bx bx-shopping-bag me-2"></i>{{ __('View Details') }}
                        </a>
                    </div>
                </div>
            </div>
        </div>
    `;
}

function refreshProducts() {
    loadProducts(true);
}

function loadMoreProducts() {
    if (hasMoreProducts && !isLoading) {
        loadProducts();
    }
}
</script>
@endsection

