@extends('layouts.app')

@section('style')
    <link href="{{ asset('assets/plugins/notifications/css/lobibox.min.css') }}" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
@endsection

@section('wrapper')
<div class="page-wrapper">
    <div class="page-content">
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">{{ __('Products') }}</div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="{{ url('/home') }}"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{ __('All Products') }}</li>
                    </ol>
                </nav>
            </div>
            <div class="ms-auto">
                <button type="button" class="btn btn-primary" id="add-product-btn" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-original-title="{{__('Add Product')}}">
                    <i class="bx bx-plus"></i> {{ __('Add Product') }}
                </button>
            </div>
        </div>

        <div class="table-responsive">
            <div class="card radius-10">
                <div class="card-body">
                    <form action="{{ route('products.index') }}" method="GET">
                        <div class="input-group mb-3">
                            <input type="text" name="search" class="form-control" placeholder="{{ __('Search products...') }}" value="{{ request('search') }}">
                            <button class="btn btn-outline-secondary" type="submit">{{ __('Search') }}</button>
                        </div>
                    </form>
                    <div class="table-responsive">
                        <table class="table align-middle mb-0">
                            <thead class="table-light">
                                <tr>
                                    <th>{{ __('Category Name') }}</th>
                                    <th>{{ __('Product Name') }}</th>
                                    <th>{{ __('Product Photo') }}</th>
                                    <th>{{ __('Price') }}</th>
                                    <th>{{ __('Stock') }}</th>
                                    <th>{{ __('Status') }}</th>
                                    <th>{{ __('Created At') }}</th>
                                    <th>{{ __('Updated At') }}</th>
                                    <th>{{ __('Actions') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($products as $product)
                                <tr>
                                    <td>{{ $product->category->name }}</td>
                                    <td>{{ $product->product_name }}</td>
                                    <td><img src="{{ $product->image_url }}" alt="{{ $product->product_name }}" width="100"></td>
                                    <td>{{ $product->price }}</td>
                                    <td>{{ $product->min_quantity }} - {{ $product->max_quantity }}</td>
                                    <td>
                                        <div class="{{ $product->status == 1 ? 'btn btn-success' : 'btn btn-danger' }}">
                                            {{ $product->status == 1 ? __('Active') : __('Deactive') }}
                                        </div>
                                    </td>
                                    <td>{{ $product->created_at->diffForHumans() }}</td>
                                    <td>{{ $product->updated_at->diffForHumans() }}</td>
                                    <td>
                                        <div class="d-flex order-actions">
                                            <a href="javascript:;" class="edit-product-btn" data-id="{{ $product->id }}" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-original-title="{{__('Edit Product')}}"><i class='bx bxs-edit'></i></a>
                                            <a href="javascript:;" class="ms-3 btn btn-danger delete-product-btn" data-id="{{ $product->id }}" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-original-title="{{__('Delete Product')}}"><i class='bx bxs-trash'></i></a>
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <div class="d-flex justify-content-center">
                        {{ $products->links('pagination::bootstrap-5') }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Offcanvas for Product Editing/Adding -->
<div class="offcanvas offcanvas-end" tabindex="-1" id="productOffcanvas" aria-labelledby="productOffcanvasLabel">
    <div class="offcanvas-header">
        <h5 class="offcanvas-title" id="productOffcanvasLabel">{{ __('Edit Product') }}</h5>
        <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body">
        <!-- Product form will be loaded via AJAX -->
    </div>
</div>

@section('script')
<script src="{{ asset('assets/plugins/notifications/js/lobibox.min.js') }}"></script>
<script src="{{ asset('assets/plugins/notifications/js/notifications.min.js') }}"></script>
<script>
    // Load product form for editing
    $(document).on('click', '.edit-product-btn', function() {
        var productId = $(this).data('id');
        $('#productOffcanvasLabel').text('{{ __("Edit Product") }}');
        $.ajax({
            url: '/products/' + productId + '/edit',
            method: 'GET',
            success: function(response) {
                $('#productOffcanvas .offcanvas-body').html(response.html);
                $('#productOffcanvas').offcanvas('show');
            },
            error: function() {
                Lobibox.notify('error', {
                    size: 'mini',
                    msg: '{{ __("An error occurred while loading the product.") }}'
                });
            }
        });
    });

    // Load product form for adding
    $('#add-product-btn').on('click', function() {
        $('#productOffcanvasLabel').text('{{ __("Add Product") }}');
        $.ajax({
            url: '/products/create',
            method: 'GET',
            success: function(response) {
                $('#productOffcanvas .offcanvas-body').html(response.html);
                $('#productOffcanvas').offcanvas('show');
            },
            error: function() {
                Lobibox.notify('error', {
                    size: 'mini',
                    msg: '{{ __("An error occurred while loading the form.") }}'
                });
            }
        });
    });

    // Handle form submission for add/edit
    $(document).on('submit', '#productForm', function(e) {
        e.preventDefault();
        var form = $(this);
        var formData = new FormData(this);

        $.ajax({
            url: form.attr('action'),
            method: form.attr('method'),
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                if (response.success) {
                    Lobibox.notify('success', {
                        size: 'mini',
                        msg: response.message
                    });
                    $('#productOffcanvas').offcanvas('hide');
                    location.reload();
                } else {
                    Lobibox.notify('error', {
                        size: 'mini',
                        msg: response.message
                    });
                }
            },
            error: function() {
                Lobibox.notify('error', {
                    size: 'mini',
                    msg: '{{ __("An error occurred, please try again.") }}'
                });
            }
        });
    });

    // Handle product deletion
    $(document).on('click', '.delete-product-btn', function() {
        var productId = $(this).data('id');
        Swal.fire({
            title: '{{ __("Are you sure?") }}',
            text: '{{ __("You won\'t be able to revert this!") }}',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: '{{ __("Yes, delete it!") }}',
            cancelButtonText: '{{ __("Cancel") }}'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: '{{ route("products.destroy", ":id") }}'.replace(':id', productId),
                    type: 'DELETE',
                    data: {
                        _token: '{{ csrf_token() }}'
                    },
                    success: function(response) {
                        if (response.success) {
                            Lobibox.notify('success', {
                                size: 'mini',
                                msg: '{{ __("Product has been deleted.") }}'
                            });
                            location.reload();
                        } else {
                            Lobibox.notify('error', {
                                size: 'mini',
                                msg: '{{ __("An error occurred, please try again.") }}'
                            });
                        }
                    },
                    error: function() {
                        Lobibox.notify('error', {
                            size: 'mini',
                            msg: '{{ __("An error occurred, please try again.") }}'
                        });
                    }
                });
            }
        });
    });
</script>
@endsection
@endsection
