<form id="productForm" action="{{ isset($product) ? route('products.update', $product->id) : route('products.store') }}" method="POST">
    @csrf
    @if(isset($product))
        @method('POST')
    @endif
    <div class="mb-3">
        <label for="product_name" class="form-label">{{ __('Product Name') }}</label>
        <input type="text" class="form-control" id="product_name" name="product_name" value="{{ $product->product_name ?? '' }}" required>
    </div>
    <div class="mb-3">
        <label for="description" class="form-label">{{ __('Description') }}</label>
        <textarea class="form-control" id="description" name="description" rows="3" required>{{ $product->description ?? '' }}</textarea>
    </div>
    <div class="mb-3">
        <label for="price" class="form-label">{{ __('Price') }}</label>
        <input type="number" step="0.01" class="form-control" id="price" name="price" value="{{ $product->price ?? '' }}" required>
    </div>
    <div class="mb-3">
        <label for="image_url" class="form-label">{{ __('Image URL') }}</label>
        <input type="text" class="form-control" id="image_url" name="image_url" value="{{ $product->image_url ?? '' }}" required>
    </div>
    <div class="mb-3">
        <label for="min_quantity" class="form-label">{{ __('Min Quantity') }}</label>
        <input type="number" class="form-control" id="min_quantity" name="min_quantity" value="{{ $product->min_quantity ?? '' }}" required>
    </div>
    <div class="mb-3">
        <label for="max_quantity" class="form-label">{{ __('Max Quantity') }}</label>
        <input type="number" class="form-control" id="max_quantity" name="max_quantity" value="{{ $product->max_quantity ?? '' }}" required>
    </div>
    <div class="mb-3">
        <label for="status" class="form-label">{{ __('Status') }}</label>
        <select class="form-control" id="status" name="status" required>
            <option value="1" {{ isset($product) && $product->status == 1 ? 'selected' : '' }}>{{ __('Active') }}</option>
            <option value="0" {{ isset($product) && $product->status == 0 ? 'selected' : '' }}>{{ __('Inactive') }}</option>
        </select>
    </div>
    <button type="submit" class="btn btn-primary">{{ isset($product) ? __('Update Product') : __('Add Product') }}</button>
</form>
