@extends('layouts.app')

@section('wrapper')
<div class="page-wrapper">
    <div class="page-content">
        <!-- Header -->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">{{__('Earnings Management')}}</div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="{{ url('/home') }}"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{__('Earnings')}}</li>
                    </ol>
                </nav>
            </div>
        </div>

        <!-- Stats Cards -->
        <div class="row">
            <div class="col-12 col-lg-8 col-xl-8 d-flex">
                <div class="card radius-10 w-100">
                    <div class="card-body">
                        <div class="row">
                            <!-- Total Platform Earnings -->
                            <div class="col-6 col-md-3">
                                <div class="text-center">
                                    <div class="widgets-icons-2 rounded-circle bg-gradient-cosmic text-white mx-auto">
                                        <i class='bx bx-trending-up'></i>
                                    </div>
                                    <h4 class="my-2">{{ number_format($stats['total_earnings'], 2) }} {{ app('settings')['currency'] ?? '₺' }}</h4>
                                    <p class="mb-0 text-secondary">{{__('Total Platform Earnings')}}</p>
                                </div>
                            </div>
                            
                            <!-- Active Users -->
                            <div class="col-6 col-md-3">
                                <div class="text-center">
                                    <div class="widgets-icons-2 rounded-circle bg-gradient-ibiza text-white mx-auto">
                                        <i class='bx bx-user-check'></i>
                                    </div>
                                    <h4 class="my-2">{{ number_format($stats['active_users']) }}</h4>
                                    <p class="mb-0 text-secondary">{{__('Active Users')}}</p>
                                </div>
                            </div>
                            
                            <!-- Today's Earnings -->
                            <div class="col-6 col-md-3">
                                <div class="text-center">
                                    <div class="widgets-icons-2 rounded-circle bg-gradient-ohhappiness text-white mx-auto">
                                        <i class='bx bx-calendar-check'></i>
                                    </div>
                                    <h4 class="my-2">{{ number_format($stats['today_earnings'], 2) }} {{ app('settings')['currency'] ?? '₺' }}</h4>
                                    <p class="mb-0 text-secondary">{{__('Today Earnings')}}</p>
                                </div>
                            </div>
                            
                            <!-- Monthly Average -->
                            <div class="col-6 col-md-3">
                                <div class="text-center">
                                    <div class="widgets-icons-2 rounded-circle bg-gradient-moonlit text-white mx-auto">
                                        <i class='bx bx-bar-chart-alt-2'></i>
                                    </div>
                                    <h4 class="my-2">{{ number_format($stats['monthly_average'], 2) }} {{ app('settings')['currency'] ?? '₺' }}</h4>
                                    <p class="mb-0 text-secondary">{{__('Monthly Average')}}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Top Earners -->
            <div class="col-12 col-lg-4 col-xl-4">
                <div class="card radius-10">
                    <div class="card-header">
                        <div class="d-flex align-items-center">
                            <div>
                                <h6 class="mb-0">{{__('Top Earners')}}</h6>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        @foreach($topEarners as $index => $earner)
                        <div class="d-flex align-items-center mb-3">
                            <div class="me-3">
                                <span class="badge bg-primary rounded-pill">{{ $index + 1 }}</span>
                            </div>
                            <div class="flex-grow-1">
                                <h6 class="mb-0">{{ $earner->account_holder }}</h6>
                                <small class="text-muted">{{ number_format($earner->total_earnings, 2) }} {{ app('settings')['currency'] ?? '₺' }}</small>
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>

        <!-- Charts Row -->
        <div class="row">
            <!-- Weekly Earnings Chart -->
            <div class="col-12 col-lg-6">
                <div class="card radius-10">
                    <div class="card-header">
                        <div class="d-flex align-items-center">
                            <div>
                                <h6 class="mb-0">{{__('Weekly Earnings')}}</h6>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <canvas id="weeklyChart" height="300"></canvas>
                    </div>
                </div>
            </div>
            
            <!-- Monthly Earnings Chart -->
            <div class="col-12 col-lg-6">
                <div class="card radius-10">
                    <div class="card-header">
                        <div class="d-flex align-items-center">
                            <div>
                                <h6 class="mb-0">{{__('Monthly Earnings')}}</h6>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <canvas id="monthlyChart" height="300"></canvas>
                    </div>
                </div>
            </div>
        </div>

        <!-- Earnings by Type Chart -->
        <div class="row">
            <div class="col-12 col-lg-8">
                <div class="card radius-10">
                    <div class="card-header">
                        <div class="d-flex align-items-center">
                            <div>
                                <h6 class="mb-0">{{__('Earnings by Task Type')}}</h6>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <canvas id="earningsTypeChart" height="200"></canvas>
                    </div>
                </div>
            </div>
            
            <!-- Earnings Distribution -->
            <div class="col-12 col-lg-4">
                <div class="card radius-10">
                    <div class="card-header">
                        <div class="d-flex align-items-center">
                            <div>
                                <h6 class="mb-0">{{__('Task Distribution')}}</h6>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <canvas id="distributionChart" height="300"></canvas>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Weekly Chart
    const weeklyCtx = document.getElementById('weeklyChart').getContext('2d');
    new Chart(weeklyCtx, {
        type: 'line',
        data: {
            labels: {!! json_encode($weeklyData['labels']) !!},
            datasets: [{
                label: '{{__("Daily Earnings")}}',
                data: {!! json_encode($weeklyData['data']) !!},
                borderColor: 'rgb(75, 192, 192)',
                backgroundColor: 'rgba(75, 192, 192, 0.1)',
                tension: 0.4,
                fill: true
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    display: false
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        callback: function(value) {
                            return value + ' {{ app("settings")["currency"] ?? "₺" }}';
                        }
                    }
                }
            }
        }
    });

    // Monthly Chart
    const monthlyCtx = document.getElementById('monthlyChart').getContext('2d');
    new Chart(monthlyCtx, {
        type: 'bar',
        data: {
            labels: {!! json_encode($monthlyData['labels']) !!},
            datasets: [{
                label: '{{__("Monthly Earnings")}}',
                data: {!! json_encode($monthlyData['data']) !!},
                backgroundColor: 'rgba(54, 162, 235, 0.8)',
                borderColor: 'rgba(54, 162, 235, 1)',
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    display: false
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        callback: function(value) {
                            return value + ' {{ app("settings")["currency"] ?? "₺" }}';
                        }
                    }
                }
            }
        }
    });

    // Earnings by Type Chart
    const typeCtx = document.getElementById('earningsTypeChart').getContext('2d');
    new Chart(typeCtx, {
        type: 'bar',
        data: {
            labels: {!! json_encode($earningsByType['labels']) !!},
            datasets: [{
                label: '{{__("Earnings")}}',
                data: {!! json_encode($earningsByType['data']) !!},
                backgroundColor: [
                    'rgba(255, 99, 132, 0.8)',
                    'rgba(54, 162, 235, 0.8)',
                    'rgba(255, 205, 86, 0.8)',
                    'rgba(75, 192, 192, 0.8)'
                ],
                borderColor: [
                    'rgba(255, 99, 132, 1)',
                    'rgba(54, 162, 235, 1)',
                    'rgba(255, 205, 86, 1)',
                    'rgba(75, 192, 192, 1)'
                ],
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    display: false
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        callback: function(value) {
                            return value + ' {{ app("settings")["currency"] ?? "₺" }}';
                        }
                    }
                }
            }
        }
    });

    // Distribution Chart (Pie)
    const distributionCtx = document.getElementById('distributionChart').getContext('2d');
    new Chart(distributionCtx, {
        type: 'doughnut',
        data: {
            labels: {!! json_encode($earningsByType['labels']) !!},
            datasets: [{
                data: {!! json_encode($earningsByType['data']) !!},
                backgroundColor: [
                    'rgba(255, 99, 132, 0.8)',
                    'rgba(54, 162, 235, 0.8)',
                    'rgba(255, 205, 86, 0.8)',
                    'rgba(75, 192, 192, 0.8)'
                ],
                borderColor: [
                    'rgba(255, 99, 132, 1)',
                    'rgba(54, 162, 235, 1)',
                    'rgba(255, 205, 86, 1)',
                    'rgba(75, 192, 192, 1)'
                ],
                borderWidth: 2
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'bottom'
                }
            }
        }
    });
});
</script>
@endpush
@endsection