@extends('layouts.app')

@section('wrapper')
<div class="page-wrapper">
    <div class="page-content">
        <!-- Header -->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">{{__('My Earnings')}}</div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="{{ url('/home') }}"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{__('My Earnings')}}</li>
                    </ol>
                </nav>
            </div>
        </div>

        <!-- Stats Cards -->
        <div class="row">
            <div class="col-12">
                <div class="card radius-10">
                    <div class="card-body">
                        <div class="row g-3">
                            <!-- Current Balance -->
                            <div class="col-6 col-sm-6 col-md-3">
                                <div class="text-center">
                                    <div class="widgets-icons-2 rounded-circle bg-gradient-cosmic text-white mx-auto">
                                        <i class='bx bx-wallet'></i>
                                    </div>
                                    <h5 class="my-2 fs-6">{{ number_format($stats['current_balance'], 2) }} {{ app('settings')['currency'] ?? '₺' }}</h5>
                                    <p class="mb-0 text-secondary small">{{__('Current Balance')}}</p>
                                </div>
                            </div>
                            
                            <!-- Total Earnings -->
                            <div class="col-6 col-sm-6 col-md-3">
                                <div class="text-center">
                                    <div class="widgets-icons-2 rounded-circle bg-gradient-burning text-white mx-auto">
                                        <i class='bx bx-trending-up'></i>
                                    </div>
                                    <h5 class="my-2 fs-6">{{ number_format($stats['total_earnings'], 2) }} {{ app('settings')['currency'] ?? '₺' }}</h5>
                                    <p class="mb-0 text-secondary small">{{__('Total Earnings')}}</p>
                                </div>
                            </div>
                            
                            <!-- Monthly Earnings -->
                            <div class="col-6 col-sm-6 col-md-3">
                                <div class="text-center">
                                    <div class="widgets-icons-2 rounded-circle bg-gradient-lush text-white mx-auto">
                                        <i class='bx bx-calendar'></i>
                                    </div>
                                    <h5 class="my-2 fs-6">{{ number_format($stats['monthly_earnings'], 2) }} {{ app('settings')['currency'] ?? '₺' }}</h5>
                                    <p class="mb-0 text-secondary small">{{__('This Month')}}</p>
                                </div>
                            </div>
                            
                            <!-- Completed Tasks -->
                            <div class="col-6 col-sm-6 col-md-3">
                                <div class="text-center">
                                    <div class="widgets-icons-2 rounded-circle bg-gradient-kyoto text-white mx-auto">
                                        <i class='bx bx-check-circle'></i>
                                    </div>
                                    <h5 class="my-2 fs-6">{{ number_format($stats['completed_tasks']) }}</h5>
                                    <p class="mb-0 text-secondary small">{{__('Completed Tasks')}}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Quick Stats -->
            <div class="col-12 col-lg-4 col-xl-4 d-flex">
                <div class="card radius-10 w-100">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">{{__('Weekly Earnings')}}</p>
                                <h4 class="my-1">{{ number_format($stats['weekly_earnings'], 2) }} {{ app('settings')['currency'] ?? '₺' }}</h4>
                            </div>
                            <div class="widgets-icons-2 rounded-circle bg-gradient-scooter text-white ms-auto">
                                <i class='bx bx-bar-chart-alt-2'></i>
                            </div>
                        </div>
                        <hr>
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">{{__('Daily Earnings')}}</p>
                                <h4 class="my-1">{{ number_format($stats['daily_earnings'], 2) }} {{ app('settings')['currency'] ?? '₺' }}</h4>
                            </div>
                            <div class="widgets-icons-2 rounded-circle bg-gradient-moonlit text-white ms-auto">
                                <i class='bx bx-time'></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Charts Row -->
        <div class="row">
            <!-- Weekly Earnings Chart -->
            <div class="col-12 col-lg-6">
                <div class="card radius-10">
                    <div class="card-header">
                        <div class="d-flex align-items-center">
                            <div>
                                <h6 class="mb-0">{{__('Weekly Earnings')}}</h6>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <canvas id="weeklyChart" height="300"></canvas>
                    </div>
                </div>
            </div>
            
            <!-- Earnings by Type -->
            <div class="col-12 col-lg-6">
                <div class="card radius-10">
                    <div class="card-header">
                        <div class="d-flex align-items-center">
                            <div>
                                <h6 class="mb-0">{{__('Earnings by Type')}}</h6>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <canvas id="earningsTypeChart" height="300"></canvas>
                    </div>
                </div>
            </div>
        </div>

        <!-- Monthly Earnings Chart -->
        <div class="row">
            <div class="col-12">
                <div class="card radius-10">
                    <div class="card-header">
                        <div class="d-flex align-items-center">
                            <div>
                                <h6 class="mb-0">{{__('Monthly Earnings Trend')}}</h6>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <canvas id="monthlyChart" height="120"></canvas>
                    </div>
                </div>
            </div>
        </div>

        <!-- Recent Earnings Table -->
        <div class="row">
            <div class="col-12">
                <div class="card radius-10">
                    <div class="card-header">
                        <div class="d-flex align-items-center">
                            <div>
                                <h6 class="mb-0">{{__('Recent Earnings')}}</h6>
                            </div>
                            <div class="ms-auto">
                                <select class="form-select form-select-sm" id="periodFilter">
                                    <option value="week">{{__('This Week')}}</option>
                                    <option value="month">{{__('This Month')}}</option>
                                    <option value="year">{{__('This Year')}}</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped table-bordered" id="earningsTable">
                                <thead>
                                    <tr>
                                        <th>{{__('Date')}}</th>
                                        <th>{{__('Task')}}</th>
                                        <th>{{__('Type')}}</th>
                                        <th>{{__('Amount')}}</th>
                                        <th>{{__('Description')}}</th>
                                    </tr>
                                </thead>
                                <tbody id="earningsTableBody">
                                    <!-- AJAX ile yüklenecek -->
                                </tbody>
                            </table>
                        </div>
                        <div id="loadingSpinner" class="text-center py-3" style="display: none;">
                            <div class="spinner-border text-primary" role="status">
                                <span class="visually-hidden">{{__('Loading...')}}</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Weekly Chart
    const weeklyCtx = document.getElementById('weeklyChart').getContext('2d');
    const weeklyChart = new Chart(weeklyCtx, {
        type: 'line',
        data: {
            labels: {!! json_encode($weeklyData['labels']) !!},
            datasets: [{
                label: '{{__("Earnings")}}',
                data: {!! json_encode($weeklyData['data']) !!},
                borderColor: 'rgb(75, 192, 192)',
                backgroundColor: 'rgba(75, 192, 192, 0.2)',
                tension: 0.1,
                fill: true
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });

    // Earnings Type Chart
    const typeCtx = document.getElementById('earningsTypeChart').getContext('2d');
    const typeChart = new Chart(typeCtx, {
        type: 'doughnut',
        data: {
            labels: {!! json_encode($earningsByType['labels']) !!},
            datasets: [{
                data: {!! json_encode($earningsByType['data']) !!},
                backgroundColor: [
                    'rgba(255, 99, 132, 0.8)',
                    'rgba(54, 162, 235, 0.8)',
                    'rgba(255, 205, 86, 0.8)'
                ]
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false
        }
    });

    // Monthly Chart
    const monthlyCtx = document.getElementById('monthlyChart').getContext('2d');
    const monthlyChart = new Chart(monthlyCtx, {
        type: 'bar',
        data: {
            labels: {!! json_encode($monthlyData['labels']) !!},
            datasets: [{
                label: '{{__("Monthly Earnings")}}',
                data: {!! json_encode($monthlyData['data']) !!},
                backgroundColor: 'rgba(54, 162, 235, 0.6)',
                borderColor: 'rgba(54, 162, 235, 1)',
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });

    // Load earnings data
    loadEarningsData('week');

    // Period filter change
    document.getElementById('periodFilter').addEventListener('change', function() {
        loadEarningsData(this.value);
    });

    function loadEarningsData(period) {
        document.getElementById('loadingSpinner').style.display = 'block';
        document.getElementById('earningsTableBody').innerHTML = '';

        fetch(`/api/user-earnings?period=${period}`)
            .then(response => response.json())
            .then(data => {
                document.getElementById('loadingSpinner').style.display = 'none';
                
                if (data.success) {
                    let html = '';
                    data.earnings.data.forEach(earning => {
                        html += `
                            <tr>
                                <td>${new Date(earning.created_at).toLocaleDateString()}</td>
                                <td>${earning.task ? earning.task.task_name : '-'}</td>
                                <td>
                                    <span class="badge bg-${getTypeColor(earning.reference_type)}">
                                        ${getTypeName(earning.reference_type)}
                                    </span>
                                </td>
                                <td class="text-success">+${parseFloat(earning.amount).toFixed(2)} {{ app('settings')['currency'] ?? '₺' }}</td>
                                <td>${earning.description || '-'}</td>
                            </tr>
                        `;
                    });
                    document.getElementById('earningsTableBody').innerHTML = html;
                }
            })
            .catch(error => {
                document.getElementById('loadingSpinner').style.display = 'none';
                console.error('Error:', error);
            });
    }

    function getTypeColor(type) {
        switch(type) {
            case 'social_media': return 'primary';
            case 'website_visit': return 'success';
            case 'youtube_watch': return 'warning';
            default: return 'secondary';
        }
    }

    function getTypeName(type) {
        switch(type) {
            case 'social_media': return '{{__("Social Media")}}';
            case 'website_visit': return '{{__("Website Visit")}}';
            case 'youtube_watch': return '{{__("YouTube Watch")}}';
            default: return '{{__("Other")}}';
        }
    }
});
</script>

<style>
.widgets-icons-2 {
    width: 56px;
    height: 56px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 27px;
}

.card {
    box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
    border: 1px solid rgba(0, 0, 0, 0.125);
}

.table th {
    font-weight: 600;
    background-color: #f8f9fa;
}

@media (max-width: 768px) {
    .widgets-icons-2 {
        width: 48px;
        height: 48px;
        font-size: 20px;
    }
    
    .card-body {
        padding: 1rem;
    }
    
    h4 {
        font-size: 1.1rem;
    }
}
</style>
@endsection