<!doctype html>
<html lang="{{ app()->getLocale() }}" dir="{{ app()->getLocale() == 'ar' ? 'rtl' : 'ltr' }}">

<head>
	<!-- Required meta tags -->
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<!--favicon-->
	<link rel="icon" href="assets/images/favicon-32x32.png" type="image/png" />
	<!--plugins-->
	<link href="assets/plugins/simplebar/css/simplebar.css" rel="stylesheet" />
	<link href="assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet" />
	<link href="assets/plugins/metismenu/css/metisMenu.min.css" rel="stylesheet" />
	<!-- loader-->
	<link href="assets/css/pace.min.css" rel="stylesheet" />
	<script src="assets/js/pace.min.js"></script>
	<!-- Bootstrap CSS -->
	<link href="assets/css/bootstrap.min.css" rel="stylesheet">
	<link href="assets/css/bootstrap-extended.css" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">
	<link href="assets/css/app.css" rel="stylesheet">
	<link href="assets/css/icons.css" rel="stylesheet">
	<meta name="csrf-token" content="{{ csrf_token() }}">
	<title>{{ $settings['title'] }} - {{__("Login Screen")}}</title>
</head>

<body class="">
	<!--wrapper-->
	<div class="wrapper">
		<div class="section-authentication-cover">
			<div class="">
				<div class="row g-0">

					<div class="col-12 col-xl-7 col-xxl-8 auth-cover-left align-items-center justify-content-center d-none d-xl-flex">

                        <div class="card shadow-none bg-transparent shadow-none rounded-0 mb-0">
							<div class="card-body">
                                 <img src="assets/images/login-images/login-cover.svg" class="img-fluid auth-img-cover-login" width="650" alt=""/>
							</div>
						</div>
						
					</div>

					<div class="col-12 col-xl-5 col-xxl-4 auth-cover-right align-items-center justify-content-center">
						<div class="card rounded-0 m-3 shadow-none bg-transparent mb-0">
							<div class="card-body p-sm-5">
								<div class="">
									<div class="mb-3 text-center">
										<img src="assets/images/{{ $settings['logo'] }}" width="150" alt="{{ $settings['title'] }}">
									</div>
									<div class="text-center mb-4">
										<h5 class="">{{ $settings['site_name'] }}</h5>
										<p class="mb-0">{{ __('Please log in to your account')}}</p>
									</div>
									<div class="form-body">
									@if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif
									<form method="POST" action="{{ route('login') }}" class="row g-3">
        @csrf
										
											<div class="col-12">
												<label for="inputEmailAddress" class="form-label">{{ __("Email")}}</label>
												<input type="email" name="email" class="form-control" id="inputEmailAddress" placeholder="{{ __("jhon@example.com")}}">
											</div>
											<div class="col-12">
												<label for="inputChoosePassword" class="form-label">{{ __("Password")}}</label>
												<div class="input-group" id="show_hide_password">
													<input type="password" name="password" class="form-control border-end-0" id="inputChoosePassword" value="" placeholder="{{ __("Enter Password")}}"> <a href="javascript:;" class="input-group-text bg-transparent"><i class="bx bx-hide"></i></a>
												</div>
											</div>
											<div class="col-md-6">
												<div class="form-check form-switch">
													<input class="form-check-input" type="checkbox" name="remember" id="flexSwitchCheckChecked">
													<label class="form-check-label" for="flexSwitchCheckChecked">{{ __("Remember Me")}}</label>
												</div>
											</div>
											<div class="col-md-6 text-end">	<a href="authentication-forgot-password.html">{{ __("Forgot Password ?")}}</a>
											</div>
											<div class="col-12">
												<div class="d-grid">
													<button type="submit" class="btn btn-primary">{{ __("Sign in")}}</button>
												</div>
											</div>
										
										

											</div>
											<div class="col-12">
												<div class="text-center ">
													<p class="mb-0">{{ __("Don't have an account yet?")}} <a href="{{ route('register') }}">{{ __("Sign up here")}}</a>
													</p>
												</div>
											</div>
										</form>
									</div>
									
<hr>
<div class="text-right">
											<div class="mobile-toggle-menu d-block d-lg-none" data-bs-toggle="offcanvas" data-bs-target="#offcanvasNavbar"><i class='bx bx-menu'></i></div>
                   
				   <div class="top-menu ms-auto">
											<ul class="navbar-nav align-items-center gap-1">
                         
						 <li class="nav-item dropdown dropdown-laungauge d-none d-sm-flex">
							 <a class="nav-link dropdown-toggle dropdown-toggle-nocaret" href="avascript:;" data-bs-toggle="dropdown">
							 @php
 $locale = session('locale', 'tr'); 
@endphp

<img src="assets/images/country/{{ in_array($locale, ['en', 'tr', 'ar']) ? $locale : 'tr' }}.png" width="22" alt="">

							 </a>
							 <ul class="dropdown-menu dropdown-menu-end">
<li><a class="dropdown-item d-flex align-items-center py-2" href="{{ route('lang.switch', 'en') }}"><img src="assets/images/country/en.png" width="20" alt=""><span class="ms-2">English</span></a></li>
<li><a class="dropdown-item d-flex align-items-center py-2" href="{{ route('lang.switch', 'tr') }}"><img src="assets/images/country/tr.png" width="20" alt=""><span class="ms-2">Türkçe</span></a></li>
<li><a class="dropdown-item d-flex align-items-center py-2" href="{{ route('lang.switch', 'ar') }}"><img src="assets/images/country/ar.png" width="20" alt=""><span class="ms-2">العربية</span></a></li>

							 </ul>
						 </li>
</ul>
</div></div>
								</div>
							</div>
						</div>
					</div>

				</div>
				<!--end row-->
			</div>
		</div>
	</div>
	<!--end wrapper-->
	<!-- Bootstrap JS -->
	<script src="assets/js/bootstrap.bundle.min.js"></script>
	<!--plugins-->
	<script src="assets/js/jquery.min.js"></script>
	<script src="assets/plugins/simplebar/js/simplebar.min.js"></script>
	<script src="assets/plugins/metismenu/js/metisMenu.min.js"></script>
	<script src="assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
	<!--Password show & hide js -->
	<script>
		$(document).ready(function () {
			$("#show_hide_password a").on('click', function (event) {
				event.preventDefault();
				if ($('#show_hide_password input').attr("type") == "text") {
					$('#show_hide_password input').attr('type', 'password');
					$('#show_hide_password i').addClass("bx-hide");
					$('#show_hide_password i').removeClass("bx-show");
				} else if ($('#show_hide_password input').attr("type") == "password") {
					$('#show_hide_password input').attr('type', 'text');
					$('#show_hide_password i').removeClass("bx-hide");
					$('#show_hide_password i').addClass("bx-show");
				}
			});
		});
	</script>
	<!--app JS-->
	<script src="assets/js/app.js"></script>
</body>

</html>