@extends('layouts.app')

@section('style')
    <link href="{{ asset('assets/plugins/notifications/css/lobibox.min.css') }}" rel="stylesheet" />
    <style>
        .platform-card {
            border: 1px solid #e9ecef;
            border-radius: 12px;
            transition: all 0.3s ease;
            background: white;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        }
        .platform-card:hover {
            box-shadow: 0 8px 25px rgba(0,0,0,0.15);
            transform: translateY(-2px);
        }
        .platform-icon {
            width: 60px;
            height: 60px;
            border-radius: 12px;
            object-fit: cover;
            border: 2px solid #f8f9fa;
        }
        .status-badge {
            font-size: 0.75rem;
            padding: 4px 12px;
            border-radius: 20px;
        }
        .action-buttons {
            display: flex;
            gap: 8px;
            flex-wrap: wrap;
        }
        .action-buttons .btn {
            padding: 6px 12px;
            font-size: 0.8rem;
            border-radius: 8px;
        }
        .search-container {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 12px;
            padding: 25px;
            margin-bottom: 25px;
            color: white;
        }
        .search-input {
            border: 2px solid rgba(255,255,255,0.3);
            border-radius: 12px;
            padding: 12px 16px;
            background: rgba(255,255,255,0.9);
            backdrop-filter: blur(10px);
        }
        .search-input:focus {
            border-color: rgba(255,255,255,0.8);
            background: white;
            box-shadow: 0 4px 15px rgba(0,0,0,0.1);
        }
        .filter-btn {
            border-radius: 12px;
            padding: 12px 20px;
            border: 2px solid rgba(255,255,255,0.3);
            background: rgba(255,255,255,0.1);
            color: white;
            backdrop-filter: blur(10px);
            font-weight: 600;
        }
        .filter-btn:hover {
            background: rgba(255,255,255,0.2);
            border-color: rgba(255,255,255,0.5);
            color: white;
            transform: translateY(-1px);
        }
        .add-platform-btn {
            background: linear-gradient(45deg, #ff6b6b, #ee5a24);
            border: none;
            border-radius: 25px;
            padding: 12px 25px;
            color: white;
            font-weight: 600;
            box-shadow: 0 4px 15px rgba(238, 90, 36, 0.4);
        }
        .add-platform-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(238, 90, 36, 0.6);
            color: white;
        }
        .loading-spinner {
            display: none;
            text-align: center;
            padding: 40px;
        }
        .empty-state {
            text-align: center;
            padding: 60px 20px;
            color: #6c757d;
        }
        .empty-state i {
            font-size: 4rem;
            margin-bottom: 20px;
            opacity: 0.5;
        }
        @media (max-width: 768px) {
            .platform-card {
                margin-bottom: 15px;
            }
            .action-buttons {
                justify-content: center;
                margin-top: 15px;
            }
            .search-container {
                padding: 20px;
                margin-bottom: 20px;
            }
            .platform-icon {
                width: 50px;
                height: 50px;
            }
        }
        .offcanvas-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }
        .offcanvas-header .btn-close {
            filter: invert(1);
        }
        .form-control:focus, .form-select:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
        }
        .icon-preview {
            width: 80px;
            height: 80px;
            border-radius: 12px;
            object-fit: cover;
            border: 2px solid #e9ecef;
            margin-top: 10px;
        }
    </style>
@endsection

@section('wrapper')
<div class="page-wrapper">
    <div class="page-content">
        <!-- Breadcrumb -->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">{{ __('Social Media') }}</div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="{{ url('/home') }}"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{ __('Social Media Platforms') }}</li>
                    </ol>
                </nav>
            </div>
        </div>

        <!-- Search and Filter Container -->
        <div class="search-container">
            <div class="row align-items-center">
                <div class="col-md-6 mb-3 mb-md-0">
                    <h2 class="mb-2 text-white">{{ __('Manage Social Platforms') }}</h2>
                    <p class="mb-0 opacity-75">{{ __('Add, edit and manage social media platforms for tasks') }}</p>
                </div>
                <div class="col-md-6">
                    <div class="d-flex gap-2 justify-content-md-end">
                        <button class="btn add-platform-btn" data-bs-toggle="offcanvas" data-bs-target="#addPlatformOffcanvas">
                            <i class="bx bx-plus me-2"></i>{{ __('Add Platform') }}
                        </button>
                    </div>
                </div>
            </div>
            
            <div class="row mt-4 g-3">
                <div class="col-12">
                    <div class="input-group">
                        <span class="input-group-text bg-white border-end-0">
                            <i class="bx bx-search text-muted"></i>
                        </span>
                        <input type="text" id="searchInput" class="form-control search-input border-start-0" 
                               placeholder="{{ __('Search platforms by name or description...') }}">
                        <button class="btn btn-primary filter-btn" type="button" onclick="searchPlatforms()">
                            {{ __('Search') }}
                        </button>
                    </div>
                </div>
                <div class="col-6 col-md-6">
                    <select id="statusFilter" class="form-select search-input" onchange="searchPlatforms()">
                        <option value="">{{ __('All Status') }}</option>
                        <option value="1">{{ __('Active') }}</option>
                        <option value="0">{{ __('Inactive') }}</option>
                    </select>
                </div>
                <div class="col-6 col-md-6">
                    <select id="perPageSelect" class="form-select search-input" onchange="changePerPage()">
                        <option value="12">12 {{ __('per page') }}</option>
                        <option value="24">24 {{ __('per page') }}</option>
                        <option value="48">48 {{ __('per page') }}</option>
                    </select>
                </div>
            </div>
        </div>

        <!-- Loading Spinner -->
        <div class="loading-spinner" id="loadingSpinner">
            <div class="spinner-border text-primary" role="status" style="width: 3rem; height: 3rem;">
                <span class="visually-hidden">{{ __('Loading...') }}</span>
            </div>
            <p class="mt-3">{{ __('Loading platforms...') }}</p>
        </div>

        <!-- Platforms Container -->
        <div id="platformsContainer">
            <!-- Platforms will be loaded here via AJAX -->
        </div>

        <!-- Pagination -->
        <div id="paginationContainer" class="d-flex justify-content-center mt-4">
            <!-- Pagination will be loaded here -->
        </div>

    </div>
</div>
<!-- Add Platform Offcanvas -->
<div class="offcanvas offcanvas-end" tabindex="-1" id="addPlatformOffcanvas" aria-labelledby="addPlatformOffcanvasLabel">
    <div class="offcanvas-header">
        <h5 class="offcanvas-title" id="addPlatformOffcanvasLabel">
            <i class="bx bx-plus-circle me-2"></i>{{ __('Add New Platform') }}
        </h5>
        <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body">
        <form id="addPlatformForm" enctype="multipart/form-data">
            @csrf
            <div class="mb-4">
                <label for="platform" class="form-label fw-bold">{{ __('Platform Name') }}</label>
                <input type="text" class="form-control" id="platform" name="platform" required 
                       placeholder="{{ __('e.g., Instagram, Facebook, Twitter') }}">
                <div class="form-text">{{ __('Enter the name of the social media platform') }}</div>
            </div>
            
            <div class="mb-4">
                <label for="icon" class="form-label fw-bold">{{ __('Platform Icon') }}</label>
                <input type="file" class="form-control" id="icon" name="icon" required 
                       accept="image/*" onchange="previewAddImage(event)">
                <div class="form-text">{{ __('Upload an icon for the platform (PNG, JPG, SVG)') }}</div>
                <img id="addIconPreview" class="icon-preview" style="display: none;" alt="Icon Preview">
            </div>
            
            <div class="mb-4">
                <label for="description" class="form-label fw-bold">{{ __('Description') }}</label>
                <textarea class="form-control" id="description" name="description" rows="4" 
                          placeholder="{{ __('Describe the platform and its purpose...') }}"></textarea>
                <div class="form-text">{{ __('Optional description for the platform') }}</div>
            </div>
            
            <div class="mb-4">
                <label for="status" class="form-label fw-bold">{{ __('Status') }}</label>
                <select class="form-select" id="status" name="status" required>
                    <option value="1">{{ __('Active') }}</option>
                    <option value="0">{{ __('Inactive') }}</option>
                </select>
                <div class="form-text">{{ __('Set platform availability for tasks') }}</div>
            </div>
            
            <div class="d-grid gap-2">
                <button type="submit" class="btn btn-primary btn-lg">
                    <i class="bx bx-check me-2"></i>{{ __('Add Platform') }}
                </button>
                <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="offcanvas">
                    {{ __('Cancel') }}
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Edit Platform Offcanvas -->
<div class="offcanvas offcanvas-end" tabindex="-1" id="editPlatformOffcanvas" aria-labelledby="editPlatformOffcanvasLabel">
    <div class="offcanvas-header">
        <h5 class="offcanvas-title text-white" id="editPlatformOffcanvasLabel">
            <i class="bx bx-edit me-2"></i>{{ __('Edit Platform') }}
        </h5>
        <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body">
        <form id="editPlatformForm" enctype="multipart/form-data">
            @csrf
            @method('POST')
            <input type="hidden" id="editPlatformId">
            
            <div class="mb-4">
                <label for="editPlatform" class="form-label fw-bold">{{ __('Platform Name') }}</label>
                <input type="text" class="form-control" id="editPlatform" name="platform" required>
            </div>
            
            <div class="mb-4">
                <label for="editIcon" class="form-label fw-bold">{{ __('Platform Icon') }}</label>
                <input type="file" class="form-control" id="editIcon" name="icon" 
                       accept="image/*" onchange="previewEditImage(event)">
                <div class="form-text">{{ __('Leave empty to keep current icon') }}</div>
                <img id="editIconPreview" class="icon-preview" style="display: none;" alt="Icon Preview">
            </div>
            
            <div class="mb-4">
                <label for="editDescription" class="form-label fw-bold">{{ __('Description') }}</label>
                <textarea class="form-control" id="editDescription" name="description" rows="4"></textarea>
            </div>
            
            <div class="mb-4">
                <label for="editStatus" class="form-label fw-bold">{{ __('Status') }}</label>
                <select class="form-select" id="editStatus" name="status" required>
                    <option value="1">{{ __('Active') }}</option>
                    <option value="0">{{ __('Inactive') }}</option>
                </select>
            </div>
            
            <div class="d-grid gap-2">
                <button type="submit" class="btn btn-primary btn-lg">
                    <i class="bx bx-save me-2"></i>{{ __('Update Platform') }}
                </button>
                <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="offcanvas">
                    {{ __('Cancel') }}
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Description Modal -->
<div class="modal fade" id="descriptionModal" tabindex="-1" aria-labelledby="descriptionModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="descriptionModalLabel">{{ __('Platform Description') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p id="fullDescription"></p>
            </div>
        </div>
    </div>
</div>
@endsection

@section('script')
<script src="{{ asset('assets/plugins/notifications/js/lobibox.min.js') }}"></script>
<script src="{{ asset('assets/plugins/notifications/js/notifications.min.js') }}"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    let currentPage = 1;
    let currentSearch = '';
    let currentStatus = '';
    let currentPerPage = 12;

    // Page load
    $(document).ready(function() {
        loadPlatforms();
        
        // Enter key search
        $('#searchInput').on('keypress', function(e) {
            if (e.which == 13) {
                searchPlatforms();
            }
        });

        // Real-time search with debounce
        let searchTimeout;
        $('#searchInput').on('input', function() {
            clearTimeout(searchTimeout);
            searchTimeout = setTimeout(function() {
                searchPlatforms();
            }, 500);
        });
    });

    function loadPlatforms(page = 1) {
        $('#loadingSpinner').show();
        $('#platformsContainer').hide();
        
        $.ajax({
            url: '{{ route("social-platforms.search") }}',
            type: 'GET',
            data: {
                page: page,
                search: currentSearch,
                status: currentStatus,
                per_page: currentPerPage
            },
            success: function(response) {
                if (response.success) {
                    displayPlatforms(response.data);
                    displayPagination(response.pagination);
                    currentPage = page;
                } else {
                    showNotification('error', '{{ __("No data received from server.") }}');
                }
                $('#loadingSpinner').hide();
                $('#platformsContainer').show();
            },
            error: function(xhr, status, error) {
                $('#loadingSpinner').hide();
                showNotification('error', '{{ __("An error occurred while loading platforms.") }}');
            }
        });
    }

    function displayPlatforms(platforms) {
        let html = '';
        
        if (platforms.length === 0) {
            html = `
                <div class="empty-state">
                    <i class="bx bx-search-alt-2"></i>
                    <h4>{{ __('No platforms found') }}</h4>
                    <p>{{ __('No social media platforms found matching your criteria.') }}</p>
                    <button class="btn btn-primary" data-bs-toggle="offcanvas" data-bs-target="#addPlatformOffcanvas">
                        <i class="bx bx-plus me-2"></i>{{ __('Add First Platform') }}
                    </button>
                </div>
            `;
        } else {
            html = '<div class="row">';
            platforms.forEach(function(platform) {
                html += generatePlatformCard(platform);
            });
            html += '</div>';
        }
        
        $('#platformsContainer').html(html);
    }

    function generatePlatformCard(platform) {
        const statusBadge = platform.status == 1 ? 
            '<span class="badge bg-success status-badge">{{ __("Active") }}</span>' : 
            '<span class="badge bg-danger status-badge">{{ __("Inactive") }}</span>';
        
        const description = platform.description || '{{ __("No description") }}';
        const shortDescription = description.length > 100 ? 
            description.substring(0, 100) + '...' : description;

        // Escape quotes for onclick
        const escapedDescription = description.replace(/'/g, "\\'").replace(/"/g, '\\"');
        const escapedPlatformName = platform.platform.replace(/'/g, "\\'").replace(/"/g, '\\"');

        return `
            <div class="col-lg-4 col-md-6 mb-4">
                <div class="platform-card p-4 h-100">
                    <div class="d-flex align-items-center mb-3">
                        <img src="/assets/images/app/${platform.icon}" 
                             class="platform-icon me-3" 
                             alt="${platform.platform}"
                             onerror="this.src='/assets/images/placeholder.png'">
                        <div class="flex-grow-1">
                            <h5 class="mb-1">${platform.platform}</h5>
                            <small class="text-muted">${platform.tasks_count || 0} {{ __('tasks') }}</small>
                        </div>
                        ${statusBadge}
                    </div>
                    
                    <p class="text-muted mb-3" style="min-height: 60px;">
                        ${shortDescription}
                        ${description.length > 100 ? `
                            <a href="#" class="text-primary" onclick="showDescription('${escapedDescription}')">
                                {{ __('Read more') }}
                            </a>
                        ` : ''}
                    </p>
                    
                    <div class="action-buttons mt-auto">
                        <button class="btn btn-outline-primary btn-sm" onclick="editPlatform(${platform.id})">
                            <i class="bx bx-edit"></i> {{ __('Edit') }}
                        </button>
                        <button class="btn btn-outline-danger btn-sm" onclick="deletePlatform(${platform.id}, '${escapedPlatformName}', ${platform.tasks_count || 0})">
                            <i class="bx bx-trash"></i> {{ __('Delete') }}
                        </button>
                    </div>
                </div>
            </div>
        `;
    }

    function displayPagination(pagination) {
        if (pagination.last_page <= 1) {
            $('#paginationContainer').html('');
            return;
        }

        let html = '<nav><ul class="pagination">';
        
        // Previous button
        if (pagination.current_page > 1) {
            html += `<li class="page-item"><a class="page-link" href="#" onclick="loadPlatforms(${pagination.current_page - 1})">{{ __('Previous') }}</a></li>`;
        }
        
        // Page numbers
        for (let i = Math.max(1, pagination.current_page - 2); i <= Math.min(pagination.last_page, pagination.current_page + 2); i++) {
            html += `<li class="page-item ${i === pagination.current_page ? 'active' : ''}">
                        <a class="page-link" href="#" onclick="loadPlatforms(${i})">${i}</a>
                     </li>`;
        }
        
        // Next button
        if (pagination.current_page < pagination.last_page) {
            html += `<li class="page-item"><a class="page-link" href="#" onclick="loadPlatforms(${pagination.current_page + 1})">{{ __('Next') }}</a></li>`;
        }
        
        html += '</ul></nav>';
        
        // Add info
        html += `<div class="text-center mt-2">
                    <small class="text-muted">
                        {{ __('Showing') }} ${pagination.from} {{ __('to') }} ${pagination.to} {{ __('of') }} ${pagination.total} {{ __('results') }}
                    </small>
                 </div>`;
        
        $('#paginationContainer').html(html);
    }

    function searchPlatforms() {
        currentSearch = $('#searchInput').val().trim();
        currentStatus = $('#statusFilter').val();
        currentPage = 1;
        loadPlatforms(1);
    }

    function changePerPage() {
        currentPerPage = $('#perPageSelect').val();
        currentPage = 1;
        loadPlatforms(1);
    }

    function editPlatform(platformId) {
        // Platform verilerini al ve formu doldur
        $.ajax({
            url: `{{ url('social-platforms') }}/${platformId}`,
            type: 'GET',
            success: function(platform) {
                $('#editPlatformId').val(platform.id);
                $('#editPlatform').val(platform.platform);
                $('#editDescription').val(platform.description || '');
                $('#editStatus').val(platform.status);
                
                if (platform.icon) {
                    $('#editIconPreview').attr('src', `/assets/images/app/${platform.icon}`).show();
                } else {
                    $('#editIconPreview').hide();
                }
                
                // Offcanvas'ı aç
                const offcanvas = new bootstrap.Offcanvas(document.getElementById('editPlatformOffcanvas'));
                offcanvas.show();
            },
            error: function() {
                showNotification('error', '{{ __("Error loading platform data.") }}');
            }
        });
    }

    function deletePlatform(platformId, platformName, tasksCount) {
        // Önce server'dan güncel görev sayısını kontrol et
        $.ajax({
            url: `{{ url('social-platforms') }}/${platformId}`,
            type: 'GET',
            success: function(platform) {
                const currentTasksCount = platform.tasks_count || 0;
                
                if (currentTasksCount > 0) {
                    Swal.fire({
                        title: '{{ __("Cannot Delete Platform") }}',
                        html: `
                            <div class="text-center">
                                <i class="bx bx-error-circle text-warning" style="font-size: 3rem;"></i>
                                <h5 class="mt-3">"${platformName}" {{ __("cannot be deleted") }}</h5>
                                <p class="text-muted">{{ __("This platform has") }} <strong>${currentTasksCount}</strong> {{ __("associated tasks.") }}</p>
                                <p class="text-muted">{{ __("Please remove all tasks before deleting this platform.") }}</p>
                            </div>
                        `,
                        icon: false,
                        confirmButtonText: '{{ __("OK") }}',
                        confirmButtonColor: '#6c757d'
                    });
                    return;
                }

                // Görev yoksa silme onayı iste
                Swal.fire({
                    title: '{{ __("Are you sure?") }}',
                    html: `
                        <div class="text-center">
                            <i class="bx bx-trash text-danger" style="font-size: 3rem;"></i>
                            <h5 class="mt-3">{{ __("Delete Platform") }}</h5>
                            <p class="text-muted">{{ __("Do you want to delete") }} "<strong>${platformName}</strong>"?</p>
                            <p class="text-warning"><small>{{ __("This action cannot be undone.") }}</small></p>
                        </div>
                    `,
                    icon: false,
                    showCancelButton: true,
                    confirmButtonColor: '#dc3545',
                    cancelButtonColor: '#6c757d',
                    confirmButtonText: '<i class="bx bx-trash me-1"></i>{{ __("Yes, delete it!") }}',
                    cancelButtonText: '{{ __("Cancel") }}'
                }).then((result) => {
                    if (result.isConfirmed) {
                        // Silme işlemini gerçekleştir
                        $.ajax({
                            url: `{{ url('social-platforms') }}/${platformId}`,
                            type: 'POST',
                            data: {
                                _token: '{{ csrf_token() }}',
                                _method: 'DELETE'
                            },
                            success: function(response) {
                                if (response.success) {
                                    Swal.fire({
                                        title: '{{ __("Deleted!") }}',
                                        text: response.message,
                                        icon: 'success',
                                        timer: 2000,
                                        showConfirmButton: false
                                    });
                                    loadPlatforms(currentPage);
                                } else {
                                    showNotification('error', response.message);
                                }
                            },
                            error: function(xhr) {
                                const response = xhr.responseJSON;
                                if (xhr.status === 422) {
                                    // Validation error - platform has tasks
                                    Swal.fire({
                                        title: '{{ __("Cannot Delete") }}',
                                        text: response?.message || '{{ __("Platform has associated tasks.") }}',
                                        icon: 'error',
                                        confirmButtonText: '{{ __("OK") }}'
                                    });
                                } else {
                                    showNotification('error', response?.message || '{{ __("An error occurred.") }}');
                                }
                            }
                        });
                    }
                });
            },
            error: function() {
                showNotification('error', '{{ __("Error loading platform data.") }}');
            }
        });
    }

    function showDescription(description) {
        $('#fullDescription').text(description);
        $('#descriptionModal').modal('show');
    }

    // Form submissions
    $('#addPlatformForm').on('submit', function(e) {
        e.preventDefault();
        const formData = new FormData(this);
        
        $.ajax({
            url: '{{ route("social-platforms.store") }}',
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                if (response.success) {
                    showNotification('success', response.message);
                    $('#addPlatformForm')[0].reset();
                    $('#addIconPreview').hide();
                    
                    // Offcanvas'ı kapat
                    const offcanvas = bootstrap.Offcanvas.getInstance(document.getElementById('addPlatformOffcanvas'));
                    offcanvas.hide();
                    
                    loadPlatforms(currentPage);
                }
            },
            error: function(xhr) {
                const response = xhr.responseJSON;
                showNotification('error', response?.message || '{{ __("An error occurred.") }}');
            }
        });
    });

    $('#editPlatformForm').on('submit', function(e) {
        e.preventDefault();
        const platformId = $('#editPlatformId').val();
        const formData = new FormData(this);
        formData.append('_method', 'POST');
        
        $.ajax({
            url: `{{ url('social-platforms') }}/${platformId}`,
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                if (response.success) {
                    showNotification('success', response.message);
                    
                    // Offcanvas'ı kapat
                    const offcanvas = bootstrap.Offcanvas.getInstance(document.getElementById('editPlatformOffcanvas'));
                    offcanvas.hide();
                    
                    loadPlatforms(currentPage);
                }
            },
            error: function(xhr) {
                const response = xhr.responseJSON;
                showNotification('error', response?.message || '{{ __("An error occurred.") }}');
            }
        });
    });

    // Image preview functions
    function previewAddImage(event) {
        const reader = new FileReader();
        reader.onload = function() {
            $('#addIconPreview').attr('src', reader.result).show();
        };
        reader.readAsDataURL(event.target.files[0]);
    }

    function previewEditImage(event) {
        const reader = new FileReader();
        reader.onload = function() {
            $('#editIconPreview').attr('src', reader.result).show();
        };
        reader.readAsDataURL(event.target.files[0]);
    }

    function showNotification(type, message) {
        Lobibox.notify(type, {
            pauseDelayOnHover: true,
            size: 'mini',
            rounded: true,
            delayIndicator: false,
            continueDelayOnInactiveTab: false,
            position: 'top right',
            msg: message
        });
    }

    // Global functions for window scope
    window.previewAddImage = previewAddImage;
    window.previewEditImage = previewEditImage;
</script>
@endsection
