<table class="table mb-0">
    <thead class="table-light">
        <tr>
            <th>{{ __('Platform') }}</th>
            <th>{{ __('Icon') }}</th>
            <th>{{ __('Description') }}</th>
            <th>{{ __('Status') }}</th>
            <th>{{ __('Actions') }}</th>
        </tr>
    </thead>
    <tbody id="platformTableBody">

        @foreach($platforms as $platform)
        <tr data-id="{{ $platform->id }}">
            <td>{{ $platform->platform }}</td>
            <td>
                <img src="/assets/images/app/{{ $platform->icon }}" class="rounded-circle p-1 border" width="50" height="50" alt="{{ $platform->icon }}">
            </td>
            <td> <span class="description-preview" data-description="{{ $platform->description }}">
                {{ Str::limit($platform->description, 50) }}
                @if (strlen($platform->description) > 50)
                    <a href="#" class="read-more" data-bs-toggle="modal" data-bs-target="#descriptionModal" data-full-description="{{ $platform->description }}">...</a>
                @endif
            </span></td>
            <td>{{ $platform->status ? __('Active') : __('Inactive') }}</td>
            <td>
                <div class="d-flex order-actions">
                    <a href="javascript:;" class="edit-platform-btn" data-bs-toggle="modal" data-bs-target="#editPlatformModal"><i class='bx bxs-edit'></i></a>
                    <a href="javascript:;" class="ms-3 delete-platform-btn"><i class='bx bxs-trash'></i></a>
                </div>
             </td>
        </tr>
    @endforeach


    </tbody>
</table>
