@extends('layouts.app')

@section('style')
    <link href="{{ asset('assets/plugins/notifications/css/lobibox.min.css') }}" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
@endsection

@section('wrapper')
<div class="page-wrapper">
    <div class="page-content">
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">{{ __('Social Media') }}</div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="{{ url('/home') }}"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{__('Approved Social Media Accounts')}}</li>
                    </ol>
                </nav>
            </div>
            <div class="ms-auto">
                <div class="btn-group">
                    <button type="button" class="btn btn-primary">{{__('Actions')}}</button>
                    <button type="button" class="btn btn-primary split-bg-primary dropdown-toggle dropdown-toggle-split" data-bs-toggle="dropdown"> <span class="visually-hidden">Toggle Dropdown</span></button>
                    <div class="dropdown-menu dropdown-menu-right dropdown-menu-lg-end">
                        <a class="dropdown-item" href="{{ route('social_media_accounts.index') }}">{{ __('All Accounts') }}</a>
                        <a class="dropdown-item" href="{{ route('social_media_accounts.approved') }}">{{ __('Approved Accounts') }}</a>
                        <a class="dropdown-item" href="javascript:;" data-bs-toggle="offcanvas" data-bs-target="#addAccountCanvas" aria-controls="addAccountCanvas">{{ __('Add Account') }}</a>
                    </div>
                </div>
            </div>
        </div>

        <div class="offcanvas offcanvas-end" tabindex="-1" id="addAccountCanvas" aria-labelledby="addAccountCanvasLabel">
            <div class="offcanvas-header">
                <h5 class="offcanvas-title" id="addAccountCanvasLabel">{{ __('Add New Account') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
            </div>
            <div class="offcanvas-body">
                <form id="addAccountForm">
                    @csrf
                    <div class="mb-3">
                        <label for="platform_id" class="form-label">{{ __('Platform') }}</label>
                        <select id="platform_id" name="platform_id" class="form-select" required>
                            @foreach($platforms as $platform)
                                <option value="{{ $platform->id }}">{{ $platform->platform }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="username" class="form-label">{{ __('Username') }}</label>
                        <input type="text" id="username" name="username" class="form-control" required>
                    </div>
                    <button type="submit" id="addAccountBtn" class="btn btn-primary">{{ __('Add Account') }}</button>
                </form>
            </div>
        </div>

        <div class="card">
            <div class="card-body">
                <table class="table mb-0">
                    <thead class="table-light">
                        <tr>
                            <th>#</th>
                            <th>{{ __('Platform') }}</th>
                            <th>{{ __('Username') }}</th>
                            <th>{{ __('Status') }}</th>
                            @if($user->user_type == 1)
                                <th>{{ __('User') }}</th>
                            @endif
                            <th>{{ __('Actions') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($accounts as $account)
                            <tr>
                                <td>{{ $account->id }}</td>
                                <td><img src="/assets/images/app/{{ $account->platform->icon }}" class="rounded-circle p-1 border" width="50" height="50" alt="{{ $account->platform->platform }}">{{ $account->platform->platform }}</td>
                                <td>
                                    @if($account->platform->url)
                                        <a href="{{ $account->platform->url }}{{ $account->username }}" title="{{ $account->username }}" target="_blank">{{ $account->username }}</a>
                                    @else
                                        {{ $account->username }}
                                    @endif
                                </td>
                                <td>
                                    <div class="form-check form-switch form-check-success">
                                        <input class="form-check-input" type="checkbox" role="switch" id="flexSwitchCheckSuccess{{ $account->id }}" checked="" onchange="approveAccount({{ $account->id }})">
                                        <label class="form-check-label" for="flexSwitchCheckSuccess{{ $account->id }}">{{ __('Approved') }}</label>
                                    </div>
                                </td>
                                @if($user->user_type == 1)
                                    <td>{{ $account->user->name }}</td>
                                @endif
                                <td>
                                    <div class="d-flex order-actions">
                                        <a href="javascript:;" class="edit-platform-btn"><i class='bx bxs-edit'></i></a>
                                        <a href="javascript:;" class="ms-3 btn btn-danger delete-platform-btn" onclick="deleteAccount({{ $account->id }})"><i class='bx bxs-trash'></i></a>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="{{ $user->user_type == 1 ? 6 : 5 }}" class="text-center">{{ __('No records found') }}</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

@section('script')
<script src="{{ asset('assets/plugins/notifications/js/lobibox.min.js') }}"></script>
<script src="{{ asset('assets/plugins/notifications/js/notifications.min.js') }}"></script>
<script>
    document.getElementById('addAccountForm').addEventListener('submit', function(e) {
        e.preventDefault();
        let form = this;
        let button = document.getElementById('addAccountBtn');
        button.disabled = true;
        button.innerText = '{{ __('Adding Account...') }}';

        fetch('{{ route('social_media_accounts.store') }}', {
            method: 'POST',
            body: new FormData(form),
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            }
        }).then(response => response.json())
        .then(data => {
            button.disabled = false;
            button.innerText = '{{ __('Add Account') }}';
            if (data.message) {
                Lobibox.notify('success', {
                    pauseDelayOnHover: true,
                    size: 'mini',
                    rounded: true,
                    icon: 'bx bx-check-circle',
                    delayIndicator: false,
                    continueDelayOnInactiveTab: false,
                    position: 'top right',
                    msg: data.message
                });
                setTimeout(function() {
                    location.reload();
                }, 2000); // 2 saniye bekle
            }
        }).catch(error => {
            button.disabled = false;
            button.innerText = '{{ __('Add Account') }}';
            Lobibox.notify('error', {
                pauseDelayOnHover: true,
                size: 'mini',
                rounded: true,
                icon: 'bx bx-check-circle',
                delayIndicator: false,
                continueDelayOnInactiveTab: false,
                position: 'top right',
                msg: '{{ __('An error occurred, please try again.') }}'
            });
        });
    });

    function deleteAccount(id) {
        Swal.fire({
            title: '{{ __('Are you sure you want to delete this account?') }}',
            text: "{{ __('This action cannot be undone!') }}",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: '{{ __('Yes, delete it!') }}',
            cancelButtonText: '{{ __('No, cancel!') }}'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: `/social-media-accounts/${id}/delete`,
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': '{{ csrf_token() }}',
                        'Accept': 'application/json'
                    },
                    dataType: 'json'
                }).done(function(response) {
                    if (response.success) {
                        Lobibox.notify('success', {
                            pauseDelayOnHover: true,
                            size: 'mini',
                            rounded: true,
                            icon: 'bx bx-check-circle',
                            continueDelayOnInactiveTab: false,
                            position: 'top right',
                            msg: response.message
                        });
                        location.reload();
                    } else {
                        Lobibox.notify('error', {
                            pauseDelayOnHover: true,
                            size: 'mini',
                            rounded: true,
                            icon: 'bx bx-error',
                            continueDelayOnInactiveTab: false,
                            position: 'top right',
                            msg: response.message
                        });
                    }
                }).fail(function(xhr) {
                    const errorMessage = xhr.responseJSON?.message || '{{ __('An error occurred while deleting the account') }}';
                    Lobibox.notify('error', {
                        pauseDelayOnHover: true,
                        size: 'mini',
                        rounded: true,
                        icon: 'bx bx-error',
                        continueDelayOnInactiveTab: false,
                        position: 'top right',
                        msg: errorMessage
                    });
                });
            }
        });
    }

    function approveAccount(id) {
        fetch(`/social-media-accounts/${id}/approve`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            }
        }).then(response => response.json())
        .then(data => {
            if (data.message) {
                Lobibox.notify('success', {
                    pauseDelayOnHover: true,
                    size: 'mini',
                    rounded: true,
                    icon: 'bx bx-check-circle',
                    delayIndicator: false,
                    continueDelayOnInactiveTab: false,
                    position: 'top right',
                    msg: data.message
                });
                setTimeout(function() {
                    location.reload();
                }, 2000); // 2 saniye bekle
            }
        }).catch(error => {
            Lobibox.notify('error', {
                pauseDelayOnHover: true,
                size: 'mini',
                rounded: true,
                icon: 'bx bx-check-circle',
                delayIndicator: false,
                continueDelayOnInactiveTab: false,
                position: 'top right',
                msg: '{{ __('An error occurred, please try again.') }}'
            });
        });
    }
</script>
@endsection
@endsection
