@extends('layouts.app')

@section('style')
    <link href="{{ asset('assets/plugins/notifications/css/lobibox.min.css') }}" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick.min.css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick-theme.min.css" />
    <style>
.modal-body img {
        max-width: 100%;
        height: auto;
    }
    .slider-for img {
        width: 500px;
        height: 500px;
        object-fit: cover;
        margin: 0 auto;
    }
    .thumbnail-slider img {
        width: 75px;
        height: 75px;
        object-fit: cover;
    }
    .slider-nav {
        margin-top: 15px;
    }
    </style>
@endsection

@section('wrapper')
<div class="page-wrapper">
    <div class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">{{__('Approved Task Proofs')}}</div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="{{ url('/home') }}"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{__('Proofs')}}</li>
                    </ol>
                </nav>
            </div>
        </div>
        <!--end breadcrumb-->

        <!-- Alert Container -->
        <div id="alert-container"></div>

        <div class="card">
            <div class="card-body">
                <div class="d-lg-flex align-items-center mb-4 gap-3">
                    <div class="position-relative">
                        <input type="text" class="form-control ps-5 radius-30" placeholder="{{__('Search Proofs')}}">
                        <span class="position-absolute top-50 product-show translate-middle-y"><i class="bx bx-search"></i></span>
                    </div>
                </div>
                <div class="table-responsive">
                    <table class="table mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>ID#</th>
                                <th>{{__('Task Name')}}</th>
                                <th>{{__('Platform')}}</th>
                                <th>{{__('Profit')}}</th>
                                <th>{{__('Added by')}}</th>
                                <th>{{__('Proof Number')}}</th>
                                <th>{{__('Added Time')}}</th>
                                <th>{{__('Status')}}</th>
                                <th>{{__('Reason')}}</th>
                                <th>{{__('Actions')}}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php
                                $proofsExist = false;
                            @endphp

                            @foreach ($tasks as $task)
                                @foreach ($task->taskProofs as $proof)
                                    @php
                                        $proofsExist = true;
                                    @endphp
                                    <tr>
                                        <td>#{{ $proof->id }}</td>
                                        <td>
                                            <div class="chip chip-md">
                                                <img src="/assets/images/tasks/{{ $task->image }}" alt="{{ $task->name }}">{{ $task->name }}
                                            </div>
                                        </td>
                                        <td>
                                            <div class="chip chip-md">
                                                <img src="/assets/images/app/{{ $task->socialPlatform->icon }}" alt="{{ $task->socialPlatform->platform }}">{{ $task->socialPlatform->platform }}
                                            </div>
                                        </td>
                                        <td>{{ number_format($task->reward, 2, ',', '.') }}{{ $settings['currency'] }}</td>
                                        <td>{{ $proof->proofUser ? $proof->proofUser->account_holder : __('Unknown User') }}</td>
                                        <td>{{ $proof->proof_count }}</td>
                                        <td>{{ $proof->created_at }}</td>
                                        <td>{!! $proof->Status == 2 ? '<span class="btn btn-danger">'.__('Denied').'</span>' : '' !!}</td>
                                        <td><p class="badge bg-danger"> {{ $proof->Reason }}</p></td>
                                        <td>
                                            <div class="d-flex order-actions">
                                            <a href="javascript:;" class="denied-proof" data-proof-id="{{ $proof->id }}"><i class='fadeIn animated bx bx-images'></i></a>
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                            @endforeach

                            @if (!$proofsExist)
                                <tr>
                                    <td colspan="10" class="text-center">{{ __('No proof found.') }}</td>
                                </tr>
                            @endif
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal Structure -->
<!-- Modal Structure -->
<div class="modal fade" id="proofModal" tabindex="-1" aria-labelledby="proofModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="proofModalLabel">{{ __('Kanit Resimleri') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="slider-for">
                    <!-- Large images will be appended here -->
                </div>
                <div class="slider-nav thumbnail-slider">
                    <!-- Thumbnails will be appended here -->
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@section('script')
    <script src="{{ asset('assets/plugins/notifications/js/lobibox.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/notifications/js/notifications.min.js') }}"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick.min.js"></script>
    <script>
$(document).ready(function() {
    // Initialize slick slider
    function initializeSlickSliders() {
        $('.slider-for').slick({
            slidesToShow: 1,
            slidesToScroll: 1,
            arrows: false,
            fade: true,
            asNavFor: '.slider-nav'
        });
        $('.slider-nav').slick({
            slidesToShow: 3,
            slidesToScroll: 1,
            asNavFor: '.slider-for',
            dots: true,
            centerMode: true,
            focusOnSelect: true
        });
    }

    // Remove and reinitialize slick sliders
    function resetSlickSliders() {
        if ($('.slider-for').hasClass('slick-initialized')) {
            $('.slider-for').slick('unslick');
        }
        if ($('.slider-nav').hasClass('slick-initialized')) {
            $('.slider-nav').slick('unslick');
        }
        initializeSlickSliders();
    }

    // Setup CSRF token for AJAX requests
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    // Event listener for denied-proof button click
    $('.denied-proof').on('click', function() {
        var proofId = $(this).data('proof-id');
        var url = '/proof-images/' + proofId;

        // Fetch proof images
        $.ajax({
            url: url,
            method: 'GET',
            success: function(response) {
                var images = response.images;

                // Clear previous images
                $('.slider-for').empty();
                $('.slider-nav').empty();

                // Append new images
                images.forEach(function(image) {
                    $('.slider-for').append('<div><img src="' + image.large + '" alt="Proof Image"></div>');
                    $('.slider-nav').append('<div><img src="' + image.thumbnail + '" alt="Proof Thumbnail" class="img-thumbnail"></div>');
                });

                // Show modal
                $('#proofModal').modal('show');

                // Reset and reinitialize slick sliders after modal is shown
                $('#proofModal').on('shown.bs.modal', function () {
                    resetSlickSliders();
                });
            },
            error: function() {
                alert('Failed to load images.');
            }
        });
    });

    // Initialize slick sliders on page load
    initializeSlickSliders();
});

    </script>
@endsection
