@extends('layouts.app')
@section('style')
    <link href="{{ asset('assets/plugins/datatable/css/dataTables.bootstrap5.min.css') }}" rel="stylesheet" />
    <link href="{{ asset('assets/plugins/notifications/css/lobibox.min.css') }}" rel="stylesheet" />
    <style>
        /* Mobile-first responsive design */
        @media (max-width: 768px) {
            .table-responsive {
                border: none;
            }
            
            .mobile-card {
                background: white;
                border-radius: 12px;
                padding: 15px;
                margin-bottom: 15px;
                box-shadow: 0 2px 8px rgba(0,0,0,0.1);
                border-left: 4px solid #0d6efd;
            }
            
            .mobile-card-header {
                display: flex;
                justify-content: space-between;
                align-items: center;
                margin-bottom: 10px;
            }
            
            .mobile-card-title {
                font-weight: 600;
                color: #333;
                font-size: 16px;
            }
            
            .mobile-card-badge {
                background: #e3f2fd;
                color: #1976d2;
                padding: 4px 8px;
                border-radius: 12px;
                font-size: 12px;
                font-weight: 500;
            }
            
            .mobile-card-body {
                margin-bottom: 10px;
            }
            
            .mobile-card-meta {
                display: flex;
                justify-content: space-between;
                align-items: center;
                font-size: 12px;
                color: #666;
                margin-bottom: 10px;
            }
            
            .mobile-card-actions {
                display: flex;
                gap: 8px;
                flex-wrap: wrap;
            }
            
            .mobile-card-actions .btn {
                font-size: 12px;
                padding: 6px 12px;
                flex: 1;
                min-width: auto;
            }
            
            .mobile-search {
                position: sticky;
                top: 0;
                z-index: 100;
                background: white;
                padding: 15px;
                margin: -15px -15px 15px -15px;
                border-bottom: 1px solid #eee;
            }
            
            .mobile-search input {
                border-radius: 25px;
                border: 2px solid #e9ecef;
                padding: 12px 20px;
                font-size: 16px; /* Prevents zoom on iOS */
            }
            
            .mobile-search input:focus {
                border-color: #0d6efd;
                box-shadow: 0 0 0 0.2rem rgba(13, 110, 253, 0.25);
            }
            
            /* Hide desktop table on mobile */
            .desktop-table {
                display: none;
            }
            
            .mobile-view {
                display: block;
            }
        }
        
        @media (min-width: 769px) {
            .mobile-view {
                display: none;
            }
            
            .desktop-table {
                display: block;
            }
        }
        .proof-image {
            cursor: pointer;
            transition: transform 0.2s;
            border-radius: 8px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }
        .proof-image:hover {
            transform: scale(1.05);
        }
    </style>
@endsection

@section('wrapper')
<div class="page-wrapper">
    <div class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">{{__('Task Proofs')}}</div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="{{ url('/home') }}"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{__('Task Proofs')}}</li>
                    </ol>
                </nav>
            </div>
        </div>
        <!--end breadcrumb-->

        <div class="card">
            <div class="card-body">
                <!-- Desktop View -->
                <div class="desktop-table">
                    <div class="d-lg-flex align-items-center mb-4 gap-3">
                        <div class="position-relative">
                            <input type="text" class="form-control ps-5 radius-30" placeholder="{{__('Search proofs...')}}" id="searchInput">
                            <span class="position-absolute top-50 product-show translate-middle-y"><i class="bx bx-search"></i></span>
                        </div>
                        <div class="ms-auto">
                            <button type="button" class="btn btn-primary radius-30 mt-2 mt-lg-0" id="refreshTable">
                                <i class="bx bx-refresh"></i> {{__('Refresh')}}
                            </button>
                        </div>
                    </div>
                    
                    <div class="table-responsive">
                        <table id="proofsTable" class="table table-striped table-bordered" style="width:100%">
                            <thead>
                                <tr>
                                    <th>{{__('Task Name')}}</th>
                                    <th>{{__('Platform')}}</th>
                                    @if($user->user_type == 1)
                                    <th>{{__('User')}}</th>
                                    @endif
                                    <th>{{__('Description')}}</th>
                                    <th>{{__('Files')}}</th>
                                    <th>{{__('Date')}}</th>
                                    <th>{{__('Actions')}}</th>
                                </tr>
                            </thead>
                            <tbody>
                                <!-- DataTable will populate this -->
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Mobile View -->
                <div class="mobile-view">
                    <div class="mobile-search">
                        <div class="position-relative">
                            <input type="text" class="form-control" placeholder="{{__('Search proofs...')}}" id="mobileSearchInput">
                            <span class="position-absolute top-50 end-0 translate-middle-y me-3">
                                <i class="bx bx-search"></i>
                            </span>
                        </div>
                        <div class="mt-2">
                            <button type="button" class="btn btn-primary btn-sm" id="mobileRefreshBtn">
                                <i class="bx bx-refresh"></i> {{__('Refresh')}}
                            </button>
                        </div>
                    </div>
                    
                    <div id="mobileProofsList">
                        <!-- Mobile cards will be populated here -->
                    </div>
                    
                    <div class="text-center mt-3">
                        <button type="button" class="btn btn-outline-primary" id="loadMoreBtn" style="display: none;">
                            <i class="bx bx-down-arrow"></i> {{__('Load More')}}
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Proof Details Offcanvas -->
        <div class="offcanvas offcanvas-end" tabindex="-1" id="proofOffcanvas" aria-labelledby="proofOffcanvasLabel" style="width: 500px;">
            <div class="offcanvas-header">
                <h5 class="offcanvas-title" id="proofOffcanvasLabel">{{__('Proof Details')}}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
            </div>
            <div class="offcanvas-body">
                <div id="proofDetails" class="mb-4">
                    <!-- Proof details will be loaded here -->
                </div>
                <div id="proofImages" class="mb-4">
                    <!-- Proof images will be loaded here -->
                </div>
                <div id="proofUser">
                    <!-- User details will be loaded here -->
                </div>
            </div>
        </div>

        <!-- Deny Reason Modal -->
        <div class="modal fade" id="denyModal" tabindex="-1" aria-labelledby="denyModalLabel" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="denyModalLabel">{{__('Deny Proof')}}</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label for="denyReason" class="form-label">{{__('Reason for denial')}}</label>
                            <textarea class="form-control" id="denyReason" rows="3" placeholder="{{__('Enter reason for denial...')}}"></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{__('Cancel')}}</button>
                        <button type="button" class="btn btn-danger" id="confirmDeny">{{__('Deny Proof')}}</button>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>
@endsection

@section('script')
    <script src="{{ asset('assets/plugins/datatable/js/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatable/js/dataTables.bootstrap5.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/notifications/js/lobibox.min.js') }}"></script>
    <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    
    <script>
        $(document).ready(function() {
            let currentProofId = null;
            let currentImages = [];
            let currentImageIndex = 0;
            let mobileProofs = [];
            let mobileCurrentPage = 0;
            let mobilePageSize = 10;
            let mobileSearchTerm = '';
            let isMobile = window.innerWidth <= 768;
            
            // Initialize based on device
            if (!isMobile) {
                initializeDesktopTable();
            } else {
                initializeMobileView();
            }

            // Initialize DataTable for desktop
            function initializeDesktopTable() {
                const table = $('#proofsTable').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: {
                        url: "{{ route('api.task.proofs.datatable') }}",
                        type: 'GET',
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    },
                    columns: [
                        { data: 'task_name', name: 'task_name' },
                        { data: 'platform', name: 'platform' },
                        @if($user->user_type == 1)
                        { data: 'user_name', name: 'user_name' },
                        @endif
                        { data: 'description', name: 'description' },
                        { data: 'files_count', name: 'files_count', searchable: false },
                        { data: 'created_at', name: 'created_at', searchable: false },
                        { data: 'actions', name: 'actions', orderable: false, searchable: false }
                    ],
                    order: [[{{ $user->user_type == 1 ? '5' : '4' }}, 'desc']],
                    pageLength: 25,
                    responsive: true,
                    search:false,
                    language: {
                        @if(app()->getLocale() == 'tr')
                        "decimal": "",
                        "emptyTable": "Tabloda herhangi bir veri mevcut değil",
                        "info": "_TOTAL_ kayıttan _START_ - _END_ arasındaki kayıtlar gösteriliyor",
                        "infoEmpty": "Kayıt yok",
                        "infoFiltered": "(_MAX_ kayıt içerisinden bulunan)",
                        "infoPostFix": "",
                        "thousands": ".",
                        "lengthMenu": "_MENU_ kayıt göster",
                        "loadingRecords": "Yükleniyor...",
                        "processing": "İşleniyor...",
                        "search": "Ara:",
                        "zeroRecords": "Eşleşen kayıt bulunamadı",
                        "paginate": {
                            "first": "İlk",
                            "last": "Son",
                            "next": "Sonraki",
                            "previous": "Önceki"
                        }
                        @else
                        "decimal": "",
                        "emptyTable": "No data available in table",
                        "info": "Showing _START_ to _END_ of _TOTAL_ entries",
                        "infoEmpty": "Showing 0 to 0 of 0 entries",
                        "infoFiltered": "(filtered from _MAX_ total entries)",
                        "infoPostFix": "",
                        "thousands": ",",
                        "lengthMenu": "Show _MENU_ entries",
                        "loadingRecords": "Loading...",
                        "processing": "Processing...",
                        "search": "Search:",
                        "zeroRecords": "No matching records found",
                        "paginate": {
                            "first": "First",
                            "last": "Last",
                            "next": "Next",
                            "previous": "Previous"
                        }
                        @endif
                    }
                });

                // Desktop search
                $('#searchInput').on('keyup', function() {
                    table.search(this.value).draw();
                });

                // Desktop refresh
                $('#refreshTable').on('click', function() {
                    table.ajax.reload();
                    showNotification('info', "{{__('Table refreshed!')}}");
                });

                window.desktopTable = table;
            }

            // Initialize mobile view
            function initializeMobileView() {
                loadMobileProofs();

                // Mobile search
                $('#mobileSearchInput').on('input', debounce(function() {
                    mobileSearchTerm = this.value;
                    mobileCurrentPage = 0;
                    loadMobileProofs(true);
                }, 500));

                // Mobile refresh
                $('#mobileRefreshBtn').on('click', function() {
                    mobileCurrentPage = 0;
                    loadMobileProofs(true);
                    showNotification('info', "{{__('List refreshed!')}}");
                });

                // Load more button
                $('#loadMoreBtn').on('click', function() {
                    mobileCurrentPage++;
                    loadMobileProofs(false);
                });
            }

            // Load mobile proofs
            function loadMobileProofs(reset = false) {
                if (reset) {
                    $('#mobileProofsList').empty();
                    mobileProofs = [];
                }

                $.ajax({
                    url: "{{ route('api.task.proofs.datatable') }}",
                    type: 'GET',
                    data: {
                        start: mobileCurrentPage * mobilePageSize,
                        length: mobilePageSize,
                        search: { value: mobileSearchTerm }
                    },
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function(response) {
                        if (response.data && response.data.length > 0) {
                            response.data.forEach(function(proof) {
                                mobileProofs.push(proof);
                                $('#mobileProofsList').append(createMobileCard(proof));
                            });

                            // Show/hide load more button
                            if (response.data.length < mobilePageSize) {
                                $('#loadMoreBtn').hide();
                            } else {
                                $('#loadMoreBtn').show();
                            }
                        } else {
                            if (reset) {
                                $('#mobileProofsList').html('<div class="text-center text-muted py-4">{{__("No proofs found")}}</div>');
                            }
                            $('#loadMoreBtn').hide();
                        }
                    },
                    error: function() {
                        showNotification('error', "{{__('Error loading proofs')}}");
                    }
                });
            }

            // Create mobile card
            function createMobileCard(proof) {
                const userColumn = @if($user->user_type == 1) `
                    <div class="mobile-card-meta">
                        <span><i class="bx bx-user"></i> ${proof.user_name}</span>
                        <span><i class="bx bx-time"></i> ${proof.created_at}</span>
                    </div>
                ` @else `
                    <div class="mobile-card-meta">
                        <span><i class="bx bx-time"></i> ${proof.created_at}</span>
                        <span><i class="bx bx-file"></i> ${proof.files_count} {{__('files')}}</span>
                    </div>
                ` @endif;

                const adminActions = @if($user->user_type == 1) `
                    <button class="btn btn-success btn-sm approve-proof" data-id="${proof.id}">
                        <i class="bx bx-check"></i> {{__('Approve')}}
                    </button>
                    <button class="btn btn-danger btn-sm deny-proof" data-id="${proof.id}">
                        <i class="bx bx-x"></i> {{__('Deny')}}
                    </button>
                ` @else '' @endif;

                return `
                    <div class="mobile-card">
                        <div class="mobile-card-header">
                            <div class="mobile-card-title">${proof.task_name}</div>
                            <div class="mobile-card-badge">${proof.platform}</div>
                        </div>
                        <div class="mobile-card-body">
                            <p class="mb-2 text-muted small">${proof.description || '{{__("No description")}}'}</p>
                        </div>
                        ${userColumn}
                        <div class="mobile-card-actions">
                            <button class="btn btn-info btn-sm view-proof" data-id="${proof.id}">
                                <i class="bx bx-show"></i> {{__('View')}}
                            </button>
                            ${adminActions}
                        </div>
                    </div>
                `;
            }

            // Utility functions
            function debounce(func, wait) {
                let timeout;
                return function executedFunction(...args) {
                    const later = () => {
                        clearTimeout(timeout);
                        func(...args);
                    };
                    clearTimeout(timeout);
                    timeout = setTimeout(later, wait);
                };
            }

            function showNotification(type, message) {
                const titles = {
                    'success': "{{__('Success')}}",
                    'error': "{{__('Error')}}",
                    'info': "{{__('Information')}}",
                    'warning': "{{__('Warning')}}"
                };

                Lobibox.notify(type, {
                    title: titles[type] || "{{__('Notification')}}",
                    pauseDelayOnHover: true,
                    continueDelayOnInactiveTab: false,
                    position: 'top right',
                    icon: type === 'success' ? 'bx bx-check-circle' : 
                          type === 'error' ? 'bx bx-x-circle' : 'bx bx-info-circle',
                    msg: message
                });
            }

            // View proof details
            $(document).on('click', '.view-proof', function() {
                const proofId = $(this).data('id');
                
                $.ajax({
                    url: `/proofs/${proofId}`,
                    type: 'GET',
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function(response) {
                        if (response.success) {
                            $('#proofDetails').html(response.detailsHtml);
                            $('#proofImages').html(response.imagesHtml);
                            $('#proofUser').html(response.userHtml);
                            
                            // Initialize SweetAlert for proof images
                            initializeSweetAlertImages();
                            
                            // Show offcanvas
                            const offcanvas = new bootstrap.Offcanvas(document.getElementById('proofOffcanvas'));
                            offcanvas.show();
                        }
                    },
                    error: function() {
                        showNotification('error', "{{__('Error loading proof details')}}");
                    }
                });
            });

            // Approve proof
            $(document).on('click', '.approve-proof', function() {
                const proofId = $(this).data('id');
                
                if (confirm("{{__('Are you sure you want to approve this proof?')}}")) {
                    $.ajax({
                        url: `/task-proofs/${proofId}/approve`,
                        type: 'POST',
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        success: function(response) {
                            if (response.success) {
                                showNotification('success', response.message);
                                if (isMobile) {
                                    mobileCurrentPage = 0;
                                    loadMobileProofs(true);
                                } else {
                                    window.desktopTable.ajax.reload();
                                }
                            }
                        },
                        error: function() {
                            showNotification('error', "{{__('Error approving proof')}}");
                        }
                    });
                }
            });

            // Deny proof
            $(document).on('click', '.deny-proof', function() {
                currentProofId = $(this).data('id');
                $('#denyReason').val('');
                
                // Bootstrap 5 modal açma
                const denyModal = new bootstrap.Modal(document.getElementById('denyModal'));
                denyModal.show();
            });

            // Confirm deny
            $('#confirmDeny').on('click', function() {
                const reason = $('#denyReason').val();
                
                $.ajax({
                    url: `/task-proofs/${currentProofId}/deny`,
                    type: 'POST',
                    data: { reason: reason },
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function(response) {
                        if (response.success) {
                            showNotification('success', response.message);
                            
                            // Bootstrap 5 modal kapatma
                            const denyModal = bootstrap.Modal.getInstance(document.getElementById('denyModal'));
                            if (denyModal) {
                                denyModal.hide();
                            }
                            
                            if (isMobile) {
                                mobileCurrentPage = 0;
                                loadMobileProofs(true);
                            } else {
                                window.desktopTable.ajax.reload();
                            }
                        }
                    },
                    error: function() {
                        showNotification('error', "{{__('Error denying proof')}}");
                    }
                });
            });

            // SweetAlert image gallery functionality
            function initializeSweetAlertImages() {
                // Collect all proof images
                currentImages = [];
                $('#proofImages img').each(function() {
                    const src = $(this).attr('src');
                    if (src) {
                        currentImages.push({
                            src: src,
                            alt: $(this).attr('alt') || 'Proof Image'
                        });
                        $(this).addClass('proof-image');
                        $(this).css('cursor', 'pointer');
                        $(this).attr('role', 'button');
                        $(this).attr('tabindex', '0');
                        $(this).attr('aria-label', 'Görseli büyüt');
                    }
                });

                // Add click and keyboard event to images
                $(document).off('click keypress', '.proof-image').on('click keypress', '.proof-image', function(e) {
                    if (e.type === 'click' || (e.type === 'keypress' && (e.which === 13 || e.which === 32))) {
                        e.preventDefault();
                        const clickedSrc = $(this).attr('src');
                        currentImageIndex = currentImages.findIndex(img => img.src === clickedSrc);
                        showImageGallery();
                    }
                });
            }

            function showImageGallery() {
                if (currentImages.length === 0) return;
                
                const currentImage = currentImages[currentImageIndex];
                const showNavigation = currentImages.length > 1;
                
                Swal.fire({
                    imageUrl: currentImage.src,
                    imageAlt: currentImage.alt,
                    showCloseButton: true,
                    showConfirmButton: false,
                    width: '90%',
                    padding: '1em',
                    background: '#fff',
                    backdrop: 'rgba(0,0,0,0.8)',
                    allowOutsideClick: true,
                    allowEscapeKey: true,
                    focusConfirm: false,
                    returnFocus: false,
                    customClass: {
                        image: 'swal-image-responsive',
                        popup: 'swal-no-focus',
                        closeButton: 'swal-close-custom'
                    },
                    html: showNavigation ? `
                        <div class="swal-image-navigation">
                            <button type="button" class="swal-nav-btn swal-prev-btn" onclick="showPrevImageSwal()">
                                <i class="bx bx-chevron-left"></i>
                            </button>
                            <span class="swal-image-counter">${currentImageIndex + 1} / ${currentImages.length}</span>
                            <button type="button" class="swal-nav-btn swal-next-btn" onclick="showNextImageSwal()">
                                <i class="bx bx-chevron-right"></i>
                            </button>
                        </div>
                        <style>
                            .swal-image-responsive { max-width: 100%; height: auto; border-radius: 8px; }
                            .swal-image-navigation { margin-top: 15px; display: flex; justify-content: center; align-items: center; gap: 15px; }
                            .swal-nav-btn { background: #007bff; color: white; border: none; border-radius: 50%; width: 40px; height: 40px; display: flex; align-items: center; justify-content: center; cursor: pointer; font-size: 18px; transition: background 0.2s; }
                            .swal-nav-btn:hover { background: #0056b3; }
                            .swal-nav-btn:focus { outline: 2px solid #0056b3; outline-offset: 2px; }
                            .swal-image-counter { font-weight: 500; color: #666; }
                            .swal-no-focus { outline: none !important; }
                            .swal2-popup { outline: none !important; }
                            .swal-close-custom { outline: 2px solid #007bff !important; outline-offset: 2px !important; }
                            .swal-close-custom:focus { outline: 2px solid #0056b3 !important; }
                        </style>
                    ` : '',
                    didOpen: (popup) => {
                        // Keyboard navigation
                        document.addEventListener('keydown', handleSwalKeydown);
                        
                        // Focus management
                        popup.setAttribute('tabindex', '-1');
                        popup.focus();
                        
                        // Prevent focus issues
                        const closeButton = popup.querySelector('.swal2-close');
                        if (closeButton) {
                            closeButton.setAttribute('tabindex', '0');
                        }
                    },
                    willClose: () => {
                        // Remove keyboard listener
                        document.removeEventListener('keydown', handleSwalKeydown);
                    }
                });
            }

            function handleSwalKeydown(e) {
                if (currentImages.length <= 1) return;
                
                switch(e.keyCode) {
                    case 37: // Left arrow
                        showPrevImageSwal();
                        break;
                    case 39: // Right arrow
                        showNextImageSwal();
                        break;
                }
            }

            // Global functions for SweetAlert navigation
            window.showPrevImageSwal = function() {
                if (currentImages.length > 1) {
                    currentImageIndex = (currentImageIndex - 1 + currentImages.length) % currentImages.length;
                    showImageGallery();
                }
            };

            window.showNextImageSwal = function() {
                if (currentImages.length > 1) {
                    currentImageIndex = (currentImageIndex + 1) % currentImages.length;
                    showImageGallery();
                }
            };
        });
    </script>
@endsection