@extends('layouts.app')
@section('style')
    <link href="{{ asset('assets/plugins/notifications/css/lobibox.min.css') }}" rel="stylesheet" />
    <style>
        .offcanvas-container {
            display: flex;
            flex-direction: row;
        }
        .offcanvas-half {
            flex: 1;
            padding: 15px;
        }
        .offcanvas-half img {
            max-width: 100%;
            height: auto;
        }
    </style>
@endsection
@section('wrapper')
<div class="page-wrapper">
    <div class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">{{__('Task Proofs')}}</div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="{{ url('/home') }}"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{__('Proofs')}}</li>
                    </ol>
                </nav>
            </div>
            <div class="ms-auto">
                <div class="btn-group">
                    <button type="button" class="btn btn-primary">{{__('Actions')}}</button>
                    <button type="button" class="btn btn-primary split-bg-primary dropdown-toggle dropdown-toggle-split" data-bs-toggle="dropdown"> <span class="visually-hidden">Toggle Dropdown</span></button>
                    <div class="dropdown-menu dropdown-menu-right dropdown-menu-lg-end">
                        <a class="dropdown-item" href="{{ route('task.proofs.denied') }}">{{__('Denied Task Proofs')}}</a>
                        <div class="dropdown-divider"></div>
                        <a class="dropdown-item" href="{{ route('task.proofs.denied') }}">{{__('Approved Task Proof')}}</a>
                        <div class="dropdown-divider"></div>
                    </div>
                </div>
            </div>
        </div>
        <!--end breadcrumb-->

        <!-- Alert Container -->
        <div id="alert-container"></div>

        <div class="card">
            <div class="card-body">
                <div class="d-lg-flex align-items-center mb-4 gap-3">
                    <div class="position-relative">
                        <input type="text" class="form-control ps-5 radius-30" placeholder="{{__('Search Proofs')}}">
                        <span class="position-absolute top-50 product-show translate-middle-y"><i class="bx bx-search"></i></span>
                    </div>
                </div>
                <div class="table-responsive">
                    @include('taskProofs.proofs_table')
                </div>
            </div>
        </div>

        <!-- Offcanvas -->
        <div class="offcanvas offcanvas-end" tabindex="-1" id="proofsOffcanvas" aria-labelledby="proofsOffcanvasLabel" style="width: 50%;">
            <div class="offcanvas-header">
                <h5 class="offcanvas-title" id="proofsOffcanvasLabel">{{__('Proof Details')}}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
            </div>
            <div class="offcanvas-body">
                <div class="offcanvas-container">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="offcanvas-half">
                                <div id="proof-details">
                                    <!-- Kanıt detayları buraya yüklenecek -->
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="offcanvas-half">
                                <h5 class="offcanvas-title" id="proofsOffcanvasLabel">{{__('Proof Images')}}</h5>
                                <div id="proof-images">
                                    <!-- Kanıt resimleri buraya yüklenecek -->
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div id="proof-user">
                                <h5 class="offcanvas-title" id="proofsOffcanvasLabel">{{__('Proof User')}}</h5>
                                <!-- Kanıtı yükleyen kullanıcı adı buraya yüklenecek -->
                            </div>
                        </div>
                    </div>
                </div>

                <button type="button" class="btn btn-success mt-3" id="approve-proof">{{__('Approve')}}</button>
                <button type="button" class="btn btn-danger mt-3" id="deny-proof">{{__('Deny')}}</button>
            </div>
        </div>
    </div>
</div>

<!-- Deny Reason Modal -->
<div class="modal fade" id="denyReasonModal" tabindex="-1" aria-labelledby="denyReasonModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="denyReasonModalLabel">{{ __('Reason for Refusal') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <textarea class="form-control" id="denyReasonInput" rows="4" maxlength="190" placeholder="{{ __('Please enter the reason for refusal...') }}"></textarea>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button>
                <button type="button" class="btn btn-danger" id="confirmDenyProof">{{ __('Deny') }}</button>
            </div>
        </div>
    </div>
</div>

<!-- Image Modal -->
<div class="modal fade" id="imageModal" tabindex="-1" aria-labelledby="imageModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="imageModalLabel">{{ __('Proof Image') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body text-center">
                <img id="modalImage" src="" alt="{{ __('Proof Image') }}" class="img-fluid">
            </div>
        </div>
    </div>
</div>
@endsection

@section('script')
    <script src="{{ asset('assets/plugins/notifications/js/lobibox.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/notifications/js/notifications.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/notifications/js/notification-custom-script.js') }}"></script>
    @if (session('success'))
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            Lobibox.notify('success', {
                pauseDelayOnHover: true,
                size: 'mini',
                rounded: true,
                icon: 'bx bx-check-circle',
                delayIndicator: false,
                continueDelayOnInactiveTab: false,
                position: 'top right',
                msg: '{{ session('success') }}'
            });
        });
    </script>
    @endif
    <script>document.addEventListener('DOMContentLoaded', function() {
        const routes = {
            show: "{{ route('proofs.show', ':id') }}",
            approve: "{{ route('proofs.approve', ':id') }}",
            deny: "{{ route('proofs.deny', ':id') }}",
            getTable: "{{ route('proofs.table') }}"
        };

        let selectedProofId = null;

        document.querySelectorAll('.view-proof-btn').forEach(button => {
            button.addEventListener('click', function() {
                selectedProofId = this.getAttribute('data-proof-id');
                fetchProofDetails(selectedProofId);
                var offcanvas = new bootstrap.Offcanvas(document.getElementById('proofsOffcanvas'));
                offcanvas.show();
            });
        });

        document.getElementById('approve-proof').addEventListener('click', function() {
            updateProofStatus(selectedProofId, 'approve'); // Approve
        });

        document.getElementById('deny-proof').addEventListener('click', function() {
            var denyReasonModal = new bootstrap.Modal(document.getElementById('denyReasonModal'));
            denyReasonModal.show();
        });

        document.getElementById('confirmDenyProof').addEventListener('click', function() {
            var reason = document.getElementById('denyReasonInput').value.trim();
            if (!reason) {
                Lobibox.notify('error', {
                    pauseDelayOnHover: true,
                    size: 'mini',
                    rounded: true,
                    icon: 'bx bx-error',
                    delayIndicator: false,
                    continueDelayOnInactiveTab: false,
                    position: 'top right',
                    msg: "{{__('Reason for refusal is mandatory!')}}"
                });
                return;
            }
            if (reason.length > 190) {
                Lobibox.notify('error', {
                    pauseDelayOnHover: true,
                    size: 'mini',
                    rounded: true,
                    icon: 'bx bx-error',
                    delayIndicator: false,
                    continueDelayOnInactiveTab: false,
                    position: 'top right',
                    msg: "{{__('Reason for refusal can not be more than 190 characters!')}}"
                });
                return;
            }
            updateProofStatus(selectedProofId, 'deny', reason);
            var denyReasonModal = bootstrap.Modal.getInstance(document.getElementById('denyReasonModal'));
            denyReasonModal.hide();
        });

        function fetchProofDetails(proofId) {
            const url = routes.show.replace(':id', proofId);
            fetch(url)
                .then(response => response.json())
                .then(data => {
                    document.getElementById('proof-details').innerHTML = data.detailsHtml;
                    document.getElementById('proof-images').innerHTML = data.imagesHtml;
                    document.getElementById('proof-user').innerHTML = data.userHtml;

                    document.querySelectorAll('.proof-image').forEach(img => {
                        img.addEventListener('click', function() {
                            const imageUrl = this.getAttribute('data-image');
                            document.getElementById('modalImage').src = imageUrl;
                        });
                    });
                });
        }

        function updateProofStatus(proofId, action, reason = null) {
    const url = action === 'approve' ? routes.approve.replace(':id', proofId) : routes.deny.replace(':id', proofId);
    const payload = {
        status: action === 'approve' ? 1 : 2,
        reason: reason
    };
    fetch(url, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '{{ csrf_token() }}'
        },
        body: JSON.stringify(payload)
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            const notificationType = action === 'approve' ? 'success' : 'warning';
            Lobibox.notify(notificationType, {
                pauseDelayOnHover: true,
                size: 'mini',
                rounded: true,
                icon: 'bx bx-check-circle',
                delayIndicator: false,
                continueDelayOnInactiveTab: false,
                position: 'top right',
                msg: data.message
            });
            removeProofRow(proofId);

            // Offcanvas'ı kapat
            var offcanvas = bootstrap.Offcanvas.getInstance(document.getElementById('proofsOffcanvas'));
            offcanvas.hide();
        } else {
            showAlert('danger', data.message);
        }
    })
    .catch(error => {
        showAlert('danger', "{{__('An error occurred while updating the proof status.')}}");
    });
}

        function removeProofRow(proofId) {
            const row = document.querySelector(`tr[data-proof-id="${proofId}"]`);
            if (row) {
                row.remove();
            }
            checkIfTableEmpty();
        }

        function checkIfTableEmpty() {
            const tableBody = document.querySelector('.table-responsive tbody');
            if (!tableBody || tableBody.rows.length === 0) {
                document.querySelector('.table-responsive').innerHTML = '<div class="alert alert-warning">{{__("No proof found.")}}</div>';
            }
        }

        function showAlert(type, message) {
            const alertContainer = document.getElementById('alert-container');
            const alertHTML = `
                <div class="alert alert-${type} alert-dismissible fade show" role="alert">
                    ${message}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            `;
            alertContainer.innerHTML = alertHTML;
        }


    });

    </script>
@endsection
