<table class="table mb-0">
    <thead class="table-light">
        <tr>
            <th>ID#</th>
            <th>{{__('Task Name')}}</th>
            <th>{{__('Platform')}}</th>
            <th>{{__('Profit')}}</th>
            <th>{{__('Added by')}}</th>
            <th>{{__('Proof Number')}}</th>
            <th>{{__('Added Time')}}</th>
            <th>{{__('Status')}}</th>
            <th>{{__('Details')}}</th>
            <th>{{__('Actions')}}</th>
        </tr>
    </thead>
    <tbody>
        @php
            $proofsExist = false;
        @endphp

        @foreach ($tasks as $task)
            @foreach ($task->taskProofs as $proof)
                @php
                    $proofsExist = true;
                @endphp
                <tr data-proof-id="{{ $proof->id }}">
                    <td>#{{ $proof->id }}</td>
                    <td>
                        <div class="chip chip-md">
                            <img src="/assets/images/tasks/{{ $task->image }}" alt="{{ $task->name }}">{{ $task->name }}
                        </div>
                    </td>
                    <td>
                        <div class="chip chip-md">
                            <img src="/assets/images/app/{{ $task->socialPlatform->icon }}" alt="{{ $task->socialPlatform->platform }}">{{ $task->socialPlatform->platform }}
                        </div>
                    </td>
                    <td>{{ number_format($task->reward, 2, ',', '.') }}{{ $settings['currency'] }}</td>
                    <td>{{ $proof->proofUser ? $proof->proofUser->account_holder : __('Unknown User') }}</td>
                    <td>{{ $proof->proof_count }}</td>
                    <td>{{ $proof->created_at }}</td>
                    <td>{{ $proof->status == 0 ? __('Waiting') : ($proof->status == 1 ? __('Confirmed') : __('Denied')) }}</td>
                    <td>
                        <button type="button" class="btn btn-primary btn-sm radius-30 px-4 view-proof-btn" data-proof-id="{{ $proof->id }}">{{__('View Proofs')}}</button>
                    </td>
                    <td>
                        <div class="d-flex order-actions">
                            <a href="javascript:;" class=""><i class='bx bxs-edit'></i></a>
                            <a href="javascript:;" class="ms-3"><i class='bx bxs-trash'></i></a>
                        </div>
                    </td>
                </tr>
            @endforeach
        @endforeach

        @if (!$proofsExist)
            <tr>
                <td colspan="10" class="text-center">{{ __('No proof found.') }}</td>
            </tr>
        @endif
    </tbody>
</table>