@extends('layouts.app')

@section('style')
    <link href="{{ asset('assets/plugins/notifications/css/lobibox.min.css') }}" rel="stylesheet" />
    <style>
        .task-card {
            border: 1px solid #e9ecef;
            border-radius: 12px;
            transition: all 0.3s ease;
            background: white;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
            margin-bottom: 20px;
        }
        .task-card:hover {
            box-shadow: 0 8px 25px rgba(0,0,0,0.15);
            transform: translateY(-2px);
        }
        .task-image {
            width: 80px;
            height: 80px;
            border-radius: 12px;
            object-fit: cover;
            border: 2px solid #f8f9fa;
        }
        .platform-icon {
            width: 40px;
            height: 40px;
            border-radius: 8px;
            object-fit: cover;
        }
        .status-badge {
            font-size: 0.75rem;
            padding: 6px 12px;
            border-radius: 20px;
            font-weight: 600;
        }
        .reward-badge {
            background: linear-gradient(45deg, #28a745, #20c997);
            color: white;
            padding: 8px 15px;
            border-radius: 20px;
            font-weight: 600;
            font-size: 0.9rem;
        }
        .tab-content {
            margin-top: 20px;
        }
        .nav-tabs .nav-link {
            border-radius: 12px 12px 0 0;
            font-weight: 600;
            color: #6c757d;
            border: none;
            background: #f8f9fa;
            margin-right: 5px;
        }
        .nav-tabs .nav-link.active {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
        }
        .empty-state {
            text-align: center;
            padding: 60px 20px;
            color: #6c757d;
        }
        .empty-state i {
            font-size: 4rem;
            margin-bottom: 20px;
            opacity: 0.5;
        }
        .creator-info {
            display: flex;
            align-items: center;
            gap: 8px;
            font-size: 0.85rem;
            color: #6c757d;
        }
        .creator-avatar {
            width: 24px;
            height: 24px;
            border-radius: 50%;
            background: linear-gradient(45deg, #667eea, #764ba2);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: bold;
            font-size: 0.7rem;
        }
        
        /* Mobile Responsive */
        @media (max-width: 768px) {
            .task-card {
                margin-bottom: 15px;
            }
            .task-image {
                width: 60px;
                height: 60px;
            }
            .platform-icon {
                width: 30px;
                height: 30px;
            }
            .reward-badge {
                font-size: 0.8rem;
                padding: 6px 12px;
            }
            .nav-tabs .nav-link {
                font-size: 0.85rem;
                padding: 8px 12px;
            }
        }
        
        @media (max-width: 576px) {
            .task-card .row {
                flex-direction: column;
            }
            .task-image {
                width: 100%;
                height: 150px;
                margin-bottom: 15px;
            }
            .nav-tabs {
                flex-direction: column;
            }
            .nav-tabs .nav-link {
                margin-right: 0;
                margin-bottom: 5px;
                text-align: center;
            }
        }
    </style>
@endsection

@section('wrapper')
<div class="page-wrapper">
    <div class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">{{ __('Tasks') }}</div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{ __('Deleted Tasks') }}</li>
                    </ol>
                </nav>
            </div>
        </div>
        <!--end breadcrumb-->

        <!-- Page Header -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <h4 class="mb-1">{{ __('Deleted Tasks') }}</h4>
                                <p class="mb-0 text-muted">{{ __('View all inactive and deleted tasks') }}</p>
                            </div>
                            <div class="d-flex gap-2">
                                <span class="badge bg-danger">{{ __('Inactive') }}</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Tabs Navigation -->
        <div class="row">
            <div class="col-12">
                <ul class="nav nav-tabs" id="taskTabs" role="tablist">
                    <li class="nav-item" role="presentation">
                        <button class="nav-link active" id="social-tab" data-bs-toggle="tab" data-bs-target="#social" type="button" role="tab">
                            <i class="bx bx-share-alt me-2"></i>{{ __('Social Media Tasks') }} 
                            <span class="badge bg-light text-dark ms-2">{{ count($socialTasks) }}</span>
                        </button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="website-tab" data-bs-toggle="tab" data-bs-target="#website" type="button" role="tab">
                            <i class="bx bx-globe me-2"></i>{{ __('Website Visit Tasks') }} 
                            <span class="badge bg-light text-dark ms-2">{{ count($websiteTasks) }}</span>
                        </button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="youtube-tab" data-bs-toggle="tab" data-bs-target="#youtube" type="button" role="tab">
                            <i class="bx bx-play-circle me-2"></i>{{ __('YouTube Watch Tasks') }} 
                            <span class="badge bg-light text-dark ms-2">{{ count($watchTasks) }}</span>
                        </button>
                    </li>
                </ul>
            </div>
        </div>

        <!-- Tab Content -->
        <div class="tab-content" id="taskTabContent">
            <!-- Social Media Tasks Tab -->
            <div class="tab-pane fade show active" id="social" role="tabpanel">
                @if(count($socialTasks) > 0)
                    @foreach($socialTasks as $task)
                        <div class="task-card p-4">
                            <div class="row align-items-center">
                                <div class="col-md-2 col-sm-3 text-center">
                                    @if($task->image)
                                        <img src="{{ asset('assets/images/tasks/' . $task->image) }}" 
                                             alt="{{ $task->name }}" class="task-image">
                                    @else
                                        <div class="task-image d-flex align-items-center justify-content-center bg-light">
                                            <i class="bx bx-image text-muted" style="font-size: 2rem;"></i>
                                        </div>
                                    @endif
                                </div>
                                <div class="col-md-6 col-sm-9">
                                    <div class="d-flex align-items-center mb-2">
                                        @if($task->socialPlatform)
                                            <img src="{{ asset('assets/images/app/' . $task->socialPlatform->icon) }}" 
                                                 alt="{{ $task->socialPlatform->platform }}" class="platform-icon me-2">
                                            <span class="badge bg-primary me-2">{{ $task->socialPlatform->platform }}</span>
                                        @endif
                                        <span class="status-badge bg-danger text-white">{{ __('Inactive') }}</span>
                                    </div>
                                    <h5 class="mb-2">{{ $task->name }}</h5>
                                    <p class="text-muted mb-2">{{ Str::limit($task->description, 100) }}</p>
                                    <div class="creator-info">
                                        <div class="creator-avatar">
                                            {{ substr($task->creator->account_holder ?? 'U', 0, 1) }}
                                        </div>
                                        <span>{{ __('Created by') }}: {{ $task->creator->account_holder ?? __('Unknown') }}</span>
                                    </div>
                                </div>
                                <div class="col-md-2 text-center">
                                    <div class="reward-badge">
                                        {{ number_format($task->reward, 2) }} ₺
                                    </div>
                                </div>
                                <div class="col-md-2 text-center">
                                    <small class="text-muted">{{ __('Updated') }}: {{ $task->updated_at->format('d.m.Y') }}</small>
                                </div>
                            </div>
                        </div>
                    @endforeach
                @else
                    <div class="empty-state">
                        <i class="bx bx-share-alt"></i>
                        <h4>{{ __('No deleted social media tasks') }}</h4>
                        <p>{{ __('There are no inactive social media tasks at the moment.') }}</p>
                    </div>
                @endif
            </div>

            <!-- Website Visit Tasks Tab -->
            <div class="tab-pane fade" id="website" role="tabpanel">
                @if(count($websiteTasks) > 0)
                    @foreach($websiteTasks as $task)
                        <div class="task-card p-4">
                            <div class="row align-items-center">
                                <div class="col-md-2 col-sm-3 text-center">
                                    <div class="task-image d-flex align-items-center justify-content-center bg-light">
                                        <i class="bx bx-globe text-primary" style="font-size: 2.5rem;"></i>
                                    </div>
                                </div>
                                <div class="col-md-6 col-sm-9">
                                    <div class="d-flex align-items-center mb-2">
                                        <span class="badge bg-info me-2">{{ __('Website Visit') }}</span>
                                        <span class="status-badge bg-danger text-white">{{ __('Inactive') }}</span>
                                    </div>
                                    <h5 class="mb-2">{{ $task->title }}</h5>
                                    <p class="text-muted mb-2">{{ Str::limit($task->description, 100) }}</p>
                                    <div class="mb-2">
                                        <small class="text-muted">{{ __('URL') }}: </small>
                                        <a href="{{ $task->website_url }}" target="_blank" class="text-decoration-none">
                                            {{ Str::limit($task->website_url, 50) }}
                                        </a>
                                    </div>
                                    <div class="creator-info">
                                        <div class="creator-avatar">
                                            {{ substr($task->creator->account_holder ?? 'U', 0, 1) }}
                                        </div>
                                        <span>{{ __('Created by') }}: {{ $task->creator->account_holder ?? __('Unknown') }}</span>
                                    </div>
                                </div>
                                <div class="col-md-2 text-center">
                                    <div class="reward-badge">
                                        {{ number_format($task->reward_amount, 2) }} ₺
                                    </div>
                                </div>
                                <div class="col-md-2 text-center">
                                    <small class="text-muted">{{ __('Updated') }}: {{ $task->updated_at->format('d.m.Y') }}</small>
                                </div>
                            </div>
                        </div>
                    @endforeach
                @else
                    <div class="empty-state">
                        <i class="bx bx-globe"></i>
                        <h4>{{ __('No deleted website visit tasks') }}</h4>
                        <p>{{ __('There are no inactive website visit tasks at the moment.') }}</p>
                    </div>
                @endif
            </div>

            <!-- YouTube Watch Tasks Tab -->
            <div class="tab-pane fade" id="youtube" role="tabpanel">
                @if(count($watchTasks) > 0)
                    @foreach($watchTasks as $task)
                        <div class="task-card p-4">
                            <div class="row align-items-center">
                                <div class="col-md-2 col-sm-3 text-center">
                                    <div class="task-image d-flex align-items-center justify-content-center bg-light">
                                        <i class="bx bx-play-circle text-danger" style="font-size: 2.5rem;"></i>
                                    </div>
                                </div>
                                <div class="col-md-6 col-sm-9">
                                    <div class="d-flex align-items-center mb-2">
                                        <span class="badge bg-danger me-2">{{ __('YouTube Watch') }}</span>
                                        <span class="status-badge bg-danger text-white">{{ __('Inactive') }}</span>
                                    </div>
                                    <h5 class="mb-2">{{ $task->title }}</h5>
                                    <p class="text-muted mb-2">{{ Str::limit($task->description, 100) }}</p>
                                    <div class="mb-2">
                                        <small class="text-muted">{{ __('Duration') }}: </small>
                                        <span class="badge bg-secondary">{{ $task->formatted_duration }}</span>
                                        <small class="text-muted ms-3">{{ __('Video ID') }}: </small>
                                        <code>{{ $task->youtube_video_id }}</code>
                                    </div>
                                    <div class="creator-info">
                                        <div class="creator-avatar">
                                            {{ substr($task->creator->account_holder ?? 'U', 0, 1) }}
                                        </div>
                                        <span>{{ __('Created by') }}: {{ $task->creator->account_holder ?? __('Unknown') }}</span>
                                    </div>
                                </div>
                                <div class="col-md-2 text-center">
                                    <div class="reward-badge">
                                        {{ number_format($task->reward_amount, 2) }} ₺
                                    </div>
                                </div>
                                <div class="col-md-2 text-center">
                                    <small class="text-muted">{{ __('Updated') }}: {{ $task->updated_at->format('d.m.Y') }}</small>
                                </div>
                            </div>
                        </div>
                    @endforeach
                @else
                    <div class="empty-state">
                        <i class="bx bx-play-circle"></i>
                        <h4>{{ __('No deleted YouTube watch tasks') }}</h4>
                        <p>{{ __('There are no inactive YouTube watch tasks at the moment.') }}</p>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection

@section('script')
    <script src="{{ asset('assets/plugins/notifications/js/lobibox.min.js') }}"></script>
    <script>
        // Tab switching with URL hash support
        document.addEventListener('DOMContentLoaded', function() {
            // Check if there's a hash in URL
            const hash = window.location.hash;
            if (hash) {
                const tabButton = document.querySelector(`button[data-bs-target="${hash}"]`);
                if (tabButton) {
                    const tab = new bootstrap.Tab(tabButton);
                    tab.show();
                }
            }

            // Update URL hash when tab changes
            const tabButtons = document.querySelectorAll('#taskTabs button[data-bs-toggle="tab"]');
            tabButtons.forEach(button => {
                button.addEventListener('shown.bs.tab', function(e) {
                    const target = e.target.getAttribute('data-bs-target');
                    window.location.hash = target;
                });
            });
        });

        // Responsive tab handling for mobile
        function handleMobileView() {
            const isMobile = window.innerWidth <= 576;
            const tabContainer = document.getElementById('taskTabs');
            
            if (isMobile) {
                tabContainer.classList.add('flex-column');
            } else {
                tabContainer.classList.remove('flex-column');
            }
        }

        // Call on load and resize
        window.addEventListener('load', handleMobileView);
        window.addEventListener('resize', handleMobileView);
    </script>
@endsection