@extends("layouts.app")
@section("style")
	<link href="{{ ('assets/plugins/notifications/css/lobibox.min.css') }}" rel="stylesheet">
	<link href="assets/plugins/Drag-And-Drop/dist/imageuploadify.min.css" rel="stylesheet">
	@endsection
@section("wrapper")
<div class="page-wrapper">
    <div class="page-content">

        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">{{__('Tasks')}}</div>


            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="{{ route('task.index') }}"><i class="bx bx-home-alt"></i></a>
                        </li>
                        <li class="breadcrumb-item"><a href="{{ route('tasks.list') }}"><i class="bx bx-home-alt"></i>{{__('Task List')}}</a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">{{__('Task Details')}}</li>
                    </ol>
                </nav>
            </div>
            <div class="ms-auto">
            <button type="button" class="btn btn-danger px-5" onclick="history.back()"><i class="fadeIn animated bx bx-arrow-back"></i>{{__('Back')}}</button>
            </div>
        </div>
        <!--end breadcrumb-->

        @if($response['IsoCode'] != $task->city && $task->city != 0)
        <div class="alert alert-danger border-0 bg-danger alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="font-35 text-white"><i class="bx bxs-message-square-x"></i>
                </div>
                <div class="ms-3">
                    <h6 class="mb-0 text-white">{{__('Warning')}}</h6>
                    <div class="text-white">{{__('You are not in the city of the mission, you cannot do this mission.')}}</div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @else
         <div class="card">
            <div class="row g-0">
              <div class="col-md-3 border-end">
                <img src="{{ asset('assets/images/tasks/' . $task->image) }}" class="rounded-circle p-1 border" width="350" alt="{{$task->name}}">

              </div>
              <div class="col-md-9">
                <div class="card-body">
                  <h4 class="card-title">{{$task->name}}</h4>
                  <div class="d-flex gap-3 py-3">

                      <div class="text-success"><i class="bx bxs-cart-alt align-middle"></i>{{__('Inventory')}}: {{ $ProofCount }}/{{$task->limit}}</div>
                  </div>
                  <div class="mb-3">
                    <span class="price h4">{{__('Profit')}}: {{ number_format($task->reward, 2, ',', '.') }}{{ $settings['currency'] }}</span>

                </div>
                <hr>
                <div class="chip">
                    <img src="{{ asset('assets/images/app/' . $task->PlatformIcon) }}" alt="{{ $task->PlatformDescription }}">{{__('Platform')}}: {{ $task->PlatformName }}
                </div>
                <hr>
                <span class="price h5">{{__('Task Description')}}:</span>
                  <p class="card-text fs-6">{{$task->description}}</p>

                  <hr>
                  <div class="chip">
                    <img src="{{ asset('assets/images/avatars/' . $task->UserAvatar) }}" alt="{{__('Added by')}}">{{__('Added by')}}: {{ $task->UserName }}
                </div>
                <div class="chip chip-lg bg-primary text-white">{{__('Limits')}}: {{__('Daily')}} {{ $task->daily_limit }}  {{__('Total')}} {{ $task->limit }}
                </div>
                <div class="chip chip-lg bg-secondary text-white">{{__('Location')}}: @if($task->CountryName == 0 || $task->CityName == 0)
                    {{__('All')}}
                @else
                    {{ $task->CountryName }}/{{ $task->CityName }}
                @endif

                </div>
                <hr>
                <div class="card-title">
                    <h5 class="mb-0">{{__('Completed')}}</h5>
                </div>
@php
$completedCount = $task->proofs->isNotEmpty() ? $task->proofs->first()->total : 0;
$completionPercentage = $task->limit > 0 ? ($completedCount / $task->limit * 100) : 0;
@endphp

<div class="progress">
<div class="progress-bar" role="progressbar" style="width: {{ $completionPercentage }}%;" aria-valuenow="{{ $completionPercentage }}" aria-valuemin="0" aria-valuemax="100">
{{ number_format($completionPercentage, 2) }}%
</div>
</div>
<hr>
                  <div class="row row-cols-auto row-cols-1 row-cols-md-1 align-items-center">
                    <form id="proofSubmitForm" enctype="multipart/form-data"{{ isset($task->is_pending) && $task->is_pending ? ' disabled' : '' }}>
                        @csrf
                        <input type="hidden" name="id" value="{{ $task->id }}">
                        <div class="col">
                            <label class="form-label">{{__('Have you completed the task? Submit your proof, let our team evaluate it and earn your reward! Supported image formats > png, jpg, jpeg')}}</label>
                            <div class="row">
                                <div class="col-xl-9 mx-auto">
                                    <h6 class="mb-0 text-uppercase">{{ __('upload_task_proofs', ['number' => $task->proof_number]) }}</h6>
                                    <hr/>
                                    <div class="card">
                                        <div class="card-body">
                                            @for ($i = 1; $i <= $task->proof_number; $i++)
                                                <div class="form-group">
                                                    <label for="proof{{$i}}">{{__('Proof')}} {{$i}}</label>
                                                    <input class="form-control" type="file" id="proof{{$i}}" name="proofs[]"{{ $pendingProof ? ' disabled' : '' }}>
                                                </div>
                                            @endfor
                                            <div class="form-group">
                                                <label for="proof_comment">{{__('Comment')}}</label>
                                                <textarea class="form-control" id="proof_comment" name="Description"{{ $pendingProof ? ' disabled' : '' }}></textarea>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="d-flex gap-3 mt-3">
                            <a href="{{ $task->link }}" target="_blank" title="{{ $task->name }}" class="btn btn-primary">{{__('Go To Task')}}</a>
                            <button type="submit" id="submitProofBtn" class="btn btn-outline-success"{{ $pendingProof ? ' disabled' : '' }}>
                                <span class="btn-text">{{ __('Complete Task') }}</span>
                                <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                            </button>
                        </div>
                    </form>

                </div>

                </div>
              </div>
            </div>
            <hr>


          </div>

    </div>
</div>
@endif

@endsection

@section("script")
	<!--notification js -->
    <script src="{{ asset('assets/plugins/notifications/js/lobibox.min.js')  }}"></script>
	<script src="{{ asset('assets/plugins/notifications/js/notifications.min.js')  }}"></script>
	<script src="{{ asset('assets/plugins/notifications/js/notification-custom-script.js')  }}"></script>
    <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
 
    @if($pendingProof)
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            Swal.fire({
                icon: 'warning',
                title: "{{__('Unconfirmed Proof')}}",
                text: "{{__('You have a proof for this task that has not yet been approved. Please wait until the evidence is approved.')}}",
                confirmButtonText: "{{__('OK')}}"
            });
        });
    </script>
    @endif

    <script>
        $(document).ready(function() {
            $('#proofSubmitForm').on('submit', function(e) {
                e.preventDefault();
                
                const form = this;
                const formData = new FormData(form);
                const submitBtn = $('#submitProofBtn');
                const btnText = submitBtn.find('.btn-text');
                const spinner = submitBtn.find('.spinner-border');
                
                // Dosya kontrolü
                const proofFiles = $('input[name="proofs[]"]');
                let hasFiles = false;
                proofFiles.each(function() {
                    if (this.files.length > 0) {
                        hasFiles = true;
                        return false;
                    }
                });
                
                if (!hasFiles) {
                    Lobibox.notify('error', {
                        pauseDelayOnHover: true,
                        continueDelayOnInactiveTab: false,
                        position: 'top right',
                        icon: 'bx bx-x-circle',
                        msg: "{{__('Please upload at least one proof file.')}}"
                    });
                    return;
                }
                
                // Button durumunu değiştir
                submitBtn.prop('disabled', true);
                btnText.text("{{__('Submitting...')}}");
                spinner.removeClass('d-none');
                
                $.ajax({
                    url: "{{ route('task.proofSubmit') }}",
                    type: 'POST',
                    data: formData,
                    processData: false,
                    contentType: false,
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function(response) {
                        if (response.success) {
                            Lobibox.notify('success', {
                                pauseDelayOnHover: true,
                                continueDelayOnInactiveTab: false,
                                position: 'top right',
                                icon: 'bx bx-check-circle',
                                msg: response.message
                            });
                            
                            // Formu temizle
                            form.reset();
                            
                            // Sayfayı 2 saniye sonra yenile
                            setTimeout(function() {
                                location.reload();
                            }, 2000);
                        } else {
                            Lobibox.notify('error', {
                                pauseDelayOnHover: true,
                                continueDelayOnInactiveTab: false,
                                position: 'top right',
                                icon: 'bx bx-x-circle',
                                msg: response.message
                            });
                        }
                    },
                    error: function(xhr, status, error) {
                        let errorMessage = "{{__('An error occurred while submitting your proof. Please try again.')}}";
                        
                        if (xhr.responseJSON && xhr.responseJSON.message) {
                            errorMessage = xhr.responseJSON.message;
                        }
                        
                        Lobibox.notify('error', {
                            pauseDelayOnHover: true,
                            continueDelayOnInactiveTab: false,
                            position: 'top right',
                            icon: 'bx bx-x-circle',
                            msg: errorMessage
                        });
                    },
                    complete: function() {
                        // Button durumunu eski haline getir
                        submitBtn.prop('disabled', false);
                        btnText.text("{{__('Complete Task')}}");
                        spinner.addClass('d-none');
                    }
                });
            });
        });
    </script>
@endsection
