@extends("layouts.app")
@section("style")
	<link href="{{ ('assets/plugins/notifications/css/lobibox.min.css') }}" rel="stylesheet" />
	@endsection
@section("wrapper")
<div class="page-wrapper">
    <div class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">{{__('Tasks')}}</div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="/"><i class="bx bx-home-alt"></i></a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                            <button type="button" class="btn btn-success position-relative me-lg-5"> <i class="fadeIn animated bx bx-task align-middle"></i> {{__('Task List')}} <span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-dark">{{ $tasks->count() }} <span class="visually-hidden">unread messages</span></span>
                            </button> 
                         </li>
                    </ol>
                </nav>
            </div>
            <div class="ms-auto">
            <button type="button" class="btn btn-danger px-5" onclick="history.back()"><i class="fadeIn animated bx bx-arrow-back"></i>{{__('Back')}}</button>
            </div>
        </div>
       
        <!--end breadcrumb-->
        <div class="row row-cols-1 row-cols-lg-2 row-cols-xl-4">
@if($tasks->isNotEmpty())
@foreach ($tasks as $task)
<div class="col">
    <div class="card radius-15">
        <div class="card-body text-center">
            <div class="p-4 border radius-15">
                <img src="{{ asset('assets/images/tasks/' . $task->image) }}" width="110" height="110" class="rounded-circle shadow" alt="{{ $task->name }}">
                <h5 class="mb-0 mt-5">{{ $task->name }}</h5>
               
                <div class="app-name">
                        <div class="chip">
                        <img src="{{ asset('assets/images/app/' . $task->PlatformIcon) }}" alt="{{ $task->PlatformDescription }}">{{__('Platform')}}: {{ $task->PlatformName }}
                    </div>
                    
             
                    <div class="chip chip-lg bg-danger text-white">{{__('Your Earnings')}}: ({{ number_format($task->reward, 2, ',', '.') }}{{ $settings['currency'] }})
                    </div>
                    <div class="chip">
                        <img src="{{ asset('assets/images/avatars/' . $task->UserAvatar) }}" alt="{{__('Added by')}}">{{__('Added by')}}: {{ $task->UserName }}
                    </div>
                    <div class="chip chip-lg bg-primary text-white">{{__('Limits')}}: {{ $task->daily_limit }}/{{ $task->limit }}
                    </div>
                    <div class="chip chip-lg bg-secondary text-white">{{__('Location')}}: @if($task->CountryName == 0 || $task->CityName == 0)
                        {{__('All')}}
                    @else
                        {{ $task->CountryName }}/{{ $task->CityName }}
                    @endif
                    
                    </div>
                  
                </div>
                <div class="card-title">
                            <h5 class="mb-0">{{__('Completed')}}</h5>
                        </div>
@php
$completedCount = $task->proofs->isNotEmpty() ? $task->proofs->first()->total : 0;
$completionPercentage = $task->limit > 0 ? ($completedCount / $task->limit * 100) : 0;
@endphp

<div class="progress">
<div class="progress-bar" role="progressbar" style="width: {{ $completionPercentage }}%;" aria-valuenow="{{ $completionPercentage }}" aria-valuemin="0" aria-valuemax="100">
{{ number_format($completionPercentage, 2) }}%
</div>
</div>
           

                
<hr>
             <div class="row">
                <div class="col-md-6">
                    <form action="{{ route('task.info') }}" method="POST">
                        @csrf
                        <input type="hidden" name="id" value="{{ $task->id }}">
                        <button type="submit"  class="btn btn-outline-info">{{ __('Task Transactions') }}</button>
                    </form>
                   
                </div>
                <div class="col-md-6">
                    <button type="button" data-id="{{ $task->id }}" target="_blank" rel="noopener" title="{{ $task->name }}"  class="btn btn-outline-primary go-to-task" onclick="window.location.href = '{{  $task->link }}'">{{__('Go To Task')}}</button>
                   
                </div>
              
             </div>
            </div>
        </div>
    </div>
</div>
@endforeach
@else
<div class="col">
<p>{{__('No data found.')}}</p>
</div>
@endif

        
        
        </div>
        <!--end row-->
    </div>
</div>
@section("script")
	<!--notification js -->
    <script src="{{ asset('assets/plugins/notifications/js/lobibox.min.js')  }}"></script>
	<script src="{{ asset('assets/plugins/notifications/js/notifications.min.js')  }}"></script>
	<script src="{{ asset('assets/plugins/notifications/js/notification-custom-script.js')  }}"></script>
    <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            document.querySelectorAll('.go-to-task').forEach(button => {
                button.addEventListener('click', function() {
                    const taskId = this.getAttribute('data-id');
                    const url = '{{ route("tasks.checkPendingProof", ":id") }}'.replace(':id', taskId);

                    fetch(url, {
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': '{{ csrf_token() }}'
                        }
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.pending) {
                            Swal.fire({
                                icon: 'warning',
                                title: 'Onaylanmamış Kanıt',
                                text: 'Bu göreve ait henüz onaylanmamış bir kanıtınız var. Lütfen kanıt onaylanana kadar bekleyin.',
                                confirmButtonText: 'Tamam'
                            });
                        } else {
                            window.location.href = data.url;
                        }
                    });
                });
            });
        });
    </script>
    @if (session('success'))
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        Lobibox.notify('success', {
            pauseDelayOnHover: true,
            size: 'mini',
            rounded: true,
            icon: 'bx bx-check-circle',
            delayIndicator: false,
            continueDelayOnInactiveTab: false,
            position: 'top right',
            msg: '{{ session('success') }}'
        });
    });
    </script>
    @endif
    @endsection
@endsection