@extends("layouts.app")
@section("style")
	<link href="{{ ('assets/plugins/notifications/css/lobibox.min.css') }}" rel="stylesheet" />
	@endsection
@section("wrapper")
<div class="page-wrapper">
<div class="page-content">
				<!--breadcrumb-->
				<div class="page-breadcrumb d-sm-flex align-items-center mb-3">
					<div class="breadcrumb-title pe-3">{{__('Tasks')}}</div>
					<div class="ps-3">
						<nav aria-label="breadcrumb">
							<ol class="breadcrumb mb-0 p-0">
								<li class="breadcrumb-item"><a href="/"><i class="bx bx-home-alt"></i></a>
								</li>
								<li class="breadcrumb-item active" aria-current="page">
                                    <button type="button" class="btn btn-danger position-relative me-lg-5"> <i class="fadeIn animated bx bx-task-x align-middle"></i> {{__('Deleted Task List')}} <span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-dark">{{ $tasks->count() }} <span class="visually-hidden">unread messages</span></span>
                                </button></li>
							</ol>
						</nav>
					</div>
					<div class="ms-auto">
						<div class="btn-group">
							<button type="button" class="btn btn-primary">{{__('Transactions')}}</button>
							<button type="button" class="btn btn-primary split-bg-primary dropdown-toggle dropdown-toggle-split" data-bs-toggle="dropdown">	<span class="visually-hidden">Toggle Dropdown</span>
							</button>
							<div class="dropdown-menu dropdown-menu-right dropdown-menu-lg-end">	
                                 <a class="dropdown-item" href="javascript:;" data-bs-toggle="offcanvas" data-bs-target="#offcanvasAdd" aria-controls="offcanvasAdd">{{__('Add Task')}}</a>
                                 <a class="dropdown-item" href="{{ route('tasks.deleted') }}">{{__('Deleted Tasks')}}</a>
                               
                                 <a class="dropdown-item" href="javascript:;" onclick="round_error_noti()">{{__('Task Notifications')}}</a>
								<div class="dropdown-divider"></div>
                                <a class="dropdown-item" href="javascript:;">{{__('Rejected Notifications')}}</a>
								<div class="dropdown-divider"></div>
							</div>
						</div>
					</div>
				</div>
               
				<!--end breadcrumb-->
                <div class="row row-cols-1 row-cols-lg-2 row-cols-xl-4">
@if($tasks->isNotEmpty())
    @foreach ($tasks as $task)
        <div class="col">
            <div class="card radius-15">
                <div class="card-body text-center">
                    <div class="p-4 border radius-15">
                        <img src="assets/images/tasks/{{ $task->image }}" width="110" height="110" class="rounded-circle shadow" alt="{{ $task->name }}">
                        <h5 class="mb-0 mt-5">{{ $task->name }}</h5>
                       
                        <div class="app-name">
                                <div class="chip">
                                <img src="{{ asset('assets/images/app/' . $task->PlatformIcon) }}" alt="{{ $task->PlatformDescription }}">{{__('Platform')}}: {{ $task->PlatformName }}
                            </div>
                            @if($task->status == 0)
                            <div class="chip chip-lg bg-warning text-white">{{__('Task Status')}}: {{ __('Disable') }}</div>
                        @elseif($task->status == 1)
                        <div class="chip chip-lg bg-success text-white">{{__('Task Status')}}: {{ __('Activate') }}</div>
                            @elseif($task->status == 2)
                            <div class="chip chip-lg bg-info text-white">{{__('Task Status')}}: {{ __('Awaiting Approval') }}</div>
                            @elseif($task->status == 3)
                            <div class="chip chip-lg bg-danger text-white">{{__('Task Status')}}: {{ __('Deleted') }}</div>
                        @endif
                     

                            <div class="chip">
                                <img src="{{ asset('assets/images/avatars/' . $task->UserAvatar) }}" alt="{{__('Added by')}}">{{__('Added by')}}: {{ $task->UserName }}
                            </div>
                            <div class="chip chip-lg bg-primary text-white">{{__('Limits')}}: {{ $task->daily_limit }}/{{ $task->limit }}
                            </div>
                            <div class="chip chip-lg bg-secondary text-white">{{__('Location')}}: @if($task->CountryName == 0 || $task->CityName == 0)
                                {{__('All')}}
                            @else
                                {{ $task->CountryName }}/{{ $task->CityName }}
                            @endif
                            
                            </div>
                          
                        </div>
                        <div class="card-title">
									<h5 class="mb-0">{{__('Completed')}}</h5>
								</div>
@php
    $completedCount = $task->proofs->isNotEmpty() ? $task->proofs->first()->total : 0;
    $completionPercentage = $task->limit > 0 ? ($completedCount / $task->limit * 100) : 0;
@endphp

<div class="progress">
    <div class="progress-bar" role="progressbar" style="width: {{ $completionPercentage }}%;" aria-valuenow="{{ $completionPercentage }}" aria-valuemin="0" aria-valuemax="100">
        {{ number_format($completionPercentage, 2) }}%
    </div>
</div>
                        <div class="list-inline contacts-social mt-3 mb-3">
                            <button type="button" data-id="{{ $task->id }}" class="btn btn-outline-info edit-task-btn">{{__('Edit')}}</button>
                            @if($task->status == 0)
                            <button type="button" data-id="{{ $task->id }}" data-action="activate" class="btn btn-outline-primary task-action-btn">{{ __('Make Active') }}</button>
                        @elseif($task->status == 1)
                            <button type="button" data-id="{{ $task->id }}" data-action="disable" class="btn btn-outline-warning task-action-btn">{{ __('Make Passive') }}</button>
                            @elseif($task->status == 3)
                            <button type="button" data-id="{{ $task->id }}" data-action="activate" class="btn btn-outline-success task-action-btn">{{ __('Republish') }}</button>
                             @else
                            <button type="button" data-id="{{ $task->id }}" data-action="confirm" class="btn btn-outline-danger task-action-btn">{{ __('Approve Task') }}</button>
                        @endif
                
                        @if($task->status != 3)
                        <button type="button" data-id="{{ $task->id }}" data-action="delete" class="btn btn-outline-danger task-action-btn">{{ __('Delete') }}</button>
                    @endif

                    @if ($task->status == 3 && $task->visibilty == 1)
                    <button type="button" data-id="{{ $task->id }}" data-action="unvisible" class="btn btn-outline-dark task-action-btn">{{ __('Un Visable') }}</button>
                @endif
                
                     </div>

                        

                     
                        <div class="d-grid">
                            <a href="#" class="btn btn-outline-primary radius-15">{{__('Go To Task')}} ({{ number_format($task->reward, 2, ',', '.') }}{{ $settings['currency'] }})</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endforeach
@else
    <div class="col">
        <p>{{__('No data found.')}}</p>
    </div>
@endif

				
				
				</div>
				<!--end row-->
			</div>
</div>

<!-- Offcanvas panel -->
<div class="offcanvas offcanvas-end" tabindex="-1" id="offcanvasAdd" aria-labelledby="offcanvasAddLabel">
    <div class="offcanvas-header">
        <h5 id="offcanvasAddLabel">{{__('Add New Task')}}</h5>
        <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body">
        <!-- Form -->
        <form action="{{ route('tasks.store') }}" class="row g-3" id="AddTaskForm" method="POST" enctype="multipart/form-data">
            @csrf
            <!-- Fields -->
            <div class="col-md-6">
                <label for="name" class="form-label">{{__('Task Name')}}</label>
                <input type="text" class="form-control" name="name" required>
            </div>

            <div class="col-md-6">
                <label for="image" class="form-label">{{__('Image')}}</label>
                <input type="file" class="form-control"  name="image" required>
            </div>
          
            <div class="col-md-6">
             
                    <label for="name" class="form-label">{{__('Task Link')}}</label>
                    <input type="url" class="form-control"  name="link" placeholder="{{__('Must be start with https://')}}" required>
                </div>

                <div class="col-md-6">
            <label for="name" class="form-label">{{__('Award Amount')}}</label>
            <div class="input-group mb-3"> <span class="input-group-text">{{ $settings['currency'] }}</span>
                <input type="text" class="form-control" aria-label="{{__('Award Amount')}}" name="reward"> <span class="input-group-text">.00</span>
            </div>
        
        
        </div>
        <div class="col-md-6">
            <label for="country_id" class="form-label">{{__('Country')}}</label>
            <select class="form-select" id="country_id" name="country_id" required onchange="updateCities()">
                <option value="0">{{__('All')}}</option>
                @foreach($countries as $country)
                    <option value="{{ $country->code }}">{{ $country->name }}</option>
                @endforeach
            </select>
        </div>

        <div class="col-md-6">
            <label for="city" class="form-label">{{__('City')}}</label>
            <select class="form-select" id="city" name="city" required>
                <option value="0">{{__('All')}}</option>
            </select>
        </div>

            <div class="col-md-6">
                <label for="category_id" class="form-label">{{__('Platform')}}</label>
                <select class="form-select" id="category_id" name="category_id" required>
                    @foreach($platforms as $platform)
                        <option value="{{ $platform->id }}" title="{{ $platform->description }}">{{ $platform->platform }}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-6">
                <label for="proof_number" class="form-label">{{__('Proof Number')}}</label>
                <select class="form-select" name="proof_number" required>
                    @for ($i = 1; $i <= 10; $i++)
                        <option value="{{ $i }}">{{ $i }}</option>
                    @endfor
                </select>
            </div>
             <div class="col-md-4">
                <label for="limit" class="form-label">{{__('Total Limit')}}</label>
                <input type="number" class="form-control"  name="limit" placeholder="{{__('Total Limit')}}" required>
            </div>
            <div class="col-md-4">
                <label for="daily_limit" class="form-label">{{__('Daily Limit')}}</label>
                <input type="number" class="form-control"  name="daily_limit" placeholder="{{__('Daily Limit')}}" required>
            </div>
            <div class="col-md-4">
                <label for="user_limit" class="form-label">{{__('User Limit')}}</label>
                <input type="number" class="form-control"  name="user_limit" placeholder="{{__('User Limit')}}" required>
            </div>
            <div class="col-md-6">
                <label for="gender" class="form-label">{{__('Gender')}}</label>
                <select class="form-select"  name="gender" required>
                    <option value="">{{__('Select a Gender')}}</option>
                    <option value="1">{{__('Male')}}</option>
                    <option value="2">{{__('Female')}}</option>
                    <option value="3" selected>{{__('All')}}</option>
                </select>
             </div>
             <div class="col-md-6">
                <label for="button_text" class="form-label">{{__('Task Button Text')}}</label>
                <input type="text" class="form-control"  name="button_text" required>
            </div>
            <div class="col-md-12">
                <label for="name" class="form-label">{{__('Task Description')}}</label>
                <textarea class="form-control"  name="description" placeholder="{{__('Task Description')}}" rows="3"></textarea>
            </div>
          
            <!-- Submission -->
            <button type="submit" class="btn btn-primary">{{__('Submit')}}</button>
        </form>
    </div>
</div>

 <!-- Edit Task -->
 <div class="offcanvas offcanvas-end" tabindex="-1" id="offcanvasEdit" aria-labelledby="offcanvasEditLabel">
    <div class="offcanvas-header">
        <h5 id="offcanvasEditLabel">{{ __('Edit Task') }}</h5>
        <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body">
      
        <form action="" id="editTaskForm" class="row g-3" method="POST" enctype="multipart/form-data">
            @csrf
            @method('POST')
             <!-- Fields -->
             <div class="col-md-12">
                <label for="name" class="form-label">{{__('Task Name')}}</label>
                <input type="text" class="form-control" value="" id="name" name="name" required>
            </div>

<div class="col-md-4">
    <img id="currentImage" src="/assets/images/placeholder.png" class="align-self-start rounded-circle p-1 border" width="90" height="90" alt="Current Image">
</div>

            <div class="col-md-8">
                <label for="image" class="form-label">{{__('Image')}}</label>
                <input type="file" class="form-control" id="image" name="image">
            </div>
            
            <div class="col-md-6">
             
                    <label for="name" class="form-label">{{__('Task Link')}}</label>
                 
                    <input type="url" class="form-control" value="" id="link" name="link" placeholder="{{__('Must be start with https://')}}" required>
                </div>

                <div class="col-md-6">
            <label for="name" class="form-label">{{__('Award Amount')}}</label>
            <div class="input-group mb-3"> <span class="input-group-text">{{ $settings['currency'] }}</span>
                <input type="text" class="form-control" value="" aria-label="{{__('Award Amount')}}" id="reward" name="reward"> <span class="input-group-text">.00</span>
            </div>
        
        
        </div>
        <div class="col-md-6">
            <label for="country_id" class="form-label">{{__('Country')}}</label>
            <select class="form-select" id="country_ids" name="country_id" required onchange="updateCities()">
                <option value="0">{{__('All')}}</option>
                @foreach($countries as $country)
                    <option value="{{ $country->code }}">{{ $country->name }}</option>
                @endforeach
            </select>
        </div>

        <div class="col-md-6">
            <label for="city" class="form-label">{{__('City')}}</label>
            <select class="form-select" id="citys" name="city" required>
                <option value="0">{{__('All')}}</option>
            </select>
        </div>

            <div class="col-md-6">
                <label for="category_id" class="form-label">{{__('Platform')}}</label>
                <select class="form-select" id="category_ids" name="category_id" required>
                    @foreach($platforms as $platform)
                        <option value="{{ $platform->id }}" title="{{ $platform->description }}">{{ $platform->platform }}</option>
                    @endforeach
                </select>
            </div>

            <div class="col-md-6">
                <label for="proof_number" class="form-label">{{__('Proof Number')}}</label>
                <select class="form-select" id="proof_number" name="proof_number" required>
                    @for ($i = 1; $i <= 10; $i++)
                        <option value="{{ $i }}">{{ $i }}</option>
                    @endfor
                </select>
            </div>
             <div class="col-md-4">
                <label for="limit" class="form-label">{{__('Total Limit')}}</label>
                <input type="number" class="form-control" id="limit" name="limit" value="" placeholder="{{__('Total Limit')}}" required>
            </div>
            <div class="col-md-4">
                <label for="daily_limit" class="form-label">{{__('Daily Limit')}}</label>
                <input type="number" class="form-control" id="daily_limit" value="" name="daily_limit" placeholder="{{__('Daily Limit')}}" required>
            </div>
            <div class="col-md-4">
                <label for="user_limit" class="form-label">{{__('User Limit')}}</label>
                <input type="number" class="form-control" value="" id="user_limit" name="user_limit" placeholder="{{__('User Limit')}}" required>
            </div>
            <div class="col-md-6">
                <label for="gender" class="form-label">{{__('Gender')}}</label>
                <select class="form-select" id="gender" name="gender" required>
                    <option value="">{{__('Select a Gender')}}</option>
                    <option value="1">{{__('Male')}}</option>
                    <option value="2">{{__('Female')}}</option>
                    <option value="3" selected>{{__('All')}}</option>
                </select>
             </div>
             <div class="col-md-6">
                <label for="button_text" class="form-label">{{__('Task Button Text')}}</label>
                <input type="text" class="form-control" value="" id="button_text" name="button_text" required>
            </div>
            <div class="col-md-12">
                <label for="name" class="form-label">{{__('Task Description')}}</label>
                <textarea class="form-control" id="description" name="description" placeholder="{{__('Task Description')}}" rows="3"></textarea>
            </div>
          
              <!-- Submission -->
              <button type="submit" class="btn btn-danger">{{__('Edit Task')}}</button>
        </form>
    </div>
</div>


<!-- Universal Task Action Modal -->
<div class="modal fade" id="taskActionModal" tabindex="-1" aria-labelledby="taskActionModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="taskActionModalLabel">Task Action</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" id="taskActionModalBody">
                Are you sure you want to perform this action?
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" id="cancelActionButton">Cancel</button>
                <button type="button" class="btn btn-primary" id="confirmActionButton">Confirm</button>
            </div>
        </div>
    </div>
</div>



            @endsection

@section("script")
	<!--notification js -->
    <script src="{{ asset('assets/plugins/notifications/js/lobibox.min.js')  }}"></script>
	<script src="{{ asset('assets/plugins/notifications/js/notifications.min.js')  }}"></script>
	<script src="{{ asset('assets/plugins/notifications/js/notification-custom-script.js')  }}"></script>
    @if (session('success'))
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        Lobibox.notify('success', {
            pauseDelayOnHover: true,
            size: 'mini',
            rounded: true,
            icon: 'bx bx-check-circle',
            delayIndicator: false,
            continueDelayOnInactiveTab: false,
            position: 'top right',
            msg: '{{ session('success') }}'
        });
    });
    </script>
    @endif
    
    @if ($errors->any())
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        @foreach ($errors->all() as $error)
        Lobibox.notify('error', {
            pauseDelayOnHover: true,
            size: 'mini',
            rounded: true,
            icon: 'bx bx-error',
            delayIndicator: false,
            continueDelayOnInactiveTab: false,
            position: 'top right',
            msg: '{{ $error }}'
        });
        @endforeach
    });
    </script>
    @endif
    <script>
		function updateCities() {
			var countryId = document.getElementById('country_id').value;
			var citySelect = document.getElementById('city');

            var countryId = document.getElementById('country_ids').value;
			var citySelect = document.getElementById('citys');
		
			citySelect.innerHTML = '<option value="">{{ __("Select City") }}</option>'; 
		
			if (countryId) {
				fetch(`/cities/${countryId}`)
					.then(response => response.json())
					.then(data => {
						data.forEach(city => {
							var option = new Option(city.name, city.id);
							citySelect.add(option);
						});
					})
					.catch(error => console.log('Error fetching cities:', error));
			}
		}

		document.addEventListener("DOMContentLoaded", function () {

  const form = document.getElementById('AddTaskForm');
    form.onsubmit = function (event) {
        event.preventDefault();
        const formData = new FormData(form);
        
        fetch(form.action, {
            method: 'POST',
            body: formData,
        })
        .then(response => response.json())
        .then(data => {
    if (data.success) {
        Lobibox.notify('success', {
                            pauseDelayOnHover: true,
            size: 'mini',
            rounded: true,
            icon: 'bx bx-error',
            delayIndicator: false,
            continueDelayOnInactiveTab: false,
            position: 'top right', 
                            msg: data.message
        });
        setTimeout(function() {
            location.reload(); 
        }, 2000);
       // window.location.href = '/tasks';
    } else {
        alert('Failed to create task: ' + data.message);
    }
})
        .catch(error => {
            console.error('Error:', error);
        });
    };
});
    document.addEventListener("DOMContentLoaded", function () {
    const editButtons = document.querySelectorAll('.edit-task-btn');
    editButtons.forEach(button => {
        button.addEventListener('click', function() {
            const taskId = this.dataset.id;
            const form = document.getElementById('editTaskForm');  
            fetch(`/tasks/${taskId}/edit`)  
                .then(response => response.json())
                .then(task => {
                    form.action = `/tasks/${task.id}`;  
                  
                    document.getElementById('name').value = task.name;
                    document.getElementById('link').value = task.link;
                    document.getElementById('description').value = task.description;
                    document.getElementById('reward').value = task.reward;
                    document.getElementById('limit').value = task.limit;
                    document.getElementById('daily_limit').value = task.daily_limit;
                    document.getElementById('user_limit').value = task.user_limit;
                    document.getElementById('country_ids').value = task.country_id;
                    document.getElementById('citys').value = task.city;
                    document.getElementById('category_ids').value = task.category_id;
                    document.getElementById('gender').value = task.gender;
                    document.getElementById('button_text').value = task.button_text;
                    document.getElementById('proof_number').value = task.proof_number;
                    document.getElementById('currentImage').src = "assets/images/tasks/" + task.image;
                    
                    const offcanvasEdit = document.getElementById('offcanvasEdit');
                    const bsOffcanvas2 = new bootstrap.Offcanvas(offcanvasEdit);
                    bsOffcanvas2.show();
                })
                .catch(error => {
                    console.error('Error:', error);
                    alert('An error occurred while fetching task data');
                });
        });
    });
});

document.addEventListener('DOMContentLoaded', function() {
    const actionButtons = document.querySelectorAll('.task-action-btn');
    actionButtons.forEach(button => {
        button.addEventListener('click', function() {
            const taskId = this.getAttribute('data-id');
            const actionType = this.getAttribute('data-action');
            const modalLabel = document.getElementById('taskActionModalLabel');
            const modalBody = document.getElementById('taskActionModalBody');
            const confirmButton = document.getElementById('confirmActionButton');
            const taskStatus = this.dataset.status;  

            
            switch (actionType) {
                case 'activate':
                    modalLabel.textContent = "{{__('Activate Task')}}";
                    modalBody.textContent = "{{__('Are you sure you want to activate this task?')}}";
                    confirmButton.className = 'btn btn-primary';
                    confirmButton.textContent = "{{__('Activate')}}";
                    confirmButton.dataset.status = 1; 
                    cancelActionButton.textContent = "{{__('Cancel')}}";
                    break;
                case 'disable':
                    modalLabel.textContent = "{{__('Disable Task')}}";
                    modalBody.textContent = "{{__('Are you sure you want to disable this task?')}}";
                    confirmButton.className = 'btn btn-warning';
                    confirmButton.textContent = "{{__('Disable')}}";
                    confirmButton.dataset.status = 0; 
                    cancelActionButton.textContent = "{{__('Cancel')}}";
                    break;
                case 'confirm':
                    modalLabel.textContent = "{{__('Confirm Task')}}";
                    modalBody.textContent = "{{__('Are you sure you want to approve this task?')}}";
                    confirmButton.className = 'btn btn-danger';
                    confirmButton.textContent = "{{__('Approve Task')}}";
                    confirmButton.dataset.status = 1; 
                    cancelActionButton.textContent = "{{__('Cancel')}}"; 
                    break;
                    case 'delete':
                    modalLabel.textContent = "{{__('Confirm Task')}}";
                    modalBody.textContent = "{{__('Are you sure you want to delete this task?')}}";
                    confirmButton.className = 'btn btn-danger';
                    confirmButton.textContent = "{{__('Delete Task')}}";
                    confirmButton.dataset.status = 3; 
                    cancelActionButton.textContent = "{{__('Cancel')}}"; 
                    break; 
                    case 'unvisible':
                    modalLabel.textContent = "{{__('Confirm Task')}}";
                    modalBody.textContent = "{{__('Are you sure you want to unvisible this task?')}}";
                    confirmButton.className = 'btn btn-danger';
                    confirmButton.textContent = "{{__('Un Visable')}}";
                    confirmButton.dataset.visibilty = 0;
                    cancelActionButton.textContent = "{{__('Cancel')}}";
                    break;
            }

            confirmButton.onclick = function() {
                fetch(`/task/${actionType}/${taskId}`, {
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify({ status: this.dataset.status }) 
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        Lobibox.notify('success', {
                            pauseDelayOnHover: true,
            size: 'mini',
            rounded: true,
            icon: 'bx bx-error',
            delayIndicator: false,
            continueDelayOnInactiveTab: false,
            position: 'top right',
                            msg: data.message});
                            setTimeout(function() {
            location.reload(); 
        }, 2000);
                    } else {
                        Lobibox.notify('error', {
                            pauseDelayOnHover: true,
            size: 'mini',
            rounded: true,
            icon: 'bx bx-error',
            delayIndicator: false,
            continueDelayOnInactiveTab: false,
            position: 'top right',
                            msg: data.message});
                    }
                    $('#taskActionModal').modal('hide');
                })
                .catch(error => {
                    console.error('Error:', error);
                    Lobibox.notify('error', {msg: 'Operation failed!'});
                });
            };

            $('#taskActionModal').modal('show');
        });
    });
});



		</script>
@endsection
