@extends("layouts.app")
@section("style")
	<link href="{{ ('assets/plugins/notifications/css/lobibox.min.css') }}" rel="stylesheet" />
	@endsection
@section("wrapper")
<div class="page-wrapper">
<div class="page-content">
				<!--breadcrumb-->
				<div class="page-breadcrumb d-sm-flex align-items-center mb-3">
					<div class="breadcrumb-title pe-3">{{__('Tasks')}}</div>
					<div class="ps-3">
						<nav aria-label="breadcrumb">
							<ol class="breadcrumb mb-0 p-0">
								<li class="breadcrumb-item"><a href="/"><i class="bx bx-home-alt"></i></a>
								</li>
								<li class="breadcrumb-item active" aria-current="page">
                                    <button type="button" class="btn btn-success position-relative me-lg-5"> <i class="fadeIn animated bx bx-task align-middle"></i> {{__('Task List')}} <span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-dark">{{ $tasks->count() }} <span class="visually-hidden">unread messages</span></span>
                                    </button> 
                                 </li>
							</ol>
						</nav>
					</div>
				
				</div>
               
				<!--end breadcrumb-->
                <div class="row row-cols-1 row-cols-lg-2 row-cols-xl-4">
                    @if($tasks->isNotEmpty())
                    @foreach ($tasks as $task)
                        <div class="col">
                            <div class="card radius-15">
                                <div class="card-body text-center">
                                    <div class="p-4 border radius-15">
                                        <img src="{{ asset('assets/images/tasks/' . $task->image) }}" width="110" height="110" class="rounded-circle shadow" alt="{{ $task->name }}">
                                        <h5 class="mb-0 mt-5">{{ $task->name }}</h5>
                                       
                                        <div class="app-name">
                                            <div class="chip">
                                                <img src="{{ asset('assets/images/app/' . $task->PlatformIcon) }}" alt="{{ $task->PlatformDescription }}">{{__('Platform')}}: {{ $task->PlatformName }}
                                            </div>
                                            <div class="chip">
                                                {{__('Profit')}} {{ number_format($task->reward, 2, ',', '.') }}{{ $settings['currency'] }}
                                            </div>
                                            @if($task->watch_time)
                                            <div class="chip">
                                                {{__('Watch Time')}}: {{ $task->watch_time }} {{__('seconds')}}
                                            </div>
                                            @endif
                                            @if($task->status == 0)
                                                <div class="chip chip-lg bg-warning text-white">{{__('Task Status')}}: {{ __('Disable') }}</div>
                                            @elseif($task->status == 1)
                                                <div class="chip chip-lg bg-success text-white">{{__('Task Status')}}: {{ __('Activate') }}</div>
                                            @elseif($task->status == 2)
                                                <div class="chip chip-lg bg-info text-white">{{__('Task Status')}}: {{ __('Awaiting Approval') }}</div>
                                            @elseif($task->status == 3)
                                                <div class="chip chip-lg bg-danger text-white">{{__('Task Status')}}: {{ __('Deleted') }}</div>
                                            @endif
                
                                            <div class="chip">
                                                <img src="{{ asset('assets/images/avatars/' . $task->UserAvatar) }}" alt="{{__('Added by')}}">{{__('Added by')}}: {{ $task->UserName }}
                                            </div>
                                            <div class="chip chip-lg bg-primary text-white">{{__('Limits')}}: {{ $task->daily_limit }}/{{ $task->limit }}
                                            </div>
                                            <div class="chip chip-lg bg-secondary text-white">{{__('Location')}}: 
                                                @if($task->CountryName == 0 || $task->CityName == 0)
                                                    {{__('All')}}
                                                @else
                                                    {{ $task->CountryName }}/{{ $task->CityName }}
                                                @endif
                                            </div>
                                        </div>
                                        
                                        <div class="card-title">
                                            <h5 class="mb-0">{{__('Completed')}}</h5>
                                        </div>
                                        
                                        @php
                                            $completedCount = $task->proofs->isNotEmpty() ? $task->proofs->first()->total : 0;
                                            $completionPercentage = $task->limit > 0 ? ($completedCount / $task->limit * 100) : 0;
                                        @endphp
                
                                        <div class="progress">
                                            <div class="progress-bar" role="progressbar" style="width: {{ $completionPercentage }}%;" aria-valuenow="{{ $completionPercentage }}" aria-valuemin="0" aria-valuemax="100">
                                                {{ number_format($completionPercentage, 2) }}%
                                            </div>
                                        </div>
                                        
                                        <div class="list-inline contacts-social mt-3 mb-3">
                                            @if($task->watch_time)
                                                <a href="{{ route('watch.video', $task->id) }}" class="btn btn-outline-primary">
                                                    <i class="bx bx-play"></i> {{ __('Watch & Earn') }}
                                                </a>
                                            @else
                                                <form action="{{ route('task.watch.old') }}" method="POST">
                                                    @csrf
                                                    <input type="hidden" name="id" value="{{ $task->id }}">
                                                    <button type="submit" class="btn btn-outline-primary">{{ __('İzle Kazan') }}</button>
                                                </form>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                @else
                    <div class="col">
                        <p>{{__('No data found.')}}</p>
                    </div>
                @endif
                

				
				
				</div>
				<!--end row-->
			</div>
</div>

  @endsection

@section("script")
	<!--notification js -->
    <script src="{{ asset('assets/plugins/notifications/js/lobibox.min.js')  }}"></script>
	<script src="{{ asset('assets/plugins/notifications/js/notifications.min.js')  }}"></script>
	<script src="{{ asset('assets/plugins/notifications/js/notification-custom-script.js')  }}"></script>
    @if (session('success'))
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        Lobibox.notify('success', {
            pauseDelayOnHover: true,
            size: 'mini',
            rounded: true,
            icon: 'bx bx-check-circle',
            delayIndicator: false,
            continueDelayOnInactiveTab: false,
            position: 'top right',
            msg: '{{ session('success') }}'
        });
    });
    </script>
    @endif
    
    @if ($errors->any())
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        @foreach ($errors->all() as $error)
        Lobibox.notify('error', {
            pauseDelayOnHover: true,
            size: 'mini',
            rounded: true,
            icon: 'bx bx-error',
            delayIndicator: false,
            continueDelayOnInactiveTab: false,
            position: 'top right',
            msg: '{{ $error }}'
        });
        @endforeach
    });
    </script>
    @endif

@endsection
