@extends('layouts.app')

@section('wrapper')
<div class="page-wrapper">
    <div class="page-content">
        <!-- Header -->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">{{__('Support')}}</div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="{{ url('/home') }}"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{__('Support Tickets')}}</li>
                    </ol>
                </nav>
            </div>
        </div>

        <!-- Desktop View -->
        <div class="d-none d-lg-block">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="mb-0">{{__('My Tickets')}}</h5>
                        <button class="btn btn-primary" onclick="openCreateTicketOffcanvas()">
                            <i class="bx bx-plus me-2"></i>{{__('Create Ticket')}}
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <!-- Filters -->
                    <div class="row mb-3">
                        <div class="col-md-3">
                            <select class="form-select" id="statusFilter">
                                <option value="">{{__('All Status')}}</option>
                                <option value="open" {{ request('status') == 'open' ? 'selected' : '' }}>{{__('Open Tickets')}}</option>
                                <option value="closed" {{ request('status') == 'closed' ? 'selected' : '' }}>{{__('Closed Tickets')}}</option>
                                <option value="waiting_user" {{ request('status') == 'waiting_user' ? 'selected' : '' }}>{{__('Waiting for User')}}</option>
                                <option value="waiting_admin" {{ request('status') == 'waiting_admin' ? 'selected' : '' }}>{{__('Waiting for Admin')}}</option>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <select class="form-select" id="categoryFilter">
                                <option value="">{{__('All Categories')}}</option>
                                <option value="general" {{ request('category') == 'general' ? 'selected' : '' }}>{{__('General')}}</option>
                                <option value="technical" {{ request('category') == 'technical' ? 'selected' : '' }}>{{__('Technical')}}</option>
                                <option value="billing" {{ request('category') == 'billing' ? 'selected' : '' }}>{{__('Billing')}}</option>
                                <option value="account" {{ request('category') == 'account' ? 'selected' : '' }}>{{__('Account')}}</option>
                                <option value="withdrawal" {{ request('category') == 'withdrawal' ? 'selected' : '' }}>{{__('Withdrawal')}}</option>
                                <option value="task" {{ request('category') == 'task' ? 'selected' : '' }}>{{__('Task')}}</option>
                            </select>
                        </div>
                    </div>

                    <!-- Tickets List -->
                    @if($tickets->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>{{__('Ticket Number')}}</th>
                                        <th>{{__('Subject')}}</th>
                                        <th>{{__('Category')}}</th>
                                        <th>{{__('Priority')}}</th>
                                        <th>{{__('Status')}}</th>
                                        <th>{{__('Last Activity')}}</th>
                                        <th>{{__('Actions')}}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($tickets as $ticket)
                                    <tr class="{{ $ticket->getUnreadCountForUser(auth()->id()) > 0 ? 'table-warning' : '' }}">
                                        <td>
                                            <strong>{{ $ticket->ticket_number }}</strong>
                                            @if($ticket->getUnreadCountForUser(auth()->id()) > 0)
                                                <span class="badge bg-danger ms-2">{{ $ticket->getUnreadCountForUser(auth()->id()) }}</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="ticket-subject">
                                                {{ \Str::limit($ticket->subject, 50) }}
                                            </div>
                                        </td>
                                        <td>
                                            <span class="badge bg-secondary">{{ $ticket->category_text }}</span>
                                        </td>
                                        <td>
                                            <span class="badge bg-{{ $ticket->priority_badge }}">{{ $ticket->priority_text }}</span>
                                        </td>
                                        <td>
                                            <span class="badge bg-{{ $ticket->status_badge }}">{{ $ticket->status_text }}</span>
                                        </td>
                                        <td>
                                            <small class="text-muted">{{ $ticket->last_activity_at->diffForHumans() }}</small>
                                        </td>
                                        <td>
                                            <a href="{{ route('tickets.show', $ticket->id) }}" class="btn btn-sm btn-primary">
                                                <i class="bx bx-show me-1"></i>{{__('View')}}
                                            </a>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                        <!-- Pagination -->
                        <div class="d-flex justify-content-center">
                            {{ $tickets->appends(request()->query())->links() }}
                        </div>
                    @else
                        <div class="text-center py-5">
                            <i class="bx bx-inbox display-1 text-muted"></i>
                            <h5 class="mt-3">{{__('No tickets found')}}</h5>
                            <p class="text-muted">{{__('You haven\'t created any support tickets yet.')}}</p>
                            <button class="btn btn-primary" onclick="openCreateTicketOffcanvas()">
                                <i class="bx bx-plus me-2"></i>{{__('Create Your First Ticket')}}
                            </button>
                        </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- Mobile View -->
        <div class="d-lg-none">
            <div class="mobile-header mb-3">
                <div class="d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">{{__('My Tickets')}}</h5>
                    <button class="btn btn-primary btn-sm" onclick="openCreateTicketOffcanvas()">
                        <i class="bx bx-plus"></i>
                    </button>
                </div>
            </div>

            <!-- Mobile Filters -->
            <div class="row mb-3">
                <div class="col-6">
                    <select class="form-select form-select-sm" id="statusFilterMobile">
                        <option value="">{{__('All Status')}}</option>
                        <option value="open">{{__('Open')}}</option>
                        <option value="closed">{{__('Closed')}}</option>
                    </select>
                </div>
                <div class="col-6">
                    <select class="form-select form-select-sm" id="categoryFilterMobile">
                        <option value="">{{__('All Categories')}}</option>
                        <option value="general">{{__('General')}}</option>
                        <option value="technical">{{__('Technical')}}</option>
                        <option value="billing">{{__('Billing')}}</option>
                        <option value="account">{{__('Account')}}</option>
                        <option value="withdrawal">{{__('Withdrawal')}}</option>
                        <option value="task">{{__('Task')}}</option>
                    </select>
                </div>
            </div>

            <!-- Mobile Tickets Container -->
            <div id="mobileTicketsContainer">
                <!-- Mobile cards will be loaded here -->
            </div>

            <div class="text-center mt-3">
                <button class="btn btn-outline-primary" id="loadMoreTicketsBtn" onclick="loadMoreTickets()">
                    <i class="bx bx-loader-alt bx-spin d-none" id="loadMoreSpinner"></i>
                    {{__('Load More Tickets')}}
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Create Ticket Offcanvas -->
<div class="offcanvas offcanvas-end" tabindex="-1" id="createTicketOffcanvas" style="width: 500px;">
    <div class="offcanvas-header bg-primary text-white">
        <h5 class="offcanvas-title">{{__('Create Support Ticket')}}</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="offcanvas"></button>
    </div>
    <div class="offcanvas-body">
        <form id="createTicketForm" enctype="multipart/form-data" onsubmit="return false;">
            @csrf
            
            <!-- Subject -->
            <div class="mb-3">
                <label for="subject" class="form-label">{{__('Subject')}} <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="subject" name="subject" required maxlength="255" placeholder="{{__('Brief description of your issue')}}">
                <div class="invalid-feedback"></div>
            </div>

            <!-- Category & Priority -->
            <div class="row mb-3">
                <div class="col-6">
                    <label for="category" class="form-label">{{__('Category')}} <span class="text-danger">*</span></label>
                    <select class="form-select" id="category" name="category" required>
                        <option value="">{{__('Select Category')}}</option>
                        <option value="general">{{__('General')}}</option>
                        <option value="technical">{{__('Technical')}}</option>
                        <option value="billing">{{__('Billing')}}</option>
                        <option value="account">{{__('Account')}}</option>
                        <option value="withdrawal">{{__('Withdrawal')}}</option>
                        <option value="task">{{__('Task')}}</option>
                    </select>
                    <div class="invalid-feedback"></div>
                </div>
                <div class="col-6">
                    <label for="priority" class="form-label">{{__('Priority')}} <span class="text-danger">*</span></label>
                    <select class="form-select" id="priority" name="priority" required>
                        <option value="">{{__('Select Priority')}}</option>
                        <option value="low">{{__('Low')}}</option>
                        <option value="medium" selected>{{__('Medium')}}</option>
                        <option value="high">{{__('High')}}</option>
                        <option value="urgent">{{__('Urgent')}}</option>
                    </select>
                    <div class="invalid-feedback"></div>
                </div>
            </div>

            <!-- Description -->
            <div class="mb-3">
                <label for="description" class="form-label">{{__('Description')}} <span class="text-danger">*</span></label>
                <textarea class="form-control" id="description" name="description" rows="5" required maxlength="5000" placeholder="{{__('Please provide detailed information about your issue...')}}"></textarea>
                <div class="form-text">{{__('Remaining characters')}}: <span id="charCount">5000</span></div>
                <div class="invalid-feedback"></div>
            </div>

            <!-- File Attachments -->
            <div class="mb-3">
                <label for="attachments" class="form-label">{{__('Attachments')}} <span class="text-muted">({{__('Optional')}})</span></label>
                <input type="file" class="form-control" id="attachments" name="attachments[]" multiple accept=".jpg,.jpeg,.png,.pdf,.doc,.docx,.txt">
                <div class="form-text">
                    {{__('Max file size: 10MB')}} | {{__('Allowed formats: JPG, PNG, PDF, DOC, TXT')}}
                </div>
                <div class="invalid-feedback"></div>
                
                <!-- File Preview -->
                <div id="filePreview" class="mt-2"></div>
            </div>

            <!-- Submit Buttons -->
            <div class="d-grid gap-2">
                <button type="button" class="btn btn-primary btn-lg" id="submitBtn" onclick="submitCreateTicketForm()">
                    <i class="bx bx-check me-2"></i>{{__('Create Ticket')}}
                    <span class="spinner-border spinner-border-sm ms-2 d-none" id="submitSpinner"></span>
                </button>
                <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="offcanvas">
                    {{__('Cancel')}}
                </button>
            </div>
        </form>
    </div>
</div>

<style>
.ticket-subject {
    font-weight: 500;
}

.table-warning {
    background-color: rgba(255, 193, 7, 0.1) !important;
}

/* Mobile Styles */
.mobile-ticket-card {
    background: white;
    border-radius: 12px;
    padding: 16px;
    margin-bottom: 12px;
    box-shadow: 0 2px 8px rgba(0,0,0,0.1);
    border: 1px solid #e9ecef;
    transition: all 0.2s ease;
}

.mobile-ticket-card:hover {
    box-shadow: 0 4px 16px rgba(0,0,0,0.15);
    transform: translateY(-1px);
}

.mobile-ticket-card.unread {
    border-left: 4px solid #ffc107;
    background-color: rgba(255, 193, 7, 0.05);
}

.mobile-ticket-header {
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
    margin-bottom: 12px;
}

.mobile-ticket-number {
    font-weight: 600;
    color: #2c3e50;
    font-size: 0.9rem;
}

.mobile-ticket-subject {
    font-weight: 600;
    color: #2c3e50;
    margin-bottom: 8px;
    font-size: 1rem;
}

.mobile-ticket-meta {
    display: flex;
    gap: 8px;
    margin-bottom: 12px;
    flex-wrap: wrap;
}

.mobile-ticket-meta .badge {
    font-size: 0.75rem;
}

.mobile-ticket-footer {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding-top: 12px;
    border-top: 1px solid #f1f3f4;
}

.mobile-ticket-time {
    font-size: 0.8rem;
    color: #6c757d;
}

.mobile-unread-badge {
    background-color: #dc3545;
    color: white;
    border-radius: 50%;
    width: 20px;
    height: 20px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 0.7rem;
    font-weight: 600;
}

/* File Preview Styles */
.file-preview-item {
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 8px 12px;
    background-color: #f8f9fa;
    border-radius: 6px;
    margin-bottom: 8px;
    border: 1px solid #e9ecef;
}

.file-preview-info {
    display: flex;
    align-items: center;
    gap: 8px;
    flex: 1;
}

.file-preview-icon {
    width: 32px;
    height: 32px;
    display: flex;
    align-items: center;
    justify-content: center;
    border-radius: 4px;
    font-size: 10px;
    font-weight: 600;
    color: white;
}

.file-preview-icon.image { background-color: #28a745; }
.file-preview-icon.pdf { background-color: #dc3545; }
.file-preview-icon.doc { background-color: #007bff; }
.file-preview-icon.txt { background-color: #6c757d; }

.file-preview-details {
    flex: 1;
}

.file-preview-name {
    font-size: 0.85rem;
    font-weight: 500;
    color: #2c3e50;
    margin-bottom: 2px;
}

.file-preview-size {
    font-size: 0.75rem;
    color: #6c757d;
}

.file-remove-btn {
    background: none;
    border: none;
    color: #dc3545;
    cursor: pointer;
    padding: 4px 6px;
    border-radius: 4px;
    transition: background-color 0.2s;
}

.file-remove-btn:hover {
    background-color: rgba(220, 53, 69, 0.1);
}
</style>

<script>
$(document).ready(function() {
    // Desktop filters
    $('#statusFilter, #categoryFilter').on('change', function() {
        const status = $('#statusFilter').val();
        const category = $('#categoryFilter').val();
        
        let url = '{{ route('tickets.index') }}?';
        if (status) url += 'status=' + status + '&';
        if (category) url += 'category=' + category;
        
        window.location.href = url;
    });

    // Mobile initialization
    if (window.innerWidth < 992) {
        loadMobileTickets();
    }

    // Mobile filters
    $('#statusFilterMobile, #categoryFilterMobile').on('change', function() {
        mobileCurrentPage = 0;
        mobileHasMore = true;
        loadMobileTickets(true);
    });
});

// Mobile variables
let mobileCurrentPage = 0;
let mobileHasMore = true;

function loadMobileTickets(reset = false) {
    if (reset) {
        $('#mobileTicketsContainer').empty();
        mobileCurrentPage = 0;
    }

    $('#loadMoreSpinner').removeClass('d-none');
    $('#loadMoreTicketsBtn').prop('disabled', true);

    const status = $('#statusFilterMobile').val();
    const category = $('#categoryFilterMobile').val();

    $.ajax({
        url: '{{ route('api.tickets.mobile') }}',
        method: 'GET',
        data: {
            start: mobileCurrentPage * 10,
            length: 10,
            status: status,
            category: category
        },
        success: function(response) {
            if (response.data && response.data.length > 0) {
                response.data.forEach(function(ticket) {
                    const card = createMobileTicketCard(ticket);
                    $('#mobileTicketsContainer').append(card);
                });
                mobileCurrentPage++;
                mobileHasMore = response.data.length === 10;
            } else {
                mobileHasMore = false;
                if (mobileCurrentPage === 0) {
                    $('#mobileTicketsContainer').html(`
                        <div class="text-center py-5">
                            <i class="bx bx-inbox display-1 text-muted"></i>
                            <h6 class="mt-3">{{__('No tickets found')}}</h6>
                            <p class="text-muted small">{{__('You haven\'t created any support tickets yet.')}}</p>
                            <button class="btn btn-primary btn-sm" onclick="openCreateTicketOffcanvas()">
                                <i class="bx bx-plus me-2"></i>{{__('Create Ticket')}}
                            </button>
                        </div>
                    `);
                }
            }
            
            $('#loadMoreTicketsBtn').toggle(mobileHasMore);
        },
        error: function() {
            showNotification('error', '{{__('Error loading tickets')}}');
        },
        complete: function() {
            $('#loadMoreSpinner').addClass('d-none');
            $('#loadMoreTicketsBtn').prop('disabled', false);
        }
    });
}

function createMobileTicketCard(ticket) {
    const priorityColors = {
        'low': 'success',
        'medium': 'warning', 
        'high': 'danger',
        'urgent': 'dark'
    };

    const statusColors = {
        'open': 'primary',
        'in_progress': 'info',
        'waiting_user': 'warning',
        'waiting_admin': 'warning', 
        'resolved': 'success',
        'closed': 'secondary'
    };

    const unreadBadge = ticket.unread_count > 0 ? 
        `<div class="mobile-unread-badge">${ticket.unread_count}</div>` : '';

    const latestMessage = ticket.latest_message ? 
        `<div class="mobile-latest-message">
            <small class="text-muted">
                <strong>${ticket.latest_message.is_admin ? '{{__('Admin')}}' : '{{__('You')}}'}</strong>: 
                ${ticket.latest_message.message}
            </small>
        </div>` : '';

    return `
        <div class="mobile-ticket-card ${ticket.unread_count > 0 ? 'unread' : ''}" onclick="window.location.href='/tickets/${ticket.id}'">
            <div class="mobile-ticket-header">
                <div class="mobile-ticket-number">${ticket.ticket_number}</div>
                ${unreadBadge}
            </div>
            
            <div class="mobile-ticket-subject">${ticket.subject}</div>
            
            <div class="mobile-ticket-meta">
                <span class="badge bg-secondary">${ticket.category_text}</span>
                <span class="badge bg-${priorityColors[ticket.priority]}">${ticket.priority_text}</span>
                <span class="badge bg-${statusColors[ticket.status]}">${ticket.status_text}</span>
            </div>
            
            ${latestMessage}
            
            <div class="mobile-ticket-footer">
                <div class="mobile-ticket-time">${ticket.last_activity_at}</div>
                <i class="bx bx-chevron-right text-muted"></i>
            </div>
        </div>
    `;
}

function loadMoreTickets() {
    if (mobileHasMore) {
        loadMobileTickets();
    }
}

// Create Ticket Functions
function openCreateTicketOffcanvas() {
    // Reset form
    $('#createTicketForm')[0].reset();
    $('#filePreview').empty();
    $('#charCount').text('5000').removeClass('text-danger');
    $('.is-invalid').removeClass('is-invalid');
    $('.invalid-feedback').text('');
    
    // Open offcanvas
    const offcanvas = new bootstrap.Offcanvas(document.getElementById('createTicketOffcanvas'));
    offcanvas.show();
}

// Character counter
$(document).on('input', '#description', function() {
    const remaining = 5000 - $(this).val().length;
    $('#charCount').text(remaining);
    
    if (remaining < 100) {
        $('#charCount').addClass('text-danger');
    } else {
        $('#charCount').removeClass('text-danger');
    }
});

// File upload handling
$(document).on('change', '#attachments', function() {
    const files = this.files;
    const preview = $('#filePreview');
    preview.empty();

    Array.from(files).forEach((file, index) => {
        if (file.size > 10 * 1024 * 1024) { // 10MB limit
            Lobibox.notify('error', {
                title: '{{__('Error')}}',
                msg: `{{__('File')}} "${file.name}" {{__('is too large. Maximum size is 10MB.')}}`
            });
            return;
        }

        const fileItem = createFilePreview(file, index);
        preview.append(fileItem);
    });
});

// Submit Create Ticket Form Function
function submitCreateTicketForm() {
    const form = document.getElementById('createTicketForm');
    const formData = new FormData(form);
    
    // Disable submit button
    $('#submitBtn').prop('disabled', true);
    $('#submitSpinner').removeClass('d-none');
    
    // Clear previous errors
    $('.is-invalid').removeClass('is-invalid');
    $('.invalid-feedback').text('');

    $.ajax({
        url: '{{ route('tickets.store') }}',
        method: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        success: function(response) {
            if (response.success) {
                Lobibox.notify('success', {
                    title: '{{__('Success')}}',
                    msg: response.message
                });
                
                // Hide offcanvas
                const offcanvas = bootstrap.Offcanvas.getInstance(document.getElementById('createTicketOffcanvas'));
                offcanvas.hide();
                
                // Refresh page or reload data
                setTimeout(() => {
                    window.location.reload();
                }, 1500);
            } else {
                Lobibox.notify('error', {
                    title: '{{__('Error')}}',
                    msg: response.message
                });
            }
        },
        error: function(xhr) {
            if (xhr.status === 422) {
                // Validation errors
                const errors = xhr.responseJSON.errors;
                Object.keys(errors).forEach(field => {
                    $(`#${field}`).addClass('is-invalid');
                    $(`#${field}`).siblings('.invalid-feedback').text(errors[field][0]);
                });
                
                Lobibox.notify('error', {
                    title: '{{__('Validation Error')}}',
                    msg: '{{__('Please check the form fields and try again.')}}'
                });
            } else {
                Lobibox.notify('error', {
                    title: '{{__('Error')}}',
                    msg: '{{__('Error creating ticket')}}'
                });
            }
        },
        complete: function() {
            $('#submitBtn').prop('disabled', false);
            $('#submitSpinner').addClass('d-none');
        }
    });
}

function createFilePreview(file, index) {
    const fileSize = formatFileSize(file.size);
    const fileType = getFileType(file.name);
    const fileIcon = getFileIcon(fileType);
    
    return `
        <div class="file-preview-item" data-index="${index}">
            <div class="file-preview-info">
                <div class="file-preview-icon ${fileType}">${fileIcon}</div>
                <div class="file-preview-details">
                    <div class="file-preview-name">${file.name}</div>
                    <div class="file-preview-size">${fileSize}</div>
                </div>
            </div>
            <button type="button" class="file-remove-btn" onclick="removeFile(${index})">
                <i class="bx bx-x"></i>
            </button>
        </div>
    `;
}

function getFileType(filename) {
    const ext = filename.split('.').pop().toLowerCase();
    if (['jpg', 'jpeg', 'png'].includes(ext)) return 'image';
    if (ext === 'pdf') return 'pdf';
    if (['doc', 'docx'].includes(ext)) return 'doc';
    return 'txt';
}

function getFileIcon(type) {
    const icons = {
        'image': 'IMG',
        'pdf': 'PDF',
        'doc': 'DOC',
        'txt': 'TXT'
    };
    return icons[type] || 'FILE';
}

function formatFileSize(bytes) {
    if (bytes === 0) return '0 Bytes';
    const k = 1024;
    const sizes = ['Bytes', 'KB', 'MB'];
    const i = Math.floor(Math.log(bytes) / Math.log(k));
    return parseFloat((bytes / Math.pow(k, i)).toFixed(2)) + ' ' + sizes[i];
}

function removeFile(index) {
    $(`.file-preview-item[data-index="${index}"]`).remove();
    
    // Update file input
    const fileInput = document.getElementById('attachments');
    const dt = new DataTransfer();
    const files = fileInput.files;
    
    for (let i = 0; i < files.length; i++) {
        if (i !== index) {
            dt.items.add(files[i]);
        }
    }
    
    fileInput.files = dt.files;
}

function showNotification(type, message) {
    Lobibox.notify(type, {
        title: type === 'success' ? '{{__('Success')}}' : '{{__('Error')}}',
        msg: message
    });
}
</script>
@endsection