@extends('layouts.app')

@section('title', __('Edit Profile'))

@section('style')
    <link href="{{ asset('assets/plugins/notifications/css/lobibox.min.css') }}" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" />
@endsection

@section('wrapper')
<div class="page-wrapper">
    <div class="page-content">
    <!--breadcrumb-->
    <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
        <div class="breadcrumb-title pe-3">{{ __('Edit Profile') }}</div>
        <div class="ps-3">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb mb-0 p-0">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}"><i class="bx bx-home-alt"></i></a></li>
                    <li class="breadcrumb-item"><a href="{{ route('user.profile') }}">{{ __('Profile') }}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{ __('Edit') }}</li>
                </ol>
            </nav>
        </div>
    </div>
    <!--end breadcrumb-->
    
    <div class="container">
        <div class="main-body">
            <div class="row">
                <div class="col-lg-8 mx-auto">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="mb-0">{{ __('Edit Profile Information') }}</h5>
                        </div>
                        <div class="card-body">
                            <form id="profileUpdateForm" action="{{ route('user.profile.update') }}" method="POST" enctype="multipart/form-data">
                                @csrf
                                @method('POST')
                                
                                <!-- Avatar Upload -->
                                <div class="row mb-3">
                                    <div class="col-sm-3">
                                        <h6 class="mb-0">{{ __('Profile Picture') }}</h6>
                                    </div>
                                    <div class="col-sm-9">
                                        <div class="d-flex align-items-center">
                                            <img src="{{ auth()->user()->user_avatar ? asset('assets/images/avatars/' . auth()->user()->user_avatar) : asset('assets/images/avatars/avatar-1.png') }}" 
                                                 alt="User Avatar" class="rounded-circle me-3" width="80" height="80">
                                            <div>
                                                <input type="file" class="form-control @error('user_avatar') is-invalid @enderror" 
                                                       name="user_avatar" accept="image/*">
                                                @error('user_avatar')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                                <small class="text-muted">{{ __('Max file size: 2MB. Allowed: JPG, PNG, GIF') }}</small>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Username -->
                                <div class="row mb-3">
                                    <div class="col-sm-3">
                                        <h6 class="mb-0">{{ __('Username') }}</h6>
                                    </div>
                                    <div class="col-sm-9">
                                        <input type="text" class="form-control @error('username') is-invalid @enderror" 
                                               name="username" value="{{ old('username', auth()->user()->username) }}" required>
                                        @error('username')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>

                                <!-- Email -->
                                <div class="row mb-3">
                                    <div class="col-sm-3">
                                        <h6 class="mb-0">{{ __('Email') }}</h6>
                                    </div>
                                    <div class="col-sm-9">
                                        <input type="email" class="form-control @error('email') is-invalid @enderror" 
                                               name="email" value="{{ old('email', auth()->user()->email) }}" required>
                                        @error('email')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>

                                <!-- Phone -->
                                <div class="row mb-3">
                                    <div class="col-sm-3">
                                        <h6 class="mb-0">{{ __('Phone') }}</h6>
                                    </div>
                                    <div class="col-sm-9">
                                        <input type="text" class="form-control @error('phone') is-invalid @enderror" 
                                               name="phone" value="{{ old('phone', auth()->user()->phone) }}">
                                        @error('phone')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>

                                <!-- Country -->
                                <div class="row mb-3">
                                    <div class="col-sm-3">
                                        <h6 class="mb-0">{{ __('Country') }}</h6>
                                    </div>
                                    <div class="col-sm-9">
                                        <select class="form-select @error('country_id') is-invalid @enderror" name="country_id" id="country_id" data-placeholder="{{ __('Select Country') }}">
                                            <option value="">{{ __('Select Country') }}</option>
                                            @foreach($countries as $country)
                                                <option value="{{ $country->id }}" 
                                                    {{ old('country_id', auth()->user()->country_id) == $country->code ? 'selected' : '' }}>
                                                    {{ $country->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                        @error('country_id')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>

                                <!-- City -->
                                <div class="row mb-3">
                                    <div class="col-sm-3">
                                        <h6 class="mb-0">{{ __('City') }}</h6>
                                    </div>
                                    <div class="col-sm-9">
                                        <select class="form-select @error('city_id') is-invalid @enderror" name="city_id" id="city_id" data-placeholder="{{ __('Select City') }}">
                                            <option value="">{{ __('Select City') }}</option>
                                            @foreach($cities as $city)
                                                <option value="{{ $city->id }}" 
                                                    {{ old('city_id', auth()->user()->city_id) == $city->id ? 'selected' : '' }}>
                                                    {{ $city->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                        @error('city_id')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>

                                <!-- Submit Buttons -->
                                <div class="row">
                                    <div class="col-sm-3"></div>
                                    <div class="col-sm-9">
                                        <button type="submit" class="btn btn-primary px-4" id="saveButton">
                                            <span class="btn-text">{{ __('Save Changes') }}</span>
                                            <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                                        </button>
                                        <a href="{{ route('user.profile') }}" class="btn btn-secondary px-4 ms-2">{{ __('Cancel') }}</a>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('script')
    <!--notification js -->
    <script src="{{ asset('assets/plugins/notifications/js/lobibox.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/notifications/js/notifications.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/notifications/js/notification-custom-script.js') }}"></script>
    
    <!--select2 js -->
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

    <script>
    $(document).ready(function() {
        // Initialize Select2
        $('#country_id').select2({
            theme: 'bootstrap-5',
            placeholder: '{{ __("Select Country") }}',
            allowClear: true
        });
        
        $('#city_id').select2({
            theme: 'bootstrap-5',
            placeholder: '{{ __("Select City") }}',
            allowClear: true
        });
        
        // Country change handler
        $('#country_id').change(function() {
            var countryId = $(this).val();
            
            // Clear city select and reinitialize
            $('#city_id').empty().append('<option value="">{{ __("Select City") }}</option>');
            $('#city_id').select2('destroy').select2({
                theme: 'bootstrap-5',
                placeholder: '{{ __("Select City") }}',
                allowClear: true
            });
            
            if (countryId) {
                $.get(`{{ url('/cities') }}/${countryId}`, function(cities) {
                    $.each(cities, function(index, city) {
                        $('#city_id').append(`<option value="${city.id}">${city.name}</option>`);
                    });
                    // Refresh Select2 after adding options
                    $('#city_id').trigger('change');
                });
            }
        });

        // Profile update form AJAX handler
        $('#profileUpdateForm').on('submit', function(e) {
            e.preventDefault();
            
            var form = $(this);
            var formData = new FormData(this);
            var saveButton = $('#saveButton');
            var btnText = saveButton.find('.btn-text');
            var spinner = saveButton.find('.spinner-border');
            
            // Clear previous errors
            $('.is-invalid').removeClass('is-invalid');
            $('.invalid-feedback').remove();
            
            // Show loading state
            saveButton.prop('disabled', true);
            btnText.text('{{ __("Saving...") }}');
            spinner.removeClass('d-none');
            
            $.ajax({
                url: form.attr('action'),
                type: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
                    'X-Requested-With': 'XMLHttpRequest'
                },
                success: function(response) {
                    if (response.success) {
                        // Show success notification
                        Lobibox.notify('success', {
                            pauseDelayOnHover: true,
                            continueDelayOnInactiveTab: false,
                            position: 'top right',
                            icon: 'bx bx-check-circle',
                            title: '{{ __("Success") }}',
                            msg: response.message
                        });
                        
                        // Update avatar if changed
                        if (response.user && response.user.avatar_url) {
                            $('img[alt="User Avatar"]').attr('src', response.user.avatar_url);
                        }
                    } else {
                        // Show error notification
                        Lobibox.notify('error', {
                            pauseDelayOnHover: true,
                            continueDelayOnInactiveTab: false,
                            position: 'top right',
                            icon: 'bx bx-x-circle',
                            title: '{{ __("Error") }}',
                            msg: response.message || '{{ __("An error occurred") }}'
                        });
                    }
                },
                error: function(xhr) {
                    if (xhr.status === 422) {
                        // Validation errors
                        var errors = xhr.responseJSON.errors;
                        
                        $.each(errors, function(field, messages) {
                            var input = $('[name="' + field + '"]');
                            input.addClass('is-invalid');
                            
                            var errorDiv = $('<div class="invalid-feedback"></div>');
                            errorDiv.text(messages[0]);
                            input.after(errorDiv);
                        });
                        
                        // Show validation error notification
                        Lobibox.notify('error', {
                            pauseDelayOnHover: true,
                            continueDelayOnInactiveTab: false,
                            position: 'top right',
                            icon: 'bx bx-error-circle',
                            title: '{{ __("Error") }}',
                            msg: xhr.responseJSON.message || '{{ __("Please check the form for errors") }}'
                        });
                    } else {
                        // General error
                        var errorMessage = xhr.responseJSON && xhr.responseJSON.message 
                            ? xhr.responseJSON.message 
                            : '{{ __("An error occurred while updating profile") }}';
                            
                        Lobibox.notify('error', {
                            pauseDelayOnHover: true,
                            continueDelayOnInactiveTab: false,
                            position: 'top right',
                            icon: 'bx bx-x-circle',
                            title: '{{ __("Error") }}',
                            msg: errorMessage
                        });
                    }
                },
                complete: function() {
                    // Reset button state
                    saveButton.prop('disabled', false);
                    btnText.text('{{ __("Save Changes") }}');
                    spinner.addClass('d-none');
                }
            });
        });
    });
    </script>
@endsection