@extends('layouts.app')

@section('title', __('User Profile'))

@section('style')
<style>
    .profile-container {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        border-radius: 20px;
        padding: 30px;
        color: white;
        margin-bottom: 30px;
    }
    
    .profile-card {
        background: white;
        border-radius: 15px;
        box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        margin-bottom: 20px;
        overflow: hidden;
    }
    
    .profile-avatar {
        width: 120px;
        height: 120px;
        border-radius: 50%;
        border: 4px solid white;
        box-shadow: 0 5px 15px rgba(0,0,0,0.2);
    }
    
    .stat-card {
        background: white;
        border-radius: 15px;
        padding: 25px;
        text-align: center;
        box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        transition: transform 0.3s ease;
        margin-bottom: 20px;
    }
    
    .stat-card:hover {
        transform: translateY(-5px);
    }
    
    .stat-number {
        font-size: 2.5rem;
        font-weight: bold;
        color: #667eea;
        margin-bottom: 10px;
    }
    
    .stat-label {
        color: #6c757d;
        font-size: 0.9rem;
    }
    
    .task-tab {
        background: white;
        border-radius: 15px;
        box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        overflow: hidden;
    }
    
    .nav-pills .nav-link {
        border-radius: 10px;
        margin: 0 5px;
        color: #6c757d;
        font-weight: 500;
    }
    
    .nav-pills .nav-link.active {
        background: linear-gradient(45deg, #667eea, #764ba2);
        color: white;
    }
    
    .task-item {
        background: #f8f9fa;
        border-radius: 10px;
        padding: 15px;
        margin-bottom: 15px;
        border-left: 4px solid #667eea;
        transition: all 0.3s ease;
    }
    
    .task-item:hover {
        background: #e9ecef;
        transform: translateX(5px);
    }
    
    .task-status {
        padding: 4px 12px;
        border-radius: 20px;
        font-size: 0.8rem;
        font-weight: bold;
    }
    
    .status-active {
        background: #d4edda;
        color: #155724;
    }
    
    .status-inactive {
        background: #f8d7da;
        color: #721c24;
    }
    
    .quick-actions {
        background: white;
        border-radius: 15px;
        padding: 25px;
        box-shadow: 0 5px 15px rgba(0,0,0,0.1);
    }
    
    .action-btn {
        display: flex;
        align-items: center;
        padding: 15px;
        background: #f8f9fa;
        border-radius: 10px;
        text-decoration: none;
        color: #495057;
        margin-bottom: 10px;
        transition: all 0.3s ease;
    }
    
    .action-btn:hover {
        background: #e9ecef;
        color: #495057;
        transform: translateX(5px);
    }
    
    .action-btn i {
        font-size: 1.5rem;
        margin-right: 15px;
        color: #667eea;
    }
    
    @media (max-width: 768px) {
        .profile-container {
            padding: 20px;
            margin: 10px;
            border-radius: 15px;
        }
        
        .profile-avatar {
            width: 100px;
            height: 100px;
        }
        
        .stat-number {
            font-size: 2rem;
        }
        
        .stat-card {
            padding: 20px;
        }
        
        .task-item {
            padding: 12px;
        }
        
        .action-btn {
            padding: 12px;
        }
    }
</style>
@endsection

@section('wrapper')
<div class="page-wrapper">
    <div class="page-content">
        <!-- Profile Header -->
        <div class="profile-container">
            <div class="row align-items-center">
                <div class="col-md-3 text-center">
                    <img src="{{ $user->user_avatar ? asset('assets/images/avatars/' . $user->user_avatar) : asset('assets/images/avatars/avatar-1.png') }}" 
                         alt="User Avatar" class="profile-avatar">
                </div>
                <div class="col-md-6">
                    <h2 class="mb-2">{{ $user->username }}</h2>
                    <p class="mb-2 opacity-90">
                        @if($user->user_type == 1)
                            <span class="badge bg-warning">{{__('Administrator')}}</span>
                        @else
                            <span class="badge bg-light text-dark">{{__('Member')}}</span>
                        @endif
                    </p>
                    <p class="mb-0 opacity-75">
                        <i class="bx bx-map me-2"></i>
                        {{ $user->country->name ?? '' }} - {{ $user->city->name ?? '' }}
                    </p>
                </div>
                <div class="col-md-3 text-center">
                    <h3 class="mb-1">{{ number_format($user->balance, 2) }}₺</h3>
                    <small class="opacity-75">{{__('Current Balance')}}</small>
                </div>
            </div>
        </div>

        <!-- Statistics -->
        <div class="row">
            <div class="col-lg-3 col-md-6">
                <div class="stat-card">
                    <div class="stat-number">{{ $totalTasks }}</div>
                    <div class="stat-label">{{__('Total Tasks Created')}}</div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="stat-card">
                    <div class="stat-number">{{ $activeTasks }}</div>
                    <div class="stat-label">{{__('Active Tasks')}}</div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="stat-card">
                    <div class="stat-number">{{ $approvedProofs }}</div>
                    <div class="stat-label">{{__('Approved Proofs')}}</div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="stat-card">
                    <div class="stat-number">{{ number_format($totalEarnings, 2) }}₺</div>
                    <div class="stat-label">{{__('Total Earnings')}}</div>
                </div>
            </div>
        </div>

        <div class="row">
            <!-- Tasks Section -->
            <div class="col-lg-8">
                <div class="task-tab">
                    <div class="card-header bg-transparent">
                        <h5 class="mb-0">
                            <i class="bx bx-task me-2"></i>
                            {{__('My Tasks')}}
                        </h5>
                    </div>
                    <div class="card-body">
                        <!-- Nav tabs -->
                        <ul class="nav nav-pills mb-4" id="taskTabs" role="tablist">
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active" id="social-tab" data-bs-toggle="pill" data-bs-target="#social" type="button">
                                    <i class="bx bx-share-alt me-2"></i>{{__('Social Media')}}
                                </button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="watch-tab" data-bs-toggle="pill" data-bs-target="#watch" type="button">
                                    <i class="bx bx-play-circle me-2"></i>{{__('Watch Tasks')}}
                                </button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="website-tab" data-bs-toggle="pill" data-bs-target="#website" type="button">
                                    <i class="bx bx-world me-2"></i>{{__('Website Visits')}}
                                </button>
                            </li>
                        </ul>

                        <!-- Tab content -->
                        <div class="tab-content" id="taskTabContent">
                            <!-- Social Media Tasks -->
                            <div class="tab-pane fade show active" id="social" role="tabpanel">
                                @if($userTasks->count() > 0)
                                    @foreach($userTasks->take(5) as $task)
                                    <div class="task-item">
                                        <div class="d-flex justify-content-between align-items-start">
                                            <div class="flex-grow-1">
                                                <h6 class="mb-1">{{ $task->title }}</h6>
                                                <p class="text-muted mb-2 small">{{ Str::limit($task->description, 100) }}</p>
                                                <div class="d-flex align-items-center">
                                                    <span class="task-status {{ $task->status ? 'status-active' : 'status-inactive' }}">
                                                        {{ $task->status ? __('Active') : __('Inactive') }}
                                                    </span>
                                                    <small class="text-muted ms-3">
                                                        <i class="bx bx-calendar me-1"></i>
                                                        {{ $task->created_at->format('d.m.Y') }}
                                                    </small>
                                                </div>
                                            </div>
                                            <div class="text-end">
                                                <div class="fw-bold text-success">{{ $task->reward }}₺</div>
                                                <small class="text-muted">{{__('Reward')}}</small>
                                            </div>
                                        </div>
                                    </div>
                                    @endforeach
                                    @if($userTasks->count() > 5)
                                        <div class="text-center">
                                            <a href="{{ route('tasks.index') }}" class="btn btn-outline-primary">
                                                {{__('View All')}} ({{ $userTasks->count() }})
                                            </a>
                                        </div>
                                    @endif
                                @else
                                    <div class="text-center py-4">
                                        <i class="bx bx-task" style="font-size: 3rem; color: #dee2e6;"></i>
                                        <p class="text-muted mt-2">{{__('No social media tasks created yet')}}</p>
                                        <a href="{{ route('tasks.create') }}" class="btn btn-primary">
                                            <i class="bx bx-plus me-2"></i>{{__('Create First Task')}}
                                        </a>
                                    </div>
                                @endif
                            </div>

                            <!-- Watch Tasks -->
                            <div class="tab-pane fade" id="watch" role="tabpanel">
                                @if($userWatchTasks->count() > 0)
                                    @foreach($userWatchTasks->take(5) as $task)
                                    <div class="task-item">
                                        <div class="d-flex justify-content-between align-items-start">
                                            <div class="flex-grow-1">
                                                <h6 class="mb-1">{{ $task->title }}</h6>
                                                <p class="text-muted mb-2 small">{{ Str::limit($task->description, 100) }}</p>
                                                <div class="d-flex align-items-center">
                                                    <span class="task-status {{ $task->is_active ? 'status-active' : 'status-inactive' }}">
                                                        {{ $task->is_active ? __('Active') : __('Inactive') }}
                                                    </span>
                                                    <small class="text-muted ms-3">
                                                        <i class="bx bx-time me-1"></i>
                                                        {{ $task->formatted_duration }}
                                                    </small>
                                                </div>
                                            </div>
                                            <div class="text-end">
                                                <div class="fw-bold text-success">{{ $task->reward_amount }}₺</div>
                                                <small class="text-muted">{{ $task->current_completions }}/{{ $task->max_completions }}</small>
                                            </div>
                                        </div>
                                    </div>
                                    @endforeach
                                    @if($userWatchTasks->count() > 5)
                                        <div class="text-center">
                                            <a href="{{ route('user.watch.tasks') }}" class="btn btn-outline-primary">
                                                {{__('View All')}} ({{ $userWatchTasks->count() }})
                                            </a>
                                        </div>
                                    @endif
                                @else
                                    <div class="text-center py-4">
                                        <i class="bx bx-play-circle" style="font-size: 3rem; color: #dee2e6;"></i>
                                        <p class="text-muted mt-2">{{__('No watch tasks created yet')}}</p>
                                        <a href="{{ route('tasks.watch') }}" class="btn btn-primary">
                                            <i class="bx bx-plus me-2"></i>{{__('Create First Task')}}
                                        </a>
                                    </div>
                                @endif
                            </div>

                            <!-- Website Visit Tasks -->
                            <div class="tab-pane fade" id="website" role="tabpanel">
                                @if($userWebsiteTasks->count() > 0)
                                    @foreach($userWebsiteTasks->take(5) as $task)
                                    <div class="task-item">
                                        <div class="d-flex justify-content-between align-items-start">
                                            <div class="flex-grow-1">
                                                <h6 class="mb-1">{{ $task->title }}</h6>
                                                <p class="text-muted mb-2 small">{{ $task->website_url }}</p>
                                                <div class="d-flex align-items-center">
                                                    <span class="task-status {{ $task->is_active ? 'status-active' : 'status-inactive' }}">
                                                        {{ $task->is_active ? __('Active') : __('Inactive') }}
                                                    </span>
                                                    <small class="text-muted ms-3">
                                                        <i class="bx bx-time me-1"></i>
                                                        {{ $task->visit_duration }}s
                                                    </small>
                                                </div>
                                            </div>
                                            <div class="text-end">
                                                <div class="fw-bold text-success">{{ $task->reward_amount }}₺</div>
                                                <small class="text-muted">{{ $task->current_visits }}/{{ $task->max_visits }}</small>
                                            </div>
                                        </div>
                                    </div>
                                    @endforeach
                                    @if($userWebsiteTasks->count() > 5)
                                        <div class="text-center">
                                            <a href="{{ route('user.website-visits.index') }}" class="btn btn-outline-primary">
                                                {{__('View All')}} ({{ $userWebsiteTasks->count() }})
                                            </a>
                                        </div>
                                    @endif
                                @else
                                    <div class="text-center py-4">
                                        <i class="bx bx-world" style="font-size: 3rem; color: #dee2e6;"></i>
                                        <p class="text-muted mt-2">{{__('No website visit tasks created yet')}}</p>
                                        <a href="{{ route('user.website-visits.create') }}" class="btn btn-primary">
                                            <i class="bx bx-plus me-2"></i>{{__('Create First Task')}}
                                        </a>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Quick Actions -->
            <div class="col-lg-4">
                <div class="quick-actions">
                    <h5 class="mb-4">
                        <i class="bx bx-zap me-2"></i>
                        {{__('Quick Actions')}}
                    </h5>
                    
                    <a href="{{ route('user.profile.edit') }}" class="action-btn">
                        <i class="bx bx-edit"></i>
                        <div>
                            <div class="fw-bold">{{__('Edit Profile')}}</div>
                            <small class="text-muted">{{__('Update your personal information')}}</small>
                        </div>
                    </a>
                    
                    <a href="{{ route('tasks.create') }}" class="action-btn">
                        <i class="bx bx-plus-circle"></i>
                        <div>
                            <div class="fw-bold">{{__('Create Task')}}</div>
                            <small class="text-muted">{{__('Add a new social media task')}}</small>
                        </div>
                    </a>
                    
                    <a href="{{ route('tasks.watch') }}" class="action-btn">
                        <i class="bx bx-play-circle"></i>
                        <div>
                            <div class="fw-bold">{{__('Watch & Earn')}}</div>
                            <small class="text-muted">{{__('Create or complete watch tasks')}}</small>
                        </div>
                    </a>
                    
                    <a href="{{ route('user.website-visits.index') }}" class="action-btn">
                        <i class="bx bx-world"></i>
                        <div>
                            <div class="fw-bold">{{__('Website Visits')}}</div>
                            <small class="text-muted">{{__('Manage website visit tasks')}}</small>
                        </div>
                    </a>
                    
                    <a href="{{ route('withdrawals.index') }}" class="action-btn">
                        <i class="bx bx-money"></i>
                        <div>
                            <div class="fw-bold">{{__('Withdraw Money')}}</div>
                            <small class="text-muted">{{__('Request withdrawal of earnings')}}</small>
                        </div>
                    </a>
                    
                    <button type="button" class="action-btn" data-bs-toggle="modal" data-bs-target="#changePasswordModal">
                        <i class="bx bx-lock"></i>
                        <div>
                            <div class="fw-bold">{{__('Change Password')}}</div>
                            <small class="text-muted">{{__('Update your account security')}}</small>
                        </div>
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Change Password Modal -->
<div class="modal fade" id="changePasswordModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{__('Change Password')}}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="changePasswordForm">
                <div class="modal-body">
                    @csrf
                    <div class="mb-3">
                        <label class="form-label">{{__('Current Password')}}</label>
                        <input type="password" class="form-control" name="current_password" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{__('New Password')}}</label>
                        <input type="password" class="form-control" name="new_password" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{__('Confirm New Password')}}</label>
                        <input type="password" class="form-control" name="new_password_confirmation" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{__('Cancel')}}</button>
                    <button type="submit" class="btn btn-primary">{{__('Update Password')}}</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('script')
<script>
$('#changePasswordForm').on('submit', function(e) {
    e.preventDefault();
    
    $.ajax({
        url: '{{ route("user.password.update") }}',
        method: 'POST',
        data: $(this).serialize(),
        success: function(response) {
            if (response.success) {
                $('#changePasswordModal').modal('hide');
                $('#changePasswordForm')[0].reset();
                
                Swal.fire({
                    icon: 'success',
                    title: '{{__("Success")}}',
                    text: response.message,
                    timer: 3000
                });
            }
        },
        error: function(xhr) {
            const errors = xhr.responseJSON?.errors || {};
            let errorMessage = xhr.responseJSON?.message || '{{__("An error occurred")}}';
            
            if (Object.keys(errors).length > 0) {
                errorMessage = Object.values(errors)[0][0];
            }
            
            Swal.fire({
                icon: 'error',
                title: '{{__("Error")}}',
                text: errorMessage
            });
        }
    });
});
</script>
@endsection