@extends('layouts.app')

@section('title', __('User Profile'))

@section('style')
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<style>
    /* Select2 custom styling */
    .select2-container--default .select2-selection--single {
        height: 38px;
        border: 1px solid #ced4da;
        border-radius: 0.375rem;
        padding: 6px 12px;
    }
    
    .select2-container--default .select2-selection--single .select2-selection__rendered {
        line-height: 24px;
        padding-left: 0;
    }
    
    .select2-container--default .select2-selection--single .select2-selection__arrow {
        height: 36px;
        right: 10px;
    }
    
    .select2-dropdown {
        border: 1px solid #ced4da;
        border-radius: 0.375rem;
    }
    
    .select2-container--default .select2-search--dropdown .select2-search__field {
        border: 1px solid #ced4da;
        border-radius: 0.375rem;
        padding: 8px 12px;
    }
    
    .select2-container--default .select2-results__option--highlighted[aria-selected] {
        background-color: #667eea;
    }
    
    .select2-container {
        width: 100% !important;
    }
    .password-strength {
        margin-top: 10px;
    }
    
    .strength-meter {
        width: 100%;
        height: 8px;
        background-color: #e9ecef;
        border-radius: 4px;
        overflow: hidden;
    }
    
    .strength-meter-fill {
        height: 100%;
        width: 0%;
        transition: all 0.3s ease;
        border-radius: 4px;
    }
    
    .strength-weak { background-color: #dc3545; }
    .strength-fair { background-color: #fd7e14; }
    .strength-good { background-color: #ffc107; }
    .strength-strong { background-color: #28a745; }
    
    .requirement {
        display: block;
        font-size: 0.875rem;
        margin-bottom: 2px;
    }
    
    .requirement.met i {
        color: #28a745 !important;
    }
    
    .requirement.met i:before {
        content: "\ea10"; /* bx-check */
    }
    
    .requirement:not(.met) i:before {
        content: "\ea0f"; /* bx-x */
    }
    
    .password-toggle {
        position: absolute;
        right: 10px;
        top: 50%;
        transform: translateY(-50%);
        cursor: pointer;
        color: #6c757d;
    }
    
    .password-input-container {
        position: relative;
    }
    .profile-container {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        border-radius: 20px;
        padding: 30px;
        color: white;
        margin-bottom: 30px;
    }
    
    .profile-card {
        background: white;
        border-radius: 15px;
        box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        margin-bottom: 20px;
        overflow: hidden;
    }
    
    .profile-avatar {
        width: 120px;
        height: 120px;
        border-radius: 50%;
        border: 4px solid white;
        box-shadow: 0 5px 15px rgba(0,0,0,0.2);
    }
    .balance-card {
        background: linear-gradient(45deg, #28a745, #20c997);
        color: white;
        border-radius: 15px;
        padding: 25px;
        text-align: center;
        margin-bottom: 30px;
    }
    
    .balance-amount {
        font-size: 2.5rem;
        font-weight: bold;
        margin-bottom: 10px;
    }
    .stat-card {
        background: white;
        border-radius: 15px;
        padding: 25px;
        text-align: center;
        box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        transition: transform 0.3s ease;
        margin-bottom: 20px;
    }
    
    .stat-card:hover {
        transform: translateY(-5px);
    }
    
    .stat-number {
        font-size: 2.5rem;
        font-weight: bold;
        color: #667eea;
        margin-bottom: 10px;
    }
    
    .stat-label {
        color: #6c757d;
        font-size: 0.9rem;
    }
    
    .task-tab {
        background: white;
        border-radius: 15px;
        box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        overflow: hidden;
    }
    
    .nav-pills .nav-link {
        border-radius: 10px;
        margin: 0 5px;
        color: #6c757d;
        font-weight: 500;
    }
    
    .nav-pills .nav-link.active {
        background: linear-gradient(45deg, #667eea, #764ba2);
        color: white;
    }
    
    .task-item {
        background: #f8f9fa;
        border-radius: 10px;
        padding: 15px;
        margin-bottom: 15px;
        border-left: 4px solid #667eea;
        transition: all 0.3s ease;
    }
    
    .task-item:hover {
        background: #e9ecef;
        transform: translateX(5px);
    }
    
    .task-status {
        padding: 4px 12px;
        border-radius: 20px;
        font-size: 0.8rem;
        font-weight: bold;
    }
    
    .status-active {
        background: #d4edda;
        color: #155724;
    }
    
    .status-inactive {
        background: #f8d7da;
        color: #721c24;
    }
    
    .quick-actions {
        background: white;
        border-radius: 15px;
        padding: 25px;
        box-shadow: 0 5px 15px rgba(0,0,0,0.1);
    }
    
    .action-btn {
        display: flex;
        align-items: center;
        padding: 15px;
        background: #f8f9fa;
        border-radius: 10px;
        text-decoration: none;
        color: #495057;
        margin-bottom: 10px;
        transition: all 0.3s ease;
    }
    
    .action-btn:hover {
        background: #e9ecef;
        color: #495057;
        transform: translateX(5px);
    }
    
    .action-btn i {
        font-size: 1.5rem;
        margin-right: 15px;
        color: #667eea;
    }
    
    @media (max-width: 768px) {
        .profile-container {
            padding: 20px;
            margin: 10px;
            border-radius: 15px;
        }
        
        .profile-avatar {
            width: 100px;
            height: 100px;
        }
        
        .stat-number {
            font-size: 2rem;
        }
        
        .stat-card {
            padding: 20px;
        }
        
        .task-item {
            padding: 12px;
        }
        
        .action-btn {
            padding: 12px;
        }
    }
</style>
@endsection

@section('wrapper')
<div class="page-wrapper">
    <div class="page-content">
        <!-- Profile Header -->
        <div class="profile-container">
            <div class="row align-items-center">
                <div class="col-md-3 text-center">
                    <img src="{{ $user->user_avatar ? asset('assets/images/avatars/' . $user->user_avatar) : asset('assets/images/avatars/avatar-1.png') }}" 
                         alt="User Avatar" class="profile-avatar">
                </div>
                <div class="col-md-6">
                    <h2 class="mb-2">{{ $user->username }}</h2>
                    <p class="mb-2 opacity-90">
                        @if($user->user_type == 1)
                            <span class="badge bg-warning">{{__('Administrator')}}</span>
                        @else
                            <span class="badge bg-light text-dark">{{__('Member')}}</span>
                        @endif
                    </p>
                    <p class="mb-0 opacity-75">
                        <i class="bx bx-map me-2"></i>
                        {{ $user->country->name ?? '' }} - {{ $user->city->name ?? '' }}
                    </p>
                </div>
                <div class="col-md-3 text-center">
                <div class="balance-card">
                        <div class="balance-amount">{{ number_format($user->balance, 2) }}{{ $currency }}</div>
                        <small class="opacity-75">{{__('Available Balance')}}</small>
                    </div>
                </div>
            </div>
        </div>

        <!-- Statistics -->
        <div class="row">
            <div class="col-lg-3 col-md-6">
                <div class="stat-card">
                    <div class="stat-number">{{ $totalTasks }}</div>
                    <div class="stat-label">{{__('Total Tasks Created')}}</div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="stat-card">
                    <div class="stat-number">{{ $activeTasks }}</div>
                    <div class="stat-label">{{__('Active Tasks')}}</div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="stat-card">
                    <div class="stat-number">{{ $approvedProofs }}</div>
                    <div class="stat-label">{{__('Approved Proofs')}}</div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="stat-card">
                    <div class="stat-number">{{ number_format($totalEarnings, 2) }}₺</div>
                    <div class="stat-label">{{__('Total Earnings')}}</div>
                </div>
            </div>
        </div>

        <div class="row">
            <!-- Tasks Section -->
            <div class="col-lg-8">
                <div class="task-tab">
                    <div class="card-header bg-transparent">
                        <h5 class="mb-0">
                            <i class="bx bx-task me-2"></i>
                            {{__('My Tasks')}}
                        </h5>
                    </div>
                    <div class="card-body">
                        <!-- Nav tabs -->
                        <ul class="nav nav-pills mb-4" id="taskTabs" role="tablist">
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active" id="social-tab" data-bs-toggle="pill" data-bs-target="#social" type="button">
                                    <i class="bx bx-share-alt me-2"></i>{{__('Social Media')}}
                                </button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="watch-tab" data-bs-toggle="pill" data-bs-target="#watch" type="button">
                                    <i class="bx bx-play-circle me-2"></i>{{__('Watch Tasks')}}
                                </button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="website-tab" data-bs-toggle="pill" data-bs-target="#website" type="button">
                                    <i class="bx bx-world me-2"></i>{{__('Website Visits')}}
                                </button>
                            </li>
                        </ul>

                        <!-- Tab content -->
                        <div class="tab-content" id="taskTabContent">
                            <!-- Social Media Tasks -->
                            <div class="tab-pane fade show active" id="social" role="tabpanel">
                                @if($userTasks->count() > 0)
                                    @foreach($userTasks->take(5) as $task)
                                    <div class="task-item">
                                        <div class="d-flex justify-content-between align-items-start">
                                            <div class="flex-grow-1">
                                                <h6 class="mb-1">{{ $task->title }}</h6>
                                                <p class="text-muted mb-2 small">{{ Str::limit($task->description, 100) }}</p>
                                                <div class="d-flex align-items-center">
                                                    <span class="task-status {{ $task->status ? 'status-active' : 'status-inactive' }}">
                                                        {{ $task->status ? __('Active') : __('Inactive') }}
                                                    </span>
                                                    <small class="text-muted ms-3">
                                                        <i class="bx bx-calendar me-1"></i>
                                                        {{ $task->created_at->format('d.m.Y') }}
                                                    </small>
                                                </div>
                                            </div>
                                            <div class="text-end">
                                                <div class="fw-bold text-success">{{ $task->reward }}₺</div>
                                                <small class="text-muted">{{__('Reward')}}</small>
                                            </div>
                                        </div>
                                    </div>
                                    @endforeach
                                    @if($userTasks->count() > 5)
                                        <div class="text-center">
                                            <a href="{{ route('tasks.index') }}" class="btn btn-outline-primary">
                                                {{__('View All')}} ({{ $userTasks->count() }})
                                            </a>
                                        </div>
                                    @endif
                                @else
                                    <div class="text-center py-4">
                                        <i class="bx bx-task" style="font-size: 3rem; color: #dee2e6;"></i>
                                        <p class="text-muted mt-2">{{__('No social media tasks created yet')}}</p>
                                        <a href="{{ route('tasks.create') }}" class="btn btn-primary">
                                            <i class="bx bx-plus me-2"></i>{{__('Create First Task')}}
                                        </a>
                                    </div>
                                @endif
                            </div>

                            <!-- Watch Tasks -->
                            <div class="tab-pane fade" id="watch" role="tabpanel">
                                @if($userWatchTasks->count() > 0)
                                    @foreach($userWatchTasks->take(5) as $task)
                                    <div class="task-item">
                                        <div class="d-flex justify-content-between align-items-start">
                                            <div class="flex-grow-1">
                                                <h6 class="mb-1">{{ $task->title }}</h6>
                                                <p class="text-muted mb-2 small">{{ Str::limit($task->description, 100) }}</p>
                                                <div class="d-flex align-items-center">
                                                    <span class="task-status {{ $task->is_active ? 'status-active' : 'status-inactive' }}">
                                                        {{ $task->is_active ? __('Active') : __('Inactive') }}
                                                    </span>
                                                    <small class="text-muted ms-3">
                                                        <i class="bx bx-time me-1"></i>
                                                        {{ $task->formatted_duration }}
                                                    </small>
                                                </div>
                                            </div>
                                            <div class="text-end">
                                                <div class="fw-bold text-success">{{ $task->reward_amount }}₺</div>
                                                <small class="text-muted">{{ $task->current_completions }}/{{ $task->max_completions }}</small>
                                            </div>
                                        </div>
                                    </div>
                                    @endforeach
                                    @if($userWatchTasks->count() > 5)
                                        <div class="text-center">
                                            <a href="{{ route('user.watch.tasks') }}" class="btn btn-outline-primary">
                                                {{__('View All')}} ({{ $userWatchTasks->count() }})
                                            </a>
                                        </div>
                                    @endif
                                @else
                                    <div class="text-center py-4">
                                        <i class="bx bx-play-circle" style="font-size: 3rem; color: #dee2e6;"></i>
                                        <p class="text-muted mt-2">{{__('No watch tasks created yet')}}</p>
                                        <a href="{{ route('tasks.watch') }}" class="btn btn-primary">
                                            <i class="bx bx-plus me-2"></i>{{__('Create First Task')}}
                                        </a>
                                    </div>
                                @endif
                            </div>

                            <!-- Website Visit Tasks -->
                            <div class="tab-pane fade" id="website" role="tabpanel">
                                @if($userWebsiteTasks->count() > 0)
                                    @foreach($userWebsiteTasks->take(5) as $task)
                                    <div class="task-item">
                                        <div class="d-flex justify-content-between align-items-start">
                                            <div class="flex-grow-1">
                                                <h6 class="mb-1">{{ $task->title }}</h6>
                                                <p class="text-muted mb-2 small">{{ $task->website_url }}</p>
                                                <div class="d-flex align-items-center">
                                                    <span class="task-status {{ $task->is_active ? 'status-active' : 'status-inactive' }}">
                                                        {{ $task->is_active ? __('Active') : __('Inactive') }}
                                                    </span>
                                                    <small class="text-muted ms-3">
                                                        <i class="bx bx-time me-1"></i>
                                                        {{ $task->visit_duration }}s
                                                    </small>
                                                </div>
                                            </div>
                                            <div class="text-end">
                                                <div class="fw-bold text-success">{{ $task->reward_amount }}₺</div>
                                                <small class="text-muted">{{ $task->current_visits }}/{{ $task->max_visits }}</small>
                                            </div>
                                        </div>
                                    </div>
                                    @endforeach
                                    @if($userWebsiteTasks->count() > 5)
                                        <div class="text-center">
                                            <a href="{{ route('user.website-visits.index') }}" class="btn btn-outline-primary">
                                                {{__('View All')}} ({{ $userWebsiteTasks->count() }})
                                            </a>
                                        </div>
                                    @endif
                                @else
                                    <div class="text-center py-4">
                                        <i class="bx bx-world" style="font-size: 3rem; color: #dee2e6;"></i>
                                        <p class="text-muted mt-2">{{__('No website visit tasks created yet')}}</p>
                                        <a href="{{ route('user.website-visits.create') }}" class="btn btn-primary">
                                            <i class="bx bx-plus me-2"></i>{{__('Create First Task')}}
                                        </a>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Quick Actions -->
            <div class="col-lg-4">
                <div class="quick-actions">
                    <h5 class="mb-4">
                        <i class="bx bx-zap me-2"></i>
                        {{__('Quick Actions')}}
                    </h5>
                    
                    <a href="#" class="action-btn" data-bs-toggle="offcanvas" data-bs-target="#editProfileOffcanvas">
                        <i class="bx bx-edit"></i>
                        <div>
                            <div class="fw-bold">{{__('Edit Profile')}}</div>
                            <small class="text-muted">{{__('Update your personal information')}}</small>
                        </div>
                    </a>
                    
                    <a href="{{url('/tasks')}}" class="action-btn">
                        <i class="bx bx-plus-circle"></i>
                        <div>
                            <div class="fw-bold">{{__('Create Task')}}</div>
                            <small class="text-muted">{{__('Add a new social media task')}}</small>
                        </div>
                    </a>
                    
                    <a href="{{ route('tasks.watch') }}" class="action-btn">
                        <i class="bx bx-play-circle"></i>
                        <div>
                            <div class="fw-bold">{{__('Watch & Earn')}}</div>
                            <small class="text-muted">{{__('Create or complete watch tasks')}}</small>
                        </div>
                    </a>
                    
                    <a href="{{ route('user.website-visits.index') }}" class="action-btn">
                        <i class="bx bx-world"></i>
                        <div>
                            <div class="fw-bold">{{__('Website Visits')}}</div>
                            <small class="text-muted">{{__('Manage website visit tasks')}}</small>
                        </div>
                    </a>
                    
                    <a href="{{ route('withdrawals.index') }}" class="action-btn">
                        <i class="bx bx-money"></i>
                        <div>
                            <div class="fw-bold">{{__('Withdraw Money')}}</div>
                            <small class="text-muted">{{__('Request withdrawal of earnings')}}</small>
                        </div>
                    </a>

                    
                    <button type="button" class="action-btn" data-bs-toggle="modal" data-bs-target="#changePasswordModal">
                        <i class="bx bx-lock"></i>
                        <div>
                            <div class="fw-bold">{{__('Change Password')}}</div>
                            <small class="text-muted">{{__('Update your account security')}}</small>
                        </div>
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Change Password Modal -->
<div class="modal fade" id="changePasswordModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{__('Change Password')}}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="changePasswordForm">
                <div class="modal-body">
                    @csrf
                    <div class="mb-3">
                        <label class="form-label">{{__('Current Password')}}</label>
                        <div class="password-input-container">
                            <input type="password" class="form-control" name="current_password" id="currentPassword" required>
                            <i class="bx bx-hide password-toggle" onclick="togglePassword('currentPassword')"></i>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{__('New Password')}}</label>
                        <div class="password-input-container">
                            <input type="password" class="form-control" name="new_password" id="newPassword" required>
                            <i class="bx bx-hide password-toggle" onclick="togglePassword('newPassword')"></i>
                        </div>
                        <div class="password-strength">
                            <div class="strength-meter">
                                <div class="strength-meter-fill" id="strengthMeter"></div>
                            </div>
                            <small id="strengthText" class="text-muted">{{__('Password strength will be shown here')}}</small>
                            <div class="mt-2">
                                <span class="requirement" id="req-length">
                                    <i class="bx bx-x text-danger"></i> {{__('At least 8 characters')}}
                                </span>
                                <span class="requirement" id="req-uppercase">
                                    <i class="bx bx-x text-danger"></i> {{__('One uppercase letter')}}
                                </span>
                                <span class="requirement" id="req-lowercase">
                                    <i class="bx bx-x text-danger"></i> {{__('One lowercase letter')}}
                                </span>
                                <span class="requirement" id="req-number">
                                    <i class="bx bx-x text-danger"></i> {{__('One number')}}
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{__('Confirm New Password')}}</label>
                        <div class="password-input-container">
                            <input type="password" class="form-control" name="new_password_confirmation" id="confirmPassword" required>
                            <i class="bx bx-hide password-toggle" onclick="togglePassword('confirmPassword')"></i>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{__('Cancel')}}</button>
                    <button type="submit" class="btn btn-primary">{{__('Update Password')}}</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit Profile Offcanvas -->
<div class="offcanvas offcanvas-end" tabindex="-1" id="editProfileOffcanvas" style="width: 400px;">
    <div class="offcanvas-header">
        <h5 class="offcanvas-title">
            <i class="bx bx-edit me-2"></i>
            {{__('Edit Profile')}}
        </h5>
        <button type="button" class="btn-close" data-bs-dismiss="offcanvas"></button>
    </div>
    <div class="offcanvas-body">
        <form id="editProfileForm">
            @csrf
            
            <!-- Avatar Upload -->
            <div class="mb-4 text-center">
                <div class="position-relative d-inline-block">
                    <img src="{{ $user->user_avatar ? asset('assets/images/avatars/' . $user->user_avatar) : asset('assets/images/avatars/avatar-1.png') }}" 
                         alt="Avatar" class="rounded-circle" width="100" height="100" id="avatarPreview">
                    <label for="avatarInput" class="position-absolute bottom-0 end-0 bg-primary rounded-circle p-2" style="cursor: pointer;">
                        <i class="bx bx-camera text-white"></i>
                    </label>
                    <input type="file" id="avatarInput" name="avatar" accept="image/*" style="display: none;">
                </div>
                <div class="mt-2">
                    <small class="text-muted">{{__('Click camera icon to change avatar')}}</small>
                </div>
            </div>
            
            <div class="mb-3">
                <label class="form-label">{{__('Username')}}</label>
                <input type="text" class="form-control" name="username" value="{{ $user->username }}" required>
                <div class="invalid-feedback"></div>
            </div>
            
            <div class="mb-3">
                <label class="form-label">{{__('Email')}}</label>
                <input type="email" class="form-control" name="email" value="{{ $user->email }}" required>
                <div class="invalid-feedback"></div>
            </div>
            
            <div class="mb-3">
                <label class="form-label">{{__('Phone')}}</label>
                <input type="tel" class="form-control" name="phone" value="{{ $user->phone }}">
                <div class="invalid-feedback"></div>
            </div>
            
            <div class="mb-3">
                <label class="form-label">{{__('Country')}}</label>
                <select class="form-select select2-country" name="country_id" id="countrySelect">
                    <option value="">{{__('Select Country')}}</option>
                    @foreach(\App\Models\Country::all() as $country)
                        <option value="{{ $country->id }}" data-code="{{ $country->code }}" {{ $user->country_id == $country->id ? 'selected' : '' }}>
                            {{ $country->name }}
                        </option>
                    @endforeach
                </select>
                <div class="invalid-feedback"></div>
            </div>
            
            <div class="mb-3">
                <label class="form-label">{{__('City')}}</label>
                <select class="form-select select2-city" name="city_id" id="citySelect">
                    <option value="">{{__('Select City')}}</option>
                    @if($user->country_id)
                        @foreach(\App\Models\City::where('country_id', \App\Models\Country::find($user->country_id)->code ?? $user->country_id)->get() as $city)
                            <option value="{{ $city->id }}" {{ $user->city_id == $city->id ? 'selected' : '' }}>
                                {{ $city->name }}
                            </option>
                        @endforeach
                    @endif
                </select>
                <div class="invalid-feedback"></div>
            </div>
            
            <div class="mb-3">
                <label class="form-label">{{__('Gender')}}</label>
                <select class="form-select select2-gender" name="gender">
                    <option value="">{{__('Select Gender')}}</option>
                    <option value="male" {{ $user->gender == 'male' ? 'selected' : '' }}>{{__('Male')}}</option>
                    <option value="female" {{ $user->gender == 'female' ? 'selected' : '' }}>{{__('Female')}}</option>
                    <option value="other" {{ $user->gender == 'other' ? 'selected' : '' }}>{{__('Other')}}</option>
                </select>
                <div class="invalid-feedback"></div>
            </div>
            
            <!-- Payment Information -->
            <hr>
            <h6 class="mb-3">
                <i class="bx bx-credit-card me-2"></i>
                {{__('Payment Information')}}
            </h6>
            
            <div class="mb-3">
                <label class="form-label">{{__('Account Holder Name')}}</label>
                <input type="text" class="form-control" name="account_holder_name" value="{{ $user->account_holder }}">
                <div class="invalid-feedback"></div>
            </div>
            
            <div class="mb-3">
                <label class="form-label">{{__('IBAN')}}</label>
                <input type="text" class="form-control" name="iban" value="{{ $user->iban }}" placeholder="TR00 0000 0000 0000 0000 0000 00">
                <div class="invalid-feedback"></div>
                <small class="text-muted">{{__('Required for withdrawal requests')}}</small>
            </div>
            
            <div class="mb-3">
                <label class="form-label">{{__('Bank Name')}}</label>
                <input type="text" class="form-control" name="bank_name" value="{{ $user->bank_name }}">
                <div class="invalid-feedback"></div>
            </div>
            
            <button type="submit" class="btn btn-primary w-100" id="updateProfileBtn">
                <i class="bx bx-save me-2"></i>{{__('Update Profile')}}
            </button>
        </form>
    </div>
</div>
@endsection

@section('script')
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
// Password visibility toggle
function togglePassword(inputId) {
    const input = document.getElementById(inputId);
    const icon = input.nextElementSibling;
    
    if (input.type === 'password') {
        input.type = 'text';
        icon.classList.remove('bx-hide');
        icon.classList.add('bx-show');
    } else {
        input.type = 'password';
        icon.classList.remove('bx-show');
        icon.classList.add('bx-hide');
    }
}

// Password strength checker
document.getElementById('newPassword').addEventListener('input', function() {
    const password = this.value;
    const strengthMeter = document.getElementById('strengthMeter');
    const strengthText = document.getElementById('strengthText');
    
    // Requirements
    const requirements = {
        length: password.length >= 8,
        uppercase: /[A-Z]/.test(password),
        lowercase: /[a-z]/.test(password),
        number: /\d/.test(password)
    };
    
    // Update requirement indicators
    Object.keys(requirements).forEach(req => {
        const element = document.getElementById(`req-${req}`);
        if (requirements[req]) {
            element.classList.add('met');
            element.querySelector('i').className = 'bx bx-check text-success';
        } else {
            element.classList.remove('met');
            element.querySelector('i').className = 'bx bx-x text-danger';
        }
    });
    
    // Calculate strength
    const metCount = Object.values(requirements).filter(Boolean).length;
    let strength = 0;
    let strengthClass = '';
    let strengthLabel = '';
    
    if (metCount === 0) {
        strength = 0;
        strengthClass = '';
        strengthLabel = '{{__("Password strength will be shown here")}}';
    } else if (metCount === 1) {
        strength = 25;
        strengthClass = 'strength-weak';
        strengthLabel = '{{__("Weak")}}';
    } else if (metCount === 2) {
        strength = 50;
        strengthClass = 'strength-fair';
        strengthLabel = '{{__("Fair")}}';
    } else if (metCount === 3) {
        strength = 75;
        strengthClass = 'strength-good';
        strengthLabel = '{{__("Good")}}';
    } else if (metCount === 4) {
        strength = 100;
        strengthClass = 'strength-strong';
        strengthLabel = '{{__("Strong")}}';
    }
    
    strengthMeter.style.width = strength + '%';
    strengthMeter.className = 'strength-meter-fill ' + strengthClass;
    strengthText.textContent = strengthLabel;
});

// Avatar preview
document.getElementById('avatarInput').addEventListener('change', function(e) {
    const file = e.target.files[0];
    if (file) {
        const reader = new FileReader();
        reader.onload = function(e) {
            document.getElementById('avatarPreview').src = e.target.result;
        };
        reader.readAsDataURL(file);
    }
});

// Initialize Select2
$(document).ready(function() {
    // Initialize Select2 for all select elements
    $('.select2-country').select2({
        placeholder: '{{__("Search and select country...")}}',
        allowClear: true,
        width: '100%'
    });
    
    $('.select2-city').select2({
        placeholder: '{{__("Search and select city...")}}',
        allowClear: true,
        width: '100%'
    });
    
    $('.select2-gender').select2({
        placeholder: '{{__("Select gender...")}}',
        allowClear: true,
        width: '100%',
        minimumResultsForSearch: Infinity // Disable search for gender (only 3 options)
    });
});

// Country change handler (updated for Select2)
$('#countrySelect').on('change', function() {
    const countryCode = $(this).find('option:selected').data('code');
    const citySelect = $('#citySelect');
    
    // Clear cities and reinitialize Select2
    citySelect.empty().append('<option value="">{{__("Select City")}}</option>');
    citySelect.select2({
        placeholder: '{{__("Search and select city...")}}',
        allowClear: true,
        width: '100%'
    });
    
    if (countryCode) {
        // Load cities for selected country
        fetch(`/api/cities/${countryCode}`, {
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                'Accept': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success && data.cities) {
                data.cities.forEach(city => {
                    const option = new Option(city.name, city.id, false, false);
                    citySelect.append(option);
                });
                // Trigger change to update Select2
                citySelect.trigger('change');
            }
        })
        .catch(error => {
            console.error('Error loading cities:', error);
        });
    }
});

// Edit profile form handler
document.getElementById('editProfileForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    const submitBtn = document.getElementById('updateProfileBtn');
    const originalText = submitBtn.innerHTML;
    
    submitBtn.disabled = true;
    submitBtn.innerHTML = '<i class="bx bx-loader-alt bx-spin me-2"></i>{{__("Updating...")}}';
    
    // Clear previous errors
    document.querySelectorAll('.is-invalid').forEach(el => el.classList.remove('is-invalid'));
    document.querySelectorAll('.invalid-feedback').forEach(el => el.textContent = '');
    
    fetch('{{ route("user.profile.update") }}', {
        method: 'POST',
        body: formData,
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
            'Accept': 'application/json',
            'X-Requested-With': 'XMLHttpRequest'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            // Close offcanvas
            bootstrap.Offcanvas.getInstance(document.getElementById('editProfileOffcanvas')).hide();
            
            // Show success message
            Swal.fire({
                icon: 'success',
                title: '{{__("Success")}}',
                text: data.message,
                timer: 3000
            }).then(() => {
                // Reload page to show updated info
                location.reload();
            });
        } else {
            throw new Error(data.message || '{{__("An error occurred")}}');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        Swal.fire({
            icon: 'error',
            title: '{{__("Error")}}',
            text: error.message || '{{__("An error occurred")}}'
        });
    })
    .finally(() => {
        submitBtn.disabled = false;
        submitBtn.innerHTML = originalText;
    });
});
$('#changePasswordForm').on('submit', function(e) {
    e.preventDefault();
    
    $.ajax({
        url: '{{ route("user.password.update") }}',
        method: 'POST',
        data: $(this).serialize(),
        success: function(response) {
            if (response.success) {
                $('#changePasswordModal').modal('hide');
                $('#changePasswordForm')[0].reset();
                
                Swal.fire({
                    icon: 'success',
                    title: '{{__("Success")}}',
                    text: response.message,
                    timer: 3000
                });
            }
        },
        error: function(xhr) {
            const errors = xhr.responseJSON?.errors || {};
            let errorMessage = xhr.responseJSON?.message || '{{__("An error occurred")}}';
            
            if (Object.keys(errors).length > 0) {
                errorMessage = Object.values(errors)[0][0];
            }
            
            Swal.fire({
                icon: 'error',
                title: '{{__("Error")}}',
                text: errorMessage
            });
        }
    });
});
</script>
@endsection