@extends('layouts.app')

@section('style')
<style>
    .my-tasks-container {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        border-radius: 20px;
        padding: 30px;
        color: white;
        margin-bottom: 30px;
    }
    
    .task-management-card {
        background: white;
        border-radius: 15px;
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        overflow: hidden;
        border: none;
        box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        margin-bottom: 20px;
    }
    
    .task-management-card:hover {
        transform: translateY(-3px);
        box-shadow: 0 15px 35px rgba(0,0,0,0.2);
    }
    
    .task-thumbnail {
        height: 120px;
        background-size: cover;
        background-position: center;
        position: relative;
        overflow: hidden;
    }
    
    .task-status-badge {
        position: absolute;
        top: 10px;
        right: 10px;
        padding: 5px 10px;
        border-radius: 20px;
        font-size: 12px;
        font-weight: bold;
    }
    
    .status-active {
        background: #28a745;
        color: white;
    }
    
    .status-inactive {
        background: #dc3545;
        color: white;
    }
    
    .task-stats {
        background: #f8f9fa;
        border-radius: 10px;
        padding: 15px;
        margin: 15px 0;
    }
    
    .stat-item {
        text-align: center;
        padding: 10px;
    }
    
    .stat-number {
        font-size: 1.5rem;
        font-weight: bold;
        color: #667eea;
    }
    
    .stat-label {
        font-size: 0.8rem;
        color: #6c757d;
        margin-top: 5px;
    }
    
    .progress-custom {
        height: 8px;
        border-radius: 10px;
        background: #e9ecef;
        overflow: hidden;
    }
    
    .progress-bar-custom {
        height: 100%;
        background: linear-gradient(90deg, #667eea, #764ba2);
        border-radius: 10px;
        transition: width 0.3s ease;
    }
    
    .btn-group-custom {
        display: flex;
        gap: 5px;
        flex-wrap: wrap;
         margin-left: 20%;
    margin-right: 4px;
    }
    .task-management-card .card-text {
    margin-left: 4px;   /* sol boşluk */
    margin-bottom: 16px;
}
.task-management-card .card-title {
    margin-left: 4px;   /* sol boşluk */
    margin-bottom: 8px;
}
.task-management-card .card-body {
    padding: 20px 5px; /* üst-alt 20px, sağ-sol 24px */
}
    .btn-custom {
        padding: 8px 15px;
        font-size: 12px;
        border-radius: 8px;
        border: none;
        cursor: pointer;
        transition: all 0.3s ease;
    }
    
    .btn-edit {
        background: #ffc107;
        color: #000;
    }
    
    .btn-toggle {
        background: #17a2b8;
        color: white;
    }
    .btn-custom[disabled],
.btn-delete:disabled {
    background: #6c757d !important;
    color: #ffffff !important;
    opacity: 0.65;
    cursor: not-allowed;
    box-shadow: none;
}
    .btn-delete {
        background: #dc3545;
        color: white;
    }
    
    .btn-custom:hover {
        transform: translateY(-1px);
        box-shadow: 0 4px 8px rgba(0,0,0,0.2);
    }
    
    .empty-state {
        text-align: center;
        padding: 60px 20px;
        color: #6c757d;
    }
    
    .empty-state i {
        font-size: 4rem;
        margin-bottom: 20px;
        color: #dee2e6;
    }
    
    @media (max-width: 768px) {
        .my-tasks-container {
            padding: 20px;
            margin: 10px;
            border-radius: 15px;
        }
        
        .task-thumbnail {
            height: 100px;
        }
        
        .btn-group-custom {
            justify-content: center;
        }
    }
</style>
@endsection

@section('wrapper')
<div class="page-wrapper">
    <div class="page-content">
        <!-- Header Section -->
        <div class="my-tasks-container">
            <div class="row align-items-center">
                <div class="col-md-8">
                    <h2 class="mb-3">
                        <i class="bx bx-task me-2"></i>
                        {{__('My Watch Tasks')}}
                    </h2>
                    <p class="mb-0 opacity-90">
                        {{__('Manage your YouTube watch tasks. Edit, activate/deactivate or delete your tasks.')}}
                    </p>
                </div>
                <div class="col-md-4 text-end">
                    <div class="d-flex flex-column align-items-end">
                 <h4 id="user-balance" class="mb-1">{{ number_format($user->balance, 2) }}₺</h4>
                        <small class="opacity-75">{{__('Your Balance')}}</small>
                        <button class="btn btn-light btn-sm mt-2" onclick="showAddTaskModal()">
                            <i class="bx bx-plus me-2"></i>{{__('Add New Task')}}
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Tasks Grid -->
        <div class="row" id="my-tasks-container">
            <!-- Tasks will be loaded here via AJAX -->
        </div>

        <!-- Empty State -->
        <div class="row d-none" id="empty-state">
            <div class="col-12">
                <div class="task-management-card">
                    <div class="card-body">
                        <div class="empty-state">
                            <i class="bx bx-video"></i>
                            <h5>{{__('No tasks created yet')}}</h5>
                            <p>{{__('Create your first YouTube watch task and start earning from viewers!')}}</p>
                            <button class="btn btn-primary" onclick="showAddTaskModal()">
                                <i class="bx bx-plus me-2"></i>{{__('Create First Task')}}
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Add Task Offcanvas -->
<div class="offcanvas offcanvas-end" tabindex="-1" id="addTaskOffcanvas" style="width: 400px;">
    <div class="offcanvas-header">
        <h5 class="offcanvas-title">
            <i class="bx bx-plus-circle me-2"></i>
            {{__('Add New Watch Task')}}
        </h5>
        <button type="button" class="btn-close" data-bs-dismiss="offcanvas"></button>
    </div>
    <div class="offcanvas-body">
        <form id="addTaskForm">
            @csrf
            <div class="mb-3">
                <label class="form-label">{{__('Task Title')}}</label>
                <input type="text" class="form-control" name="title" required>
                <div class="invalid-feedback"></div>
            </div>
            
            <div class="mb-3">
                <label class="form-label">{{__('Description')}} ({{__('Optional')}})</label>
                <textarea class="form-control" name="description" rows="3"></textarea>
                <div class="invalid-feedback"></div>
            </div>
            
            <div class="mb-3">
                <label class="form-label">{{__('YouTube URL')}}</label>
                <input type="url" class="form-control" name="youtube_url" required 
                       placeholder="https://www.youtube.com/watch?v=...">
                <div class="invalid-feedback"></div>
                <small class="text-muted">{{__('YouTube video or shorts URL')}}</small>
            </div>
            
            <div class="row">
                <div class="col-6">
                    <div class="mb-3">
                        <label class="form-label">{{__('Watch Duration')}} ({{__('seconds')}})</label>
                        <input type="number" class="form-control" name="watch_duration" 
                               min="10" max="3600" value="60" required>
                        <div class="invalid-feedback"></div>
                    </div>
                </div>
                <div class="col-6">
                    <div class="mb-3">
                        <label class="form-label">{{__('Reward Amount')}} (₺)</label>
                        <input type="number" class="form-control" name="reward_amount" 
                               min="0.01" step="0.01" value="1.00" required>
                        <div class="invalid-feedback"></div>
                    </div>
                </div>
            </div>
            
            <div class="mb-3">
                <label class="form-label">{{__('Max Completions')}}</label>
                <input type="number" class="form-control" name="max_completions" 
                       min="1" value="100" required>
                <div class="invalid-feedback"></div>
                <small class="text-muted">{{__('Maximum number of users who can complete this task')}}</small>
            </div>
            
            <div class="alert alert-info">
                <h6>{{__('Cost Preview')}}</h6>
                <div class="row text-center">
                    <div class="col-4">
                        <div class="fw-bold" id="reward-preview">1.00₺</div>
                        <small>{{__('Per User')}}</small>
                    </div>
                    <div class="col-4">
                        <div class="fw-bold" id="completions-preview">100</div>
                        <small>{{__('Max Users')}}</small>
                    </div>
                    <div class="col-4">
                        <div class="fw-bold text-primary" id="total-cost-preview">100.00₺</div>
                        <small>{{__('Total Cost')}}</small>
                    </div>
                </div>
            </div>
            
            <button type="submit" class="btn btn-primary w-100" id="submitBtn">
                <i class="bx bx-check me-2"></i>{{__('Create Task')}}
            </button>
        </form>
    </div>
</div>

<!-- Edit Task Modal -->
<div class="modal fade" id="editTaskModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{__('Edit Task')}}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form id="editTaskForm">
                    @csrf
                    @method('POST')
                    <input type="hidden" id="edit-task-id">
                    
                    <div class="mb-3">
                        <label class="form-label">{{__('Task Title')}}</label>
                        <input type="text" class="form-control" name="title" id="edit-title" required>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">{{__('Description')}}</label>
                        <textarea class="form-control" name="description" id="edit-description" rows="3"></textarea>
                    </div>
                    
                    <div class="row">
                        <div class="col-6">
                            <div class="mb-3">
                                <label class="form-label">{{__('Watch Duration')}} ({{__('seconds')}})</label>
                                <input type="number" class="form-control" name="watch_duration" id="edit-duration" 
                                       min="10" max="3600" required>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="mb-3">
                                <label class="form-label">{{__('Reward Amount')}} (₺)</label>
                                <input type="number" class="form-control" name="reward_amount" id="edit-reward" 
                                       min="0.01" step="0.01" required>
                            </div>
                        </div>
                    </div>
                    
                    <button type="submit" class="btn btn-primary">
                        <i class="bx bx-save me-2"></i>{{__('Save Changes')}}
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@section('script')
 
<script>
   // sayfa yüklendiğinde
let userBalance = {{ $user->balance }};


function updateUserBalance(newBalance) {
 // 1) Gelen değerin tipini ve kendisini konsola basıyoruz
  console.log('▶ newBalance:', newBalance, 'typeof:', typeof newBalance);

  // 2) Eğer string geldiyse parseFloat ile sayıya dök
  let bal = newBalance;
  if (typeof bal !== 'number') {
    // örneğin "47.10" ya da "47,10" gelebilir
    bal = parseFloat(
      String(bal)
        .replace(/\s/g, '')      // boşlukları temizle
        .replace(',', '.')       // virgülü noktaya çevir
    );
  }

  // 3) Artık bal kesin number, toFixed kullanabiliriz
  userBalance = bal;
  $('#user-balance').text(bal.toFixed(2) + '₺');
}
$(document).ready(function() {
    loadMyTasks();
    $('input[name="reward_amount"], input[name="max_completions"]').on('input', updateCostPreview);
});

function loadMyTasks() {
    $.ajax({
        url: '{{ route("api.user.watch.tasks") }}',
        method: 'GET',
        headers: {
            'Accept': 'application/json',
            'X-Requested-With': 'XMLHttpRequest'
        },
        success: function(response) {
            if (response.success) {
                displayMyTasks(response.tasks);
            }
        },
        error: function(xhr) {
            console.log('Load tasks error:', xhr);
        }
    });
}

function displayMyTasks(tasks) {
    const container = $('#my-tasks-container');
    const emptyState = $('#empty-state');

    if (tasks.length === 0) {
        container.empty();
        emptyState.removeClass('d-none');
        return;
    }

    emptyState.addClass('d-none');
    container.empty();

    tasks.forEach(task => {
        const taskCard = createMyTaskCard(task);
        container.append(taskCard);
    });
}

function createMyTaskCard(task) {
    const thumbnailUrl = `https://img.youtube.com/vi/${task.youtube_video_id}/maxresdefault.jpg`;
    const completionPercentage = task.max_completions > 0 ? (task.current_completions / task.max_completions) * 100 : 0;
    
    return `
        <div class="col-lg-6 col-xl-4">
            <div class="task-management-card" data-task-id="${task.id}" data-duration="${task.watch_duration}" data-reward="${task.reward_amount}">
                <div class="task-thumbnail" style="background-image: url('${thumbnailUrl}')">
                    <div class="task-status-badge ${task.is_active ? 'status-active' : 'status-inactive'}">
                        ${task.is_active ? '{{__("Active")}}' : '{{__("Inactive")}}'}
                    </div>
                </div>
                <div class="card-body">
                    <h6 class="card-title mb-2">${task.title}</h6>
                    <p class="card-text text-muted small mb-3">${task.description || '{{__("No description")}}'}</p>
                    
                    <div class="task-stats">
                        <div class="row">
                            <div class="col-4">
                                <div class="stat-item">
                                    <div class="stat-number">${task.current_completions}</div>
                                    <div class="stat-label">{{__('Completed')}}</div>
                                </div>
                            </div>
                            <div class="col-4">
                                <div class="stat-item">
                                    <div class="stat-number">${task.max_completions}</div>
                                    <div class="stat-label">{{__('Max')}}</div>
                                </div>
                            </div>
                            <div class="col-4">
                                <div class="stat-item">
                                    <div class="stat-number">${task.reward_amount}₺</div>
                                    <div class="stat-label">{{__('Reward')}}</div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="progress-custom mt-3">
                            <div class="progress-bar-custom" style="width: ${completionPercentage}%"></div>
                        </div>
                        <div class="text-center mt-2">
                            <small class="text-muted">${Math.round(completionPercentage)}% {{__('completed')}}</small>
                        </div>
                    </div>
                    
                    <div class="btn-group-custom">
                        <button class="btn-custom btn-edit" onclick="editTask(${task.id})">
                            <i class="bx bx-edit"></i> {{__('Edit')}}
                        </button>
                        <button class="btn-custom btn-toggle" onclick="toggleTaskStatus(${task.id}, ${task.is_active})">
                            <i class="bx ${task.is_active ? 'bx-pause' : 'bx-play'}"></i>
                            ${task.is_active ? '{{__("Deactivate")}}' : '{{__("Activate")}}'}
                        </button>
                       <button
  class="btn-custom btn-delete"
  ${!task.is_active ? 'disabled' : ''}
  onclick="${task.is_active ? `deleteTask(${task.id})` : ''}"
>
  <i class="bx bx-trash"></i> Sil
</button>
                    </div>
                </div>
            </div>
        </div>
    `;
}

function showAddTaskModal() {
    const offcanvas = new bootstrap.Offcanvas(document.getElementById('addTaskOffcanvas'));
    offcanvas.show();
}

function updateCostPreview() {
    const reward = parseFloat($('input[name="reward_amount"]').val()) || 0;
    const completions = parseInt($('input[name="max_completions"]').val()) || 0;
    const totalCost = reward * completions;
    
    $('#reward-preview').text(reward.toFixed(2) + '₺');
    $('#completions-preview').text(completions);
    $('#total-cost-preview').text(totalCost.toFixed(2) + '₺');
    
    // Check if user has enough balance
    const submitBtn = $('#submitBtn');
    if (totalCost > userBalance) {
        submitBtn.prop('disabled', true).html('<i class="bx bx-x me-2"></i>{{__("Insufficient Balance")}}');
    } else {
        submitBtn.prop('disabled', false).html('<i class="bx bx-check me-2"></i>{{__("Create Task")}}');
    }
}

$('#addTaskForm').on('submit', function(e) {
    e.preventDefault();
    
    const submitBtn = $('#submitBtn');
    const originalText = submitBtn.html();
    
    submitBtn.prop('disabled', true).html('<i class="bx bx-loader-alt bx-spin me-2"></i>{{__("Creating...")}}');
    
    $.ajax({
        url: '{{ route("api.watch.store") }}',
        method: 'POST',
        data: $(this).serialize(),
        success: function(response) {
            if (response.success) {
                bootstrap.Offcanvas.getInstance(document.getElementById('addTaskOffcanvas')).hide();
                $('#addTaskForm')[0].reset();
                loadMyTasks();

                 console.log('☑️ response.new_balance geldi:', response.new_balance);
    updateUserBalance(response.new_balance);
                
                Swal.fire({
                    icon: 'success',
                    title: '{{__("Success")}}',
                    text: response.message,
                    timer: 3000
                });
            }
        },
        error: function(xhr) {
            const errors = xhr.responseJSON?.errors || {};
            
            Object.keys(errors).forEach(field => {
                const input = $(`[name="${field}"]`);
                input.addClass('is-invalid');
                input.siblings('.invalid-feedback').text(errors[field][0]);
            });
            
            if (xhr.responseJSON?.message) {
                Swal.fire({
                    icon: 'error',
                    title: '{{__("Error")}}',
                    text: xhr.responseJSON.message
                });
            }
        },
        complete: function() {
            submitBtn.prop('disabled', false).html(originalText);
        }
    });
});

function editTask(taskId) {
    // Basit çözüm: Görev verilerini DOM'dan al
    const taskCard = $(`[data-task-id="${taskId}"]`);
    if (taskCard.length === 0) {
        // Fallback: API'dan veri çek
        $.ajax({
            url: '{{ route("api.user.watch.tasks") }}',
            method: 'GET',
            headers: {
                'Accept': 'application/json',
                'X-Requested-With': 'XMLHttpRequest'
            },
            xhrFields: {
                withCredentials: true
            },
            success: function(response) {
                if (response.success) {
                    const task = response.tasks.find(t => t.id == taskId);
                    if (task) {
                        fillEditForm(task);
                        $('#editTaskModal').modal('show');
                    }
                }
            },
            error: function(xhr) {
                Swal.fire({
                    icon: 'error',
                    title: '{{__("Error")}}',
                    text: '{{__("Could not load task data")}}'
                });
            }
        });
    } else {
        // DOM'dan veri al
        const taskData = {
            id: taskId,
            title: taskCard.find('.card-title').text(),
            description: taskCard.find('.card-text').text(),
            watch_duration: taskCard.data('duration') || 60,
            reward_amount: taskCard.data('reward') || 1.00
        };
        fillEditForm(taskData);
        $('#editTaskModal').modal('show');
    }
}

function fillEditForm(task) {
    $('#edit-task-id').val(task.id);
    $('#edit-title').val(task.title);
    $('#edit-description').val(task.description);
    $('#edit-duration').val(task.watch_duration);
    $('#edit-reward').val(task.reward_amount);
}

$('#editTaskForm').on('submit', function(e) {
    e.preventDefault();
    
    const taskId = $('#edit-task-id').val();
    
    $.ajax({
        url: `/api/user/watch-tasks/${taskId}`,
        method: 'POST',
        data: $(this).serialize(),
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
            'Accept': 'application/json'
        },
        xhrFields: {
            withCredentials: true
        },
        success: function(response) {
            if (response.success) {
                $('#editTaskModal').modal('hide');
                loadMyTasks();
                
                Swal.fire({
                    icon: 'success',
                    title: '{{__("Success")}}',
                    text: response.message,
                    timer: 2000
                });
            }
        },
        error: function(xhr) {
            console.log('Edit Error:', xhr);
            Swal.fire({
                icon: 'error',
                title: '{{__("Error")}}',
                text: xhr.responseJSON?.message || '{{__("An error occurred")}}'
            });
        }
    });
});

function toggleTaskStatus(taskId) {
  $.ajax({
    url: `/api/watch-tasks/${taskId}/toggle`,  // POST toggle rotası
    method: 'POST',
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
      'Accept':       'application/json'
    },
    success: function(response) {
      loadMyTasks();
       Lobibox.notify('success', {
        pauseDelayOnHover: true,
        size: 'mini',
        rounded: true,
        icon: 'bx bx-check-circle',
        continueDelayOnInactiveTab: false,
        position: 'top right',
        msg: response.message
      });
      
    },
    error: function(xhr) {
      Swal.fire({
        icon: 'error',
        text: xhr.responseJSON?.message || 'Bir hata oluştu.'
      });
    }
  });
}
 
function deleteTask(taskId) {
  Swal.fire({
        title: @json(__('Are you sure?')),
    text: @json(__('This action cannot be undone!')),
    icon: 'warning',
    showCancelButton: true,
    confirmButtonText: @json(__('Yes, delete it!')),
    cancelButtonText: @json(__('No, cancel!')),
    reverseButtons: true
  }).then(result => {
    if (!result.isConfirmed) return;

    $.ajax({
      url: `/api/watch-tasks/${taskId}`,    // artık web.php’de tanımlı
      method: 'POST',                       // GERÇEK POST
      data: { _method: 'DELETE' },          // Laravel method spoofing
      dataType: 'json'                      // JSON bekliyoruz
    })
    .done(res => {
      loadMyTasks(); // listenizi yenileyin

      // iade varsa bakiye güncelleyin
      if (res.refund_amount) {
        userBalance += res.refund_amount;
        $('.my-tasks-container h4').text(userBalance.toFixed(2) + '₺');
      }

      Lobibox.notify('success', {
        pauseDelayOnHover: true,
        size: 'mini',
        rounded: true,
        icon: 'bx bx-check-circle',
        continueDelayOnInactiveTab: false,
        position: 'top right',
        msg: res.message
      });
    })
    .fail(xhr => {
      const err = xhr.responseJSON?.message || 'Bir hata oluştu.';
      Lobibox.notify('error', {
        pauseDelayOnHover: true,
        size: 'mini',
        rounded: true,
        icon: 'bx bx-error',
        continueDelayOnInactiveTab: false,
        position: 'top right',
        msg: err
      });
    });
  });
}
</script>

@endsection