@extends('layouts.app')

@section('title', __('Create Website Visit Task'))

@section('style')
    <link href="{{ asset('assets/plugins/notifications/css/lobibox.min.css') }}" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" />
@endsection

@section('wrapper')
<div class="page-wrapper">
    <div class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">{{ __('Create Website Visit Task') }}</div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item"><a href="{{ route('website-visits.index') }}">{{ __('Website Visits') }}</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('user.website-visits.index') }}">{{ __('My Tasks') }}</a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{ __('Create Task') }}</li>
                    </ol>
                </nav>
            </div>
            <div class="ms-auto">
                <a href="{{ route('user.website-visits.index') }}" class="btn btn-secondary">
                    <i class='bx bx-arrow-back me-1'></i>{{ __('Back') }}
                </a>
            </div>
        </div>
        <!--end breadcrumb-->

        <div class="row">
            <div class="col-xl-8 mx-auto">
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">{{ __('Task Information') }}</h5>
                    </div>
                    <div class="card-body">
                        <form id="taskForm" action="{{ route('user.website-visits.store') }}" method="POST">
                            @csrf
                            
                            <!-- Basic Information -->
                            <div class="row mb-3">
                                <div class="col-md-12">
                                    <label class="form-label">{{ __('Task Title') }} <span class="text-danger">*</span></label>
                                    <input type="text" name="title" class="form-control" required 
                                           placeholder="{{ __('Enter a descriptive title for your task') }}" 
                                           value="{{ old('title') }}">
                                    @error('title')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="row mb-3">
                                <div class="col-md-12">
                                    <label class="form-label">{{ __('Description') }} <span class="text-danger">*</span></label>
                                    <textarea name="description" class="form-control" rows="3" required 
                                              placeholder="{{ __('Describe what users should do on the website') }}">{{ old('description') }}</textarea>
                                    @error('description')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <!-- Website Information -->
                            <div class="row mb-3">
                                <div class="col-md-8">
                                    <label class="form-label">{{ __('Website URL') }} <span class="text-danger">*</span></label>
                                    <input type="url" name="website_url" class="form-control" required 
                                           placeholder="https://example.com" value="{{ old('website_url') }}">
                                    @error('website_url')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label">{{ __('Visit Method') }} <span class="text-danger">*</span></label>
                                    <select name="visit_method" class="form-select" required onchange="toggleSearchKeywords()">
                                        <option value="direct" {{ old('visit_method') == 'direct' ? 'selected' : '' }}>{{ __('Direct Visit') }}</option>
                                        <option value="google_search" {{ old('visit_method') == 'google_search' ? 'selected' : '' }}>{{ __('Google Search') }}</option>
                                    </select>
                                </div>
                            </div>

                            <div class="row mb-3" id="searchKeywordsRow" style="display: none;">
                                <div class="col-md-12">
                                    <label class="form-label">{{ __('Search Keywords') }} <span class="text-danger">*</span></label>
                                    <input type="text" name="search_keywords" class="form-control" 
                                           placeholder="{{ __('Keywords users should search for') }}" 
                                           value="{{ old('search_keywords') }}">
                                    <div class="form-text">{{ __('Users will search for these keywords on Google to find your website') }}</div>
                                </div>
                            </div>

                            <!-- Task Settings -->
                            <div class="row mb-3">
                                <div class="col-md-4">
                                    <label class="form-label">{{ __('Required Time (seconds)') }} <span class="text-danger">*</span></label>
                                    <input type="number" name="required_time" class="form-control" min="10" max="3600" 
                                           value="{{ old('required_time', 30) }}" required>
                                    <div class="form-text">{{ __('Minimum time users must spend on the website') }}</div>
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label">{{ __('Reward Amount') }} <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <span class="input-group-text">$</span>
                                        <input type="number" name="reward_amount" class="form-control" step="0.01" min="0.01" 
                                               value="{{ old('reward_amount', '0.10') }}" required>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label">{{ __('Max Completions') }} <span class="text-danger">*</span></label>
                                    <input type="number" name="max_completions" class="form-control" min="1" 
                                           value="{{ old('max_completions', 100) }}" required>
                                    <div class="form-text">{{ __('Total number of times this task can be completed') }}</div>
                                </div>
                            </div>

                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <label class="form-label">{{ __('User Daily Limit') }} <span class="text-danger">*</span></label>
                                    <input type="number" name="user_daily_limit" class="form-control" min="1" max="50" 
                                           value="{{ old('user_daily_limit', 1) }}" required>
                                    <div class="form-text">{{ __('How many times per day each user can complete this task') }}</div>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">{{ __('User Total Limit') }} <span class="text-danger">*</span></label>
                                    <input type="number" name="user_total_limit" class="form-control" min="1" 
                                           value="{{ old('user_total_limit', 1) }}" required>
                                    <div class="form-text">{{ __('How many times total each user can complete this task') }}</div>
                                </div>
                            </div>

                            <!-- Targeting Options -->
                            <div class="row mb-3">
                                <div class="col-md-4">
                                    <label class="form-label">{{ __('Target Country') }}</label>
                                    <select name="target_country_id" class="form-select" id="countrySelect">
                                        <option value="0">{{ __('All Countries') }}</option>
                                        @foreach($countries as $country)
                                            <option value="{{ $country->code }}" {{ old('target_country_id') == $country->code ? 'selected' : '' }}>
                                                {{ $country->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label">{{ __('Target City') }}</label>
                                    <select name="target_city_id" class="form-select" id="citySelect">
                                        <option value="0">{{ __('All Cities') }}</option>
                                        @foreach($cities as $city)
                                            <option value="{{ $city->id }}" {{ old('target_city_id') == $city->id ? 'selected' : '' }}>
                                                {{ $city->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label">{{ __('Target Gender') }} <span class="text-danger">*</span></label>
                                    <select name="target_gender" class="form-select" required>
                                        <option value="0" {{ old('target_gender') == '0' ? 'selected' : '' }}>{{ __('All Genders') }}</option>
                                        <option value="1" {{ old('target_gender') == '1' ? 'selected' : '' }}>{{ __('Male') }}</option>
                                        <option value="2" {{ old('target_gender') == '2' ? 'selected' : '' }}>{{ __('Female') }}</option>
                                    </select>
                                </div>
                            </div>

                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <label class="form-label">{{ __('Expiration Date') }}</label>
                                    <input type="datetime-local" name="expires_at" class="form-control" 
                                           value="{{ old('expires_at') }}">
                                    <div class="form-text">{{ __('Leave empty for no expiration') }}</div>
                                </div>
                            </div>

                            <div class="d-grid gap-2">
                                <button type="submit" class="btn btn-primary">
                                    <i class='bx bx-save me-2'></i>{{ __('Create Task') }}
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('script')
    <script src="{{ asset('assets/plugins/notifications/js/lobibox.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/notifications/js/notifications.min.js') }}"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

    <script>
        $(document).ready(function() {
            // Initialize Select2
            $('#countrySelect, #citySelect').select2({
                theme: 'bootstrap-5'
            });

            // Toggle search keywords field
            toggleSearchKeywords();
            
            // Handle country change
            $('#countrySelect').on('change', function() {
                const countryCode = $(this).val();
                const citySelect = $('#citySelect');
                
                // Clear city options
                citySelect.empty().append('<option value="0">{{ __("All Cities") }}</option>');
                
                if (countryCode && countryCode !== '0') {
                    // Load cities for selected country
                    $.ajax({
                        url: `/cities/${countryCode}`,
                        type: 'GET',
                        success: function(cities) {
                            cities.forEach(function(city) {
                                citySelect.append(`<option value="${city.id}">${city.name}</option>`);
                            });
                        },
                        error: function() {
                            console.error('Failed to load cities');
                        }
                    });
                }
            });
        });

        function toggleSearchKeywords() {
            const visitMethod = $('select[name="visit_method"]').val();
            const searchKeywordsRow = $('#searchKeywordsRow');
            const searchKeywordsInput = $('input[name="search_keywords"]');

            if (visitMethod === 'google_search') {
                searchKeywordsRow.show();
                searchKeywordsInput.attr('required', true);
            } else {
                searchKeywordsRow.hide();
                searchKeywordsInput.attr('required', false);
            }
        }

        // Handle form submission
        $('#taskForm').on('submit', function(e) {
            e.preventDefault();
            
            const submitBtn = $(this).find('button[type="submit"]');
            const originalText = submitBtn.html();
            
            submitBtn.prop('disabled', true).html('<i class="bx bx-loader-alt bx-spin me-2"></i>{{ __("Creating...") }}');
            
            $.ajax({
                url: $(this).attr('action'),
                type: 'POST',
                data: $(this).serialize(),
                headers: {
                    'X-Requested-With': 'XMLHttpRequest'
                },
                success: function(response) {
                    if (response.success) {
                        showNotification('success', '{{ __("Success") }}', response.message);
                        setTimeout(() => {
                            window.location.href = '{{ route("user.website-visits.index") }}';
                        }, 2000);
                    } else {
                        showNotification('error', '{{ __("Error") }}', response.message);
                    }
                },
                error: function(xhr) {
                    if (xhr.status === 422) {
                        const errors = xhr.responseJSON.errors;
                        let errorMessage = '';
                        Object.keys(errors).forEach(key => {
                            errorMessage += errors[key][0] + '<br>';
                        });
                        showNotification('error', '{{ __("Validation Error") }}', errorMessage);
                    } else {
                        const message = xhr.responseJSON?.message || '{{ __("An error occurred") }}';
                        showNotification('error', '{{ __("Error") }}', message);
                    }
                },
                complete: function() {
                    submitBtn.prop('disabled', false).html(originalText);
                }
            });
        });

        function showNotification(type, title, message) {
            Lobibox.notify(type, {
                pauseDelayOnHover: true,
                continueDelayOnInactiveTab: false,
                position: 'top right',
                icon: type === 'success' ? 'bx bx-check-circle' : 'bx bx-x-circle',
                title: title,
                msg: message
            });
        }
    </script>
@endsection